/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.util.HashSet;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.MetaDataStringLiteral;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.AbstractIteratorStatement;
import org.jpox.store.rdbms.query.QueryStatement;
import org.jpox.store.rdbms.table.SCOTable;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class UnionIteratorStatement
extends AbstractIteratorStatement {
    Class sourceType = null;
    JavaTypeMapping sourceMapping = null;
    DatastoreContainerObject sourceTable = null;
    boolean sourceJoin = false;
    boolean joinToExcludeTargetSubclasses = true;
    Boolean withMetadata = null;
    boolean allowsNull = false;

    public UnionIteratorStatement(ClassLoaderResolver clr, Class candidateType, boolean includeSubclasses, StoreManager storeMgr, Class sourceType, JavaTypeMapping sourceMapping, DatastoreContainerObject sourceTable, boolean sourceJoin, Boolean withMetadata, boolean joinToExcludeTargetSubclasses, boolean allowsNull) {
        super(candidateType, clr, includeSubclasses, storeMgr);
        this.sourceType = sourceType;
        this.sourceMapping = sourceMapping;
        this.sourceTable = sourceTable;
        this.sourceJoin = sourceJoin;
        this.joinToExcludeTargetSubclasses = joinToExcludeTargetSubclasses;
        this.withMetadata = withMetadata;
        this.allowsNull = allowsNull;
        if (!sourceType.isAssignableFrom(candidateType)) {
            if (candidateType.isInterface()) {
                if (!candidateType.isAssignableFrom(sourceType)) {
                    throw new IncompatibleQueryElementTypeException(this.candidateFullClassName, sourceType.getName());
                }
            } else {
                throw new IncompatibleQueryElementTypeException(sourceType.getName(), candidateType.getName());
            }
        }
        if (!sourceTable.equals(this.candidateTable) && !includeSubclasses) {
            JPOXLogger.RDBMS.warn(LOCALISER.msg("Extent.NoSubclassesWarning", this, this.candidateFullClassName));
        }
    }

    public QueryExpression getQueryStatement() {
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(this.candidateFullClassName)) {
            QueryExpression qs = this.dba.newQueryStatement(this.sourceTable, this.clr);
            qs.select(this.sourceMapping);
            return qs;
        }
        if (this.candidateTable == null) {
            AbstractClassMetaData acmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.candidateFullClassName, this.clr);
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(acmd, this.clr);
            if (subclassCmds != null && subclassCmds.length == 1) {
                this.candidateTable = this.storeMgr.getDatastoreClass(subclassCmds[0].getFullClassName(), this.clr);
                this.candidateFullClassName = subclassCmds[0].getFullClassName();
            } else {
                throw new JPOXUserException("Attempt to create iterator for class " + this.candidateFullClassName + " that is using \"subclass-table\" inheritance strategy and that doesnt have only 1 subclass." + " This is not currently supported");
            }
        }
        if (!this.includeSubclasses && this.withMetadata == null) {
            this.withMetadata = Boolean.FALSE;
        }
        HashSet subclasses = null;
        if (this.includeSubclasses) {
            subclasses = this.storeMgr.getSubClassesForClass(this.candidateFullClassName, true, this.clr);
        }
        QueryExpression stmt = this.getQueryForElement(this.candidateFullClassName, this.storeMgr.getDatastoreClass(this.candidateFullClassName, this.clr), false);
        if (this.includeSubclasses) {
            Iterator iterator = subclasses.iterator();
            while (iterator.hasNext()) {
                String subCandidateType = (String)iterator.next();
                DatastoreClass subCandidateTable = this.storeMgr.getDatastoreClass(subCandidateType, this.clr);
                if (subCandidateTable == null) continue;
                QueryExpression stmt_subclass = this.getQueryForElement(subCandidateType, subCandidateTable, false);
                stmt.union(stmt_subclass);
            }
        }
        if (this.allowsNull && this.sourceTable instanceof SCOTable) {
            QueryExpression nullStmt = this.getQueryForElement(this.candidateFullClassName, this.storeMgr.getDatastoreClass(this.candidateFullClassName, this.clr), true);
            ScalarExpression elemIdExpr = this.sourceMapping.newScalarExpression(nullStmt, nullStmt.getDefaultTableExpression());
            nullStmt.andCondition(new NullLiteral(nullStmt).eq(elemIdExpr));
            stmt.union(nullStmt);
        }
        return stmt;
    }

    private QueryExpression getQueryForElement(String targetElementType, DatastoreClass targetElementTable, boolean allowNull) {
        QueryExpression stmt;
        JavaTypeMapping discriminatorMapping = null;
        DiscriminatorMetaData discriminatorMetaData = null;
        LogicSetExpression discriminatorTableExpr = null;
        if (this.sourceTable instanceof SCOTable) {
            stmt = this.dba.newQueryStatement(this.sourceTable, this.clr);
            DatastoreIdentifier targetTableIdentifier = this.joinSourceToTargetElement(stmt, targetElementTable, allowNull);
            discriminatorMapping = targetElementTable.getDiscriminatorMapping();
            discriminatorMetaData = targetElementTable.getDiscriminatorMetaData();
            discriminatorTableExpr = stmt.getTableExpression(targetTableIdentifier);
            if (this.joinToExcludeTargetSubclasses) {
                this.joinToExcludeTargetWhenSubElementsExists(stmt, this.sourceMapping, targetElementType);
            }
        } else {
            stmt = this.dba.newQueryStatement(this.candidateTable, this.clr);
            discriminatorMapping = this.sourceTable.getDiscriminatorMapping();
            discriminatorMetaData = this.sourceTable.getDiscriminatorMetaData();
            discriminatorTableExpr = stmt.getDefaultTableExpression();
            if (!((Object)targetElementTable).toString().equals(this.sourceTable.toString()) && !this.candidateTable.getType().equals(targetElementType) || this.sourceJoin) {
                if (this.sourceJoin) {
                    this.joinTargetToSourceElement(stmt, targetElementTable, false);
                } else {
                    this.joinSourceToTargetElement(stmt, targetElementTable, false);
                }
            }
            if (this.joinToExcludeTargetSubclasses) {
                this.joinToExcludeTargetWhenSubElementsExists(stmt, this.candidateTable.getIDMapping(), targetElementType);
            }
        }
        if (discriminatorMapping != null && discriminatorMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
            String discriminatorValue = targetElementType;
            if (discriminatorMetaData.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                AbstractClassMetaData targetCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(targetElementType, this.clr);
                discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
            }
            ScalarExpression discrExpr = discriminatorMapping.newScalarExpression(stmt, discriminatorTableExpr);
            ScalarExpression discrVal = discriminatorMapping.newLiteral(stmt, discriminatorValue);
            stmt.andCondition(discrExpr.eq(discrVal));
        }
        if (this.withMetadata == null || this.withMetadata.booleanValue()) {
            this.selectMetadata(stmt, targetElementType, allowNull);
        }
        return stmt;
    }

    private DatastoreIdentifier joinSourceToTargetElement(QueryExpression stmt, DatastoreClass elementTargetTable, boolean leftOuterJoin) {
        DatastoreIdentifier targetTableIdentifier = stmt.getStoreManager().getIdentifierFactory().newIdentifier(0, "ELEMENT");
        LogicSetExpression teTargetElement = stmt.newTableExpression(elementTargetTable, targetTableIdentifier);
        ScalarExpression sourceExpr = this.sourceMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression targetExpr = elementTargetTable.getIDMapping().newScalarExpression(stmt, teTargetElement);
        if (leftOuterJoin) {
            stmt.leftOuterJoin(sourceExpr, targetExpr, teTargetElement, true);
        } else {
            stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
        }
        return targetTableIdentifier;
    }

    private void joinTargetToSourceElement(QueryExpression stmt, DatastoreClass elementTargetTable, boolean leftOuterJoin) {
        DatastoreIdentifier sourceTableIdentifier = stmt.getStoreManager().getIdentifierFactory().newIdentifier(0, "VALUE");
        LogicSetExpression teSourceElement = stmt.newTableExpression(this.sourceTable, sourceTableIdentifier);
        ScalarExpression sourceExpr = this.sourceMapping.newScalarExpression(stmt, teSourceElement);
        ScalarExpression targetExpr = elementTargetTable.getIDMapping().newScalarExpression(stmt, stmt.getDefaultTableExpression());
        if (leftOuterJoin) {
            stmt.leftOuterJoin(sourceExpr, targetExpr, teSourceElement, true);
        } else {
            stmt.innerJoin(sourceExpr, targetExpr, teSourceElement, true);
        }
    }

    private void joinToExcludeTargetWhenSubElementsExists(QueryExpression stmt, JavaTypeMapping targetElementMapping, String targetElementType) {
        Iterator iterTargetSubElementType = this.storeMgr.getSubClassesForClass(targetElementType, false, stmt.getClassLoaderResolver()).iterator();
        int subSequenceIdentifier = 0;
        while (iterTargetSubElementType.hasNext()) {
            String targetSubElementType = (String)iterTargetSubElementType.next();
            DatastoreClass cbtTargetSubElementType = this.storeMgr.getDatastoreClass(targetSubElementType, this.clr);
            DatastoreClass[] targetSubElementTypes = null;
            if (cbtTargetSubElementType == null) {
                AbstractClassMetaData targetSubCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(targetSubElementType, stmt.getClassLoaderResolver());
                AbstractClassMetaData[] targetSubCmds = this.storeMgr.getClassesManagingTableForClass(targetSubCmd, this.clr);
                targetSubElementTypes = new DatastoreClass[targetSubCmds.length];
                for (int i = 0; i < targetSubCmds.length; ++i) {
                    targetSubElementTypes[i] = this.storeMgr.getDatastoreClass(targetSubCmds[i].getFullClassName(), this.clr);
                }
            } else {
                targetSubElementTypes = new DatastoreClass[]{cbtTargetSubElementType};
            }
            for (int i = 0; i < targetSubElementTypes.length; ++i) {
                if (((Object)targetSubElementTypes[i]).toString().equals(((Object)this.storeMgr.getDatastoreClass(targetElementType, this.clr)).toString())) continue;
                DatastoreIdentifier tiTargetSubElementType = this.storeMgr.getIdentifierFactory().newIdentifier(0, "SUBELEMENT" + subSequenceIdentifier++);
                QueryStatement targetQS = new QueryStatement(targetSubElementTypes[i], tiTargetSubElementType, stmt.getClassLoaderResolver());
                LogicSetExpression teTargetSubElementType = targetQS.newTableExpression(targetSubElementTypes[i], tiTargetSubElementType);
                JavaTypeMapping targetMapping = targetSubElementTypes[i].getIDMapping();
                ScalarExpression targetElementExpr = targetElementMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                ScalarExpression targetSubElementTypeExpr = targetMapping.newScalarExpression(stmt, teTargetSubElementType);
                stmt.leftOuterJoin(targetElementExpr, targetSubElementTypeExpr, teTargetSubElementType, true);
                ScalarExpression seTargetSubElementType = targetMapping.newScalarExpression(targetQS, teTargetSubElementType);
                stmt.andCondition(new NullLiteral(stmt).eq(seTargetSubElementType));
            }
        }
    }

    private void selectMetadata(QueryExpression stmt, String pcClass, boolean allowNull) {
        int maxClassNameLen = this.candidateFullClassName.length();
        boolean hasSubClasses = false;
        Iterator iterator = this.storeMgr.getSubClassesForClass(this.candidateFullClassName, true, this.clr).iterator();
        if (iterator.hasNext()) {
            hasSubClasses = true;
            while (iterator.hasNext()) {
                String nextClass = (String)iterator.next();
                if (nextClass.length() <= maxClassNameLen) continue;
                maxClassNameLen = nextClass.length();
            }
        }
        if (this.withMetadata == null && hasSubClasses || this.withMetadata != null && this.withMetadata.booleanValue()) {
            if (allowNull) {
                NullLiteral nullLtl = new NullLiteral(stmt);
                nullLtl.as("JPOXMETADATA");
                stmt.selectScalarExpression(nullLtl);
            } else {
                String classname = pcClass;
                if (maxClassNameLen > classname.length()) {
                    classname = StringUtils.leftAlignedPaddedString(pcClass, maxClassNameLen);
                }
                stmt.selectScalarExpression(new MetaDataStringLiteral(stmt, classname));
            }
        }
    }
}

