/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.identity.OID;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.VersionMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.FetchStatement;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.fieldmanager.ResultSetGetter;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.Request;
import org.jpox.store.rdbms.table.CollectionTable;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class FetchRequest
extends Request {
    private final MappingCallbacks[] callbacks;
    private FetchMappingConsumer consumer;
    private MappingStatementIndex mappingStatementIndex;
    private FetchStatement fetchStatement;
    private final String fieldsToFetch;
    private AbstractClassMetaData cmd;
    private String[] stmt = new String[2];
    static /* synthetic */ Class class$java$util$Collection;

    public FetchRequest(DatastoreClass table, AbstractMemberMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(table);
        this.cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        this.mappingStatementIndex = new MappingStatementIndex();
        this.fetchStatement = new RDBMSFetchStatement(table);
        this.consumer = new FetchMappingConsumer(this.fetchStatement, clr);
        AbstractMemberMetaData[] fetchFmds = fieldMetaData;
        VersionMetaData vermd = table.getVersionMetaData();
        if (vermd != null && vermd.getFieldName() != null) {
            fetchFmds = new AbstractMemberMetaData[fetchFmds.length + 1];
            for (int i = 0; i < fieldMetaData.length; ++i) {
                fetchFmds[i] = fieldMetaData[i];
            }
            fetchFmds[fetchFmds.length - 1] = this.cmd.getMetaDataForMember(vermd.getFieldName());
        }
        table.provideMappingsForFields(this.consumer, fetchFmds, true);
        table.provideDatastoreIdMappings(this.consumer);
        table.provideDiscriminatorMappings(this.consumer);
        this.callbacks = this.consumer.getMappingCallbacks().toArray(new MappingCallbacks[this.consumer.getMappingCallbacks().size()]);
        StringBuffer str = new StringBuffer();
        int[] fieldNumbersToFetch = this.consumer.getNumbersOfFieldsToBeFetched();
        if (fieldNumbersToFetch != null && fieldNumbersToFetch.length > 0) {
            for (int i = 0; i < fieldNumbersToFetch.length; ++i) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbersToFetch[i]);
                if (i > 0) {
                    str.append(",");
                }
                str.append(fmd.getName());
            }
        }
        if (vermd != null && vermd.getFieldName() == null) {
            table.provideVersionMappings(this.consumer);
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("[VERSION]");
        }
        if (str.length() > 0) {
            this.fieldsToFetch = str.toString();
            table.providePrimaryKeyMappings(this.consumer);
        } else {
            this.fieldsToFetch = null;
            this.fetchStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.fieldsToFetch != null && JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.Fetch", StringUtils.toJVMIDString(sm.getObject()), this.fieldsToFetch, this.table));
        }
        if (this.fetchStatement != null) {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            Transaction tx = om.getTransaction();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            if (this.stmt[useUpdateLock ? 1 : 0] == null) {
                this.stmt[useUpdateLock ? 1 : 0] = this.fetchStatement.toString(useUpdateLock);
            }
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.stmt[useUpdateLock ? 1 : 0]);
                    try {
                        if (sm.getInternalObjectId() instanceof OID) {
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else {
                            sm.provideFields(this.consumer.getPrimaryKeyFieldsToBeProvided(), new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(conn, this.stmt[useUpdateLock ? 1 : 0], ps);
                        try {
                            if (!rs.next()) {
                                JPOXLogger.RDBMS_SQL.warn(LOCALISER.msg("RDBMS.Manager.ObjectWithIdNotFound", sm.getInternalObjectId()));
                                throw new JPOXObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                            sm.replaceFields(this.consumer.getNumbersOfFieldsToBeFetched(), new ResultSetGetter(sm, rs, this.mappingStatementIndex.getFields()));
                            VersionMetaData vermd = this.table.getVersionMetaData();
                            if (vermd != null && sm.getTransactionalVersion(sm.getObject()) == null) {
                                Object datastoreVersion = null;
                                if (vermd.getFieldName() != null) {
                                    AbstractClassMetaData cmd = (AbstractClassMetaData)vermd.getParent();
                                    datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                                } else {
                                    datastoreVersion = this.table.getVersionMapping().getObject(om, rs, this.mappingStatementIndex.getVersion().getExpressionIndex());
                                }
                                sm.setVersion(datastoreVersion);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("RDBMS.Request.Fetch.Error", StringUtils.toJVMIDString(sm.getObject()), this.stmt[useUpdateLock ? 1 : 0], e.getMessage());
                JPOXLogger.RDBMS_SQL.warn(msg);
                throw new JPOXDataStoreException(msg, e);
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].postFetch(sm);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FetchMappingConsumer
    implements MappingConsumer {
        private int paramIndex = 1;
        final FetchStatement fetchStmt;
        List fetchFields = new ArrayList();
        List pkbp = new ArrayList();
        List mappingCallbacks = new ArrayList();
        boolean initialized = false;
        final ClassLoaderResolver clr;

        public FetchMappingConsumer(FetchStatement fetchStmt, ClassLoaderResolver clr) {
            this.fetchStmt = fetchStmt;
            this.clr = clr;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                FetchRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                FetchRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            block26: {
                int[] expressionsIndex;
                block29: {
                    block27: {
                        DatastoreContainerObject joinTable;
                        int relationType;
                        block28: {
                            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(FetchRequest.this.cmd)) {
                                return;
                            }
                            if (!m.includeInFetchStatement()) break block26;
                            ((FetchRequest)FetchRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                            FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setMapping(m);
                            expressionsIndex = null;
                            if (m.getNumberOfDatastoreFields() != 0 || !(m instanceof PersistenceCapableMapping) && !(m instanceof InterfaceMapping)) break block27;
                            relationType = fmd.getRelationType(this.clr);
                            if (relationType != 2) break block28;
                            MetaDataManager mmgr = FetchRequest.this.table.getStoreManager().getMetaDataManager();
                            if (fmd.getMappedBy() != null) {
                                Class fieldType = fmd.getType();
                                String[] clsNames = null;
                                if (fieldType.isInterface()) {
                                    Class fldTypeCls;
                                    if (fmd.getFieldTypes() != null && fmd.getFieldTypes().length == 1 && (fldTypeCls = this.clr.classForName(fmd.getFieldTypes()[0])).isInterface()) {
                                        clsNames = mmgr.getClassesImplementingInterface(fmd.getFieldTypes()[0], this.clr);
                                    }
                                    if (clsNames == null) {
                                        clsNames = mmgr.getClassesImplementingInterface(fieldType.getName(), this.clr);
                                    }
                                } else {
                                    clsNames = new String[]{fieldType.getName()};
                                }
                                DatastoreClass relatedTable = FetchRequest.this.table.getStoreManager().getDatastoreClass(clsNames[0], this.clr);
                                JavaTypeMapping referenceMapping = relatedTable.getFieldMapping(fmd.getMappedBy());
                                JavaTypeMapping selectMapping = relatedTable.getIDMapping();
                                JavaTypeMapping refDiscrimMapping = relatedTable.getDiscriminatorMapping();
                                Object[] discrimValues = null;
                                JavaTypeMapping refTypeMapping = null;
                                expressionsIndex = new int[referenceMapping.getNumberOfDatastoreFields()];
                                if (refDiscrimMapping != null) {
                                    DiscriminatorStrategy strategy = relatedTable.getDiscriminatorMetaData().getStrategy();
                                    if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                                        int i;
                                        HashSet<String> allclasses = new HashSet<String>();
                                        if (clsNames != null) {
                                            for (i = 0; i < clsNames.length; ++i) {
                                                allclasses.add(clsNames[i]);
                                            }
                                        }
                                        for (i = 0; i < clsNames.length; ++i) {
                                            HashSet subclasses = FetchRequest.this.table.getStoreManager().getSubClassesForClass(clsNames[i], true, this.clr);
                                            if (subclasses == null || subclasses.size() <= 0) continue;
                                            allclasses.addAll(subclasses);
                                        }
                                        discrimValues = allclasses.toArray();
                                    } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
                                        HashSet subclasses = FetchRequest.this.table.getStoreManager().getSubClassesForClass(fmd.getTypeName(), true, this.clr);
                                        if (subclasses != null && subclasses.size() > 0) {
                                            int valNo = 0;
                                            discrimValues = new Object[subclasses.size() + 1];
                                            discrimValues[valNo++] = fmd.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                                            Iterator subclassesIter = subclasses.iterator();
                                            while (subclassesIter.hasNext()) {
                                                String subclass = (String)subclassesIter.next();
                                                AbstractClassMetaData subclassCmd = mmgr.getMetaDataForClass(subclass, this.clr);
                                                discrimValues[valNo++] = subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                                            }
                                        } else {
                                            discrimValues = new Object[]{mmgr.getMetaDataForClass(fmd.getType(), this.clr).getInheritanceMetaData().getDiscriminatorMetaData().getValue()};
                                        }
                                    }
                                } else if (relatedTable != referenceMapping.getDataStoreMapping(0).getDatastoreField().getDatastoreContainerObject()) {
                                    refTypeMapping = relatedTable.getIDMapping();
                                }
                                expressionsIndex = refTypeMapping == null ? FetchRequest.this.fetchStatement.selectOuterJoin(referenceMapping, selectMapping, refDiscrimMapping, discrimValues) : FetchRequest.this.fetchStatement.selectOuterJoin(referenceMapping, selectMapping, refTypeMapping);
                            }
                            break block29;
                        }
                        if (relationType != 6) break block29;
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                        if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null || (joinTable = FetchRequest.this.table.getStoreManager().getDatastoreContainerObject(relatedMmds[0])) == null) break block29;
                        JavaTypeMapping referenceMapping = null;
                        JavaTypeMapping selectMapping = null;
                        if ((class$java$util$Collection == null ? (class$java$util$Collection = FetchRequest.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(relatedMmds[0].getType())) {
                            CollectionTable collTable = (CollectionTable)joinTable;
                            referenceMapping = collTable.getElementMapping();
                            selectMapping = collTable.getOwnerMapping();
                        }
                        expressionsIndex = FetchRequest.this.fetchStatement.selectOuterJoin(referenceMapping, selectMapping, null, null);
                        break block29;
                    }
                    expressionsIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int i = 0; i < expressionsIndex.length; ++i) {
                        expressionsIndex[i] = this.fetchStmt.select(m.getDataStoreMapping(i).getDatastoreField());
                    }
                }
                FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setExpressionIndex(expressionsIndex);
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                if (fmd.isPrimaryKey()) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField(m.getDataStoreMapping(j).getDatastoreField()) + "=?");
                        if (!this.pkbp.contains(abs_field_num)) {
                            this.pkbp.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                    FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                } else if (!this.fetchFields.contains(abs_field_num)) {
                    this.fetchFields.add(abs_field_num);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mappingCallbacks.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                FetchRequest.this.mappingStatementIndex.getVersion().setMapping(FetchRequest.this.table.getVersionMapping());
                int[] expressionsIndex = new int[FetchRequest.this.table.getVersionMapping().getNumberOfDatastoreFields()];
                for (int j = 0; j < expressionsIndex.length; ++j) {
                    expressionsIndex[j] = this.fetchStmt.select(FetchRequest.this.table.getVersionMapping().getDataStoreMapping(j).getDatastoreField());
                }
                FetchRequest.this.mappingStatementIndex.getVersion().setExpressionIndex(expressionsIndex);
            } else if (mappingType == 2) {
                this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField((DatastoreField)FetchRequest.this.key.getColumns().get(0)) + "=?");
                int[] nArray = new int[]{this.paramIndex++};
                FetchRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(nArray);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public List getMappingCallbacks() {
            return this.mappingCallbacks;
        }

        public int[] getNumbersOfFieldsToBeFetched() {
            int[] fieldsToBeFetched = new int[this.fetchFields.size()];
            for (int i = 0; i < this.fetchFields.size(); ++i) {
                fieldsToBeFetched[i] = (Integer)this.fetchFields.get(i);
            }
            return fieldsToBeFetched;
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }
    }
}

