/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.VersionMetaData;
import org.jpox.state.ActivityState;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.VersionMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.Request;
import org.jpox.store.rdbms.table.SecondaryTable;
import org.jpox.store.rdbms.table.Table;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.StringUtils;

public class InsertRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final MappingCallbacks[] callbacks;
    private final int[] insertFieldNumbers;
    private final int[] pkFieldNumbers;
    private final int[] reachableFieldNumbers;
    private final int[] relationFieldNumbers;
    private final String insertStmt;
    private boolean hasAutoIncrementColumn = false;
    private StatementExpressionIndex[] statementExpressionIndex;
    private StatementExpressionIndex[] retrievedStatementExpressionIndex;
    private StatementExpressionIndex versionStatementExpressionIndex;
    private StatementExpressionIndex discriminatorStatementExpressionIndex;
    private StatementExpressionIndex[] externalFKStatementExpressionIndex;
    private StatementExpressionIndex[] externalFKDiscrimStatementExpressionIndex;
    private StatementExpressionIndex[] externalOrderStatementExpressionIndex;
    private boolean batch = false;
    static /* synthetic */ Class class$java$lang$Integer;

    public InsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table);
        AbstractClassMetaData cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        InsertMappingConsumer consumer = new InsertMappingConsumer(clr, cmd, 1);
        table.provideDatastoreIdMappings(consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        table.provideVersionMappings(consumer);
        table.provideDiscriminatorMappings(consumer);
        table.provideExternalMappings(consumer, 5);
        table.provideExternalMappings(consumer, 6);
        table.provideExternalMappings(consumer, 4);
        table.provideUnmappedDatastoreFields(consumer);
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.statementExpressionIndex = consumer.getStatementExpressionIndex();
        this.versionStatementExpressionIndex = consumer.getVersionStatementExpressionIndex();
        this.discriminatorStatementExpressionIndex = consumer.getDiscriminatorStatementExpressionIndex();
        this.externalFKStatementExpressionIndex = consumer.getExternalFKStatementExpressionIndex();
        this.externalFKDiscrimStatementExpressionIndex = consumer.getExternalFKDiscrimStatementExpressionIndex();
        this.externalOrderStatementExpressionIndex = consumer.getExternalOrderStatementExpressionIndex();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        if (table.getIdentityType() == IdentityType.APPLICATION && this.pkFieldNumbers.length < 1 && !this.hasAutoIncrementColumn) {
            throw new JPOXException(LOCALISER.msg("RDBMS.Request.InsertWithNoPrimaryKeyError", cmd.getFullClassName())).setFatal();
        }
        this.insertFieldNumbers = consumer.getInsertFieldNumbers();
        this.retrievedStatementExpressionIndex = consumer.getReachableStatementIndex();
        this.reachableFieldNumbers = consumer.getReachableFieldNumbers();
        this.relationFieldNumbers = consumer.getRelationFieldNumbers();
        this.insertStmt = consumer.getInsertStmt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
            JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.Insert", StringUtils.toJVMIDString(sm.getObject()), this.table));
        }
        try {
            VersionMetaData vermd = this.table.getVersionMetaData();
            if (vermd != null && vermd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                Object currentVersion = sm.getVersion(sm.getObject());
                if (currentVersion instanceof Integer) {
                    currentVersion = new Long(((Integer)currentVersion).longValue());
                }
                Object nextOptimisticVersion = VersionMapping.getNextVersion(this.table.getVersionMetaData(), currentVersion);
                if (verfmd.getType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = InsertRequest.class$("java.lang.Integer")) : class$java$lang$Integer) || verfmd.getType() == Integer.TYPE) {
                    nextOptimisticVersion = new Integer(((Long)nextOptimisticVersion).intValue());
                }
                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextOptimisticVersion, false);
            }
            sm.changeActivityState(ActivityState.INSERTING, this.table);
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            SQLController sqlControl = storeMgr.getSQLController();
            ManagedConnection mconn = storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.insertStmt, this.batch);
                try {
                    int i;
                    int i2;
                    if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                        if (!this.table.isObjectIDDatastoreAttributed() || !this.table.isBaseDatastoreClass()) {
                            int[] paramNumber = new int[]{1};
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, paramNumber, sm.getInternalObjectId());
                        }
                    } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(this.pkFieldNumbers, new ParameterSetter(sm, ps, this.statementExpressionIndex, true));
                    }
                    int numberOfFieldsToProvide = 0;
                    for (int i3 = 0; i3 < this.insertFieldNumbers.length; ++i3) {
                        if (this.insertFieldNumbers[i3] >= sm.getHighestFieldNumber()) continue;
                        ++numberOfFieldsToProvide;
                    }
                    int j = 0;
                    int[] classFieldNumbers = new int[numberOfFieldsToProvide];
                    for (i2 = 0; i2 < this.insertFieldNumbers.length; ++i2) {
                        if (this.insertFieldNumbers[i2] < sm.getHighestFieldNumber()) {
                            classFieldNumbers[j++] = this.insertFieldNumbers[i2];
                            continue;
                        }
                        StatementExpressionIndex stmtExprIndex = this.statementExpressionIndex[this.insertFieldNumbers[i2]];
                        stmtExprIndex.getMapping().setDefault(om, ps, stmtExprIndex.getParameterIndex());
                    }
                    sm.provideFields(classFieldNumbers, new ParameterSetter(sm, ps, this.statementExpressionIndex, true));
                    if (this.table.getVersionMapping() != null) {
                        Object currentVersion = sm.getVersion(sm.getObject());
                        Object nextOptimisticVersion = VersionMapping.getNextVersion(this.table.getVersionMetaData(), currentVersion);
                        this.table.getVersionMapping().setObject(om, ps, this.versionStatementExpressionIndex.getParameterIndex(), nextOptimisticVersion);
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    }
                    if (this.table.getDiscriminatorMapping() != null) {
                        DiscriminatorMetaData dismd = this.table.getDiscriminatorMetaData();
                        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                            this.table.getDiscriminatorMapping().setObject(om, ps, this.discriminatorStatementExpressionIndex.getParameterIndex(), sm.getObject().getClass().getName());
                        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                            dismd = sm.getClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData();
                            this.table.getDiscriminatorMapping().setObject(om, ps, this.discriminatorStatementExpressionIndex.getParameterIndex(), dismd.getValue());
                        }
                    }
                    if (this.externalFKStatementExpressionIndex != null) {
                        for (i2 = 0; i2 < this.externalFKStatementExpressionIndex.length; ++i2) {
                            Object fkValue = sm.getValueForExternalField(this.externalFKStatementExpressionIndex[i2].getMapping());
                            if (fkValue != null) {
                                AbstractMemberMetaData ownerFmd = this.table.getMetaDataForExternalMapping(this.externalFKStatementExpressionIndex[i2].getMapping(), 5);
                                this.externalFKStatementExpressionIndex[i2].getMapping().setObject(om, ps, this.externalFKStatementExpressionIndex[i2].getParameterIndex(), fkValue, null, ownerFmd.getAbsoluteFieldNumber());
                                continue;
                            }
                            this.externalFKStatementExpressionIndex[i2].getMapping().setObject(om, ps, this.externalFKStatementExpressionIndex[i2].getParameterIndex(), null);
                        }
                    }
                    if (this.externalFKDiscrimStatementExpressionIndex != null) {
                        for (i2 = 0; i2 < this.externalFKDiscrimStatementExpressionIndex.length; ++i2) {
                            Object discrimValue = sm.getValueForExternalField(this.externalFKDiscrimStatementExpressionIndex[i2].getMapping());
                            this.externalFKDiscrimStatementExpressionIndex[i2].getMapping().setObject(om, ps, this.externalFKDiscrimStatementExpressionIndex[i2].getParameterIndex(), discrimValue);
                        }
                    }
                    if (this.externalOrderStatementExpressionIndex != null) {
                        for (i2 = 0; i2 < this.externalOrderStatementExpressionIndex.length; ++i2) {
                            Object orderValue = sm.getValueForExternalField(this.externalOrderStatementExpressionIndex[i2].getMapping());
                            if (orderValue == null) {
                                orderValue = new Integer(-1);
                            }
                            this.externalOrderStatementExpressionIndex[i2].getMapping().setObject(om, ps, this.externalOrderStatementExpressionIndex[i2].getParameterIndex(), orderValue);
                        }
                    }
                    sqlControl.executeStatementUpdate(conn, this.insertStmt, ps, !this.batch);
                    if (this.hasAutoIncrementColumn) {
                        Object newId = this.getInsertedDatastoreIdentity(om, sqlControl, sm, conn, ps);
                        if (JPOXLogger.RDBMS_SQL.isDebugEnabled()) {
                            JPOXLogger.RDBMS_SQL.debug(LOCALISER.msg("RDBMS.Request.Insert.StrategyValueReturned", StringUtils.toJVMIDString(sm.getObject()), newId));
                        }
                        sm.setPostStoreNewObjectId(newId);
                    }
                    sm.changeActivityState(ActivityState.INSERTING_CALLBACKS, this.table);
                    for (int i4 = 0; i4 < this.relationFieldNumbers.length; ++i4) {
                        Object value = sm.provideField(this.relationFieldNumbers[i4]);
                        if (value == null || !om.getApiAdapter().isDetached(value)) continue;
                        Object valueAttached = om.persistObjectInternal(value, null);
                        sm.replaceField(this.relationFieldNumbers[i4], valueAttached, false);
                    }
                    int numberOfReachableFields = 0;
                    for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                        if (this.reachableFieldNumbers[i] >= sm.getHighestFieldNumber()) continue;
                        ++numberOfReachableFields;
                    }
                    classFieldNumbers = new int[numberOfReachableFields];
                    j = 0;
                    for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                        if (this.reachableFieldNumbers[i] < sm.getHighestFieldNumber()) {
                            classFieldNumbers[j++] = this.reachableFieldNumbers[i];
                            continue;
                        }
                        StatementExpressionIndex stmtExprIndex = this.retrievedStatementExpressionIndex[this.reachableFieldNumbers[i]];
                        stmtExprIndex.getMapping().setDefault(om, ps, stmtExprIndex.getParameterIndex());
                    }
                    sm.provideFields(classFieldNumbers, new ParameterSetter(sm, ps, this.retrievedStatementExpressionIndex, true));
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = LOCALISER.msg("RDBMS.Request.Insert.Error", StringUtils.toJVMIDString(sm.getObject()), this.insertStmt, e.getMessage());
            JPOXLogger.RDBMS_SQL.warn(msg);
            throw new JPOXDataStoreException(msg, e);
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.PostInsert", StringUtils.toJVMIDString(sm.getObject()), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getFullFieldName()));
                }
                this.callbacks[i].postInsert(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInsertedDatastoreIdentity(ObjectManager om, SQLController sqlControl, StateManager sm, Connection conn, PreparedStatement ps) throws SQLException {
        Object datastoreId = null;
        if (((RDBMSAdapter)om.getStoreManager().getDatastoreAdapter()).supportsStatementGetGeneratedKeys() && JavaUtils.isJRE1_4OrAbove()) {
            ResultSet rs = null;
            try {
                rs = ps.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            catch (Throwable e) {
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (datastoreId == null) {
            String tableName = ((Object)this.table.getIdentifier()).toString();
            String columnName = null;
            JavaTypeMapping idMapping = this.table.getIDMapping();
            if (idMapping != null) {
                for (int i = 0; i < idMapping.getNumberOfDatastoreFields(); ++i) {
                    Column col = (Column)idMapping.getDataStoreMapping(i).getDatastoreField();
                    if (!col.isAutoIncrement()) continue;
                    columnName = ((Object)col.getIdentifier()).toString();
                    break;
                }
            }
            String autoIncStmt = ((RDBMSAdapter)om.getStoreManager().getDatastoreAdapter()).getAutoIncrementStmt(tableName, columnName);
            PreparedStatement psAutoIncrement = sqlControl.getStatementForQuery(conn, autoIncStmt);
            ResultSet rs = null;
            try {
                rs = sqlControl.executeStatementQuery(conn, autoIncStmt, psAutoIncrement);
                if (rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (psAutoIncrement != null) {
                    psAutoIncrement.close();
                }
            }
        }
        if (datastoreId == null) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Request.InsertOfAutoincrementReturnedNullIdentity", this.table));
        }
        return datastoreId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InsertMappingConsumer
    implements MappingConsumer {
        List insertFields = new ArrayList();
        List pkFields = new ArrayList();
        List reachableFields = new ArrayList();
        List relationFields = new ArrayList();
        StringBuffer columnNames = new StringBuffer();
        StringBuffer columnValues = new StringBuffer();
        Map assignedColumns = new HashMap();
        List mc = new ArrayList();
        boolean initialized = false;
        int paramIndex;
        private StatementExpressionIndex[] statementExpressionIndex;
        private StatementExpressionIndex[] retrievedStatementExpressionIndex;
        private StatementExpressionIndex versionStatementExpressionIndex;
        private StatementExpressionIndex discriminatorStatementExpressionIndex;
        private StatementExpressionIndex[] externalFKStmtExprIndex;
        private StatementExpressionIndex[] externalFKDiscrimStmtExprIndex;
        private StatementExpressionIndex[] externalOrderStmtExprIndex;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public InsertMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = initialParamIndex;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.statementExpressionIndex = new StatementExpressionIndex[highestFieldNumber];
                this.retrievedStatementExpressionIndex = new StatementExpressionIndex[highestFieldNumber];
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            block22: {
                int relationType;
                block23: {
                    int relationType2;
                    block24: {
                        if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                            return;
                        }
                        if (!m.includeInInsertStatement()) break block22;
                        if (m.getNumberOfDatastoreFields() != 0 || !(m instanceof PersistenceCapableMapping) && !(m instanceof ReferenceMapping)) break block23;
                        this.retrievedStatementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                        this.retrievedStatementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                        relationType2 = fmd.getRelationType(this.clr);
                        if (relationType2 != 2) break block24;
                        if (fmd.getMappedBy() != null) {
                            this.reachableFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        }
                        break block22;
                    }
                    if (relationType2 != 6) break block22;
                    AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                    if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) break block22;
                    this.reachableFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                    break block22;
                }
                if (fmd.hasExtension("insertable") && fmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                    return;
                }
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds != null && colmds.length > 0) {
                    for (int i = 0; i < colmds.length; ++i) {
                        if (colmds[i].getInsertable()) continue;
                        return;
                    }
                }
                if ((relationType = fmd.getRelationType(this.clr)) == 2) {
                    if (fmd.getMappedBy() == null) {
                        // empty if block
                    }
                } else if (relationType == 6) {
                    AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                    if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                        this.relationFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                    }
                }
                this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                for (int j = 0; j < parametersIndex.length; ++j) {
                    Column c = (Column)m.getDataStoreMapping(j).getDatastoreField();
                    DatastoreIdentifier columnId = c.getIdentifier();
                    if (!this.assignedColumns.containsKey(((Object)columnId).toString())) {
                        if (InsertRequest.this.table instanceof SecondaryTable || !InsertRequest.this.table.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false) && !c.isAutoIncrement() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                            if (this.columnNames.length() > 0) {
                                this.columnNames.append(',');
                                this.columnValues.append(',');
                            }
                            this.columnNames.append(columnId);
                            this.columnValues.append(((RDBMSMapping)m.getDataStoreMapping(j)).getInsertionInputParameter());
                            if (((RDBMSMapping)m.getDataStoreMapping(j)).insertValuesOnInsert()) {
                                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                                if (fmd.isPrimaryKey()) {
                                    if (!this.pkFields.contains(abs_field_num)) {
                                        this.pkFields.add(abs_field_num);
                                    }
                                } else if (!this.insertFields.contains(abs_field_num)) {
                                    this.insertFields.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(((Object)c.getIdentifier()).toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                        } else {
                            InsertRequest.this.hasAutoIncrementColumn = true;
                        }
                    } else {
                        parametersIndex[j] = (Integer)this.assignedColumns.get(((Object)c.getIdentifier()).toString());
                    }
                    this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                if (InsertRequest.this.table.getVersionMapping() != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getVersionMapping().getDataStoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getVersionMapping().getDataStoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.versionStatementExpressionIndex = new StatementExpressionIndex();
                    this.versionStatementExpressionIndex.setMapping(InsertRequest.this.table.getVersionMapping());
                    int[] param = new int[]{this.paramIndex++};
                    this.versionStatementExpressionIndex.setParameterIndex(param);
                } else {
                    this.versionStatementExpressionIndex = null;
                }
            } else if (mappingType == 3) {
                if (InsertRequest.this.table.getDiscriminatorMapping() != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getDiscriminatorMapping().getDataStoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.discriminatorStatementExpressionIndex = new StatementExpressionIndex();
                    this.discriminatorStatementExpressionIndex.setMapping(InsertRequest.this.table.getDiscriminatorMapping());
                    int[] param = new int[]{this.paramIndex++};
                    this.discriminatorStatementExpressionIndex.setParameterIndex(param);
                } else {
                    this.discriminatorStatementExpressionIndex = null;
                }
            } else if (mappingType == 2) {
                if (InsertRequest.this.table.getIdentityType() == IdentityType.DATASTORE) {
                    if (!InsertRequest.this.table.isObjectIDDatastoreAttributed() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                        Iterator iterator = InsertRequest.this.key.getColumns().iterator();
                        if (this.columnNames.length() > 0) {
                            this.columnNames.append(',');
                            this.columnValues.append(',');
                        }
                        this.columnNames.append(((Object)((Column)iterator.next()).getIdentifier()).toString());
                        this.columnValues.append("?");
                        ++this.paramIndex;
                    } else {
                        InsertRequest.this.hasAutoIncrementColumn = true;
                    }
                }
            } else if (mappingType == 5) {
                this.externalFKStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalFKStmtExprIndex);
            } else if (mappingType == 6) {
                this.externalFKDiscrimStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalFKDiscrimStmtExprIndex);
            } else if (mappingType == 4) {
                this.externalOrderStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalOrderStmtExprIndex);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
            if (this.columnNames.length() > 0) {
                this.columnNames.append(',');
                this.columnValues.append(',');
            }
            Column col = (Column)fld;
            this.columnNames.append(fld.getIdentifier());
            ColumnMetaData colmd = (ColumnMetaData)col.getMetaData();
            String value = colmd.getInsertValue();
            if (colmd.getJdbcType().equals("VARCHAR") || colmd.getJdbcType().equals("CHAR")) {
                value = "\"" + value + "\"";
            }
            this.columnValues.append(value);
        }

        private StatementExpressionIndex[] processExternalMapping(JavaTypeMapping mapping, StatementExpressionIndex[] fieldStmtExprIndex, StatementExpressionIndex[] stmtExprIndex) {
            int i;
            for (int i2 = 0; i2 < fieldStmtExprIndex.length; ++i2) {
                if (fieldStmtExprIndex[i2] == null || fieldStmtExprIndex[i2].getMapping() != mapping) continue;
                return stmtExprIndex;
            }
            int pos = 0;
            if (stmtExprIndex == null) {
                stmtExprIndex = new StatementExpressionIndex[1];
                pos = 0;
            } else {
                for (int i3 = 0; i3 < stmtExprIndex.length; ++i3) {
                    if (stmtExprIndex[i3].getMapping() != mapping) continue;
                    return stmtExprIndex;
                }
                StatementExpressionIndex[] tmpStmtExprIndex = stmtExprIndex;
                stmtExprIndex = new StatementExpressionIndex[tmpStmtExprIndex.length + 1];
                for (i = 0; i < tmpStmtExprIndex.length; ++i) {
                    stmtExprIndex[i] = tmpStmtExprIndex[i];
                }
                pos = tmpStmtExprIndex.length;
            }
            stmtExprIndex[pos] = new StatementExpressionIndex();
            stmtExprIndex[pos].setMapping(mapping);
            int[] param = new int[mapping.getNumberOfDatastoreFields()];
            for (i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(((Column)mapping.getDataStoreMapping(i).getDatastoreField()).getIdentifier());
                this.columnValues.append(((RDBMSMapping)mapping.getDataStoreMapping(i)).getUpdateInputParameter());
                ++this.paramIndex;
            }
            stmtExprIndex[pos].setParameterIndex(param);
            return stmtExprIndex;
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getInsertFieldNumbers() {
            int[] fieldNumbers = new int[this.insertFields.size()];
            for (int i = 0; i < this.insertFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.insertFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getReachableFieldNumbers() {
            int[] fieldNumbers = new int[this.reachableFields.size()];
            for (int i = 0; i < this.reachableFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.reachableFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getRelationFieldNumbers() {
            int[] fieldNumbers = new int[this.relationFields.size()];
            for (int i = 0; i < this.relationFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.relationFields.get(i);
            }
            return fieldNumbers;
        }

        public StatementExpressionIndex[] getStatementExpressionIndex() {
            return this.statementExpressionIndex;
        }

        public StatementExpressionIndex[] getReachableStatementIndex() {
            return this.retrievedStatementExpressionIndex;
        }

        public StatementExpressionIndex getVersionStatementExpressionIndex() {
            return this.versionStatementExpressionIndex;
        }

        public StatementExpressionIndex getDiscriminatorStatementExpressionIndex() {
            return this.discriminatorStatementExpressionIndex;
        }

        public StatementExpressionIndex[] getExternalFKStatementExpressionIndex() {
            return this.externalFKStmtExprIndex;
        }

        public StatementExpressionIndex[] getExternalFKDiscrimStatementExpressionIndex() {
            return this.externalFKDiscrimStmtExprIndex;
        }

        public StatementExpressionIndex[] getExternalOrderStatementExpressionIndex() {
            return this.externalOrderStmtExprIndex;
        }

        public String getInsertStmt() {
            if (this.columnNames.length() > 0 && this.columnValues.length() > 0) {
                return "INSERT INTO " + ((Object)InsertRequest.this.table).toString() + " (" + this.columnNames + ") VALUES (" + this.columnValues + ")";
            }
            return ((RDBMSAdapter)InsertRequest.this.table.getStoreManager().getDatastoreAdapter()).getInsertStatementForNoColumns((Table)((Object)InsertRequest.this.table));
        }
    }
}

