/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXOptimisticException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.VersionMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.VersionCheckRequest;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class UpdateRequest
extends VersionCheckRequest {
    private final String updateStmt;
    private final String updateStmtOptimistic;
    private final MappingCallbacks[] callbacks;
    private MappingStatementIndex mappingStatementIndex = new MappingStatementIndex();
    private final int[] updateFieldNumbers;
    private final int[] pkFieldNumbers;
    private final AbstractMemberMetaData[] oneToOneNonOwnerFields;
    private final int highestFieldNumber;
    static /* synthetic */ Class class$java$lang$Integer;

    public UpdateRequest(DatastoreClass table, AbstractMemberMetaData[] reqFieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(table, cls, clr);
        AbstractMemberMetaData[] updateFmds;
        UpdateMappingConsumer consumer = new UpdateMappingConsumer(clr, this.cmd);
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                updateFmds = new AbstractMemberMetaData[reqFieldMetaData.length + 1];
                for (int i = 0; i < reqFieldMetaData.length; ++i) {
                    updateFmds[i] = reqFieldMetaData[i];
                }
                updateFmds[updateFmds.length - 1] = this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName());
                table.provideMappingsForFields(consumer, updateFmds, false);
            } else {
                table.provideMappingsForFields(consumer, reqFieldMetaData, false);
                table.provideVersionMappings(consumer);
            }
        } else {
            table.provideMappingsForFields(consumer, reqFieldMetaData, false);
        }
        consumer.setWhereClauseConsumption(true);
        table.providePrimaryKeyMappings(consumer);
        table.provideDatastoreIdMappings(consumer);
        this.updateStmt = consumer.getStatement();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                updateFmds = new AbstractMemberMetaData[]{this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName())};
                table.provideMappingsForFields(consumer, updateFmds, false);
            } else {
                table.provideVersionMappings(consumer);
            }
        }
        this.updateStmtOptimistic = consumer.getStatement();
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        this.updateFieldNumbers = consumer.getUpdateFieldNumbers();
        this.oneToOneNonOwnerFields = consumer.getOneToOneNonOwnerFields();
        this.highestFieldNumber = consumer.getHighestFieldNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        String stmt = null;
        ObjectManager om = sm.getObjectManager();
        boolean optimisticChecks = this.versionMetaData != null && om.getTransaction().getOptimistic() && this.versionChecks;
        stmt = optimisticChecks ? this.updateStmtOptimistic : this.updateStmt;
        if (stmt != null) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < this.updateFieldNumbers.length; ++i) {
                    if (fieldStr.length() > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.updateFieldNumbers[i]).getName());
                }
                if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
                    if (fieldStr.length() > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append("[VERSION]");
                }
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.Update", StringUtils.toJVMIDString(sm.getObject()), fieldStr.toString(), this.table));
            }
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            boolean batch = false;
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, stmt, batch);
                    try {
                        int[] rcs;
                        Object currentVersion = sm.getTransactionalVersion(sm.getObject());
                        Object nextVersion = null;
                        if (this.versionMetaData != null) {
                            if (this.versionMetaData.getFieldName() != null) {
                                AbstractMemberMetaData verfmd = this.cmd.getMetaDataForMember(this.table.getVersionMetaData().getFieldName());
                                if (currentVersion instanceof Integer) {
                                    currentVersion = new Long(((Integer)currentVersion).longValue());
                                }
                                nextVersion = VersionMapping.getNextVersion(this.versionMetaData, currentVersion);
                                if (verfmd.getType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = UpdateRequest.class$("java.lang.Integer")) : class$java$lang$Integer) || verfmd.getType() == Integer.TYPE) {
                                    nextVersion = new Integer(((Long)nextVersion).intValue());
                                }
                                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextVersion, false);
                            } else {
                                nextVersion = VersionMapping.getNextVersion(this.versionMetaData, currentVersion);
                            }
                            sm.setTransactionalVersion(nextVersion);
                        }
                        if (this.updateFieldNumbers != null) {
                            sm.provideFields(this.updateFieldNumbers, new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), true));
                        }
                        if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
                            this.table.getVersionMapping().setObject(om, ps, this.mappingStatementIndex.getVersion().getParameterIndex(), nextVersion);
                        }
                        if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                            sm.provideFields(this.pkFieldNumbers, new ParameterSetter(sm, ps, this.mappingStatementIndex.getPrimaryKeys(), true));
                        }
                        if (optimisticChecks) {
                            JavaTypeMapping verMapping = this.mappingStatementIndex.getVersion2().getMapping();
                            verMapping.setObject(om, ps, this.mappingStatementIndex.getVersion2().getParameterIndex(), currentVersion);
                        }
                        if ((rcs = sqlControl.executeStatementUpdate(conn, stmt, ps, !batch))[0] == 0 && optimisticChecks) {
                            String msg = LOCALISER.msg("RDBMS.Request.OptimisticVersionMismatch", StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId(), "" + sm.getTransactionalVersion(sm.getObject()));
                            JPOXLogger.RDBMS.error(msg);
                            throw new JPOXOptimisticException(msg, sm.getObject());
                        }
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("RDBMS.Request.Update.Error", StringUtils.toJVMIDString(sm.getObject()), stmt, e.getMessage());
                JPOXLogger.RDBMS_SQL.error(msg);
                throw new JPOXDataStoreException(msg, e);
            }
        }
        if (this.oneToOneNonOwnerFields != null && this.oneToOneNonOwnerFields.length > 0) {
            for (int i = 0; i < this.oneToOneNonOwnerFields.length; ++i) {
                this.updateOneToOneBidirectionalOwnerObjectForField(sm, this.oneToOneNonOwnerFields[i]);
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.PostUpdate", StringUtils.toJVMIDString(sm.getObject()), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getFullFieldName()));
                }
                this.callbacks[i].postUpdate(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOneToOneBidirectionalOwnerObjectForField(StateManager sm, AbstractMemberMetaData fmd) {
        block33: {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("RDBMS.Request.UpdateRelated", StringUtils.toJVMIDString(sm.getObject()), fmd.getFullFieldName()));
            }
            ObjectManager om = sm.getObjectManager();
            ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
            AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
            int relationType = fmd.getRelationType(clr);
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            Object newValue = sm.provideField(fmd.getAbsoluteFieldNumber());
            JavaTypeMapping m = this.table.getFieldMapping(fmd);
            DatastoreClass relatedTable = null;
            if (m instanceof ReferenceMapping) {
                JPOXLogger.RDBMS.warn("PC object with 1-1 reference to other PC objects via interface/Object field with FK stored in the related objects. Using first available implementation!");
                JavaTypeMapping[] refMappings = ((ReferenceMapping)m).getJavaTypeMapping();
                relatedTable = sm.getStoreManager().getDatastoreClass(refMappings[0].getType(), clr);
            } else {
                relatedTable = sm.getStoreManager().getDatastoreClass(fmd.getTypeName(), clr);
            }
            if (relatedTable == null) {
                throw new JPOXException("Could not find table for type " + fmd.getTypeName() + ". You should verify if the inheritance strategy is valid.");
            }
            JavaTypeMapping refMapping = relatedTable.getFieldMapping(fmd.getMappedBy());
            StateManager newSM = om.findStateManager(newValue);
            if (newSM != null && relationType == 4) {
                newSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
            }
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    int j;
                    JavaTypeMapping refIdMapping = relatedMmds[0].getAbstractClassMetaData().getIdentityType() == IdentityType.DATASTORE ? relatedTable.getDataStoreObjectIdMapping() : relatedTable.getIDMapping();
                    StringBuffer clearLinkStmt = new StringBuffer("UPDATE " + ((Object)relatedTable).toString() + " SET ");
                    for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                        if (j > 0) {
                            clearLinkStmt.append(",");
                        }
                        clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                        clearLinkStmt.append("=NULL");
                    }
                    clearLinkStmt.append(" WHERE ");
                    for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                        if (j > 0) {
                            clearLinkStmt.append(" AND ");
                        }
                        clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                        clearLinkStmt.append("=?");
                    }
                    if (sm.provideField(fmd.getAbsoluteFieldNumber()) != null) {
                        for (j = 0; j < refIdMapping.getNumberOfDatastoreFields(); ++j) {
                            clearLinkStmt.append(" AND ");
                            clearLinkStmt.append(refIdMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                            clearLinkStmt.append("<>?");
                        }
                    }
                    PreparedStatement ps = null;
                    try {
                        ps = sqlControl.getStatementForUpdate(conn, clearLinkStmt.toString(), false);
                        refMapping.setObject(om, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        if (sm.provideField(fmd.getAbsoluteFieldNumber()) != null) {
                            StatementExpressionIndex[] indexes = new StatementExpressionIndex[this.highestFieldNumber];
                            StatementExpressionIndex index = new StatementExpressionIndex();
                            index.setMapping(refIdMapping);
                            int[] paramIndexes = new int[refIdMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < paramIndexes.length; ++i) {
                                paramIndexes[i] = refMapping.getNumberOfDatastoreFields() + 1 + i;
                            }
                            index.setParameterIndex(paramIndexes);
                            indexes[fmd.getAbsoluteFieldNumber()] = index;
                            sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, new ParameterSetter(sm, ps, indexes, false));
                        }
                        sqlControl.executeStatementUpdate(conn, clearLinkStmt.toString(), ps, true);
                    }
                    finally {
                        if (ps != null) {
                            sqlControl.closeStatement(conn, ps);
                        }
                    }
                    if (newValue == null) break block33;
                    ps = null;
                    try {
                        int j2;
                        StringBuffer newLinkStmt = new StringBuffer("UPDATE " + ((Object)relatedTable).toString() + " SET ");
                        for (j2 = 0; j2 < refMapping.getNumberOfDatastoreFields(); ++j2) {
                            if (j2 > 0) {
                                newLinkStmt.append(",");
                            }
                            newLinkStmt.append(refMapping.getDataStoreMapping(j2).getDatastoreField().getIdentifier());
                            newLinkStmt.append("=?");
                        }
                        newLinkStmt.append(" WHERE ");
                        for (j2 = 0; j2 < refIdMapping.getNumberOfDatastoreFields(); ++j2) {
                            if (j2 > 0) {
                                newLinkStmt.append(" AND ");
                            }
                            newLinkStmt.append(refIdMapping.getDataStoreMapping(j2).getDatastoreField().getIdentifier());
                            newLinkStmt.append("=?");
                        }
                        ps = sqlControl.getStatementForUpdate(conn, newLinkStmt.toString(), false);
                        refMapping.setObject(om, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        StatementExpressionIndex[] indexes = new StatementExpressionIndex[this.highestFieldNumber];
                        StatementExpressionIndex index = new StatementExpressionIndex();
                        index.setMapping(refIdMapping);
                        int[] paramIndexes = new int[refIdMapping.getNumberOfDatastoreFields()];
                        for (int i = 0; i < paramIndexes.length; ++i) {
                            paramIndexes[i] = refMapping.getNumberOfDatastoreFields() + 1 + i;
                        }
                        index.setParameterIndex(paramIndexes);
                        indexes[fmd.getAbsoluteFieldNumber()] = index;
                        sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, new ParameterSetter(sm, ps, indexes, false));
                        sqlControl.executeStatementUpdate(conn, newLinkStmt.toString(), ps, true);
                    }
                    finally {
                        if (ps != null) {
                            sqlControl.closeStatement(conn, ps);
                        }
                    }
                    newSM = om.findStateManager(newValue);
                    if (newSM != null) {
                        newSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JPOXDataStoreException("Update request failed", e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UpdateMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        int paramIndex = 1;
        int highestFieldNumber = 0;
        List updateFields = new ArrayList();
        List pkFields = new ArrayList();
        List oneToOneNonOwnerFields = new ArrayList();
        List mc = new ArrayList();
        StringBuffer columnAssignments = new StringBuffer();
        Map assignedColumns = new HashMap();
        StringBuffer where = new StringBuffer();
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;
        private boolean whereClauseConsumption = false;

        public UpdateMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
            this.clr = clr;
            this.cmd = cmd;
        }

        public void setWhereClauseConsumption(boolean whereClause) {
            this.whereClauseConsumption = whereClause;
        }

        public int getHighestFieldNumber() {
            return this.highestFieldNumber;
        }

        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                this.highestFieldNumber = highest;
                UpdateRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highest]);
                UpdateRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highest]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (fmd.hasExtension("updateable") && fmd.getValueForExtension("updateable").equalsIgnoreCase("false")) {
                    return;
                }
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds != null && colmds.length > 0) {
                    for (int i = 0; i < colmds.length; ++i) {
                        if (colmds[i].getUpdateable()) continue;
                        return;
                    }
                }
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                if (m.getNumberOfDatastoreFields() == 0 && m instanceof PersistenceCapableMapping || m instanceof ReferenceMapping) {
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        if (fmd.getMappedBy() != null) {
                            this.oneToOneNonOwnerFields.add(fmd);
                        }
                    } else if (relationType == 6) {
                        AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                        if (fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
                StatementExpressionIndex sei = new StatementExpressionIndex();
                sei.setMapping(m);
                sei.setParameterIndex(parametersIndex);
                if (fmd.isPrimaryKey()) {
                    ((UpdateRequest)UpdateRequest.this).mappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.where.append(condition);
                        if (!this.pkFields.contains(abs_field_num)) {
                            this.pkFields.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                } else if (this.whereClauseConsumption) {
                    UpdateRequest.this.mappingStatementIndex.setVersion2(sei);
                    ++this.paramIndex;
                    String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                    String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    this.where.append(condition);
                } else {
                    ((UpdateRequest)UpdateRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (!this.assignedColumns.containsKey(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString())) {
                            if (this.columnAssignments.length() > 0) {
                                this.columnAssignments.append(", ");
                            }
                            String param = ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                            this.columnAssignments.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).append("=").append(param);
                            if (param.indexOf("?") > -1) {
                                if (!this.updateFields.contains(abs_field_num)) {
                                    this.updateFields.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                            continue;
                        }
                        parametersIndex[j] = (Integer)this.assignedColumns.get(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                int[] param = new int[]{this.paramIndex++};
                StatementExpressionIndex versStmtIdx = null;
                if (this.whereClauseConsumption) {
                    versStmtIdx = UpdateRequest.this.mappingStatementIndex.getVersion2();
                    String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    this.where.append(condition);
                } else {
                    versStmtIdx = UpdateRequest.this.mappingStatementIndex.getVersion();
                    String condition = m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    if (this.columnAssignments.length() > 0) {
                        this.columnAssignments.append(", ");
                    }
                    this.columnAssignments.append(condition);
                }
                versStmtIdx.setMapping(m);
                versStmtIdx.setParameterIndex(param);
            } else if (mappingType == 2) {
                String condition = ((DatastoreField)UpdateRequest.this.key.getColumns().get(0)).getIdentifier() + "=?";
                this.where.append(condition);
                int[] param = new int[]{this.paramIndex++};
                UpdateRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(param);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getUpdateFieldNumbers() {
            int[] fieldNumbers = new int[this.updateFields.size()];
            for (int i = 0; i < this.updateFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.updateFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public AbstractMemberMetaData[] getOneToOneNonOwnerFields() {
            AbstractMemberMetaData[] fields = new AbstractMemberMetaData[this.oneToOneNonOwnerFields.size()];
            for (int i = 0; i < this.oneToOneNonOwnerFields.size(); ++i) {
                fields[i] = (AbstractMemberMetaData)this.oneToOneNonOwnerFields.get(i);
            }
            return fields;
        }

        public String getStatement() {
            if (this.columnAssignments.length() < 1) {
                return null;
            }
            return "UPDATE " + ((Object)UpdateRequest.this.table).toString() + " SET " + this.columnAssignments + " WHERE " + this.where;
        }
    }
}

