/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.VersionMetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.FetchStatement;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.Request;
import org.jpox.store.rdbms.table.AbstractClassTable;

public abstract class VersionCheckRequest
extends Request {
    protected AbstractClassMetaData cmd = null;
    protected String versionStmt = null;
    protected MappingStatementIndex versionMappingStatementIndex = null;
    protected int[] versionPkFieldsToBeProvided = null;
    protected boolean versionChecks = false;
    protected VersionMetaData versionMetaData = null;
    protected JavaTypeMapping versionMapping = null;

    public VersionCheckRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table);
        this.cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        this.versionMetaData = table.getVersionMetaData();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName());
                this.versionMapping = table.getFieldMapping(fmd);
            } else {
                this.versionMapping = table.getVersionMapping();
            }
            VersionMappingConsumer versionConsumer = new VersionMappingConsumer(this.cmd, (AbstractClassTable)((Object)table));
            this.versionMappingStatementIndex = versionConsumer.getMappingStatementIndex();
            this.versionStmt = versionConsumer.getStatement();
            this.versionPkFieldsToBeProvided = versionConsumer.getPrimaryKeyFieldsToBeProvided();
            if (this.versionMetaData.getVersionStrategy() != VersionStrategy.NONE) {
                this.versionChecks = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getCurrentVersionForObject(StateManager sm, Connection conn, SQLController sqlControl) throws SQLException {
        Object datastoreVersion = null;
        ObjectManager om = sm.getObjectManager();
        if (this.versionStmt != null) {
            PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.versionStmt);
            try {
                if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                    this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.versionMappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                    sm.provideFields(this.versionPkFieldsToBeProvided, new ParameterSetter(sm, ps, this.versionMappingStatementIndex.getPrimaryKeys(), true));
                }
                ResultSet rs = sqlControl.executeStatementQuery(conn, this.versionStmt, ps);
                try {
                    if (rs.next()) {
                        datastoreVersion = this.versionMapping.getObject(om, rs, this.versionMappingStatementIndex.getVersion().getExpressionIndex());
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                sqlControl.closeStatement(conn, ps);
            }
        }
        return datastoreVersion;
    }

    class VersionMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        boolean hasVersionMapping = false;
        int paramIndex = 1;
        int exprIndex = 1;
        List pkbp = new ArrayList();
        private final AbstractClassMetaData cmd;
        FetchStatement fetchStmt = null;
        MappingStatementIndex versionMappingStatementIndex;

        public VersionMappingConsumer(AbstractClassMetaData cmd, AbstractClassTable table) {
            this.cmd = cmd;
            this.fetchStmt = new RDBMSFetchStatement(table.getPrimaryDatastoreContainerObject());
            this.versionMappingStatementIndex = new MappingStatementIndex();
            if (VersionCheckRequest.this.versionMetaData.getFieldName() != null) {
                AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[]{cmd.getMetaDataForMember(VersionCheckRequest.this.versionMetaData.getFieldName())};
                table.provideMappingsForFields(this, fmds, false);
                table.providePrimaryKeyMappings(this);
                table.provideDatastoreIdMappings(this);
            } else {
                table.provideVersionMappings(this);
                table.providePrimaryKeyMappings(this);
                table.provideDatastoreIdMappings(this);
            }
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.versionMappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                StatementExpressionIndex sei = new StatementExpressionIndex();
                sei.setMapping(m);
                sei.setParameterIndex(parametersIndex);
                if (fmd.isPrimaryKey()) {
                    this.versionMappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.fetchStmt.andCondition(condition);
                        this.pkbp.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        ++this.paramIndex;
                    }
                } else if (fmd.getName().equals(VersionCheckRequest.this.versionMetaData.getFieldName())) {
                    this.hasVersionMapping = true;
                    this.fetchStmt.select(m.getDataStoreMapping(0).getDatastoreField());
                    this.versionMappingStatementIndex.getVersion().setMapping(m);
                    this.versionMappingStatementIndex.getVersion().setExpressionIndex(new int[]{this.exprIndex++});
                }
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                this.hasVersionMapping = true;
                this.fetchStmt.select(m.getDataStoreMapping(0).getDatastoreField());
                this.versionMappingStatementIndex.getVersion().setMapping(m);
                this.versionMappingStatementIndex.getVersion().setExpressionIndex(new int[]{this.exprIndex++});
            } else if (mappingType == 2) {
                String condition = ((DatastoreField)VersionCheckRequest.this.key.getColumns().get(0)).getIdentifier() + "=? ";
                this.fetchStmt.andCondition(condition);
                int[] param = new int[]{this.paramIndex++};
                this.versionMappingStatementIndex.getDatastoreId().setParameterIndex(param);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public String getStatement() {
            if (!this.hasVersionMapping) {
                return null;
            }
            return ((Object)this.fetchStmt).toString();
        }

        public MappingStatementIndex getMappingStatementIndex() {
            return this.versionMappingStatementIndex;
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }
    }
}

