/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.scostore.ElementContainerStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.util.JPOXLogger;

public abstract class AbstractArrayStore
extends ElementContainerStore
implements ArrayStore {
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractArrayStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public List getArray(StateManager ownerSM) {
        Iterator iter = this.iterator(ownerSM);
        ArrayList elements = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            elements.add(obj);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        String clearStmt = this.getClearStmt();
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    sqlControl.executeStatementUpdate(conn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", clearStmt), e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getObjectManager().deleteObjects(dependentElements.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(StateManager ownerSM, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ownerSM, obj, null);
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = this.allowsBatching() && length > 1;
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            sqlControl.processStatementsForConnection(conn);
            try {
                Object element = null;
                for (int i = 0; i < length; ++i) {
                    element = Array.get(array, i);
                    try {
                        int[] rc = this.internalAdd(ownerSM, element, conn, batched, i, i == length - 1);
                        if (rc == null) continue;
                        for (int j = 0; j < rc.length; ++j) {
                            if (rc[j] <= 0) continue;
                            modified = true;
                        }
                        continue;
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                        exceptions.add(sqle);
                        JPOXLogger.RDBMS.error(sqle);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            JPOXLogger.RDBMS.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getAddStmt());
            JPOXLogger.RDBMS.error(msg);
            throw new JPOXDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), (Object)ownerSM.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int position) {
        this.validateElementForWriting(sm, element, null);
        boolean modified = false;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            try {
                int[] returnCode = this.internalAdd(sm, element, conn, false, position, true);
                if (returnCode[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getAddStmt()), e);
        }
        return modified;
    }

    protected int[] internalAdd(StateManager sm, Object element, Connection conn, boolean batched, int orderId, boolean executeNow) throws SQLException {
        ObjectManager om = sm.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, false);
        boolean notYetFlushedError = false;
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            jdbcPosition = this.populateOrderInStatement(om, ps, orderId, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
            return nArray;
        }
        catch (NotYetFlushedException nfe) {
            notYetFlushedError = true;
            throw nfe;
        }
        finally {
            if (notYetFlushedError) {
                sqlControl.abortStatementForConnection(conn, ps);
            } else {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager ownerSM) {
        ArrayStoreIterator iter;
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new JPOXException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull")).setFatal();
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = stmt.toStatementText(useUpdateLock).toString();
        if (statement == null) {
            throw new JPOXException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull")).setFatal();
        }
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = stmt.toStatementText(useUpdateLock).prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, statement, ps);
                    try {
                        iter = new ArrayStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.IteratorRequestFailed", statement), e);
        }
        return iter;
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        stmt.select(collectionRangeVar, this.elementMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = AbstractArrayStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ArrayStoreIterator
    implements Iterator {
        private final ObjectManager om;
        private final Iterator delegate;
        private Object lastElement = null;

        public ArrayStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.om = sm.getObjectManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractArrayStore.this.elementsAreEmbedded || AbstractArrayStore.this.elementsAreSerialised) {
                        param = new int[AbstractArrayStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractArrayStore.this.elementMapping instanceof SerialisedPCMapping || AbstractArrayStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractArrayStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractArrayStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractArrayStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractArrayStore.this.elementMapping.getObject(this.om, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractArrayStore.this.elementMapping.getObject(this.om, rs, param);
                        }
                    } else if (AbstractArrayStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractArrayStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractArrayStore.this.elementMapping.getObject(this.om, rs, param);
                    } else {
                        nextElement = rof.getObject(this.om, rs);
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
        }
    }
}

