/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.scostore.AbstractCollectionStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.JPOXLogger;

abstract class AbstractSetStore
extends AbstractCollectionStore
implements SetStore {
    protected String setName;

    protected AbstractSetStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager ownerSM) {
        SetStoreIterator iter;
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new JPOXException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull")).setFatal();
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        String statement = stmt.toStatementText(useUpdateLock).toString();
        if (statement == null) {
            throw new JPOXException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull")).setFatal();
        }
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = stmt.toStatementText(useUpdateLock).prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, statement, ps);
                    try {
                        iter = new SetStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.IteratorRequestFailed", statement), e);
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int size) {
        this.validateElementForWriting(sm, element, null);
        boolean modified = false;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            try {
                int[] num = this.internalAdd(sm, conn, false, element, true);
                if (num[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getAddStmt());
            JPOXLogger.RDBMS.error(msg);
            throw new JPOXDataStoreException(msg, e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForWriting(sm, iter.next(), null);
        }
        ObjectManager om = sm.getObjectManager();
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        Connection conn = (Connection)mconn.getConnection();
        try {
            iter = elements.iterator();
            Object element = null;
            int[] returnCode = null;
            while (iter.hasNext()) {
                element = iter.next();
                try {
                    returnCode = this.internalAdd(sm, conn, batched, element, !batched || batched && !iter.hasNext());
                }
                catch (SQLException sqe) {
                    exceptions.add(sqe);
                    JPOXLogger.RDBMS.error(sqe);
                }
            }
            if (exceptions.size() == 0) {
                if (returnCode == null) {
                    modified = false;
                } else {
                    for (int i = 0; i < returnCode.length; ++i) {
                        if (returnCode[i] <= 0) continue;
                        modified = true;
                    }
                }
            }
        }
        finally {
            mconn.release();
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getAddStmt());
            JPOXLogger.RDBMS.error(msg);
            throw new JPOXDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), (Object)sm.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalAdd(StateManager ownerSM, Connection conn, boolean batched, Object element, boolean processNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, processNow);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(StateManager sm, Object element, int size) {
        if (!this.validateElementForReading(sm, element)) {
            JPOXLogger.RDBMS.debug("AbstractSetStore::remove element=" + element + " doesn't exist in this Set.");
            return false;
        }
        boolean modified = false;
        ObjectManager om = sm.getObjectManager();
        String removeStmt = this.getRemoveStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    modified = (rowsDeleted = sqlControl.executeStatementUpdate(conn, removeStmt, ps, true))[0] == 1;
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            String msg = LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", removeStmt);
            JPOXLogger.RDBMS.error(msg);
            throw new JPOXDataStoreException(msg, e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement()) {
            om.deleteObjectInternal(element);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (this.validateElementForReading(sm, element)) continue;
            JPOXLogger.RDBMS.debug("AbstractSetStore::removeAll element=" + element + " doesn't exist in this Set.");
            return false;
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            try {
                Object element = null;
                iter = elements.iterator();
                SQLController sqlControl = this.storeMgr.getSQLController();
                sqlControl.processStatementsForConnection(conn);
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalRemove(sm, conn, batched, element, !batched || batched && !iter.hasNext());
                        if (rc == null) continue;
                        for (int i = 0; i < rc.length; ++i) {
                            if (rc[i] <= 0) continue;
                            modified = true;
                        }
                    }
                    catch (SQLException sqe) {
                        sqe.printStackTrace();
                        exceptions.add(sqe);
                        JPOXLogger.RDBMS.error(sqe);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            JPOXLogger.RDBMS.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", this.getRemoveStmt());
            JPOXLogger.RDBMS.error(msg);
            throw new JPOXDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), (Object)sm.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalRemove(StateManager ownerSM, Connection conn, boolean batched, Object element, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
            jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
            }
            int[] nArray = sqlControl.executeStatementUpdate(conn, removeStmt, ps, executeNow);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    private class SetStoreIterator
    implements Iterator {
        private final StateManager sm;
        private final ObjectManager om;
        private final Iterator delegate;
        private Object lastElement = null;

        public SetStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.sm = sm;
            this.om = sm.getObjectManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractSetStore.this.elementsAreEmbedded || AbstractSetStore.this.elementsAreSerialised) {
                        param = new int[AbstractSetStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractSetStore.this.elementMapping instanceof SerialisedPCMapping || AbstractSetStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractSetStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractSetStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractSetStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractSetStore.this.elementMapping.getObject(this.om, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractSetStore.this.elementMapping.getObject(this.om, rs, param);
                        }
                    } else if (AbstractSetStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractSetStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractSetStore.this.elementMapping.getObject(this.om, rs, param);
                    } else {
                        nextElement = rof.getObject(this.om, rs);
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            AbstractSetStore.this.remove(this.sm, this.lastElement, -1);
            this.delegate.remove();
            this.lastElement = null;
        }
    }
}

