/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.PreparedStatement;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.util.Localiser;

abstract class BaseContainerStore {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected RDBMSManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected final DatastoreIdentifier thisIdentifier;
    protected boolean allowsNull = false;
    static /* synthetic */ Class class$org$jpox$store$mapping$InterfaceMapping;
    static /* synthetic */ Class class$org$jpox$store$mapping$OIDMapping;

    protected BaseContainerStore(StoreManager storeMgr) {
        this.storeMgr = (RDBMSManager)storeMgr;
        this.dba = storeMgr.getDatastoreAdapter();
        this.thisIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "this");
    }

    protected void setOwnerMemberMetaData(AbstractMemberMetaData mmd) {
        this.ownerMemberMetaData = mmd;
        if (this.ownerMemberMetaData.hasExtension("allow-nulls") && this.ownerMemberMetaData.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            this.allowsNull = true;
        }
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean isEmbeddedMapping(JavaTypeMapping mapping) {
        return !(class$org$jpox$store$mapping$InterfaceMapping == null ? (class$org$jpox$store$mapping$InterfaceMapping = BaseContainerStore.class$("org.jpox.store.mapping.InterfaceMapping")) : class$org$jpox$store$mapping$InterfaceMapping).isAssignableFrom(mapping.getClass()) && !(class$org$jpox$store$mapping$OIDMapping == null ? (class$org$jpox$store$mapping$OIDMapping = BaseContainerStore.class$("org.jpox.store.mapping.OIDMapping")) : class$org$jpox$store$mapping$OIDMapping).isAssignableFrom(mapping.getClass());
    }

    protected int populateOwnerInStatement(StateManager sm, ObjectManager om, PreparedStatement ps, int jdbcPosition) {
        if (!((RDBMSMapping)this.ownerMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        if (this.ownerMemberMetaData != null) {
            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject(), sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
        } else {
            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), sm.getObject());
        }
        return jdbcPosition + this.ownerMapping.getNumberOfDatastoreFields();
    }

    protected StateManager getStateManagerForEmbeddedPCObject(StateManager sm, Object obj, JoinTable table) {
        ObjectManager om = sm.getObjectManager();
        StateManager objSM = om.findStateManager(obj);
        if (objSM == null) {
            objSM = StateManagerFactory.newStateManagerForEmbedded(om, obj, false);
            AbstractMemberMetaData ownerFmd = table.getOwnerFieldMetaData();
            objSM.addEmbeddedOwner(sm, ownerFmd.getAbsoluteFieldNumber());
        }
        return objSM;
    }

    protected boolean allowsBatching() {
        return ((RDBMSAdapter)this.dba).supportsStatementBatching() && this.storeMgr.getOMFContext().getPersistenceConfiguration().getStatementBatchLimit() != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

