/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlan;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.IdentityType;
import org.jpox.sco.SCOUtils;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.store.rdbms.scostore.BaseContainerStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.util.ClassUtils;

public abstract class ElementContainerStore
extends BaseContainerStore {
    protected boolean iterateUsingDiscriminator = false;
    protected ElementInfo[] elementInfo;
    protected AbstractClassMetaData emd;
    protected DatastoreContainerObject containerTable;
    protected JavaTypeMapping elementMapping;
    protected String elementType;
    protected boolean elementsAreEmbedded;
    protected boolean elementsAreSerialised;
    protected boolean elementIsPersistentInterface = false;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;
    protected final DatastoreIdentifier elmIdentifier;
    protected ClassLoaderResolver clr;
    private String sizeStmt;
    protected String clearStmt;
    protected String addStmt;
    protected String removeStmt;
    protected boolean usingDiscriminatorInSizeStmt = false;

    protected ElementContainerStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.clr = clr;
        this.elmIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "ELEMENT");
    }

    protected ElementInfo[] getElementInformationForClass() {
        String[] clsNames;
        DatastoreClass tbl;
        ElementInfo[] info = null;
        if (!this.clr.classForName(this.elementType).isInterface()) {
            tbl = this.storeMgr.getDatastoreClass(this.elementType, this.clr);
            clsNames = new String[]{this.elementType};
        } else {
            clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.elementType, this.clr);
            tbl = this.storeMgr.getDatastoreClass(clsNames[0], this.clr);
        }
        if (tbl == null) {
            AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(this.emd, this.clr);
            info = new ElementInfo[subclassCmds.length];
            for (int i = 0; i < subclassCmds.length; ++i) {
                DatastoreClass table = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), this.clr);
                info[i] = new ElementInfo(subclassCmds[i], table);
            }
        } else {
            info = new ElementInfo[clsNames.length];
            for (int i = 0; i < clsNames.length; ++i) {
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                info[i] = new ElementInfo(cmd, table);
            }
        }
        return info;
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    public String getElementType() {
        return this.elementType;
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType(elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        return clr.isAssignableFrom(this.elementType, element.getClass());
    }

    protected boolean validateElementForReading(StateManager sm, Object element) {
        ObjectManager om;
        if (!this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            return false;
        }
        return element == null || this.elementsAreEmbedded || this.elementsAreSerialised || (om = sm.getObjectManager()).getApiAdapter().isPersistent(element) && om == ObjectManagerHelper.getObjectManager(element) || om.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementForWriting(StateManager sm, Object element, FieldValues fieldValues) {
        if (!this.elementIsPersistentInterface && !this.validateElementType(sm.getObjectManager().getClassLoaderResolver(), element)) {
            throw new ClassCastException(LOCALISER.msg("RDBMS.SCO.Collection.ElementIsInvalid", element.getClass().getName(), this.ownerMemberMetaData.getFullFieldName(), this.elementType));
        }
        boolean persisted = false;
        if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
            ObjectManager om = sm.getObjectManager();
            StateManager elementSM = om.findStateManager(element);
            if (elementSM != null && elementSM.isEmbedded()) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.CannotContainEmbeddedElement", this.ownerMemberMetaData.getFullFieldName(), element));
            }
            persisted = SCOUtils.validateObjectForWriting(om, element, fieldValues);
        }
        return persisted;
    }

    protected int populateElementInStatement(ObjectManager om, PreparedStatement ps, Object element, int jdbcPosition) {
        if (!((RDBMSMapping)this.elementMapping.getDataStoreMapping(0)).insertValuesOnInsert()) {
            return jdbcPosition;
        }
        this.elementMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.elementMapping), element);
        return jdbcPosition + this.elementMapping.getNumberOfDatastoreFields();
    }

    protected int populateOrderInStatement(ObjectManager om, PreparedStatement ps, int idx, int jdbcPosition) {
        this.orderMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.orderMapping), new Integer(idx));
        return jdbcPosition + this.orderMapping.getNumberOfDatastoreFields();
    }

    protected int populateRelationDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition) {
        this.relationDiscriminatorMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.relationDiscriminatorMapping), this.relationDiscriminatorValue);
        return jdbcPosition + this.relationDiscriminatorMapping.getNumberOfDatastoreFields();
    }

    protected int populateElementDiscriminatorInStatement(ObjectManager om, PreparedStatement ps, int jdbcPosition, boolean includeSubclasses, ElementInfo info) {
        HashSet subclasses;
        DiscriminatorStrategy strategy = info.getDiscriminatorStrategy();
        JavaTypeMapping discrimMapping = info.getDiscriminatorMapping();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), info.getClassName());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), info.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
        }
        if (includeSubclasses && (subclasses = this.storeMgr.getSubClassesForClass(info.getClassName(), true, this.clr)) != null && subclasses.size() > 0) {
            Iterator iter = subclasses.iterator();
            while (iter.hasNext()) {
                String subclass = (String)iter.next();
                if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                    discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), subclass);
                    jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
                    continue;
                }
                if (strategy != DiscriminatorStrategy.VALUE_MAP) continue;
                AbstractClassMetaData subclassCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(subclass, this.clr);
                discrimMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, discrimMapping), subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                jdbcPosition += discrimMapping.getNumberOfDatastoreFields();
            }
        }
        return jdbcPosition;
    }

    protected int populateEmbeddedElementFieldsInStatement(StateManager sm, Object element, PreparedStatement ps, int jdbcPosition, JoinTable joinTable) {
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)this.elementMapping;
        StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[this.emd.getNoOfManagedMembers() + this.emd.getNoOfInheritedManagedMembers()];
        int[] elementFieldNumbers = new int[embeddedMapping.getNumberOfJavaTypeMappings()];
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            int absFieldNum;
            JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
            elementFieldNumbers[i] = absFieldNum = this.emd.getAbsolutePositionOfMember(fieldMapping.getFieldMetaData().getName());
            if (fieldMapping == null) continue;
            statementExpressionIndex[absFieldNum] = new StatementExpressionIndex();
            statementExpressionIndex[absFieldNum].setMapping(fieldMapping);
            int[] jdbcParamPositions = new int[fieldMapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < fieldMapping.getNumberOfDatastoreFields(); ++j) {
                jdbcParamPositions[j] = jdbcPosition++;
            }
            statementExpressionIndex[absFieldNum].setParameterIndex(jdbcParamPositions);
        }
        StateManager elementSM = this.getStateManagerForEmbeddedPCObject(sm, element, joinTable);
        elementSM.setPcObjectType(2);
        elementSM.provideFields(elementFieldNumbers, new ParameterSetter(elementSM, ps, statementExpressionIndex, true));
        return jdbcPosition;
    }

    protected String getClearStmt() {
        if (this.clearStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearStmt = stmt.toString();
        }
        return this.clearStmt;
    }

    public abstract Iterator iterator(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && !collmd.isSerializedElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        String clearStmt = this.getClearStmt();
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    sqlControl.executeStatementUpdate(conn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", clearStmt), e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            Iterator iter = dependentElements.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (ownerSM.getObjectManager().getApiAdapter().isDeleted(obj)) continue;
                ownerSM.getObjectManager().deleteObjectInternal(obj);
            }
        }
    }

    protected String getSizeStmt() {
        int i;
        int i2;
        if (this.sizeStmt != null && !this.usingDiscriminatorInSizeStmt) {
            return this.sizeStmt;
        }
        boolean allowNulls = false;
        if (this.ownerMemberMetaData != null && this.ownerMemberMetaData.hasExtension("allow-nulls") && this.ownerMemberMetaData.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            allowNulls = true;
        }
        StringBuffer stmt = new StringBuffer();
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        stmt.append("SELECT COUNT(*) FROM ");
        stmt.append(this.containerTable.toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        if (this.elementInfo != null && this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass() != this.containerTable && this.elementInfo[0].getDiscriminatorMapping() != null) {
            joinedDiscrim = true;
            JavaTypeMapping elemIdMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
            if (allowNulls) {
                stmt.append(" LEFT OUTER JOIN ");
            } else {
                stmt.append(" INNER JOIN ");
            }
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString()).append(" ").append(joinedElementAlias).append(" ON ");
            for (i2 = 0; i2 < this.elementMapping.getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".").append(this.elementMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
                stmt.append("=");
                stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(containerAlias).append(".").append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append("=");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.orderMapping != null) {
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(">=0");
            }
        }
        if (this.elementInfo != null && this.elementInfo.length == 1) {
            StringBuffer discrStmt = new StringBuffer();
            for (i2 = 0; i2 < this.elementInfo.length; ++i2) {
                if (this.elementInfo[i2].getDiscriminatorMapping() == null) continue;
                this.usingDiscriminatorInSizeStmt = true;
                if (discrStmt.length() > 0) {
                    discrStmt.append(" OR ");
                }
                JavaTypeMapping discrimMapping = this.elementInfo[i2].getDiscriminatorMapping();
                for (int j = 0; j < discrimMapping.getNumberOfDatastoreFields(); ++j) {
                    if (joinedDiscrim) {
                        discrStmt.append(joinedElementAlias);
                    } else {
                        discrStmt.append(containerAlias);
                    }
                    discrStmt.append(".");
                    discrStmt.append(((Object)discrimMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                    discrStmt.append("=");
                    discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(j)).getUpdateInputParameter());
                }
                HashSet subclasses = this.storeMgr.getSubClassesForClass(this.elementInfo[i2].getClassName(), true, this.clr);
                if (subclasses == null || subclasses.size() <= 0) continue;
                for (int j = 0; j < subclasses.size(); ++j) {
                    for (int k = 0; k < discrimMapping.getNumberOfDatastoreFields(); ++k) {
                        discrStmt.append(" OR ");
                        if (joinedDiscrim) {
                            discrStmt.append(joinedElementAlias);
                        } else {
                            discrStmt.append(containerAlias);
                        }
                        discrStmt.append(".");
                        discrStmt.append(((Object)discrimMapping.getDataStoreMapping(k).getDatastoreField().getIdentifier()).toString());
                        discrStmt.append("=");
                        discrStmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(k)).getUpdateInputParameter());
                    }
                }
            }
            if (discrStmt.length() > 0) {
                stmt.append(" AND (");
                stmt.append(discrStmt);
                if (allowNulls) {
                    stmt.append(" OR ");
                    stmt.append(((Object)this.elementInfo[0].getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" IS NULL");
                }
                stmt.append(")");
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            for (int i3 = 0; i3 < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i3) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i3).getDatastoreField().getIdentifier()).toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i3)).getUpdateInputParameter());
            }
        }
        this.sizeStmt = stmt.toString();
        return this.sizeStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(StateManager sm) {
        int numRows;
        String sizeStmt = this.getSizeStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, sizeStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    if (this.elementInfo != null && this.elementInfo.length == 1) {
                        for (int i = 0; i < this.elementInfo.length; ++i) {
                            if (this.elementInfo[i].getDiscriminatorMapping() == null) continue;
                            jdbcPosition = this.populateElementDiscriminatorInStatement(om, ps, jdbcPosition, true, this.elementInfo[i]);
                        }
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(conn, sizeStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.SizeRequestFailed", sizeStmt));
                        }
                        numRows = rs.getInt(1);
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.SizeRequestFailed", sizeStmt), e);
        }
        return numRows;
    }

    protected String getAddStmt() {
        if (this.addStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("INSERT INTO ");
            stmt.append(this.containerTable.toString());
            stmt.append(" (");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                }
            }
            stmt.append(") VALUES (");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(0)).getInsertionInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(0)).getInsertionInputParameter());
                }
            }
            stmt.append(") ");
            this.addStmt = stmt.toString();
        }
        return this.addStmt;
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return new PersistentIDROF(null, null, this.emd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
        }
        if (this.elementMapping instanceof ReferenceMapping) {
            JavaTypeMapping[] implMappings = ((ReferenceMapping)this.elementMapping).getJavaTypeMapping();
            for (int i = 0; i < implMappings.length; ++i) {
                stmt.select(implMappings[i]);
            }
            return new PersistentIDROF(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, null, this.emd, null, null, null, ignoreCache, false, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
        }
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.elmIdentifier, this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            }
            if (this.elementInfo[0].getDatastoreClass().getVersionMapping() != null) {
                versionIndex = stmt.select(this.elmIdentifier, this.elementInfo[0].getDatastoreClass().getVersionMapping(), true);
            }
        } else {
            if (this.elementInfo[0].getDatastoreClass().getIdentityType() == IdentityType.DATASTORE) {
                datastoreIndex = stmt.select(this.thisIdentifier, this.elementInfo[0].getDatastoreClass().getDataStoreObjectIdMapping(), true);
            }
            if (this.elementInfo[0].getDatastoreClass().getVersionMapping() != null) {
                versionIndex = stmt.select(this.thisIdentifier, this.elementInfo[0].getDatastoreClass().getVersionMapping(), true);
            }
        }
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] prefetchFieldNumbers = null;
        if (useFetchPlan) {
            FetchPlan fp = sm.getObjectManager().getFetchPlan();
            fp.manageFetchPlanForClass(this.emd);
            FetchPlan.FetchPlanForClass fpc = fp.getFetchPlanForClass(this.emd);
            int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
            int[] fn = new int[fieldNumbers.length];
            int prefetchFieldCount = 0;
            int fieldCount = this.emd.getNoOfInheritedManagedMembers() + this.emd.getNoOfManagedMembers();
            statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                JavaTypeMapping m;
                AbstractMemberMetaData fmd = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                if (fmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || (m = this.elementInfo[0].getDatastoreClass().getFieldMapping(fmd)) == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                statementExpressionIndex[fieldNumbers[i]] = new StatementExpressionIndex();
                statementExpressionIndex[fieldNumbers[i]].setMapping(m);
                fn[prefetchFieldCount++] = fieldNumbers[i];
            }
            prefetchFieldNumbers = new int[prefetchFieldCount];
            System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
        } else if (this.emd.getIdentityType() == IdentityType.APPLICATION) {
            prefetchFieldNumbers = new int[this.emd.getPKMemberPositions().length];
            int fieldCount = this.emd.getNoOfInheritedManagedMembers() + this.emd.getNoOfManagedMembers();
            statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                JavaTypeMapping m;
                prefetchFieldNumbers[i] = this.emd.getPKMemberPositions()[i];
                AbstractMemberMetaData fmd = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]);
                if (fmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || (m = this.elementInfo[0].getDatastoreClass().getFieldMapping(fmd)) == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
            }
        }
        if (stmt.getTableExpression(this.elmIdentifier) != null) {
            Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
        } else {
            Mappings.selectMapping(stmt, statementExpressionIndex);
        }
        return new PersistentIDROF(this.elementInfo != null ? this.elementInfo[0].getDatastoreClass() : null, prefetchFieldNumbers, this.emd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.iterateUsingDiscriminator, stmt.hasMetaDataExpression(), null, clr.classForName(this.elementType));
    }

    public class ElementInfo {
        AbstractClassMetaData cmd;
        DatastoreClass table;

        public ElementInfo(AbstractClassMetaData cmd, DatastoreClass table) {
            this.cmd = cmd;
            this.table = table;
        }

        public String getClassName() {
            return this.cmd.getFullClassName();
        }

        public AbstractClassMetaData getAbstractClassMetaData() {
            return this.cmd;
        }

        public DatastoreClass getDatastoreClass() {
            return this.table;
        }

        public DiscriminatorStrategy getDiscriminatorStrategy() {
            return this.cmd.getDiscriminatorStrategy();
        }

        public JavaTypeMapping getDiscriminatorMapping() {
            return this.table.getDiscriminatorMapping();
        }
    }
}

