/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.FetchPlan;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.OrderMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractListStore;
import org.jpox.store.rdbms.scostore.BaseContainerStore;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class FKListStore
extends AbstractListStore {
    private final int ownerFieldNumber;
    private String unsetStmt;
    private String removeAtNullifyStmt;
    private String clearNullifyStmt;
    private String updateFkStmt;

    public FKListStore(AbstractMemberMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwnerMemberMetaData(fmd);
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.CollectionMetaDataMissing", fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class)) {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.ElementMetaDataNotFound", element_class.getName(), fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.ElementWithSubclassTableWithMultipleTablesNotSupported", this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(mappedByFieldName);
            if (eofmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.MappedByNonExistent", fmd.getFullFieldName(), mappedByFieldName, element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.MappedByTypeInvalid", fmd.getFullFieldName(), eofmd.getFullFieldName(), eofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType, ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.elementType, eofmd.getTypeName(), fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (fmd.getOrderMetaData() != null && !fmd.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.List.InverseIndexFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        this.listName = "inverseList";
    }

    protected String getSetStmt() {
        if (this.setStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(this.containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.setStmt = stmt.toString();
        }
        return this.setStmt;
    }

    protected String getUnsetStmt() {
        if (this.unsetStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(this.containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = NULL");
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append("=-1");
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.unsetStmt = stmt.toString();
        }
        return this.unsetStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, -1);
        Object o = this.get(sm, index);
        String setStmt = this.getSetStmt();
        String unsetStmt = this.getUnsetStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, unsetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    if (this.orderMapping != null) {
                        jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    sqlControl.executeStatementUpdate(conn, unsetStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
                PreparedStatement ps2 = sqlControl.getStatementForUpdate(conn, setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps2, jdbcPosition);
                    if (this.orderMapping != null) {
                        jdbcPosition = this.populateOrderInStatement(om, ps2, index, jdbcPosition);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps2, jdbcPosition);
                    }
                    jdbcPosition = this.populateElementInStatement(om, ps2, element, jdbcPosition);
                    sqlControl.executeStatementUpdate(conn, setStmt, ps2, true);
                }
                finally {
                    ps2.close();
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.SetRequestFailed", setStmt), e);
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement() && allowDependentField && o != null) {
            sm.getObjectManager().deleteObjectInternal(o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        ObjectManager om = sm.getObjectManager();
        String updateFkStmt = this.getUpdateFkStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    }
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    }
                    if (this.orderMapping != null) {
                        jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    sqlControl.executeStatementUpdate(conn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", updateFkStmt), e);
        }
        return retval;
    }

    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM, int start_index, int end_index) {
        if (this.elementInfo == null) {
            return null;
        }
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        if (this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{clr.classForName(this.elementInfo[0].getClassName())}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementType);
                QueryExpression subStmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, elementCls, this.elementMapping, this.elementInfo[elementNo].getDatastoreClass(), false, null, true, false).getQueryStatement();
                if (stmt == null) {
                    stmt = subStmt;
                    continue;
                }
                stmt.union(subStmt);
            }
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.indexedList) {
            ScalarExpression indexVal;
            ScalarExpression indexExpr;
            boolean returning_range = false;
            if (start_index == -1 && end_index == -1) {
                returning_range = true;
            } else if (start_index == end_index && start_index >= 0) {
                indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                stmt.andCondition(indexExpr.eq(indexVal), true);
            } else {
                returning_range = true;
                if (start_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                    stmt.andCondition(indexExpr.gteq(indexVal), true);
                }
                if (end_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(end_index));
                    stmt.andCondition(indexExpr.lt(indexVal), true);
                }
            }
            if (returning_range) {
                ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
                exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        } else {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getFieldMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                ScalarExpression[] exprIndex = new ScalarExpression[fieldMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[fieldMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < descendingOrder.length; ++j) {
                    descendingOrder[j] = !orderComponents[i].isForward();
                }
                exprIndex = fieldMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(StateManager sm, int startAt, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(sm) : size;
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(sm, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                int shift = c.size();
                try {
                    for (int i = currentListSize - 1; i >= startAt; --i) {
                        this.internalShift(sm, conn, false, i, shift, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getShiftStmt()), e);
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            elementIter = c.iterator();
            while (elementIter.hasNext()) {
                Object element = elementIter.next();
                this.updateElementFk(sm, element, sm.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    protected String getRemoveAtNullifyStmt() {
        if (this.removeAtNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=NULL");
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=-1");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.removeAtNullifyStmt = stmt.toString();
        }
        return this.removeAtNullifyStmt;
    }

    protected boolean internalRemove(StateManager sm, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(sm, element);
            if (index == -1) {
                return false;
            }
            this.removeAt(sm, index, size);
        } else if (this.ownerMapping.isNullable()) {
            StateManager elementSM = sm.getObjectManager().findStateManager(element);
            if (this.ownerMemberMetaData.getRelationType(this.clr) == 4) {
                elementSM.replaceField(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null, true);
                if (sm.getObjectManager().isFlushing()) {
                    elementSM.flush();
                }
            } else {
                this.updateElementFk(sm, element, null, -1);
            }
        } else {
            sm.getObjectManager().deleteObjectInternal(element);
        }
        return true;
    }

    protected void removeAt(StateManager sm, int index, int size) {
        String stmt = null;
        if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.List.RemoveElementFromInverseNull"));
            stmt = this.getRemoveAtNullifyStmt();
        } else {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.List.RemoveElementFromInverseDelete"));
            stmt = this.getRemoveAtStmt();
        }
        this.internalRemoveAt(sm, index, stmt, size);
    }

    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=NULL");
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=-1");
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append("=NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }

    protected String getSizeStmt() {
        return super.getSizeStmt();
    }

    protected String getContainsStmt() {
        return super.getContainsStmt();
    }

    protected String getClearStmt() {
        return super.getClearStmt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDeleteDependent"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseNull"));
            deleteElements = false;
        } else if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseNull"));
            deleteElements = false;
        } else {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDelete"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.isLoaded(ownerSM.getObject(), this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Collection value = (Collection)ownerSM.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Iterator elementsIter = null;
            elementsIter = value != null && !value.isEmpty() ? value.iterator() : this.iterator(ownerSM);
            if (elementsIter != null) {
                ObjectManager om = ownerSM.getObjectManager();
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (om.getApiAdapter().isPersistable(element) && om.getApiAdapter().isDeleted(element)) {
                        StateManager objSM = om.findStateManager(element);
                        objSM.flush();
                        continue;
                    }
                    om.deleteObject(element);
                }
            }
        } else {
            String clearNullifyStmt = this.getClearNullifyStmt();
            try {
                ObjectManager om = ownerSM.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition);
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                        }
                        sqlControl.executeStatementUpdate(conn, clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", clearNullifyStmt), e);
            }
        }
    }

    protected boolean validateElementForWriting(final StateManager sm, Object element, final int index) {
        final PersistenceCapable newOwner = sm.getObject();
        boolean inserted = super.validateElementForWriting(sm, element, new FieldValues(){

            public void fetchFields(StateManager esm) {
                boolean isPersistentInterface = FKListStore.this.storeMgr.getMetaDataManager().isPersistentInterface(FKListStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.storeMgr.getMetaDataManager().getImplementationNameForPersistentInterface(FKListStore.this.elementType), FKListStore.this.clr) : FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.elementType, FKListStore.this.clr);
                if (elementTable == null) {
                    AbstractClassMetaData[] managingCmds = FKListStore.this.storeMgr.getClassesManagingTableForClass(FKListStore.this.emd, FKListStore.this.clr);
                    if (managingCmds != null && managingCmds.length == 1) {
                        elementTable = FKListStore.this.storeMgr.getDatastoreClass(managingCmds[0].getFullClassName(), FKListStore.this.clr);
                    } else {
                        throw new JPOXUserException("Field " + FKListStore.this.ownerMemberMetaData.getFullFieldName() + " is a List with element using subclass-table strategy BUT there are more than 1 subclass with table. This is not yet supported by JPOX");
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setExternalFieldValueForMapping(externalFKMapping, sm.getObject());
                    }
                    if (FKListStore.this.relationDiscriminatorMapping != null) {
                        esm.setExternalFieldValueForMapping(FKListStore.this.relationDiscriminatorMapping, FKListStore.this.relationDiscriminatorValue);
                    }
                    if (FKListStore.this.orderMapping != null && index >= 0) {
                        if (FKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && FKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = FKListStore.this.orderMapping.getFieldMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || FKListStore.this.orderMapping.getFieldMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)new Long(index) : (Number)new Integer(index);
                            esm.replaceField(FKListStore.this.orderMapping.getFieldMetaData().getAbsoluteFieldNumber(), indexValue, true);
                        } else {
                            esm.setExternalFieldValueForMapping(FKListStore.this.orderMapping, new Integer(index));
                        }
                    }
                }
                if (FKListStore.this.ownerFieldNumber >= 0) {
                    Object currentOwner = esm.provideField(FKListStore.this.ownerFieldNumber);
                    if (currentOwner == null) {
                        JPOXLogger.JDO.info(BaseContainerStore.LOCALISER.msg("RDBMS.SCO.Collection.UpdateOwnerOfElement", StringUtils.toJVMIDString(sm.getObject()), FKListStore.this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString(esm.getObject())));
                        esm.replaceField(FKListStore.this.ownerFieldNumber, newOwner, true);
                    } else if (currentOwner != newOwner) {
                        throw new JPOXUserException(BaseContainerStore.LOCALISER.msg("RDBMS.SCO.Collection.InconsistentOwnerOfElement", StringUtils.toJVMIDString(sm.getObject()), FKListStore.this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString(esm.getObject()), StringUtils.toJVMIDString(currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(StateManager sm2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getObjectManager().getClassLoaderResolver());
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, sm.getObjectManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.elementMapping);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredElementTable, elementRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = listRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = elementRangeVar;
        }
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.containerTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

