/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlan;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.MapMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.exceptions.ClassDefinitionException;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.SerialisedMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractMapStore;
import org.jpox.store.rdbms.scostore.MapEntrySetStore;
import org.jpox.store.rdbms.scostore.MapKeySetStore;
import org.jpox.store.rdbms.scostore.MapValueSetStore;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.ClassUtils;

public class FKMapStore
extends AbstractMapStore {
    private final int ownerFieldNumber;
    private int keyFieldNumber = -1;
    private int valueFieldNumber = -1;
    private final String updateFkStmt;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;
    static /* synthetic */ Class class$org$jpox$store$mapping$SimpleDatastoreRepresentation;
    static /* synthetic */ Class class$java$lang$String;

    public FKMapStore(AbstractMemberMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.setOwnerMemberMetaData(fmd);
        String ownerFieldName = fmd.getMappedBy();
        MapMetaData mmd = (MapMetaData)fmd.getContainer();
        if (mmd == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.MapMetaDataMissing", fmd.getFullFieldName()));
        }
        boolean keyStoredInValue = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() == null) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyValueMappedNotSpecified", fmd.getFullFieldName()));
        }
        this.keyType = mmd.getKeyType();
        this.valueType = mmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        ApiAdapter api = this.getStoreManager().getApiAdapter();
        if (keyStoredInValue && !api.isPersistable(valueClass)) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyStoredInValueButValueNotPC", fmd.getFullFieldName(), this.valueType));
        }
        if (!keyStoredInValue && !api.isPersistable(keyClass)) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueStoredInKeyButKeyNotPC", fmd.getFullFieldName(), this.keyType));
        }
        if (keyStoredInValue) {
            this.vmd = storeMgr.getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.vmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.ValueMetaDataNotFound", this.valueType, fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIDMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (ownerFieldName != null) {
                AbstractMemberMetaData vofmd = this.vmd.getMetaDataForMember(ownerFieldName);
                if (vofmd == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByNonExistent", fmd.getFullFieldName(), ownerFieldName, valueClass.getName()));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByTypeInvalid", fmd.getFullFieldName(), vofmd.getFullFieldName(), vofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.vmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getFieldMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.valueType, ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.valueType, vofmd.getTypeName(), fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.valueType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldNotSpecified", valueClass.getName()));
            }
            String key_field_name = fmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null && (vkfmd = storeMgr.getMetaDataManager().getMetaDataForMember(valueClass, clr, key_field_name)) == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldNotFound", valueClass.getName(), key_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldNotSpecified", fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.keyType, clr)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldTypeIncompatible", fmd.getFullFieldName(), this.keyType, vkfmd.getType().getName()));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.vmd.getAbsolutePositionOfMember(keyFieldName);
            this.keyMapping = this.valueTable.getFieldMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerKeyFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.valueType, keyFieldName));
            }
            if (!(class$org$jpox$store$mapping$SimpleDatastoreRepresentation == null ? (class$org$jpox$store$mapping$SimpleDatastoreRepresentation = FKMapStore.class$("org.jpox.store.mapping.SimpleDatastoreRepresentation")) : class$org$jpox$store$mapping$SimpleDatastoreRepresentation).isAssignableFrom(this.keyMapping.getClass())) {
                throw new JPOXUserException("Invalid field type for map key field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = this.valueTable;
        } else {
            this.kmd = storeMgr.getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.kmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.KeyMetaDataNotFound", this.keyType, fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIDMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (ownerFieldName != null) {
                AbstractMemberMetaData kofmd = this.kmd.getMetaDataForMember(ownerFieldName);
                if (kofmd == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByNonExistent", fmd.getFullFieldName(), ownerFieldName, keyClass.getName()));
                }
                if (!ClassUtils.typesAreCompatible(kofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName(), clr)) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByTypeInvalid", fmd.getFullFieldName(), kofmd.getFullFieldName(), kofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.kmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getFieldMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.keyType, ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.keyType, kofmd.getTypeName(), fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.keyType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldNotSpecified", keyClass.getName()));
            }
            String value_field_name = fmd.getValueMetaData().getMappedBy();
            if (value_field_name != null && (vkfmd = storeMgr.getMetaDataManager().getMetaDataForMember(keyClass, clr, value_field_name)) == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldNotFound", keyClass.getName(), value_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldNotSpecified", fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.valueType, clr)) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldTypeIncompatible", fmd.getFullFieldName(), this.valueType, vkfmd.getType().getName()));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.kmd.getAbsolutePositionOfMember(valueFieldName);
            this.valueMapping = this.valueTable.getFieldMapping(this.kmd.getMetaDataForManagedMemberAtAbsolutePosition(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerValueFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.keyType, valueFieldName));
            }
            if (!(class$org$jpox$store$mapping$SimpleDatastoreRepresentation == null ? (class$org$jpox$store$mapping$SimpleDatastoreRepresentation = FKMapStore.class$("org.jpox.store.mapping.SimpleDatastoreRepresentation")) : class$org$jpox$store$mapping$SimpleDatastoreRepresentation).isAssignableFrom(this.valueMapping.getClass())) {
                throw new JPOXUserException("Invalid field type for map value field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = this.valueTable;
        }
        this.initialiseStatements();
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        } else {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateValueFk(StateManager sm, Object value, Object owner) {
        boolean retval;
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(sm, value);
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateValueInStatement(om, ps, value, jdbcPosition);
                    sqlControl.executeStatementUpdate(conn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateKeyFk(StateManager sm, Object key, Object owner) {
        boolean retval;
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(sm, key);
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
                    sqlControl.executeStatementUpdate(conn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), e);
        }
        return retval;
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        ClassLoaderResolver clr = ownerSm.getObjectManager().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        QueryExpression stmt = null;
        if (this.valueTable.getDiscriminatorMetaData() != null && this.valueTable.getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerMemberMetaData.getMap().getValueType()))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getMap().getValueType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{valueCls}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
        } else {
            stmt = new UnionIteratorStatement(clr, valueCls, true, this.storeMgr, valueCls, this.valueMapping, this.valueTable, false, null, true, false).getQueryStatement();
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key).add(this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = FKMapStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr).newLiteral(stmt, "%"));
            stmt.andCondition(new BooleanExpression(keyExpr, ScalarExpression.OP_LIKE, keyVal), true);
        } else {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key);
            stmt.andCondition(keyExpr.eq(keyVal), true);
        }
        return stmt;
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(LOCALISER.msg("RDBMS.SCO.Map.NullValuesNotAllowed"));
        }
        super.validateValueType(clr, value);
    }

    public Object put(StateManager sm, final Object newKey, Object newValue) {
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(sm, newKey);
            this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), newKey);
            this.validateValueForWriting(sm, newValue);
        }
        Object oldValue = this.get(sm, newKey);
        if (oldValue != newValue) {
            if (this.vmd != null) {
                if (oldValue != null) {
                    this.removeValue(sm, newKey, oldValue);
                }
                ObjectManager om = sm.getObjectManager();
                final PersistenceCapable newOwner = sm.getObject();
                if (om.getApiAdapter().isPersistent(newValue)) {
                    PersistenceCapable newValuePC = (PersistenceCapable)newValue;
                    if (om != ObjectManagerHelper.getObjectManager(newValue)) {
                        throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValudInvalidWithDifferentPM"), newValuePC.jdoGetObjectId());
                    }
                    StateManager vsm = om.findStateManager(newValue);
                    if (this.ownerFieldNumber >= 0) {
                        vsm.isLoaded(newValuePC, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(newValuePC, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                    vsm.isLoaded(newValuePC, this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.setObjectField(newValuePC, this.keyFieldNumber, oldKey, newKey);
                } else {
                    om.persistObjectInternal(newValue, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner, true);
                            }
                            vsm.replaceField(FKMapStore.this.keyFieldNumber, newKey, true);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    });
                    if (this.ownerFieldNumber < 0) {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                }
            } else {
                ObjectManager om = sm.getObjectManager();
                PersistenceCapable pcNewKey = (PersistenceCapable)newKey;
                final PersistenceCapable newOwner = sm.getObject();
                if (om.getApiAdapter().isPersistent(pcNewKey)) {
                    if (om != ObjectManagerHelper.getObjectManager(pcNewKey)) {
                        throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteKeyInvalidWithDifferentPM"), pcNewKey.jdoGetObjectId());
                    }
                    StateManager vsm = om.findStateManager(pcNewKey);
                    if (this.ownerFieldNumber >= 0) {
                        vsm.isLoaded(pcNewKey, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(pcNewKey, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                    vsm.isLoaded(pcNewKey, this.valueFieldNumber);
                    oldValue = vsm.provideField(this.valueFieldNumber);
                    vsm.setObjectField(pcNewKey, this.valueFieldNumber, oldValue, newValue);
                } else {
                    final Object newValueObj = newValue;
                    om.persistObjectInternal(newKey, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner, true);
                            }
                            vsm.replaceField(FKMapStore.this.valueFieldNumber, newValueObj, true);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    });
                    if (this.ownerFieldNumber < 0) {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                }
            }
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(StateManager sm, Object key) {
        Object oldValue = this.get(sm, key);
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                this.removeValue(sm, key, oldValue);
                sm.getObjectManager().flush(false);
            }
        } else {
            sm.getObjectManager().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentKey()) {
            sm.getObjectManager().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue()) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    private void removeValue(StateManager sm, Object key, Object oldValue) {
        ObjectManager om = sm.getObjectManager();
        if (this.keyMapping.isNullable()) {
            PersistenceCapable pcOldValue = (PersistenceCapable)oldValue;
            StateManager vsm = om.findStateManager(pcOldValue);
            vsm.setObjectField(pcOldValue, this.keyFieldNumber, key, null);
            vsm.replaceField(this.keyFieldNumber, null, true);
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.setObjectField(pcOldValue, this.ownerFieldNumber, oldOwner, null);
                vsm.replaceField(this.ownerFieldNumber, null, true);
            } else {
                this.updateValueFk(sm, pcOldValue, null);
            }
        } else {
            om.deleteObjectInternal(oldValue);
        }
    }

    public void clear(StateManager sm) {
        Iterator iter = this.keySetStore(sm.getObjectManager().getClassLoaderResolver()).iterator(sm);
        while (iter.hasNext()) {
            this.remove(sm, iter.next());
        }
    }

    public void clearKeyOfValue(StateManager sm, Object key, Object oldValue) {
        ObjectManager om = sm.getObjectManager();
        if (this.keyMapping.isNullable()) {
            PersistenceCapable oldValuePC;
            StateManager vsm = om.findStateManager(oldValue);
            if (!vsm.isDeleted(oldValuePC = (PersistenceCapable)oldValue)) {
                vsm.setObjectField(oldValuePC, this.keyFieldNumber, key, null);
                vsm.replaceField(this.keyFieldNumber, null, true);
                vsm.makeDirty(this.keyFieldNumber);
            }
        } else {
            om.deleteObjectInternal(oldValue);
        }
    }

    public synchronized SetStore keySetStore(ClassLoaderResolver clr) {
        return this.keySetStore == null ? new MapKeySetStore(this.valueTable, this.ownerMapping, this.keyMapping, clr, this.ownerMemberMetaData) : this.keySetStore;
    }

    public synchronized SetStore valueSetStore(ClassLoaderResolver clr) {
        return this.valueSetStore == null ? new MapValueSetStore(this.valueTable, this.ownerMapping, this.valueMapping, this, clr, this.ownerMemberMetaData) : this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        return this.entrySetStore == null ? new MapEntrySetStore(this.valueTable, this.ownerMapping, this.keyMapping, this.valueMapping, this) : this.entrySetStore;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.valueType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, candidateClass);
        }
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getObjectManager().getClassLoaderResolver());
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, sm.getObjectManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.valueMapping);
        return stmt;
    }

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapRangeVar, Class filteredKeyType, ScalarExpression kExpr, DatastoreIdentifier keyRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType.getName());
        }
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, te);
        DatastoreIdentifier containerRangeVar = mapRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = keyRangeVar;
        }
        stmt.newTableExpression(this.mapTable, containerRangeVar);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (!this.storeMgr.getOMFContext().getTypeManager().isSupportedType(filteredKeyType.getName())) {
            DatastoreClass filteredKeyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
            JavaTypeMapping keyTableID = filteredKeyTable.getIDMapping();
            stmt.newTableExpression(filteredKeyTable, keyRangeVar);
            ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            ScalarExpression keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyRangeVar));
            stmt.innerJoin(keyExpr, keyMapExpr, stmt.getTableExpression(keyRangeVar), true, true);
            return keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyRangeVar));
        }
        return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType.getName());
        }
        DatastoreClass filteredValueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredValueTable, valueRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = mapRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = valueRangeVar;
        }
        ScalarExpression ownerValueExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.valueTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerValueExpr), true);
        JavaTypeMapping valueTableID = filteredValueTable.getIDMapping();
        return valueTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyRangeVar, DatastoreIdentifier valueRangeVar) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredKeyType, keyExpr, keyRangeVar), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredValueType, valExpr, valueRangeVar)};
        return qclKeyValues;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

