/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractArrayStore;
import org.jpox.store.rdbms.scostore.ElementContainerStore;
import org.jpox.store.rdbms.table.ArrayTable;
import org.jpox.util.ClassUtils;

public class JoinArrayStore
extends AbstractArrayStore {
    public JoinArrayStore(ArrayTable joinTable, ClassLoaderResolver clr) {
        super(joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwnerMemberMetaData(joinTable.getOwnerFieldMetaData());
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = joinTable.getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 4, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
                if (this.emd != null) {
                    this.elementType = this.emd.getFullClassName();
                    if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
                        this.elementInfo = this.getElementInformationForClass();
                        if (this.elementInfo != null && this.elementInfo.length > 1) {
                            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Array.ElementWithSubclassTableWithMultipleTablesNotSupported", this.ownerMemberMetaData.getFullFieldName()));
                        }
                    } else {
                        this.elementInfo = null;
                    }
                } else {
                    this.elementInfo = null;
                }
            }
        }
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        QueryExpression stmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
            stmt.select(this.elementMapping);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                QueryExpression elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                        String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        elementStmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement();
                    } else {
                        elementStmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement();
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    elementStmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, Boolean.TRUE, true, this.allowsNull).getQueryStatement();
                }
                if (stmt == null) {
                    stmt = elementStmt;
                    continue;
                }
                stmt.union(elementStmt);
            }
        } else {
            throw new JPOXUserException("Attempt to get iterator for an array when insufficient information is available to perform the operation.");
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
        boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
        exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
        stmt.setOrdering(exprIndex, descendingOrder);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class primitiveType = ClassUtils.getWrapperTypeForPrimitiveType(clr.classForName(this.elementType));
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType) && primitiveType != null && clr.isAssignableFrom(this.elementType, primitiveType.getName())) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, listRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        if (!parentStmt.hasCrossJoin(ownTblExpr)) {
            stmt.crossJoin(ownTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        DatastoreClass joiningClass = elmExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elmExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementRangeVar);
        if (elmTblExpr == null) {
            elmTblExpr = stmt.newTableExpression(elementTable, elementRangeVar);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        if (!parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        if (elmExpr.getLogicSetExpression() != null && !elementTable.equals(elmExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(elmSetExpr.eq(elmExpr), true);
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listRangeVar));
        }
        ScalarExpression elementExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementRangeVar));
        stmt.andCondition(elmSetExpr.eq(elementExpr), true);
        return elementExpr;
    }
}

