/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.sco.SCOMtoN;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractSetStore;
import org.jpox.store.rdbms.scostore.ElementContainerStore;
import org.jpox.store.rdbms.table.CollectionTable;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class JoinSetStore
extends AbstractSetStore {
    protected String locateStmt;
    protected String maxOrderColumnIdStmt;
    protected final boolean m2n;

    public JoinSetStore(AbstractMemberMetaData fmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super(joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwnerMemberMetaData(fmd);
        this.setName = "set";
        int relationType = this.ownerMemberMetaData.getRelationType(clr);
        this.m2n = relationType == 5;
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = fmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null ? (!this.elementsAreEmbedded ? this.getElementInformationForClass() : null) : null;
            }
        }
    }

    private String getMaxOrderColumnIdStmt() {
        if (this.maxOrderColumnIdStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT MAX(" + ((Object)this.orderMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() + ")");
            stmt.append(" FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(0)).getUpdateInputParameter());
            for (i = 1; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 1; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.maxOrderColumnIdStmt = stmt.toString();
        }
        return this.maxOrderColumnIdStmt;
    }

    private String getLocateStmt() {
        if (this.locateStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT 1 FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append("=");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append("=");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getInsertionInputParameter());
                }
            }
            this.locateStmt = stmt.toString();
        }
        return this.locateStmt;
    }

    protected String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        stmt.append(((Object)this.ownerMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString());
        stmt.append(" = ");
        stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(0)).getUpdateInputParameter());
        for (i = 1; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            if (this.elementsAreSerialised) {
                stmt.append(" LIKE ");
            } else {
                stmt.append(" = ");
            }
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getRemoveAllStmt(StateManager ownerSm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        Iterator elementsIter = elements.iterator();
        boolean first = true;
        while (elementsIter.hasNext()) {
            int i;
            elementsIter.next();
            if (first) {
                stmt.append("(");
            } else {
                stmt.append(" OR (");
            }
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                if (this.elementsAreSerialised) {
                    stmt.append(" LIKE ");
                } else {
                    stmt.append(" = ");
                }
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        String removeAllStmt = this.getRemoveAllStmt(sm, elements);
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    Iterator iter = elements.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                        jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    int[] number = sqlControl.executeStatementUpdate(conn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", removeAllStmt), e);
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    private boolean elementAlreadyContainsOwnerInMtoN(StateManager ownerSM, Object element) {
        AbstractMemberMetaData[] relatedMmds;
        ObjectManager om = ownerSM.getObjectManager();
        StateManager elementSM = om.findStateManager(element);
        Object elementSCO = elementSM.provideField((relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(om.getClassLoaderResolver()))[0].getAbsoluteFieldNumber());
        if (elementSCO instanceof SCOMtoN) {
            if (this.contains(ownerSM, element)) {
                JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.SCO.Set.ElementAlreadyExistsinMtoN", this.ownerMemberMetaData.getFullFieldName(), element));
                return true;
            }
        } else if (this.locate(ownerSM, element)) {
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.SCO.Set.ElementAlreadyExistsinMtoN", this.ownerMemberMetaData.getFullFieldName(), element));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locate(StateManager sm, Object element) {
        boolean exists = true;
        String stmt = this.getLocateStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(conn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            exists = false;
                        }
                    }
                    catch (SQLException sqle) {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.LocateRequestFailed", stmt), e);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int size) {
        StateManager elementSM;
        this.validateElementForWriting(sm, element, null);
        if (this.ownerMemberMetaData.getRelationType(this.clr) == 4 && (elementSM = sm.getObjectManager().findStateManager(element)) != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                JPOXLogger.JDO.info(LOCALISER.msg("RDBMS.SCO.Collection.UpdateOwnerOfElement", StringUtils.toJVMIDString(sm.getObject()), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
            } else if (elementOwner != sm.getObject() && elementOwner != sm.getReferencedPC()) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.InconsistentOwnerOfElement", StringUtils.toJVMIDString(sm.getObject()), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString(elementSM.getObject()), StringUtils.toJVMIDString(elementOwner)));
            }
        }
        boolean modified = false;
        boolean toBeInserted = true;
        if (this.m2n) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                Connection conn = (Connection)mconn.getConnection();
                try {
                    int[] returnCode;
                    int orderID = -1;
                    if (this.orderMapping != null) {
                        orderID = this.getNextIDForOrderColumn(sm);
                    }
                    if ((returnCode = this.internalAdd(sm, element, conn, false, orderID, true))[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                JPOXLogger.RDBMS.error(e);
                String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getAddStmt());
                JPOXLogger.RDBMS.error(msg);
                throw new JPOXDataStoreException(msg, e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            StateManager elementSM;
            Object element = iter.next();
            this.validateElementForWriting(sm, element, null);
            if (this.ownerMemberMetaData.getRelationType(this.clr) != 4 || (elementSM = sm.getObjectManager().findStateManager(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                JPOXLogger.JDO.info(LOCALISER.msg("RDBMS.SCO.Collection.UpdateOwnerOfElement", StringUtils.toJVMIDString(sm.getObject()), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
                continue;
            }
            if (elementOwner == sm.getObject() || elementOwner == sm.getReferencedPC()) continue;
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.Collection.InconsistentOwnerOfElement", StringUtils.toJVMIDString(sm.getObject()), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString(elementSM.getObject()), StringUtils.toJVMIDString(elementOwner)));
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            sqlControl.processStatementsForConnection(conn);
            try {
                int nextOrderID = 0;
                if (this.orderMapping != null) {
                    nextOrderID = this.getNextIDForOrderColumn(sm);
                }
                iter = elements.iterator();
                Object element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalAdd(sm, element, conn, batched, nextOrderID, !batched || batched && !iter.hasNext());
                        if (rc != null) {
                            for (int i = 0; i < rc.length; ++i) {
                                if (rc[i] <= 0) continue;
                                modified = true;
                            }
                        }
                        ++nextOrderID;
                    }
                    catch (SQLException sqe) {
                        sqe.printStackTrace();
                        exceptions.add(sqe);
                        JPOXLogger.RDBMS.error(sqe);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            JPOXLogger.RDBMS.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.getAddStmt());
            JPOXLogger.RDBMS.error(msg);
            throw new JPOXDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), (Object)sm.getObject());
        }
        return modified;
    }

    private int[] internalAdd(StateManager sm, Object element, Connection conn, boolean batched, int orderId, boolean executeNow) throws SQLException {
        boolean toBeInserted = true;
        if (this.m2n) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            String addStmt = this.getAddStmt();
            boolean notYetFlushedError = false;
            ObjectManager om = sm.getObjectManager();
            SQLController sqlControl = this.storeMgr.getSQLController();
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
            try {
                int jdbcPosition = 1;
                jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                if (this.orderMapping != null) {
                    jdbcPosition = this.populateOrderInStatement(om, ps, orderId, jdbcPosition);
                }
                if (this.relationDiscriminatorMapping != null) {
                    jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                }
                int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForOrderColumn(StateManager sm) {
        int nextID;
        ObjectManager om = sm.getObjectManager();
        String stmt = this.getMaxOrderColumnIdStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(om, ps, jdbcPosition);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(conn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.SCO.MaxAdapterColumnIdRequestFailed", stmt), e);
        }
        return nextID;
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        QueryExpression stmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
            stmt.select(this.elementMapping);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            stmt = this.dba.newQueryStatement(this.containerTable, clr);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                QueryExpression elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                        String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        elementStmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement();
                    } else {
                        elementStmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, this.storeMgr, true, this.allowsNull, this.containerTable, this.elementMapping, this.elmIdentifier).getQueryStatement();
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    elementStmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, Boolean.TRUE, true, this.allowsNull).getQueryStatement();
                }
                if (stmt == null) {
                    stmt = elementStmt;
                    continue;
                }
                stmt.union(elementStmt);
            }
        } else {
            throw new JPOXUserException("Attempt to get iterator for Set when insufficient information is available to perform the operation.");
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.orderMapping != null) {
            ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
            exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
            stmt.setOrdering(exprIndex, descendingOrder);
        }
        return stmt;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.SCO.QueryOverCollectionImpossible"));
        }
        DatastoreIdentifier setRangeVar = this.storeMgr.getIdentifierFactory().newIdentifier(0, this.setName);
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, setRangeVar, sm.getObjectManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(candidateClass)) {
            stmt.select(setRangeVar, this.elementMapping);
        } else {
            DatastoreIdentifier elementRangeVar = this.thisIdentifier;
            DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getObjectManager().getClassLoaderResolver());
            JavaTypeMapping elementTableID = candidateTable.getIDMapping();
            stmt.newTableExpression(candidateTable, elementRangeVar);
            ScalarExpression elmExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
            ScalarExpression elmTblExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementRangeVar));
            stmt.innerJoin(elmExpr, elmTblExpr, stmt.getTableExpression(elementRangeVar), true, true);
            stmt.select(elementTableID);
        }
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, setRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
        if (!parentStmt.hasCrossJoin(ownTblExpr)) {
            stmt.crossJoin(ownTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        if (this.storeMgr.getOMFContext().getTypeManager().isSupportedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        DatastoreClass joiningClass = elmExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elmExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementRangeVar);
        if (elmTblExpr == null) {
            elmTblExpr = stmt.newTableExpression(elementTable, elementRangeVar);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
        if (!parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        if (elmExpr.getLogicSetExpression() != null && !elementTable.equals(elmExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(elmSetExpr.eq(elmExpr), true);
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(setRangeVar));
        }
        ScalarExpression elementExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementRangeVar));
        stmt.andCondition(elmSetExpr.eq(elementExpr), true);
        return elementExpr;
    }
}

