/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractSetStore;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.scostore.MapStore;

public class MapValueSetStore
extends AbstractSetStore {
    private final MapStore mapStore;
    private final JavaTypeMapping keyMapping;
    private final String findKeyStmt;
    private DatastoreIdentifier valueIdentifier;

    public MapValueSetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.setName = "values";
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.elementMapping = mapTable.getValueMapping();
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        this.initialize(clr);
        this.findKeyStmt = this.getFindKeyStmt();
    }

    public MapValueSetStore(DatastoreClass valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractMemberMetaData fmd) {
        super(valueTable.getStoreManager(), clr);
        this.containerTable = valueTable;
        this.setName = "values";
        this.ownerMemberMetaData = fmd;
        this.ownerMapping = ownerMapping;
        this.keyMapping = null;
        this.elementMapping = valueMapping;
        this.mapStore = mapStore;
        this.initialize(clr);
        this.clearStmt = null;
        this.findKeyStmt = null;
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        Class element_class = clr.classForName(this.elementType);
        this.emd = this.storeMgr.getOMFContext().getTypeManager().isReferenceType(element_class) ? this.storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr) : this.storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
        this.valueIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "VALUE");
    }

    private String getFindKeyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        Class elementCls = clr.classForName(this.elementType);
        QueryExpression stmt = null;
        if (this.emd != null && this.emd.getDiscriminatorStrategy() != null && this.emd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && this.containerTable instanceof DatastoreClass) {
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(clr.classForName(this.elementType))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
            DatastoreClass sourceTable = this.storeMgr.getDatastoreClass(this.elementType, clr);
            ScalarExpression sourceExpr = sourceTable.getIDMapping().newScalarExpression(stmt, stmt.getDefaultTableExpression());
            LogicSetExpression teTargetElement = stmt.newTableExpression(this.containerTable, this.valueIdentifier);
            ScalarExpression targetExpr = this.elementMapping.newScalarExpression(stmt, teTargetElement);
            stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
        } else {
            stmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, elementCls, this.elementMapping, this.containerTable, false, null, true, false).getQueryStatement();
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        return stmt;
    }

    public boolean add(StateManager sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(StateManager sm, Object element, int size) {
        if (this.findKeyStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its value set");
        }
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        Object key = null;
        boolean keyExists = false;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.findKeyStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, om, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    ResultSet rs = sqlControl.executeStatementQuery(conn, this.findKeyStmt, ps);
                    try {
                        if (rs.next()) {
                            key = this.keyMapping.getObject(om, rs, Mappings.getParametersIndex(1, this.keyMapping));
                            keyExists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException("Request failed to check if set contains an element: " + this.findKeyStmt, e);
        }
        if (keyExists) {
            this.mapStore.remove(sm, key);
            return true;
        }
        return false;
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        throw new JPOXUserException("Cannot remove elements from a map through its value set");
    }

    public void clear(StateManager sm) {
        if (this.clearStmt == null) {
            throw new JPOXUserException("Cannot clear an inverse map through its value set");
        }
        super.clear(sm);
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        throw new JPOXUserException("Cannot query sets obtained by Map.values()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        throw new JPOXUserException("Cannot query sets obtained by Map.values()");
    }
}

