/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.sqlidentifier;

import org.jpox.ClassLoaderResolver;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.rdbms.sqlidentifier.AbstractRDBMSIdentifierFactory;
import org.jpox.store.rdbms.sqlidentifier.ColumnIdentifier;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;

public class JPAIdentifierFactory
extends AbstractRDBMSIdentifierFactory {
    public JPAIdentifierFactory(DatastoreAdapter dba, String defaultCatalog, String defaultSchema, String requiredCase, String wordSeparator, String tablePrefix, String tableSuffix) {
        super(dba, requiredCase, defaultCatalog, defaultSchema);
    }

    public DatastoreIdentifier newDatastoreContainerIdentifier(ClassLoaderResolver clr, AbstractMemberMetaData fmd) {
        String identifierName = null;
        String schemaName = null;
        String catalogName = null;
        AbstractMemberMetaData[] relatedMmds = null;
        if (fmd.getColumnMetaData().length > 0 && fmd.getColumnMetaData()[0].getName() != null) {
            identifierName = fmd.getColumnMetaData()[0].getName();
        } else if (fmd.hasContainer()) {
            String[] parts;
            String specifiedName;
            if (fmd.getTable() != null) {
                specifiedName = fmd.getTable();
                parts = this.getIdentifierNamePartsFromName(specifiedName);
                if (parts != null) {
                    catalogName = parts[0];
                    schemaName = parts[1];
                    identifierName = parts[2];
                }
                if (catalogName == null) {
                    catalogName = fmd.getCatalog();
                }
                if (schemaName == null) {
                    schemaName = fmd.getSchema();
                }
            } else {
                relatedMmds = fmd.getRelatedMemberMetaData(clr);
                if (relatedMmds != null && relatedMmds[0].getTable() != null) {
                    specifiedName = relatedMmds[0].getTable();
                    parts = this.getIdentifierNamePartsFromName(specifiedName);
                    if (parts != null) {
                        catalogName = parts[0];
                        schemaName = parts[1];
                        identifierName = parts[2];
                    }
                    if (catalogName == null) {
                        catalogName = relatedMmds[0].getCatalog();
                    }
                    if (schemaName == null) {
                        schemaName = relatedMmds[0].getSchema();
                    }
                }
            }
        }
        if (schemaName == null && catalogName == null) {
            if (fmd.getParent() instanceof AbstractClassMetaData) {
                AbstractClassMetaData ownerCmd = (AbstractClassMetaData)fmd.getParent();
                if (this.rdba.supportsCatalogsInTableDefinitions()) {
                    catalogName = ownerCmd.getCatalog();
                }
                if (this.rdba.supportsSchemasInTableDefinitions()) {
                    schemaName = ownerCmd.getSchema();
                }
            }
            if (schemaName == null && catalogName == null) {
                if (this.rdba.supportsCatalogsInTableDefinitions()) {
                    catalogName = this.defaultCatalogName;
                }
                if (this.rdba.supportsSchemasInTableDefinitions()) {
                    schemaName = this.defaultSchemaName;
                }
            }
        }
        if (identifierName == null) {
            String unique_name;
            String ownerClass = fmd.getClassName(false);
            String otherClass = fmd.getTypeName();
            if (fmd.hasCollection()) {
                otherClass = fmd.getCollection().getElementType();
            } else if (fmd.hasArray()) {
                otherClass = fmd.getArray().getElementType();
            } else if (fmd.hasMap()) {
                otherClass = fmd.getMap().getValueType();
            }
            if (fmd.hasCollection() && relatedMmds != null && relatedMmds[0].hasCollection() && fmd.getMappedBy() != null) {
                ownerClass = relatedMmds[0].getClassName(false);
                otherClass = relatedMmds[0].getCollection().getElementType();
            }
            otherClass = otherClass.substring(otherClass.lastIndexOf(46) + 1);
            identifierName = unique_name = ownerClass + this.getWordSeparator() + otherClass;
        }
        SQLIdentifier identifier = (SQLIdentifier)this.newDatastoreContainerIdentifier(identifierName);
        if (schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if (catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        return identifier;
    }

    public DatastoreIdentifier newDatastoreContainerIdentifier(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        String identifierName = null;
        String schemaName = null;
        String catalogName = null;
        String specifiedName = cmd.getTable();
        String[] parts = this.getIdentifierNamePartsFromName(specifiedName);
        if (parts != null) {
            catalogName = parts[0];
            schemaName = parts[1];
            identifierName = parts[2];
        }
        if (schemaName == null && catalogName == null) {
            if (this.rdba.supportsCatalogsInTableDefinitions()) {
                catalogName = cmd.getCatalog();
            }
            if (this.rdba.supportsSchemasInTableDefinitions()) {
                schemaName = cmd.getSchema();
            }
            if (schemaName == null && catalogName == null) {
                if (this.rdba.supportsCatalogsInTableDefinitions()) {
                    catalogName = this.defaultCatalogName;
                }
                if (this.rdba.supportsSchemasInTableDefinitions()) {
                    schemaName = this.defaultSchemaName;
                }
            }
        }
        if (identifierName == null) {
            String unique_name;
            identifierName = unique_name = cmd.getFullClassName().substring(cmd.getFullClassName().lastIndexOf(46) + 1);
        }
        SQLIdentifier identifier = (SQLIdentifier)this.newDatastoreContainerIdentifier(identifierName);
        if (schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if (catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        return identifier;
    }

    public DatastoreIdentifier newReferenceFieldIdentifier(AbstractMemberMetaData refMetaData, AbstractClassMetaData implMetaData, DatastoreIdentifier implIdentifier, boolean embedded, int fieldRole) {
        DatastoreIdentifier identifier = null;
        String key = "[" + refMetaData.getFullFieldName() + "][" + implMetaData.getFullClassName() + "][" + implIdentifier.getIdentifier() + "]";
        identifier = (DatastoreIdentifier)this.references.get(key);
        if (identifier == null) {
            String referenceName = refMetaData.getName();
            String implementationName = implMetaData.getFullClassName();
            int dot = implementationName.lastIndexOf(46);
            if (dot > -1) {
                implementationName = implementationName.substring(dot + 1);
            }
            String name = referenceName + "." + implementationName + "." + implIdentifier.getIdentifier();
            String datastoreID = this.generateIdentifierNameForJavaName(name);
            String baseID = JPAIdentifierFactory.truncate(datastoreID, this.getMaxLengthForIdentifierType(1));
            identifier = new ColumnIdentifier(this, baseID);
            this.references.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newJoinTableFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        DatastoreIdentifier identifier = null;
        if (relatedFmd != null) {
            if (fieldRole == 1) {
                identifier = this.newDatastoreFieldIdentifier(relatedFmd.getName() + this.getWordSeparator() + destinationId.getIdentifier());
            } else if (fieldRole == 3 || fieldRole == 4 || fieldRole == 5 || fieldRole == 6) {
                if (destinationId != null) {
                    identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + destinationId.getIdentifier());
                } else if (fieldRole == 4 || fieldRole == 3) {
                    identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + "ELEMENT");
                } else if (fieldRole == 5) {
                    identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + "KEY");
                } else if (fieldRole == 6) {
                    identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + "VALUE");
                }
            } else {
                identifier = this.newDatastoreFieldIdentifier(destinationId.getIdentifier(), embedded, fieldRole);
            }
        } else if (fieldRole == 1) {
            identifier = this.newDatastoreFieldIdentifier(ownerFmd.getClassName(false) + this.getWordSeparator() + destinationId.getIdentifier());
        } else if (fieldRole == 3 || fieldRole == 4 || fieldRole == 5 || fieldRole == 6) {
            if (destinationId != null) {
                identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + destinationId.getIdentifier());
            } else if (fieldRole == 4 || fieldRole == 3) {
                identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + "ELEMENT");
            } else if (fieldRole == 5) {
                identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + "KEY");
            } else if (fieldRole == 6) {
                identifier = this.newDatastoreFieldIdentifier(ownerFmd.getName() + this.getWordSeparator() + "VALUE");
            }
        } else {
            identifier = this.newDatastoreFieldIdentifier(destinationId.getIdentifier(), embedded, fieldRole);
        }
        return identifier;
    }

    public DatastoreIdentifier newForeignKeyFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (relatedFmd != null) {
            if (fieldRole == 1) {
                return this.newDatastoreFieldIdentifier(relatedFmd.getName() + "." + destinationId.getIdentifier(), embedded, fieldRole);
            }
            if (fieldRole == 7) {
                return this.newDatastoreFieldIdentifier(relatedFmd.getName() + "." + destinationId.getIdentifier(), embedded, fieldRole);
            }
            throw new JPOXException("DatastoreField role " + fieldRole + " not supported by this method").setFatal();
        }
        if (fieldRole == 1) {
            return this.newDatastoreFieldIdentifier(ownerFmd.getName() + "." + destinationId.getIdentifier(), embedded, fieldRole);
        }
        if (fieldRole == 7) {
            return this.newDatastoreFieldIdentifier(ownerFmd.getName() + ".IDX", embedded, fieldRole);
        }
        throw new JPOXException("DatastoreField role " + fieldRole + " not supported by this method").setFatal();
    }

    public DatastoreIdentifier newDiscriminatorFieldIdentifier() {
        String name = "DTYPE";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newVersionFieldIdentifier() {
        String name = "VERSION";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newIndexFieldIdentifier() {
        String name = "IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newAdapterIndexFieldIdentifier() {
        String name = "IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public String generateIdentifierNameForJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (c >= 'A' && c <= 'Z' && this.identifierCase != 4 && this.identifierCase != 5) {
                s.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z' && (this.identifierCase == 4 || this.identifierCase == 5)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && (this.identifierCase == 4 || this.identifierCase == 5)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && this.identifierCase != 4 && this.identifierCase != 5) {
                s.append((char)(c - 32));
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                s.append(c);
                continue;
            }
            if (c == '.') {
                s.append(this.getWordSeparator());
                continue;
            }
            String cval = "000" + Integer.toHexString(c);
            s.append(cval.substring(cval.length() - (c > '\u00ff' ? 4 : 2)));
        }
        while (s.length() > 0 && s.charAt(0) == '_') {
            s.deleteCharAt(0);
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("Illegal Java identifier: " + javaName);
        }
        return s.toString();
    }

    protected String getColumnIdentifierSuffix(int role, boolean embedded) {
        String suffix = "";
        if (role == 0) {
            suffix = !embedded ? "_ID" : "";
        }
        return suffix;
    }
}

