/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ElementMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.store.DatastoreArray;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.table.ColumnCreator;
import org.jpox.store.rdbms.table.ElementContainerTable;
import org.jpox.util.JPOXLogger;

public class ArrayTable
extends ElementContainerTable
implements DatastoreArray {
    public ArrayTable(DatastoreIdentifier tableName, AbstractMemberMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        boolean elementPC;
        PrimaryKeyMetaData pkmd;
        super.initialize(clr);
        PrimaryKeyMetaData primaryKeyMetaData = pkmd = this.fmd.getJoinMetaData() != null ? this.fmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null ? pkmd.getColumnMetaData() != null : false;
        boolean pkRequired = this.requiresPrimaryKey();
        boolean bl = elementPC = this.fmd.hasArray() && this.fmd.getArray().getElementClassMetaData() != null;
        if (this.isSerialisedElementPC() || this.isEmbeddedElementPC() || this.isEmbeddedElement() && !elementPC) {
            this.elementMapping = this.dba.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 2);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        } else {
            ColumnMetaData[] elemColmd = null;
            ElementMetaData elemmd = this.fmd.getElementMetaData();
            if (elemmd != null && elemmd.getColumnMetaData() != null && elemmd.getColumnMetaData().length > 0) {
                elemColmd = elemmd.getColumnMetaData();
            }
            this.elementMapping = ColumnCreator.createColumnsForJoinTables(this.fmd.getType().getComponentType(), this.fmd, elemColmd, this.storeMgr, this, false, true, this.fmd.getArray().isSerializedElement(), false, 4, clr);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        }
        ColumnMetaData colmd = null;
        if (this.fmd.getOrderMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData().length > 0) {
            colmd = this.fmd.getOrderMetaData().getColumnMetaData()[0];
        } else {
            DatastoreIdentifier id = ((RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory()).newIndexFieldIdentifier();
            colmd = new ColumnMetaData((MetaData)this.fmd, id.getIdentifier());
        }
        this.orderMapping = this.dba.getMapping(Integer.TYPE, this.storeMgr);
        ColumnCreator.createIndexColumn(this.orderMapping, this.storeMgr, clr, this, colmd, pkRequired && !pkColsSpecified);
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            this.debugMapping(this.orderMapping);
        }
        if (pkRequired && pkColsSpecified) {
            this.applyUserPrimaryKeySpecification(pkmd);
        }
        this.state = 2;
    }

    public String getElementType() {
        return this.fmd.getType().getComponentType().getName();
    }

    public boolean isSerialisedElement() {
        return this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement();
    }

    public boolean isEmbeddedElement() {
        if (this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement()) {
            return false;
        }
        return this.fmd.getArray() != null && this.fmd.getArray().isEmbeddedElement();
    }

    public boolean isSerialisedElementPC() {
        return this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement();
    }

    public boolean isEmbeddedElementPC() {
        if (this.fmd.getArray() != null && this.fmd.getArray().isSerializedElement()) {
            return false;
        }
        return this.fmd.getElementMetaData() != null && this.fmd.getElementMetaData().getEmbeddedMetaData() != null;
    }
}

