/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractElementMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ColumnMetaDataContainer;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.ForeignKeyAction;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.OrderMetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.sco.SCOUtils;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.exceptions.ClassDefinitionException;
import org.jpox.store.exceptions.NoSuchPersistentFieldException;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.mapping.CorrespondentColumnsMapper;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.DiscriminatorMapping;
import org.jpox.store.mapping.EmbeddedPCMapping;
import org.jpox.store.mapping.IndexMapping;
import org.jpox.store.mapping.IntegerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.LongMapping;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.VersionMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.exceptions.DuplicateColumnNameException;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Index;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.request.DeleteRequest;
import org.jpox.store.rdbms.request.FetchRequest;
import org.jpox.store.rdbms.request.InsertRequest;
import org.jpox.store.rdbms.request.LocateRequest;
import org.jpox.store.rdbms.request.UpdateRequest;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.table.AbstractClassTable;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.table.ColumnCreator;
import org.jpox.store.rdbms.table.SecondaryTable;
import org.jpox.store.rdbms.table.TableUtils;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.MacroString;
import org.jpox.util.MultiMap;

public class ClassTable
extends AbstractClassTable
implements DatastoreClass {
    private final ClassMetaData cmd;
    private final Collection managedClassMetaData = new HashSet();
    private ClassTable supertable;
    private Map secondaryTables;
    private HashMap externalFkMappings;
    private HashMap externalFkDiscriminatorMappings;
    private HashMap externalOrderMappings;
    private MacroString tableDef;
    private String createStatementDDL;
    private static MultiMap callbacks = new MultiMap();
    HashMap candidateKeysByMapField = new HashMap();
    HashSet unmappedColumns = null;
    protected transient String managingClassCurrent = null;
    protected boolean runCallbacksAfterManageClass = false;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public ClassTable(DatastoreIdentifier tableName, RDBMSManager storeMgr, ClassMetaData cmd) {
        super(tableName, storeMgr);
        this.cmd = cmd;
        if (cmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.NEW_TABLE && cmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.COMPLETE_TABLE) {
            throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.ClassHasNoTableError", cmd.getFullClassName(), cmd.getInheritanceMetaData().getStrategyValue().toString())).setFatal();
        }
        this.highestFieldNumber = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        String tableImpStr = cmd.getValueForExtension("ddl-imports");
        String tableDefStr = null;
        if (this.dba.getVendorID() != null) {
            tableDefStr = cmd.getValueForExtension("ddl-definition-" + this.dba.getVendorID());
        }
        if (tableDefStr == null) {
            tableDefStr = cmd.getValueForExtension("ddl-definition");
        }
        if (tableDefStr != null) {
            this.tableDef = new MacroString(cmd.getFullClassName(), tableImpStr, tableDefStr);
        }
    }

    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        if (this.cmd.getInheritanceMetaData().getStrategyValue() != InheritanceStrategy.COMPLETE_TABLE) {
            this.supertable = this.getSupertable(this.cmd, clr);
            if (this.supertable != null && !this.supertable.isInitialized() && !this.supertable.isPKInitialized()) {
                this.supertable.preInitialize(clr);
            }
        }
        if (!this.isPKInitialized()) {
            this.initializePK(clr);
        }
    }

    public void initialize(ClassLoaderResolver clr) {
        DiscriminatorMetaData dismd;
        InheritanceMetaData imd;
        this.assertIsUninitialized();
        this.initializeForClass(this.cmd, clr);
        VersionMetaData vmd = this.cmd.getVersionMetaData();
        if (vmd != null && vmd.getFieldName() == null) {
            if (vmd.getVersionStrategy() == VersionStrategy.NONE) {
                this.versionMapping = new VersionMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr));
            } else if (vmd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                this.versionMapping = new VersionMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr));
            } else if (vmd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                this.versionMapping = new VersionMapping(this.dba, this, this.dba.getMapping(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ClassTable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, this.storeMgr));
            }
        }
        if ((imd = this.cmd.getInheritanceMetaData()) != null && imd.getStrategyValue() == InheritanceStrategy.NEW_TABLE && (dismd = imd.getDiscriminatorMetaData()) != null) {
            if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                this.discriminatorMapping = new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr));
            } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                ColumnMetaData disColmd = dismd.getColumnMetaData();
                this.discriminatorMapping = disColmd != null && disColmd.getJdbcType() != null ? (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC") ? new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = ClassTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr)) : new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr))) : new DiscriminatorMapping(this.dba, this, this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ClassTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr));
            }
        }
        if (this.secondaryTables != null) {
            Set secondaryTableNames = this.secondaryTables.keySet();
            Iterator secondaryTableNamesIter = secondaryTableNames.iterator();
            while (secondaryTableNamesIter.hasNext()) {
                String secondaryTableName = (String)secondaryTableNamesIter.next();
                SecondaryTable second = (SecondaryTable)this.secondaryTables.get(secondaryTableName);
                if (second.isInitialized()) continue;
                second.initialize(clr);
            }
        }
        this.state = 2;
    }

    public void postInitialize(final ClassLoaderResolver clr) {
        this.assertIsInitialized();
        this.runCallBacks(clr);
        if (this.tableDef != null) {
            this.createStatementDDL = this.tableDef.substituteMacros(new MacroString.MacroHandler(){

                public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                    ClassTable.this.storeMgr.resolveIdentifierMacro(im, clr);
                }

                public void onParameterMacro(MacroString.ParameterMacro pm) {
                    throw new JPOXUserException(AbstractTable.LOCALISER.msg("RDBMS.Table.MacrosNotAllowedInTableDefinition", ClassTable.this.cmd.getFullClassName(), pm));
                }
            }, clr);
        }
    }

    public void manageClass(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Table.ManagingClassFields", this.toString(), theCmd.getFullClassName(), theCmd.getInheritanceMetaData().getStrategyValue().toString()));
        }
        this.managingClassCurrent = theCmd.getFullClassName();
        this.managedClassMetaData.add(theCmd);
        this.manageFields(theCmd, clr, theCmd.getManagedMembers());
        this.manageFields(theCmd, clr, theCmd.getOverriddenMembers());
        this.manageUnmappedColumns(theCmd, clr);
        this.managingClassCurrent = null;
        if (this.runCallbacksAfterManageClass) {
            this.runCallBacks(clr);
            this.runCallbacksAfterManageClass = false;
        }
    }

    public String[] getManagedClasses() {
        String[] classNames = new String[this.managedClassMetaData.size()];
        Iterator iter = this.managedClassMetaData.iterator();
        int i = 0;
        while (iter.hasNext()) {
            classNames[i++] = ((ClassMetaData)iter.next()).getFullClassName();
        }
        return classNames;
    }

    private void manageFields(AbstractClassMetaData theCmd, ClassLoaderResolver clr, AbstractMemberMetaData[] fields) {
        for (int fieldNumber = 0; fieldNumber < fields.length; ++fieldNumber) {
            DatastoreClass dc;
            AbstractMemberMetaData fmd = fields[fieldNumber];
            if (fmd.isPrimaryKey()) continue;
            if (this.managesField(fmd.getFullFieldName())) {
                if (fmd.getClassName(true).equals(theCmd.getFullClassName())) continue;
                JavaTypeMapping fieldMapping = this.getMappingForFieldName(fmd.getFullFieldName());
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds == null || colmds.length <= 0) continue;
                int colnum = 0;
                IdentifierFactory idFactory = this.getStoreManager().getIdentifierFactory();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    Column col = (Column)fieldMapping.getDataStoreMapping(i).getDatastoreField();
                    col.setIdentifier(idFactory.newDatastoreFieldIdentifier(colmds[colnum].getName()));
                    col.setMetaData(colmds[colnum]);
                    if (++colnum == colmds.length) break;
                }
                if (!JPOXLogger.RDBMS.isDebugEnabled()) continue;
                StringBuffer columnsStr = new StringBuffer();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        columnsStr.append(",");
                    }
                    columnsStr.append(fieldMapping.getDataStoreMapping(i).getDatastoreField());
                }
                if (fieldMapping.getNumberOfDatastoreFields() == 0) {
                    columnsStr.append("[none]");
                }
                StringBuffer datastoreMappingTypes = new StringBuffer();
                for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                    if (i > 0) {
                        datastoreMappingTypes.append(',');
                    }
                    datastoreMappingTypes.append(fieldMapping.getDataStoreMapping(i).getClass().getName());
                }
                JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Table.FieldToColumnMapping", fmd.getFullFieldName(), columnsStr.toString(), fieldMapping.getClass().getName(), datastoreMappingTypes.toString()));
                continue;
            }
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                boolean isPrimary = true;
                if (fmd.getTable() != null && fmd.getJoinMetaData() == null) {
                    isPrimary = false;
                }
                if (isPrimary) {
                    this.addFieldMapping(this.dba.getMappingManager().getMapping(this, fmd, this.dba, clr, 0));
                } else {
                    SecondaryTable secTable;
                    if (this.secondaryTables == null) {
                        this.secondaryTables = new HashMap();
                    }
                    if ((secTable = (SecondaryTable)this.secondaryTables.get(fmd.getTable())) == null) {
                        String schemaName;
                        JoinMetaData[] joinmds = theCmd.getJoinMetaData();
                        JoinMetaData joinmd = null;
                        if (joinmds != null) {
                            for (int j = 0; j < joinmds.length; ++j) {
                                if (!joinmds[j].getTable().equalsIgnoreCase(fmd.getTable()) || joinmds[j].getCatalog() != null && (joinmds[j].getCatalog() == null || !joinmds[j].getCatalog().equalsIgnoreCase(fmd.getCatalog())) || joinmds[j].getSchema() != null && (joinmds[j].getSchema() == null || !joinmds[j].getSchema().equalsIgnoreCase(fmd.getSchema()))) continue;
                                joinmd = joinmds[j];
                                break;
                            }
                        }
                        SQLIdentifier secTableIdentifier = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(fmd.getTable());
                        String catalogName = fmd.getCatalog();
                        if (catalogName == null) {
                            catalogName = this.getCatalogName();
                        }
                        if ((schemaName = fmd.getSchema()) == null) {
                            schemaName = this.getSchemaName();
                        }
                        secTableIdentifier.setCatalogName(catalogName);
                        secTableIdentifier.setSchemaName(schemaName);
                        secTable = new SecondaryTable(secTableIdentifier, this.storeMgr, this, joinmd, clr);
                        secTable.preInitialize(clr);
                        secTable.initialize(clr);
                        secTable.postInitialize(clr);
                        this.secondaryTables.put(fmd.getTable(), secTable);
                    }
                    secTable.addFieldMapping(this.dba.getMappingManager().getMapping(secTable, fmd, this.dba, clr, 0));
                }
            } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                throw new JPOXException(LOCALISER.msg("RDBMS.Table.InvalidPersistenceModifierForField", fmd.getName())).setFatal();
            }
            boolean needsFKToContainerOwner = false;
            int relationType = fmd.getRelationType(clr);
            if (relationType == 4) {
                AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
                if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                    needsFKToContainerOwner = true;
                }
            } else if (relationType == 3 && fmd.getJoinMetaData() == null) {
                needsFKToContainerOwner = true;
            }
            if (!needsFKToContainerOwner) continue;
            if (fmd.getCollection() != null && !SCOUtils.collectionHasSerialisedElements(fmd) || fmd.getArray() != null && !SCOUtils.arrayIsStoredInSingleColumn(fmd)) {
                AbstractClassMetaData elementCmd = null;
                elementCmd = fmd.hasCollection() ? this.storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getCollection().getElementType(), clr) : this.storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getType().getComponentType(), clr);
                if (elementCmd == null) {
                    if (fmd.hasCollection()) {
                        JPOXLogger.METADATA.warn(LOCALISER.msg("RDBMS.Table.Collection.ElementHasNoMetaData", theCmd.getFullClassName(), fmd.getCollection().getElementType()));
                        continue;
                    }
                    JPOXLogger.METADATA.warn(LOCALISER.msg("RDBMS.Table.Array.ElementHasNoMetaData", theCmd.getFullClassName(), fmd.getType().getComponentType().getName()));
                    continue;
                }
                AbstractClassMetaData[] elementCmds = null;
                elementCmds = elementCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(elementCmd, clr) : new ClassMetaData[]{elementCmd};
                for (int i = 0; i < elementCmds.length; ++i) {
                    callbacks.put(elementCmds[i].getFullClassName(), new CallBack(fmd));
                    dc = this.storeMgr.getDatastoreClass(elementCmds[i].getFullClassName(), clr);
                    ClassTable ct = (ClassTable)dc;
                    if (!ct.isInitialized()) continue;
                    ct.runCallBacks(clr);
                }
                continue;
            }
            if (fmd.getMap() == null || SCOUtils.mapHasSerialisedKeysAndValues(fmd)) continue;
            if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
                AbstractClassMetaData valueCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getMap().getValueType(), clr);
                if (valueCmd == null) {
                    JPOXLogger.METADATA.warn(LOCALISER.msg("RDBMS.Table.Map.ValueHasNoMetaData", theCmd.getFullClassName(), fmd.getMap().getValueType()));
                    continue;
                }
                AbstractClassMetaData[] valueCmds = null;
                valueCmds = valueCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(valueCmd, clr) : new ClassMetaData[]{valueCmd};
                for (int i = 0; i < valueCmds.length; ++i) {
                    callbacks.put(valueCmds[i].getFullClassName(), new CallBack(fmd));
                    dc = this.storeMgr.getDatastoreClass(valueCmds[i].getFullClassName(), clr);
                    ClassTable ct = (ClassTable)dc;
                    if (!ct.isInitialized()) continue;
                    ct.runCallBacks(clr);
                }
                continue;
            }
            if (fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) continue;
            AbstractClassMetaData keyCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getMap().getKeyType(), clr);
            if (keyCmd == null) {
                JPOXLogger.METADATA.warn(LOCALISER.msg("RDBMS.Table.Map.KeyHasNoMetaData", theCmd.getFullClassName(), fmd.getMap().getKeyType()));
                continue;
            }
            AbstractClassMetaData[] keyCmds = null;
            keyCmds = keyCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE ? this.storeMgr.getClassesManagingTableForClass(keyCmd, clr) : new ClassMetaData[]{keyCmd};
            for (int i = 0; i < keyCmds.length; ++i) {
                callbacks.put(keyCmds[i].getFullClassName(), new CallBack(fmd));
                dc = this.storeMgr.getDatastoreClass(keyCmds[i].getFullClassName(), clr);
                ClassTable ct = (ClassTable)dc;
                if (!ct.isInitialized()) continue;
                ct.runCallBacks(clr);
            }
        }
    }

    private void manageUnmappedColumns(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        List cols = theCmd.getUnmappedColumns();
        if (cols != null && cols.size() > 0) {
            Iterator colsIter = cols.iterator();
            while (colsIter.hasNext()) {
                ColumnMetaData colmd = (ColumnMetaData)colsIter.next();
                if (colmd.getJdbcType().equals("VARCHAR") && colmd.getLength() == null) {
                    colmd.setLength(this.getStoreManager().getOMFContext().getPersistenceConfiguration().getStringDefaultLength());
                }
                IdentifierFactory idFactory = this.getStoreManager().getIdentifierFactory();
                DatastoreIdentifier colIdentifier = idFactory.newIdentifier(1, colmd.getName());
                Column col = (Column)this.addDatastoreField(null, colIdentifier, null, colmd);
                TypeInfo typeInfo = this.dba.getTypeInfo(JDBCUtils.getJDBCTypeForName(colmd.getJdbcType()));
                col.setTypeInfo(typeInfo);
                if (this.unmappedColumns == null) {
                    this.unmappedColumns = new HashSet();
                }
                if (JPOXLogger.RDBMS.isDebugEnabled()) {
                    JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Table.UnmappedColumnMapping", col.toString(), colmd.getJdbcType()));
                }
                this.unmappedColumns.add(col);
            }
        }
    }

    public boolean managesClass(String className) {
        if (className == null) {
            return false;
        }
        Iterator iter = this.managedClassMetaData.iterator();
        while (iter.hasNext()) {
            ClassMetaData managedCmd = (ClassMetaData)iter.next();
            if (!managedCmd.getFullClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    protected void initializePK(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        AbstractMemberMetaData[] fieldsToAdd = new AbstractMemberMetaData[this.cmd.getNoOfPrimaryKeyMembers()];
        int pkFieldNum = 0;
        int fieldCount = this.cmd.getNoOfManagedMembers();
        boolean hasPrimaryKeyInThisClass = false;
        if (this.cmd.getNoOfPrimaryKeyMembers() > 0) {
            this.pkMappings = new JavaTypeMapping[this.cmd.getNoOfPrimaryKeyMembers()];
            for (int relativeFieldNumber = 0; relativeFieldNumber < fieldCount; ++relativeFieldNumber) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtPosition(relativeFieldNumber);
                if (!fmd.isPrimaryKey()) continue;
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    fieldsToAdd[pkFieldNum++] = fmd;
                    hasPrimaryKeyInThisClass = true;
                } else if (fmd.getPersistenceModifier() != FieldPersistenceModifier.TRANSACTIONAL) {
                    throw new JPOXException(LOCALISER.msg("RDBMS.Table.InvalidPersistenceModifierForField", fmd.getName())).setFatal();
                }
                if (fmd.getValueStrategy() != IdentityStrategy.IDENTITY || this.dba.supportsAutoIncrementFields()) continue;
                throw new JPOXException(LOCALISER.msg("RDBMS.Table.AutoIncrementNotSupportedByRDBMS", this.cmd.getFullClassName(), fmd.getName())).setFatal();
            }
        }
        if (!hasPrimaryKeyInThisClass) {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                DatastoreClass elementCT = this.storeMgr.getDatastoreClass(this.cmd.getPersistenceCapableSuperclass(), clr);
                if (elementCT != null) {
                    MetaData colContainer = null;
                    if (this.cmd.getInheritanceMetaData() != null) {
                        colContainer = this.cmd.getInheritanceMetaData().getJoinMetaData();
                    }
                    if (colContainer == null) {
                        colContainer = this.cmd.getPrimaryKeyMetaData();
                    }
                    this.addApplicationIdUsingClassTableId((ColumnMetaDataContainer)((Object)colContainer), elementCT, clr, this.cmd);
                } else {
                    AbstractClassMetaData pkCmd = this.storeMgr.getClassWithPrimaryKeyForClass(this.cmd.getSuperAbstractClassMetaData(), clr);
                    if (pkCmd != null) {
                        this.pkMappings = new JavaTypeMapping[pkCmd.getNoOfPrimaryKeyMembers()];
                        pkFieldNum = 0;
                        fieldCount = pkCmd.getNoOfInheritedManagedMembers() + pkCmd.getNoOfManagedMembers();
                        for (int absFieldNum = 0; absFieldNum < fieldCount; ++absFieldNum) {
                            AbstractMemberMetaData fmd = pkCmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNum);
                            if (!fmd.isPrimaryKey()) continue;
                            AbstractMemberMetaData overriddenFmd = this.cmd.getOverriddenMember(fmd.getName());
                            if (overriddenFmd != null) {
                                fmd = overriddenFmd;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                                fieldsToAdd[pkFieldNum++] = fmd;
                                continue;
                            }
                            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                            throw new JPOXException(LOCALISER.msg("RDBMS.Table.InvalidPersistenceModifierForField", fmd.getName())).setFatal();
                        }
                    }
                }
            } else if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                MetaData colContainer = null;
                if (this.cmd.getIdentityMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData() != null && this.cmd.getIdentityMetaData().getColumnMetaData().length > 0) {
                    colContainer = this.cmd.getIdentityMetaData();
                }
                if (colContainer == null) {
                    colContainer = this.cmd.getPrimaryKeyMetaData();
                }
                this.addDatastoreId((ColumnMetaDataContainer)((Object)colContainer), null, this.cmd);
            } else if (this.cmd.getIdentityType() == IdentityType.NONDURABLE) {
                // empty if block
            }
        }
        for (int i = 0; i < fieldsToAdd.length; ++i) {
            if (fieldsToAdd[i] == null) continue;
            try {
                DatastoreClass datastoreClass = this.getStoreManager().getDatastoreClass(fieldsToAdd[i].getType().getName(), clr);
                if (datastoreClass.getIDMapping() == null) {
                    throw new JPOXException("Unsupported relationship with field " + fieldsToAdd[i].getFullFieldName()).setFatal();
                }
            }
            catch (NoTableManagedException ex) {
                // empty catch block
            }
            JavaTypeMapping fieldMapping = this.dba.getMappingManager().getMapping(this, fieldsToAdd[i], this.dba, clr, 0);
            this.addFieldMapping(fieldMapping);
            this.pkMappings[i] = fieldMapping;
        }
        this.initializeIDMapping();
        this.state = 1;
    }

    private void initializeForClass(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        this.manageClass(theCmd, clr);
        AbstractClassMetaData parentCmd = theCmd.getSuperAbstractClassMetaData();
        if (parentCmd != null) {
            if (this.cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
                this.initializeForClass(parentCmd, clr);
            } else if (parentCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                this.initializeForClass(parentCmd, clr);
            }
        }
    }

    private void runCallBacks(ClassLoaderResolver clr) {
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData managedCmd = (ClassMetaData)cmdIter.next();
            if (this.managingClassCurrent != null && this.managingClassCurrent.equals(managedCmd.getFullClassName())) {
                this.runCallbacksAfterManageClass = true;
                break;
            }
            Collection c = (Collection)callbacks.remove(managedCmd.getFullClassName());
            this.runSpecifiedCallbacks(managedCmd, c, clr);
        }
    }

    private void runSpecifiedCallbacks(ClassMetaData classCmd, Collection callbacks, ClassLoaderResolver clr) {
        if (callbacks != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                JavaTypeMapping orderMapping;
                JavaTypeMapping fkDiscrimMapping;
                CallBack callback = (CallBack)it.next();
                if (callback.fmd.getJoinMetaData() != null) continue;
                AbstractMemberMetaData ownerFmd = callback.fmd;
                if (ownerFmd.getMappedBy() != null) {
                    AbstractMemberMetaData fmd = classCmd.getMetaDataForMember(ownerFmd.getMappedBy());
                    if (fmd == null) {
                        throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.RelationshipMappedByFieldNotFound", ownerFmd.getMappedBy(), classCmd.getFullClassName(), ownerFmd.getFullFieldName()));
                    }
                    if (ownerFmd.getMap() != null && this.storeMgr.getOMFContext().getPersistenceConfiguration().getUniqueConstraintsMapInverse()) {
                        this.initializeFKMapUniqueConstraints(ownerFmd);
                    }
                    boolean duplicate = false;
                    fkDiscrimMapping = null;
                    orderMapping = null;
                    if (ownerFmd.hasExtension("relation-discriminator-column")) {
                        String colName = ownerFmd.getValueForExtension("relation-discriminator-column");
                        if (colName == null) {
                            colName = "RELATION_DISCRIM";
                        }
                        Set fkDiscrimEntries = this.getExternalFkDiscriminatorMappings().entrySet();
                        Iterator discrimMappingIter = fkDiscrimEntries.iterator();
                        while (discrimMappingIter.hasNext()) {
                            entry = discrimMappingIter.next();
                            JavaTypeMapping discrimMapping = (JavaTypeMapping)entry.getValue();
                            String discrimColName = ((ColumnMetaData)discrimMapping.getDataStoreMapping(0).getDatastoreField().getMetaData()).getName();
                            if (!discrimColName.equalsIgnoreCase(colName)) continue;
                            duplicate = true;
                            fkDiscrimMapping = discrimMapping;
                            orderMapping = (JavaTypeMapping)this.getExternalOrderMappings().get(entry.getKey());
                            break;
                        }
                        if (!duplicate) {
                            ColumnMetaData colmd = new ColumnMetaData(null, colName);
                            colmd.setAllowsNull(Boolean.TRUE);
                            fkDiscrimMapping = this.dba.getMapping(class$java$lang$String == null ? ClassTable.class$("java.lang.String") : class$java$lang$String, this.storeMgr);
                            ColumnCreator.createIndexColumn(fkDiscrimMapping, this.storeMgr, clr, this, colmd, false);
                        }
                        if (fkDiscrimMapping != null) {
                            this.getExternalFkDiscriminatorMappings().put(ownerFmd, fkDiscrimMapping);
                        }
                    }
                    this.addOrderMapping(ownerFmd, orderMapping, clr);
                    continue;
                }
                String ownerClassName = ownerFmd.getAbstractClassMetaData().getFullClassName();
                JavaTypeMapping fkMapping = new PersistenceCapableMapping();
                fkMapping.initialize(this.dba, ownerClassName);
                fkDiscrimMapping = null;
                orderMapping = null;
                boolean duplicate = false;
                try {
                    JavaTypeMapping ownerIdMapping = this.storeMgr.getDatastoreClass(ownerClassName, clr).getIDMapping();
                    AbstractElementMetaData colmdContainer = null;
                    if (ownerFmd.hasCollection() || ownerFmd.hasArray()) {
                        colmdContainer = ownerFmd.getElementMetaData();
                    } else if (ownerFmd.hasMap() && ownerFmd.getKeyMetaData() != null && ownerFmd.getKeyMetaData().getMappedBy() != null) {
                        colmdContainer = ownerFmd.getValueMetaData();
                    } else if (ownerFmd.hasMap() && ownerFmd.getValueMetaData() != null && ownerFmd.getValueMetaData().getMappedBy() != null) {
                        colmdContainer = ownerFmd.getKeyMetaData();
                    }
                    CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(colmdContainer, ownerIdMapping, true);
                    int countIdFields = ownerIdMapping.getNumberOfDatastoreFields();
                    for (int i = 0; i < countIdFields; ++i) {
                        DatastoreMapping refDatastoreMapping = ownerIdMapping.getDataStoreMapping(i);
                        JavaTypeMapping mapping = this.dba.getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType(), this.storeMgr);
                        ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(((Column)refDatastoreMapping.getDatastoreField()).getIdentifier());
                        if (colmd == null) {
                            throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.PrimaryKeyColumnNotMapped", ((Column)refDatastoreMapping.getDatastoreField()).getIdentifier(), this.toString())).setFatal();
                        }
                        DatastoreIdentifier identifier = null;
                        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
                        identifier = colmd.getName() == null || colmd.getName().length() < 1 ? ((RDBMSIdentifierFactory)idFactory).newForeignKeyFieldIdentifier(ownerFmd, null, refDatastoreMapping.getDatastoreField().getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(mapping.getJavaType()), 1) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        DatastoreField refColumn = this.addDatastoreField(mapping.getJavaType().getName(), identifier, mapping, colmd);
                        ((Column)refDatastoreMapping.getDatastoreField()).copyConfigurationTo(refColumn);
                        if (colmd == null || colmd != null && !colmd.isAllowsNullSet() || colmd != null && colmd.isAllowsNullSet() && colmd.isAllowsNull()) {
                            refColumn.setNullable();
                        }
                        fkMapping.addDataStoreMapping(this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, this.storeMgr, refColumn, refDatastoreMapping.getJavaTypeMapping().getJavaType().getName()));
                        ((PersistenceCapableMapping)fkMapping).addJavaTypeMapping(mapping);
                    }
                }
                catch (DuplicateColumnNameException dcne) {
                    if (!ownerFmd.hasExtension("relation-discriminator-column")) {
                        throw dcne;
                    }
                    Iterator fkIter = this.getExternalFkMappings().entrySet().iterator();
                    fkMapping = null;
                    block5: while (fkIter.hasNext()) {
                        entry = fkIter.next();
                        JavaTypeMapping existingFkMapping = (JavaTypeMapping)entry.getValue();
                        for (int j = 0; j < existingFkMapping.getNumberOfDatastoreFields(); ++j) {
                            if (!((Object)existingFkMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString().equals(((Object)dcne.getConflictingColumn().getIdentifier()).toString())) continue;
                            fkMapping = existingFkMapping;
                            fkDiscrimMapping = (JavaTypeMapping)this.externalFkDiscriminatorMappings.get(entry.getKey());
                            orderMapping = (JavaTypeMapping)this.getExternalOrderMappings().get(entry.getKey());
                            continue block5;
                        }
                    }
                    if (fkMapping == null) {
                        throw dcne;
                    }
                    duplicate = true;
                }
                if (!duplicate && ownerFmd.hasExtension("relation-discriminator-column")) {
                    String colName = ownerFmd.getValueForExtension("relation-discriminator-column");
                    if (colName == null) {
                        colName = "RELATION_DISCRIM";
                    }
                    ColumnMetaData colmd = new ColumnMetaData(null, colName);
                    colmd.setAllowsNull(Boolean.TRUE);
                    fkDiscrimMapping = this.dba.getMapping(class$java$lang$String == null ? ClassTable.class$("java.lang.String") : class$java$lang$String, this.storeMgr);
                    ColumnCreator.createIndexColumn(fkDiscrimMapping, this.storeMgr, clr, this, colmd, false);
                }
                this.getExternalFkMappings().put(ownerFmd, fkMapping);
                if (fkDiscrimMapping != null) {
                    this.getExternalFkDiscriminatorMappings().put(ownerFmd, fkDiscrimMapping);
                }
                this.addOrderMapping(ownerFmd, orderMapping, clr);
            }
        }
    }

    private JavaTypeMapping addOrderMapping(AbstractMemberMetaData fmd, JavaTypeMapping orderMapping, ClassLoaderResolver clr) {
        boolean needsOrderMapping = false;
        if (fmd.hasArray()) {
            needsOrderMapping = true;
        } else if (this.storeMgr.getOMFContext().getTypeManager().isSCOList(fmd.getType())) {
            needsOrderMapping = true;
            if (fmd.getOrderMetaData() != null && !fmd.getOrderMetaData().isIndexedList()) {
                needsOrderMapping = false;
            }
        }
        if (needsOrderMapping) {
            this.state = 0;
            if (orderMapping == null) {
                orderMapping = this.addOrderColumn(fmd, clr);
            }
            this.getExternalOrderMappings().put(fmd, orderMapping);
            this.state = 2;
        }
        return orderMapping;
    }

    public String getType() {
        return this.cmd.getFullClassName();
    }

    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    public final VersionMetaData getVersionMetaData() {
        return this.cmd.getVersionMetaData();
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return this.cmd.getInheritanceMetaData().getDiscriminatorMetaData();
    }

    public boolean isObjectIDDatastoreAttributed() {
        boolean attributed = this.storeMgr.isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), this.cmd.getIdentityType() == IdentityType.DATASTORE);
        if (attributed) {
            return true;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            if (!col.isPrimaryKey() || !col.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    public boolean isBaseDatastoreClass() {
        return this.supertable == null;
    }

    public DatastoreClass getSuperDatastoreClass() {
        this.assertIsInitialized();
        return this.supertable;
    }

    private ClassTable getSupertable(AbstractClassMetaData theCmd, ClassLoaderResolver clr) {
        if (this.cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
            return null;
        }
        AbstractClassMetaData superCmd = theCmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            if (superCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                return (ClassTable)this.storeMgr.getDatastoreClass(superCmd.getFullClassName(), clr);
            }
            if (superCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                return this.getSupertable(superCmd, clr);
            }
            return this.getSupertable(superCmd, clr);
        }
        return null;
    }

    public DatastoreClass getBaseDatastoreClassWithField(AbstractMemberMetaData fmd) {
        if (fmd.isPrimaryKey() && this.getSuperDatastoreClass() != null) {
            return this.getSuperDatastoreClass().getBaseDatastoreClassWithField(fmd);
        }
        if (this.fieldMappingsMap.get(fmd) != null) {
            return this;
        }
        if (this.getSuperDatastoreClass() == null) {
            return this;
        }
        return this.getSuperDatastoreClass().getBaseDatastoreClassWithField(fmd);
    }

    ClassMetaData getClassMetaData() {
        return this.cmd;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        DiscriminatorMetaData dismd;
        Index index;
        VersionMetaData vermd;
        IndexMetaData idxmd;
        Index index2;
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getRDBMSConstraintCreateMode().equals("JPOX")) {
            autoMode = true;
        }
        HashSet<Index> indices = new HashSet<Index>();
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            Index index3;
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                    JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                    IndexMetaData imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                    if (imd == null || (index2 = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                    indices.add(index2);
                }
                continue;
            }
            IndexMetaData imd = fmd.getIndexMetaData();
            if (imd == null || (index3 = TableUtils.getIndexForField(this, imd, fieldMapping)) == null) continue;
            indices.add(index3);
        }
        if (this.versionMapping != null && (idxmd = (vermd = this.cmd.getVersionMetaData()).getIndexMetaData()) != null) {
            index = new Index(this, idxmd.isUnique() != null ? idxmd.isUnique() : false, idxmd.getValueForExtension("extended-setting"));
            if (idxmd.getName() != null) {
                index.setName(idxmd.getName());
            }
            int countVersionFields = this.versionMapping.getNumberOfDatastoreFields();
            for (int i = 0; i < countVersionFields; ++i) {
                index.addDatastoreField(this.versionMapping.getDataStoreMapping(i).getDatastoreField());
            }
            indices.add(index);
        }
        if (this.discriminatorMapping != null && (idxmd = (dismd = this.getDiscriminatorMetaData()).getIndexMetaData()) != null) {
            index = new Index(this, idxmd.isUnique() != null ? idxmd.isUnique() : false, idxmd.getValueForExtension("extended-setting"));
            if (idxmd.getName() != null) {
                index.setName(idxmd.getName());
            }
            int countDiscrimFields = this.discriminatorMapping.getNumberOfDatastoreFields();
            for (int i = 0; i < countDiscrimFields; ++i) {
                index.addDatastoreField(this.discriminatorMapping.getDataStoreMapping(i).getDatastoreField());
            }
            indices.add(index);
        }
        Set orderMappingsEntries = this.getExternalOrderMappings().entrySet();
        Iterator orderMappingsEntriesIter = orderMappingsEntries.iterator();
        while (orderMappingsEntriesIter.hasNext()) {
            Map.Entry entry = orderMappingsEntriesIter.next();
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)entry.getKey();
            JavaTypeMapping mapping = (JavaTypeMapping)entry.getValue();
            OrderMetaData omd = fmd.getOrderMetaData();
            if (omd == null || omd.getIndexMetaData() == null || (index2 = this.getIndexForIndexMetaDataAndMapping(omd.getIndexMetaData(), mapping)) == null) continue;
            indices.add(index2);
        }
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData thisCmd = (ClassMetaData)cmdIter.next();
            IndexMetaData[] classIndices = thisCmd.getIndexMetaData();
            if (classIndices == null) continue;
            for (int i = 0; i < classIndices.length; ++i) {
                index2 = this.getIndexForIndexMetaData(classIndices[i]);
                if (index2 == null) continue;
                indices.add(index2);
            }
        }
        if (autoMode) {
            indices.addAll(super.getExpectedIndices(clr));
        }
        return indices;
    }

    private Index getIndexForIndexMetaDataAndMapping(IndexMetaData imd, JavaTypeMapping mapping) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(this, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            index.setName(imd.getName());
        }
        int numCols = mapping.getNumberOfDatastoreFields();
        for (int i = 0; i < numCols; ++i) {
            index.addDatastoreField(mapping.getDataStoreMapping(i).getDatastoreField());
        }
        return index;
    }

    private Index getIndexForIndexMetaData(IndexMetaData imd) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(this, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            index.setName(imd.getName());
        }
        ColumnMetaData[] colmds = imd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = imd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.Index.ColumnNotFound", this.toString(), index.getName(), colmds[i].getName()));
                    break;
                }
                index.addDatastoreField(col);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (int i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getFieldMetaData(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(realFmd);
                int countFields = fieldMapping.getNumberOfDatastoreFields();
                for (int j = 0; j < countFields; ++j) {
                    index.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
                }
            }
        } else {
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.Index.NoColumnsSpecified", this.toString(), index.getName()));
            return null;
        }
        return index;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        ForeignKeyMetaData idFkmd;
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getRDBMSConstraintCreateMode().equals("JPOX")) {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            ForeignKey fk;
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fmd.getEmbeddedMetaData() != null && fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                this.addExpectedForeignKeysForEmbeddedPCField(foreignKeys, autoMode, clr, embMapping);
                continue;
            }
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(fmd.getType()) && fieldMapping instanceof ReferenceMapping) {
                Collection fks = TableUtils.getForeignKeysForReferenceField(fieldMapping, fmd, autoMode, this.storeMgr, clr);
                foreignKeys.addAll(fks);
                continue;
            }
            if (this.storeMgr.getMetaDataManager().getMetaDataForClass(fmd.getType(), clr) == null || fieldMapping.getNumberOfDatastoreFields() <= 0 || !(fieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(fieldMapping, fmd, autoMode, this.storeMgr, clr)) == null) continue;
            foreignKeys.add(fk);
        }
        ForeignKeyMetaData foreignKeyMetaData = idFkmd = this.cmd.getInheritanceMetaData().getJoinMetaData() != null ? this.cmd.getInheritanceMetaData().getJoinMetaData().getForeignKeyMetaData() : null;
        if (this.supertable != null && (autoMode || idFkmd != null && idFkmd.getDeleteAction() != ForeignKeyAction.NONE)) {
            ForeignKey fk = new ForeignKey(this.getIDMapping(), this.dba, this.supertable, false);
            if (idFkmd != null && idFkmd.getName() != null) {
                fk.setName(idFkmd.getName());
            }
            foreignKeys.add(0, fk);
        }
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData thisCmd = (ClassMetaData)cmdIter.next();
            ForeignKeyMetaData[] fkmds = thisCmd.getForeignKeyMetaData();
            if (fkmds == null) continue;
            for (int i = 0; i < fkmds.length; ++i) {
                ForeignKey fk = this.getForeignKeyForForeignKeyMetaData(fkmds[i]);
                if (fk == null) continue;
                foreignKeys.add(fk);
            }
        }
        HashMap externalFks = this.getExternalFkMappings();
        if (!externalFks.isEmpty()) {
            Set externalFkKeys = externalFks.keySet();
            Iterator externalFkKeysIter = externalFkKeys.iterator();
            while (externalFkKeysIter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)externalFkKeysIter.next();
                DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(fmd.getAbstractClassMetaData().getFullClassName(), clr);
                if (referencedTable == null) continue;
                ForeignKeyMetaData fkmd = fmd.getForeignKeyMetaData();
                if (fkmd == null && fmd.getElementMetaData() != null) {
                    fkmd = fmd.getElementMetaData().getForeignKeyMetaData();
                }
                if ((fkmd == null || fkmd.getDeleteAction() == ForeignKeyAction.NONE) && !autoMode) continue;
                JavaTypeMapping fkMapping = (JavaTypeMapping)externalFks.get(fmd);
                ForeignKey fk = new ForeignKey(fkMapping, this.dba, referencedTable, true);
                fk.setForMetaData(fkmd);
                if (foreignKeys.contains(fk)) continue;
                foreignKeys.add(fk);
            }
        }
        return foreignKeys;
    }

    private void addExpectedForeignKeysForEmbeddedPCField(List foreignKeys, boolean autoMode, ClassLoaderResolver clr, EmbeddedPCMapping embeddedMapping) {
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            ForeignKey fk;
            JavaTypeMapping embFieldMapping = embeddedMapping.getJavaTypeMapping(i);
            if (embFieldMapping instanceof EmbeddedPCMapping) {
                this.addExpectedForeignKeysForEmbeddedPCField(foreignKeys, autoMode, clr, (EmbeddedPCMapping)embFieldMapping);
                continue;
            }
            AbstractMemberMetaData embFmd = embFieldMapping.getFieldMetaData();
            if (this.storeMgr.getOMFContext().getTypeManager().isReferenceType(embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                Collection fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                foreignKeys.addAll(fks);
                continue;
            }
            if (this.storeMgr.getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
            foreignKeys.add(fk);
        }
    }

    private ForeignKey getForeignKeyForForeignKeyMetaData(ForeignKeyMetaData fkmd) {
        int j;
        int i;
        if (fkmd == null) {
            return null;
        }
        ForeignKey fk = new ForeignKey(fkmd.isDeferred());
        fk.setForMetaData(fkmd);
        ClassMetaData acmd = this.cmd;
        if (fkmd.getTable() == null) {
            JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER.msg("RDBMS.Table.ForeignKey.NoTableForFK", acmd.getFullClassName()));
            return null;
        }
        DatastoreIdentifier tableId = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(fkmd.getTable());
        ClassTable refTable = (ClassTable)this.storeMgr.getDatastoreClass(tableId);
        if (refTable == null) {
            JPOXLogger.JDO.warn(LOCALISER.msg("RDBMS.Table.ForeignKey.TableForFKUnknown", acmd.getFullClassName(), fkmd.getTable()));
            return null;
        }
        PrimaryKey pk = refTable.getPrimaryKey();
        List targetCols = pk.getColumns();
        ArrayList<DatastoreField> sourceCols = new ArrayList<DatastoreField>();
        ColumnMetaData[] colmds = fkmd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = fkmd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colId = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column sourceCol = (Column)this.columnsByName.get(colId);
                if (sourceCol == null) {
                    JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER.msg("RDBMS.Table.ForeignKey.ColumnForFKUnknown", acmd.getFullClassName(), fkmd.getTable(), colmds[i].getName(), this.toString()));
                    return null;
                }
                sourceCols.add(sourceCol);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getFieldMetaData(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(realFmd);
                int countDatastoreFields = fieldMapping.getNumberOfDatastoreFields();
                for (j = 0; j < countDatastoreFields; ++j) {
                    sourceCols.add(fieldMapping.getDataStoreMapping(i).getDatastoreField());
                }
            }
        }
        if (sourceCols.size() != targetCols.size()) {
            JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER.msg("RDBMS.Table.ForeignKey.UnequalNumberOfColumns", acmd.getFullClassName(), fkmd.getTable(), "" + sourceCols.size(), "" + targetCols.size()));
        }
        if (sourceCols.size() > 0) {
            for (i = 0; i < sourceCols.size(); ++i) {
                Column source = (Column)sourceCols.get(i);
                String targetColName = colmds[i].getTarget();
                Column target = (Column)targetCols.get(i);
                if (targetColName != null) {
                    for (j = 0; j < targetCols.size(); ++j) {
                        Column targetCol = (Column)targetCols.get(j);
                        if (!targetCol.getIdentifier().getIdentifier().equalsIgnoreCase(targetColName)) continue;
                        target = targetCol;
                        break;
                    }
                }
                fk.addDatastoreField(source, target);
            }
        }
        return fk;
    }

    protected List getExpectedCandidateKeys() {
        int i;
        this.assertIsInitialized();
        List candidateKeys = super.getExpectedCandidateKeys();
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            CandidateKey ck;
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fieldMapping instanceof EmbeddedPCMapping) {
                EmbeddedPCMapping embMapping = (EmbeddedPCMapping)fieldMapping;
                for (i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                    CandidateKey ck2;
                    JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                    UniqueMetaData umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                    if (umd == null || (ck2 = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                    candidateKeys.add(ck2);
                }
                continue;
            }
            UniqueMetaData umd = fmd.getUniqueMetaData();
            if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, fieldMapping)) == null) continue;
            candidateKeys.add(ck);
        }
        Iterator cmdIter = this.managedClassMetaData.iterator();
        while (cmdIter.hasNext()) {
            ClassMetaData thisCmd = (ClassMetaData)cmdIter.next();
            UniqueMetaData[] classCKs = thisCmd.getUniqueMetaData();
            if (classCKs == null) continue;
            for (i = 0; i < classCKs.length; ++i) {
                CandidateKey ck = this.getCandidateKeyForUniqueMetaData(classCKs[i]);
                if (ck == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    private CandidateKey getCandidateKeyForUniqueMetaData(UniqueMetaData umd) {
        CandidateKey ck = new CandidateKey(this);
        if (umd.getName() != null) {
            ck.setName(umd.getName());
        }
        ColumnMetaData[] colmds = umd.getColumnMetaData();
        AbstractMemberMetaData[] fmds = umd.getMemberMetaData();
        if (colmds != null && colmds.length > 0) {
            for (int i = 0; i < colmds.length; ++i) {
                DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmds[i].getName());
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.CandidateKey.ColumnNotFound", this.toString(), ck.getName(), colmds[i].getName()));
                    break;
                }
                ck.addDatastoreField(col);
            }
        } else if (fmds != null && fmds.length > 0) {
            for (int i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData realFmd = this.getFieldMetaData(fmds[i].getName());
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(realFmd);
                int countFields = fieldMapping.getNumberOfDatastoreFields();
                for (int j = 0; j < countFields; ++j) {
                    ck.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
                }
            }
        } else {
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.CandidateKey.NoColumnsSpecified", this.toString(), ck.getName()));
            return null;
        }
        return ck;
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKey pk = super.getPrimaryKey();
        PrimaryKeyMetaData pkmd = this.cmd.getPrimaryKeyMetaData();
        if (pkmd != null && pkmd.getName() != null) {
            pk.setName(pkmd.getName());
        }
        return pk;
    }

    protected List getSQLCreateStatements(Properties props) {
        List<String> stmts;
        Properties tableProps = null;
        if (this.createStatementDDL != null) {
            stmts = new ArrayList();
            StringTokenizer tokens = new StringTokenizer(this.createStatementDDL, ";");
            while (tokens.hasMoreTokens()) {
                stmts.add(tokens.nextToken());
            }
        } else {
            if (this.cmd.getExtensions() != null) {
                tableProps = new Properties();
                ExtensionMetaData[] emds = this.cmd.getExtensions();
                for (int i = 0; i < emds.length; ++i) {
                    if (!emds[i].getVendorName().equalsIgnoreCase("jpox")) continue;
                    tableProps.put(emds[i].getKey(), emds[i].getValue());
                }
            }
            stmts = super.getSQLCreateStatements(tableProps);
        }
        if (this.secondaryTables != null) {
            Set secondaryTableNames = this.secondaryTables.keySet();
            Iterator iter = secondaryTableNames.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)this.secondaryTables.get(iter.next());
                stmts.addAll(secTable.getSQLCreateStatements(tableProps));
            }
        }
        stmts.addAll(this.getSQLAddUniqueConstraintsStatements());
        return stmts;
    }

    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        if (this.secondaryTables != null) {
            Set secondaryTableNames = this.secondaryTables.keySet();
            Iterator iter = secondaryTableNames.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)this.secondaryTables.get(iter.next());
                stmts.addAll(secTable.getSQLDropStatements());
            }
        }
        stmts.add(this.dba.getDropTableStatement(this));
        return stmts;
    }

    private List getSQLAddUniqueConstraintsStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        Iterator cks = this.candidateKeysByMapField.values().iterator();
        int ckNum = 0;
        RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
        while (cks.hasNext()) {
            DatastoreIdentifier ckName = idFactory.newCandidateKeyIdentifier(this, ++ckNum);
            CandidateKey ck = (CandidateKey)cks.next();
            ck.setName(ckName.getIdentifier());
            stmts.add(this.dba.getAddCandidateKeyStatement(ck, idFactory));
        }
        return stmts;
    }

    private void initializeFKMapUniqueConstraints(AbstractMemberMetaData ownerfmd) {
        AbstractMemberMetaData mfmd = null;
        String map_field_name = ownerfmd.getMappedBy();
        if (map_field_name != null) {
            mfmd = this.cmd.getMetaDataForMember(map_field_name);
            if (mfmd == null) {
                ClassMetaData managedCmd;
                Iterator cmdIter = this.managedClassMetaData.iterator();
                while (cmdIter.hasNext() && (mfmd = (managedCmd = (ClassMetaData)cmdIter.next()).getMetaDataForMember(map_field_name)) == null) {
                }
            }
            if (mfmd == null) {
                throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.RelationshipMappedByFieldNotFound", map_field_name, this.cmd.getFullClassName(), ownerfmd.getFullFieldName()));
            }
            if (mfmd != null && ownerfmd.getJoinMetaData() == null) {
                if (ownerfmd.getKeyMetaData() != null && ownerfmd.getKeyMetaData().getMappedBy() != null) {
                    AbstractMemberMetaData kmd = null;
                    String key_field_name = ownerfmd.getKeyMetaData().getMappedBy();
                    if (key_field_name != null) {
                        kmd = this.cmd.getMetaDataForMember(key_field_name);
                    }
                    if (kmd == null) {
                        ClassMetaData managedCmd;
                        Iterator cmdIter = this.managedClassMetaData.iterator();
                        while (cmdIter.hasNext() && (kmd = (managedCmd = (ClassMetaData)cmdIter.next()).getMetaDataForMember(key_field_name)) == null) {
                        }
                    }
                    if (kmd == null) {
                        throw new ClassDefinitionException(LOCALISER.msg("RDBMS.Table.InvalidMapKeyField", mfmd.getFullFieldName(), key_field_name));
                    }
                    JavaTypeMapping ownerMapping = this.getFieldMapping(map_field_name);
                    JavaTypeMapping keyMapping = this.getFieldMapping(kmd.getName());
                    if ((this.dba.supportsNullsInCandidateKeys() || !ownerMapping.isNullable() && !keyMapping.isNullable()) && keyMapping.getDatastoreContainer() == this && ownerMapping.getDatastoreContainer() == this) {
                        CandidateKey ck = new CandidateKey(this);
                        HashSet<Column> addedColumns = new HashSet<Column>();
                        int countOwnerFields = ownerMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countOwnerFields; ++i) {
                            Column col = (Column)ownerMapping.getDataStoreMapping(i).getDatastoreField();
                            addedColumns.add(col);
                            ck.addDatastoreField(col);
                        }
                        int countKeyFields = keyMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countKeyFields; ++i) {
                            Column col = (Column)keyMapping.getDataStoreMapping(i).getDatastoreField();
                            if (!addedColumns.contains(col)) {
                                addedColumns.add(col);
                                ck.addDatastoreField(col);
                                continue;
                            }
                            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.KeyTypeMapColumnOverwriteValueTypeMapColumn", ownerfmd.getName()));
                        }
                        if (this.candidateKeysByMapField.put(mfmd, ck) != null) {
                            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.DuplicateMapOwnerField", mfmd.getFullFieldName(), ownerfmd.getFullFieldName()));
                        }
                    }
                } else if (ownerfmd.getValueMetaData() != null && ownerfmd.getValueMetaData().getMappedBy() != null) {
                    AbstractMemberMetaData vmd = null;
                    String value_field_name = ownerfmd.getValueMetaData().getMappedBy();
                    if (value_field_name != null) {
                        vmd = this.cmd.getMetaDataForMember(value_field_name);
                    }
                    if (vmd == null) {
                        throw new ClassDefinitionException(LOCALISER.msg("RDBMS.Table.InvalidMapValueField", mfmd));
                    }
                    JavaTypeMapping ownerMapping = this.getFieldMapping(map_field_name);
                    JavaTypeMapping valueMapping = this.getFieldMapping(vmd.getName());
                    if ((this.dba.supportsNullsInCandidateKeys() || !ownerMapping.isNullable() && !valueMapping.isNullable()) && valueMapping.getDatastoreContainer() == this && ownerMapping.getDatastoreContainer() == this) {
                        CandidateKey ck = new CandidateKey(this);
                        HashSet<Column> addedColumns = new HashSet<Column>();
                        int countOwnerFields = ownerMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countOwnerFields; ++i) {
                            Column col = (Column)ownerMapping.getDataStoreMapping(i).getDatastoreField();
                            addedColumns.add(col);
                            ck.addDatastoreField(col);
                        }
                        int countValueFields = valueMapping.getNumberOfDatastoreFields();
                        for (int i = 0; i < countValueFields; ++i) {
                            Column col = (Column)valueMapping.getDataStoreMapping(i).getDatastoreField();
                            if (!addedColumns.contains(col)) {
                                addedColumns.add(col);
                                ck.addDatastoreField(col);
                                continue;
                            }
                            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.ValueTypeMapColumnOverwriteKeyTypeMapColumn", ownerfmd.getName()));
                        }
                        if (this.candidateKeysByMapField.put(mfmd, ck) != null) {
                            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.DuplicateMapOwnerField", mfmd.getFullFieldName(), ownerfmd.getFullFieldName()));
                        }
                    }
                } else {
                    throw new ClassDefinitionException(LOCALISER.msg("RDBMS.Table.MissingMapKeyValueField", ownerfmd.getFullFieldName()));
                }
            }
        }
    }

    private void initializeIDMapping() {
        if (this.idMapping != null) {
            return;
        }
        PersistenceCapableMapping mapping = new PersistenceCapableMapping();
        mapping.initialize(this.getStoreManager().getDatastoreAdapter(), this.cmd.getFullClassName());
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            mapping.addJavaTypeMapping(this.datastoreIDMapping);
        } else if (this.getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < this.pkMappings.length; ++i) {
                mapping.addJavaTypeMapping(this.pkMappings[i]);
            }
        }
        this.idMapping = mapping;
    }

    public JavaTypeMapping getIDMapping() {
        return this.idMapping;
    }

    private HashMap getExternalOrderMappings() {
        if (this.externalOrderMappings == null) {
            this.externalOrderMappings = new HashMap();
        }
        return this.externalOrderMappings;
    }

    private HashMap getExternalFkMappings() {
        if (this.externalFkMappings == null) {
            this.externalFkMappings = new HashMap();
        }
        return this.externalFkMappings;
    }

    public JavaTypeMapping getExternalMapping(AbstractMemberMetaData fmd, int mappingType) {
        if (mappingType == 5) {
            return (JavaTypeMapping)this.getExternalFkMappings().get(fmd);
        }
        if (mappingType == 6) {
            return (JavaTypeMapping)this.getExternalFkDiscriminatorMappings().get(fmd);
        }
        if (mappingType == 4) {
            return (JavaTypeMapping)this.getExternalOrderMappings().get(fmd);
        }
        return null;
    }

    public AbstractMemberMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        block4: {
            block5: {
                block3: {
                    if (mappingType != 5) break block3;
                    Set entries = this.getExternalFkMappings().entrySet();
                    Iterator iter = entries.iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        if (entry.getValue() != mapping) continue;
                        return (AbstractMemberMetaData)entry.getKey();
                    }
                    break block4;
                }
                if (mappingType != 6) break block5;
                Set entries = this.getExternalFkDiscriminatorMappings().entrySet();
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (entry.getValue() != mapping) continue;
                    return (AbstractMemberMetaData)entry.getKey();
                }
                break block4;
            }
            if (mappingType != 4) break block4;
            Set entries = this.getExternalOrderMappings().entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (entry.getValue() != mapping) continue;
                return (AbstractMemberMetaData)entry.getKey();
            }
        }
        return null;
    }

    private HashMap getExternalFkDiscriminatorMappings() {
        if (this.externalFkDiscriminatorMappings == null) {
            this.externalFkDiscriminatorMappings = new HashMap();
        }
        return this.externalFkDiscriminatorMappings;
    }

    public JavaTypeMapping getFieldMapping(AbstractMemberMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        if (fmd instanceof PropertyMetaData && fmd.getAbstractClassMetaData() instanceof InterfaceMetaData) {
            return this.getFieldMapping(fmd.getName());
        }
        if (fmd.isPrimaryKey()) {
            this.assertIsPKInitialized();
        } else {
            this.assertIsInitialized();
        }
        JavaTypeMapping m = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
        if (m != null) {
            return m;
        }
        int ifc = this.cmd.getNoOfInheritedManagedMembers();
        if (fmd.getAbsoluteFieldNumber() < ifc && this.supertable != null && (m = this.supertable.getFieldMapping(fmd)) != null) {
            return m;
        }
        if (this.secondaryTables != null) {
            Collection secTables = this.secondaryTables.values();
            Iterator iter = secTables.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)iter.next();
                m = secTable.getFieldMapping(fmd);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }

    public JavaTypeMapping getFieldMapping(String fieldName) {
        this.assertIsInitialized();
        AbstractMemberMetaData fmd = this.getFieldMetaData(fieldName);
        JavaTypeMapping m = this.getFieldMapping(fmd);
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fieldName);
        }
        return m;
    }

    AbstractMemberMetaData getFieldMetaData(String fieldName) {
        AbstractMemberMetaData fmd = this.cmd.getMetaDataForMember(fieldName);
        if (fmd == null) {
            Iterator iter = this.managedClassMetaData.iterator();
            while (iter.hasNext()) {
                AbstractClassMetaData theCmd = (AbstractClassMetaData)iter.next();
                AbstractMemberMetaData foundFmd = theCmd.getMetaDataForMember(fieldName);
                if (foundFmd == null) continue;
                if (!(fmd == null || fmd.toString().equalsIgnoreCase(foundFmd.toString()) && fmd.getType() == foundFmd.getType())) {
                    String errMsg = "Table " + this.getIdentifier() + " manages at least 2 subclasses that both define a field \"" + fieldName + "\", " + "and the fields' metadata is different or they have different type! That means you can get e.g. wrong fetch results.";
                    JPOXLogger.RDBMS.error(errMsg);
                    throw new JPOXException(errMsg).setFatal();
                }
                fmd = foundFmd;
            }
        }
        return fmd;
    }

    void assertPCClass(StateManager sm) {
        Class<?> c = sm.getObject().getClass();
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.cmd.getFullClassName(), c)) {
            throw new JPOXException(LOCALISER.msg("RDBMS.Table.ClassObjectInfo", this.cmd.getFullClassName(), c)).setFatal();
        }
    }

    public void insert(StateManager sm) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        if (this.supertable != null) {
            this.supertable.insert(sm);
        }
        InsertRequest req = this.storeMgr.getInsertRequest(this, sm.getObject().getClass(), sm.getObjectManager().getClassLoaderResolver());
        req.execute(sm);
        if (this.secondaryTables != null) {
            Collection tables = this.secondaryTables.values();
            Iterator tablesIter = tables.iterator();
            while (tablesIter.hasNext()) {
                SecondaryTable table = (SecondaryTable)tablesIter.next();
                table.insert(sm);
            }
        }
    }

    public void fetch(StateManager sm, AbstractMemberMetaData[] fieldMetaData) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        if (this.supertable != null) {
            this.supertable.fetch(sm, fieldMetaData);
        }
        FetchRequest req = this.storeMgr.getFetchRequest(this, fieldMetaData, sm.getObject().getClass(), sm.getObjectManager().getClassLoaderResolver());
        req.execute(sm);
    }

    public void update(StateManager sm, AbstractMemberMetaData[] fieldMetaData) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        if (this.supertable != null) {
            this.supertable.update(sm, fieldMetaData);
        }
        UpdateRequest req = this.storeMgr.getUpdateRequest(this, fieldMetaData, sm.getObject().getClass(), sm.getObjectManager().getClassLoaderResolver());
        req.execute(sm);
        if (this.secondaryTables != null) {
            Collection tables = this.secondaryTables.values();
            Iterator tablesIter = tables.iterator();
            while (tablesIter.hasNext()) {
                SecondaryTable table = (SecondaryTable)tablesIter.next();
                table.update(sm, fieldMetaData);
            }
        }
    }

    public void delete(StateManager sm) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        if (this.secondaryTables != null) {
            Collection tables = this.secondaryTables.values();
            Iterator tablesIter = tables.iterator();
            while (tablesIter.hasNext()) {
                SecondaryTable table = (SecondaryTable)tablesIter.next();
                table.delete(sm);
            }
        }
        DeleteRequest req = this.storeMgr.getDeleteRequest(this, sm.getObject().getClass(), sm.getObjectManager().getClassLoaderResolver());
        req.execute(sm);
        if (this.supertable != null) {
            this.supertable.delete(sm);
        }
    }

    public void locate(StateManager sm) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        LocateRequest req = this.storeMgr.getLocateRequest(this, sm.getObject().getClass().getName());
        req.execute(sm);
    }

    private JavaTypeMapping addOrderColumn(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        Class indexType = class$java$lang$Integer == null ? (class$java$lang$Integer = ClassTable.class$("java.lang.Integer")) : class$java$lang$Integer;
        IndexMapping indexMapping = new IndexMapping();
        indexMapping.initialize(this.dba, indexType.getName());
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier indexColumnName = null;
        ColumnMetaData colmd = null;
        OrderMetaData omd = fmd.getOrderMetaData();
        if (omd != null) {
            ColumnMetaData columnMetaData = colmd = omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 ? omd.getColumnMetaData()[0] : null;
            if (omd.getMappedBy() != null) {
                this.state = 2;
                JavaTypeMapping orderMapping = this.getFieldMapping(omd.getMappedBy());
                if (orderMapping == null) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.OrderMappingMappedByFieldNotFound", fmd.getFullFieldName(), omd.getMappedBy()));
                }
                if (!(orderMapping instanceof IntegerMapping) && !(orderMapping instanceof LongMapping)) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.Table.OrderMappingFieldInvalid", fmd.getFullFieldName(), omd.getMappedBy()));
                }
                return orderMapping;
            }
            String colName = null;
            if (omd.getColumnMetaData() != null && omd.getColumnMetaData().length > 0 && omd.getColumnMetaData()[0].getName() != null) {
                colName = omd.getColumnMetaData()[0].getName();
                indexColumnName = idFactory.newDatastoreFieldIdentifier(colName);
            }
        }
        if (indexColumnName == null) {
            indexColumnName = ((RDBMSIdentifierFactory)idFactory).newForeignKeyFieldIdentifier(fmd, null, null, this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(indexType), 7);
        }
        DatastoreField column = this.addDatastoreField(indexType.getName(), indexColumnName, indexMapping, colmd);
        if (colmd == null || colmd != null && !colmd.isAllowsNullSet() || colmd != null && colmd.isAllowsNullSet() && colmd.isAllowsNull()) {
            column.setNullable();
        }
        this.storeMgr.getMappingManager().createDatastoreMapping(indexMapping, this.storeMgr, column, indexType.getName());
        return indexMapping;
    }

    public void providePrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.pkMappings != null) {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < this.pkMappings.length; ++i) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.pkMappings[i], fmd);
            }
        } else {
            int[] primaryKeyFieldNumbers = this.cmd.getPKMemberPositions();
            int countPkFields = this.cmd.getNoOfPrimaryKeyMembers();
            for (int i = 0; i < countPkFields; ++i) {
                AbstractMemberMetaData pkfmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.getFieldMapping(pkfmd), pkfmd);
            }
        }
    }

    public final void provideExternalMappings(MappingConsumer consumer, int mappingType) {
        block4: {
            block5: {
                block3: {
                    if (mappingType != 5 || this.externalFkMappings == null) break block3;
                    consumer.preConsumeMapping(this.highestFieldNumber + 1);
                    Set fieldNumbersSet = this.externalFkMappings.keySet();
                    Iterator iter = fieldNumbersSet.iterator();
                    while (iter.hasNext()) {
                        AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
                        JavaTypeMapping fieldMapping = (JavaTypeMapping)this.externalFkMappings.get(fmd);
                        if (fieldMapping == null) continue;
                        consumer.consumeMapping(fieldMapping, 5);
                    }
                    break block4;
                }
                if (mappingType != 6 || this.externalFkDiscriminatorMappings == null) break block5;
                consumer.preConsumeMapping(this.highestFieldNumber + 1);
                Set fieldNumbersSet = this.externalFkDiscriminatorMappings.keySet();
                Iterator iter = fieldNumbersSet.iterator();
                while (iter.hasNext()) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
                    JavaTypeMapping fieldMapping = (JavaTypeMapping)this.externalFkDiscriminatorMappings.get(fmd);
                    if (fieldMapping == null) continue;
                    consumer.consumeMapping(fieldMapping, 6);
                }
                break block4;
            }
            if (mappingType != 4 || this.externalOrderMappings == null) break block4;
            consumer.preConsumeMapping(this.highestFieldNumber + 1);
            Set fieldNumbersSet = this.externalOrderMappings.keySet();
            Iterator iter = fieldNumbersSet.iterator();
            while (iter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
                JavaTypeMapping fieldMapping = (JavaTypeMapping)this.externalOrderMappings.get(fmd);
                if (fieldMapping == null) continue;
                consumer.consumeMapping(fieldMapping, 4);
            }
        }
    }

    public void provideMappingsForFields(MappingConsumer consumer, AbstractMemberMetaData[] fieldMetaData, boolean includeSecondaryTables) {
        super.provideMappingsForFields(consumer, fieldMetaData, true);
        if (includeSecondaryTables && this.secondaryTables != null) {
            Collection secTables = this.secondaryTables.values();
            Iterator iter = secTables.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)iter.next();
                secTable.provideMappingsForFields(consumer, fieldMetaData, false);
            }
        }
    }

    public void provideUnmappedDatastoreFields(MappingConsumer consumer) {
        if (this.unmappedColumns != null) {
            Iterator iter = this.unmappedColumns.iterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                consumer.consumeUnmappedDatastoreField(col);
            }
        }
    }

    public boolean validateConstraints(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean modified = false;
        if (super.validateConstraints(conn, autoCreate, autoCreateErrors, clr)) {
            modified = true;
        }
        if (this.secondaryTables != null) {
            Collection secTables = this.secondaryTables.values();
            Iterator iter = secTables.iterator();
            while (iter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)iter.next();
                if (!secTable.validateConstraints(conn, autoCreate, autoCreateErrors, clr)) continue;
                modified = true;
            }
        }
        return modified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallBack {
        final AbstractMemberMetaData fmd;

        public CallBack(AbstractMemberMetaData fmd) {
            this.fmd = fmd;
        }
    }
}

