/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceConfiguration;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.store.DatastoreField;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.table.TableImpl;
import org.jpox.util.JPOXLogger;

public class ProbeTable
extends TableImpl {
    public ProbeTable(RDBMSManager storeMgr) {
        super(storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier("DELETEME" + System.currentTimeMillis()), storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        JavaTypeMapping mapping = this.dba.getMapping(Integer.TYPE, this.storeMgr);
        DatastoreField column = this.addDatastoreField(Integer.TYPE.getName(), this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier("UNUSED"), mapping, null);
        this.getStoreManager().getMappingManager().createDatastoreMapping(mapping, this.storeMgr, column, Integer.TYPE.getName());
        this.state = 2;
    }

    public JavaTypeMapping getIDMapping() {
        throw new JPOXException("Attempt to get ID mapping of ProbeTable!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSchemaDetails(Connection conn) throws SQLException {
        String[] schemaDetails = new String[2];
        DatabaseMetaData dmd = conn.getMetaData();
        String table_name = this.identifier.getIdentifier();
        if (this.storeMgr.getIdentifierFactory().getIdentifierCase() == 2 || this.storeMgr.getIdentifierFactory().getIdentifierCase() == 3) {
            table_name = table_name.toLowerCase();
        } else if (this.storeMgr.getIdentifierFactory().getIdentifierCase() == 0 || this.storeMgr.getIdentifierFactory().getIdentifierCase() == 1) {
            table_name = table_name.toUpperCase();
        }
        PersistenceConfiguration pmfConfig = this.storeMgr.getOMFContext().getPersistenceConfiguration();
        String catalog_name = pmfConfig.getCatalog();
        String schema_name = pmfConfig.getSchema();
        if (!this.dba.supportsCatalogsInTableDefinitions()) {
            catalog_name = null;
        }
        if (!this.dba.supportsSchemasInTableDefinitions()) {
            schema_name = null;
        }
        ResultSet rs = dmd.getTables(catalog_name, schema_name, table_name, null);
        try {
            if (!rs.next()) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Table.ProbeTableError", this.identifier));
            }
            schemaDetails[0] = rs.getString(1);
            schemaDetails[1] = rs.getString(2);
        }
        finally {
            rs.close();
        }
        if (schemaDetails[0] == null) {
            JPOXLogger.RDBMS_SCHEMA.info(LOCALISER.msg("RDBMS.Table.CatalogNameUndeterminable"));
        }
        if (schemaDetails[1] == null) {
            JPOXLogger.RDBMS_SCHEMA.info(LOCALISER.msg("RDBMS.Table.SchemaNameUndeterminable"));
        }
        return schemaDetails;
    }

    protected boolean allowDDLOutput() {
        return false;
    }

    public JavaTypeMapping getFieldMapping(AbstractMemberMetaData fmd) {
        return null;
    }
}

