/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.RDBMSStoreHelper;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.exceptions.MissingColumnException;
import org.jpox.store.rdbms.exceptions.MissingTableException;
import org.jpox.store.rdbms.exceptions.NotAViewException;
import org.jpox.store.rdbms.exceptions.PrimaryKeyColumnNotAllowedException;
import org.jpox.store.rdbms.exceptions.UnexpectedColumnException;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.util.JPOXLogger;

public abstract class ViewImpl
extends AbstractTable {
    public ViewImpl(DatastoreIdentifier name, RDBMSManager storeMgr) {
        super(name, storeMgr);
    }

    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
    }

    public void postInitialize(ClassLoaderResolver clr) {
        this.assertIsInitialized();
    }

    public boolean validate(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        this.assertIsInitialized();
        int tableType = RDBMSStoreHelper.getTableType(this.storeMgr, this, conn);
        if (tableType == -1) {
            throw new MissingTableException(this.getCatalogName(), this.getSchemaName(), this.toString());
        }
        long startTime = System.currentTimeMillis();
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.View.Validating", this));
        }
        if (tableType != 2) {
            throw new NotAViewException(this.toString(), tableType);
        }
        HashMap unvalidated = new HashMap(this.columnsByName);
        Iterator i = this.storeMgr.getColumnInfoForTable(this, conn).iterator();
        while (i.hasNext()) {
            ColumnInfo ci = (ColumnInfo)i.next();
            DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newIdentifier(1, ci.getColumnName());
            Column col = (Column)unvalidated.get(colName);
            if (col == null) {
                if (this.hasColumnName(colName)) continue;
                throw new UnexpectedColumnException(this.toString(), colName.getIdentifier(), this.getSchemaName(), this.getCatalogName());
            }
            if (validateColumnStructure) {
                col.validate(ci);
                unvalidated.remove(colName);
                continue;
            }
            unvalidated.remove(colName);
        }
        if (unvalidated.size() > 0) {
            throw new MissingColumnException(this, unvalidated.values());
        }
        this.state = 4;
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return false;
    }

    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getDropViewStatement(this));
        return stmts;
    }

    protected synchronized void addColumnInternal(Column col) {
        if (col.isPrimaryKey()) {
            throw new PrimaryKeyColumnNotAllowedException(this.toString(), ((Object)col.getIdentifier()).toString());
        }
        super.addColumnInternal(col);
    }
}

