/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.transaction;

import java.util.Hashtable;
import org.jpox.transaction.JPOXTransactionException;
import org.jpox.transaction.Transaction;

public class TransactionManager {
    Hashtable transactions = new Hashtable();

    public void begin(Object om) {
        Transaction tx = (Transaction)this.transactions.get(om);
        if (tx != null) {
            throw new JPOXTransactionException("Invalid state. Transaction has already started");
        }
        tx = new Transaction();
        this.transactions.put(om, tx);
    }

    public void commit(Object om) {
        Transaction tx = (Transaction)this.transactions.get(om);
        if (tx == null) {
            throw new JPOXTransactionException("Invalid state. Transaction does not exist");
        }
        tx.commit();
        this.transactions.remove(om);
    }

    public Transaction getTransaction(Object om) {
        if (om == null) {
            return null;
        }
        return (Transaction)this.transactions.get(om);
    }

    public void resume(Object om, Transaction tx) {
        throw new UnsupportedOperationException();
    }

    public void rollback(Object om) {
        Transaction tx = (Transaction)this.transactions.get(om);
        if (tx == null) {
            throw new JPOXTransactionException("Invalid state. Transaction does not exist");
        }
        tx.rollback();
        this.transactions.remove(om);
    }

    public void setRollbackOnly(Object om) {
        Transaction tx = (Transaction)this.transactions.get(om);
        if (tx == null) {
            throw new JPOXTransactionException("Invalid state. Transaction does not exist");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(Object om, int millis) {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend(Object om) {
        throw new UnsupportedOperationException();
    }
}

