/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.jpox.util.StringUtils;

public class CommandLine {
    protected HashMap options = new HashMap();
    protected HashMap valueOptions = new HashMap();
    protected ArrayList optionList = new ArrayList();
    protected String[] defaultArg;
    protected String originalArguments;
    protected boolean displaysDash = true;

    public CommandLine() {
    }

    public CommandLine(boolean displaysDash) {
        this.displaysDash = displaysDash;
    }

    public void addOption(String shortName, String longName, String argName, String desc) {
        Option option = null;
        if (StringUtils.isEmpty(shortName) && StringUtils.isEmpty(longName)) {
            throw new IllegalArgumentException("require shortName or longName");
        }
        option = StringUtils.notEmpty(argName) ? new WithArgOption(shortName, longName, desc, argName) : new NoArgOption(shortName, longName, desc);
        this.optionList.add(option);
        if (StringUtils.notEmpty(shortName)) {
            this.options.put("-" + shortName, option);
            this.valueOptions.put(shortName, option);
        }
        if (StringUtils.notEmpty(longName)) {
            this.options.put("--" + longName, option);
            this.valueOptions.put(longName, option);
        }
    }

    public void parse(String[] args) {
        int i;
        ArrayList<String> defaultArg = new ArrayList<String>();
        if (args == null || args.length == 0) {
            return;
        }
        for (i = 0; i < args.length; ++i) {
            if (StringUtils.isEmpty(args[i])) continue;
            if (args[i].startsWith("-")) {
                this.originalArguments = this.originalArguments + args + " ";
                if (this.options.containsKey(args[i])) {
                    Option option = (Option)this.options.get(args[i]);
                    if (option instanceof NoArgOption) {
                        ((NoArgOption)option).selected = true;
                        continue;
                    }
                    if (args.length - 1 == i) {
                        throw new RuntimeException("option " + args[i] + " needs an argument");
                    }
                    ((WithArgOption)option).option = args[i + 1];
                    ++i;
                    continue;
                }
                defaultArg.add(args[i]);
                continue;
            }
            defaultArg.add(args[i]);
        }
        if (defaultArg.size() == 0) {
            this.defaultArg = new String[0];
        }
        String[] result = new String[defaultArg.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (String)defaultArg.get(i);
        }
        this.defaultArg = result;
    }

    public boolean hasOption(String name) {
        if (!this.valueOptions.containsKey(name)) {
            throw new IllegalArgumentException("no such option " + name);
        }
        Option option = (Option)this.valueOptions.get(name);
        if (option instanceof NoArgOption) {
            return ((NoArgOption)option).selected;
        }
        return StringUtils.notEmpty(((WithArgOption)option).option);
    }

    public String getOptionArg(String name) {
        if (!this.valueOptions.containsKey(name)) {
            throw new IllegalArgumentException("no such option " + name);
        }
        Option option = (Option)this.valueOptions.get(name);
        if (option instanceof NoArgOption) {
            return "" + ((NoArgOption)option).selected;
        }
        return ((WithArgOption)option).option;
    }

    public String toString() {
        int i;
        if (this.optionList.size() == 0) {
            return "[NO OPTIONS]";
        }
        int maxLength = 80;
        StringBuffer sb = new StringBuffer();
        int shortMax = 0;
        int longMax = 0;
        int argNameMax = 0;
        int descMax = 0;
        for (i = 0; i < this.optionList.size(); ++i) {
            Option o = (Option)this.optionList.get(i);
            if (o.shortName == null) continue;
            if (o.shortName != null && o.shortName.length() > shortMax) {
                shortMax = o.shortName.length();
            }
            if (o.longName != null && o.longName.length() > longMax) {
                longMax = o.longName.length();
            }
            if (o instanceof WithArgOption) {
                WithArgOption op = (WithArgOption)o;
                if (op.name.length() > argNameMax) {
                    argNameMax = op.name.length();
                }
            }
            if (o.description == null || o.description.length() <= descMax) continue;
            descMax = o.description.length();
        }
        if (shortMax > 0) {
            shortMax += 3;
        }
        if (longMax > 0) {
            longMax += 3;
        }
        if (argNameMax > 0) {
            argNameMax += 3;
        }
        for (i = 0; i < this.optionList.size(); ++i) {
            int j = 0;
            Option o = (Option)this.optionList.get(i);
            if (StringUtils.notEmpty(o.shortName)) {
                if (this.displaysDash) {
                    sb.append("-");
                }
                sb.append(o.shortName);
                j = o.shortName.length() + 1;
            }
            while (j < shortMax) {
                sb.append(" ");
                ++j;
            }
            j = 0;
            if (StringUtils.notEmpty(o.longName)) {
                sb.append("--");
                sb.append(o.longName);
                j = o.longName.length() + 2;
            }
            while (j < longMax) {
                sb.append(" ");
                ++j;
            }
            j = 0;
            if (o instanceof WithArgOption) {
                WithArgOption op = (WithArgOption)o;
                sb.append(op.name);
                j = op.name.length();
            }
            while (j < argNameMax) {
                sb.append(" ");
                ++j;
            }
            if (StringUtils.notEmpty(o.description)) {
                int basePos;
                if (shortMax + longMax + argNameMax > maxLength) {
                    basePos = maxLength / 2;
                    sb.append("\n");
                    for (int k = 0; k < basePos; ++k) {
                        sb.append(" ");
                    }
                } else {
                    basePos = shortMax + longMax + argNameMax;
                }
                int pos = basePos;
                for (j = 0; j < o.description.length(); ++j) {
                    sb.append(o.description.charAt(j));
                    if (pos >= maxLength) {
                        if (j < o.description.length() - 1 && o.description.charAt(j + 1) != ' ') {
                            for (int p = sb.length() - 1; p >= 0; --p) {
                                if (sb.charAt(p) != ' ') continue;
                                sb.insert(p, '\n');
                                for (int k = 0; k < basePos - 1; ++k) {
                                    sb.insert(p + 1, " ");
                                }
                                break;
                            }
                        } else {
                            sb.append("\n");
                            for (int k = 0; k < basePos; ++k) {
                                sb.append(" ");
                            }
                        }
                        pos = basePos;
                    }
                    ++pos;
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String[] getDefaultArgs() {
        return this.defaultArg;
    }

    public String getOriginalArguments() {
        return this.originalArguments;
    }

    protected static class WithArgOption
    extends Option {
        String name;
        String option;

        public WithArgOption(String shortName, String longName, String desc, String name) {
            super(shortName, longName, desc);
            this.name = name;
        }
    }

    protected static class NoArgOption
    extends Option {
        boolean selected;

        public NoArgOption(String shortName, String longName, String desc) {
            super(shortName, longName, desc);
        }
    }

    protected static class Option {
        final String shortName;
        final String longName;
        final String description;

        public Option(String shortName, String longName, String desc) {
            this.shortName = shortName;
            this.longName = longName;
            this.description = desc;
        }
    }
}

