/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.cache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.jdo.JDOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.ObjectExistsException;
import org.jpox.cache.CachedPC;
import org.jpox.cache.Level2Cache;

public class EhcacheLevel2Cache
implements Level2Cache {
    private final CacheManager cacheManager;
    private final Cache cache;
    static /* synthetic */ Class class$net$sf$ehcache$CacheManager;

    public EhcacheLevel2Cache(Properties props) {
        if (props.getProperty("ConfigurationFile") == null) {
            throw new JDOException("Cant create cache since property org.jpox.cache.level2.configurationFile is not defined.");
        }
        if (props.getProperty("CacheName") == null) {
            throw new JDOException("Cant create cache since property org.jpox.cache.level2.cacheName is not defined.");
        }
        try {
            this.cacheManager = CacheManager.create((URL)(class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = EhcacheLevel2Cache.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager).getResource(props.getProperty("ConfigurationFile")));
        }
        catch (CacheException e) {
            throw new JDOException("Cant create cache");
        }
        if (!this.cacheManager.cacheExists(props.getProperty("CacheName"))) {
            try {
                this.cacheManager.addCache(props.getProperty("CacheName"));
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw new JDOException("Cant create cache");
            }
            catch (ObjectExistsException e) {
                e.printStackTrace();
                throw new JDOException("Cant create cache");
            }
            catch (CacheException e) {
                e.printStackTrace();
                throw new JDOException("Cant create cache");
            }
        }
        this.cache = this.cacheManager.getCache(props.getProperty("CacheName"));
    }

    public void clear() {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean containsOid(Object oid) {
        try {
            return this.cache.getKeys().contains(oid);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return false;
    }

    public CachedPC get(Object oid) {
        try {
            Element element = this.cache.get((Serializable)oid);
            if (element == null) {
                return null;
            }
            return this.toPC(element);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return null;
    }

    private CachedPC toPC(Element object) {
        return (CachedPC)((CacheElement)object.getValue()).getValue();
    }

    private Element toElement(Object oid, CachedPC object) {
        return new Element((Serializable)oid, (Serializable)new CacheElement(object));
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by Ehcache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by Ehcache plugin");
    }

    public int getSize() {
        try {
            return this.cache.getSize();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean isEmpty() {
        try {
            return this.cache.getSize() == 0;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        return true;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (pc.getPersistenceCapable().jdoGetPersistenceManager() != null) {
            return null;
        }
        this.cache.put(this.toElement(oid, pc));
        return pc;
    }

    public void evict(Object oid) {
        CachedPC pc = this.get(oid);
        if (pc != null) {
            this.cache.remove((Serializable)this.toElement(oid, pc));
        }
    }

    public void evictAll() {
        this.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by Ehcache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by Ehcache plugin");
    }

    public void pinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by Ehcache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by Ehcache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by Ehcache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by Ehcache plugin");
    }

    public void unpinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by Ehcache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by Ehcache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by Ehcache plugin");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CacheElement
    implements Serializable {
        private final Object value;

        public CacheElement(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object arg0) {
            if (arg0 == this) {
                return true;
            }
            if (!(arg0 instanceof CacheElement)) {
                return false;
            }
            return ((CacheElement)arg0).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

