/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import java.util.ArrayList;
import java.util.HashMap;
import org.jpox.enhancer.EnhanceUtil;

public class CommandLine {
    protected HashMap options = new HashMap();
    protected HashMap valueOptions = new HashMap();
    protected ArrayList optionList = new ArrayList();
    protected String[] defaultArg;
    protected String originalArguments;

    public void addOption(String shortName, String longName, String argName, String desc) {
        Option option = null;
        if (EnhanceUtil.isEmpty(shortName) && EnhanceUtil.isEmpty(longName)) {
            throw new IllegalArgumentException("require shortName or longName");
        }
        option = EnhanceUtil.notEmpty(argName) ? new WithArgOption(shortName, longName, desc, argName) : new NoArgOption(shortName, longName, desc);
        this.optionList.add(option);
        if (EnhanceUtil.notEmpty(shortName)) {
            this.options.put("-" + shortName, option);
            this.valueOptions.put(shortName, option);
        }
        if (EnhanceUtil.notEmpty(longName)) {
            this.options.put("--" + longName, option);
            this.valueOptions.put(longName, option);
        }
    }

    public void parse(String[] args) {
        int i;
        ArrayList<String> defaultArg = new ArrayList<String>();
        if (args == null || args.length == 0) {
            return;
        }
        for (i = 0; i < args.length; ++i) {
            if (EnhanceUtil.isEmpty(args[i])) continue;
            if (args[i].startsWith("-")) {
                this.originalArguments = this.originalArguments + args + " ";
                if (this.options.containsKey(args[i])) {
                    Option option = (Option)this.options.get(args[i]);
                    if (option instanceof NoArgOption) {
                        ((NoArgOption)option).selected = true;
                        continue;
                    }
                    if (args.length - 1 == i) {
                        throw new RuntimeException("option " + args[i] + " needs an argument");
                    }
                    ((WithArgOption)option).option = args[i + 1];
                    ++i;
                    continue;
                }
                defaultArg.add(args[i]);
                continue;
            }
            defaultArg.add(args[i]);
        }
        if (defaultArg.size() == 0) {
            this.defaultArg = new String[0];
        }
        String[] result = new String[defaultArg.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (String)defaultArg.get(i);
        }
        this.defaultArg = result;
    }

    public boolean hasOption(String name) {
        if (!this.valueOptions.containsKey(name)) {
            throw new IllegalArgumentException("no such option " + name);
        }
        Option option = (Option)this.valueOptions.get(name);
        if (option instanceof NoArgOption) {
            return ((NoArgOption)option).selected;
        }
        return EnhanceUtil.notEmpty(((WithArgOption)option).option);
    }

    public String getOptionArg(String name) {
        if (!this.valueOptions.containsKey(name)) {
            throw new IllegalArgumentException("no such option " + name);
        }
        Option option = (Option)this.valueOptions.get(name);
        if (option instanceof NoArgOption) {
            return "" + ((NoArgOption)option).selected;
        }
        return ((WithArgOption)option).option;
    }

    public String toString() {
        int i;
        if (this.optionList.size() == 0) {
            return "[NO OPTIONS]";
        }
        int maxLength = 50;
        StringBuffer sb = new StringBuffer();
        int shortMax = 0;
        int longMax = 0;
        int argNameMax = 0;
        int descMax = 0;
        for (i = 0; i < this.optionList.size(); ++i) {
            Option o = (Option)this.optionList.get(i);
            if (o.shortName == null) continue;
            if (o.shortName != null && o.shortName.length() > shortMax) {
                shortMax = o.shortName.length();
            }
            if (o.longName != null && o.longName.length() > longMax) {
                longMax = o.longName.length();
            }
            if (o instanceof WithArgOption) {
                WithArgOption op = (WithArgOption)o;
                if (op.name.length() > argNameMax) {
                    argNameMax = op.name.length();
                }
            }
            if (o.description == null || o.description.length() <= descMax) continue;
            descMax = o.description.length();
        }
        if (shortMax > 0) {
            shortMax += 4;
        }
        if (longMax > 0) {
            longMax += 4;
        }
        if (argNameMax > 0) {
            argNameMax += 4;
        }
        for (i = 0; i < this.optionList.size(); ++i) {
            int j = 0;
            Option o = (Option)this.optionList.get(i);
            if (EnhanceUtil.notEmpty(o.shortName)) {
                sb.append("-");
                sb.append(o.shortName);
                j = o.shortName.length() + 1;
            }
            while (j < shortMax) {
                sb.append(" ");
                ++j;
            }
            j = 0;
            if (EnhanceUtil.notEmpty(o.longName)) {
                sb.append("--");
                sb.append(o.longName);
                j = o.longName.length() + 2;
            }
            while (j < longMax) {
                sb.append(" ");
                ++j;
            }
            j = 0;
            if (o instanceof WithArgOption) {
                WithArgOption op = (WithArgOption)o;
                sb.append(op.name);
                j = op.name.length();
            }
            while (j < argNameMax) {
                sb.append(" ");
                ++j;
            }
            if (EnhanceUtil.notEmpty(o.description)) {
                int basePos;
                if (shortMax + longMax + argNameMax > maxLength) {
                    basePos = maxLength / 2;
                    sb.append("\n");
                    for (int k = 0; k < basePos; ++k) {
                        sb.append(" ");
                    }
                } else {
                    basePos = shortMax + longMax + argNameMax;
                }
                int pos = basePos;
                for (j = 0; j < o.description.length(); ++j) {
                    sb.append(o.description.charAt(j));
                    if (pos >= maxLength) {
                        sb.append("\n");
                        for (int k = 0; k < basePos; ++k) {
                            sb.append(" ");
                        }
                        pos = basePos;
                    }
                    ++pos;
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String[] getDefaultArgs() {
        return this.defaultArg;
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine();
        cl.addOption("d", "dist", "output", "output dir aaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaa aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
        cl.addOption("c", null, null, null);
        cl.addOption("e", null, null, "test");
        cl.addOption(null, "f", null, null);
        cl.addOption(null, "g", null, "test");
        String[] arg = new String[]{"-d", "./", "a", "b"};
        System.out.println(cl.toString());
        cl.parse(arg);
        System.out.println(cl.hasOption("d") + " " + cl.hasOption("dist") + " " + cl.getOptionArg("d"));
        System.out.println(cl.hasOption("c") + " " + cl.hasOption("e"));
        String[] defaultArgs = cl.getDefaultArgs();
        for (int i = 0; i < defaultArgs.length; ++i) {
            System.out.println(defaultArgs[i] + ", ");
        }
    }

    public String getOriginalArguments() {
        return this.originalArguments;
    }

    protected static class WithArgOption
    extends Option {
        String name;
        String option;

        public WithArgOption(String shortName, String longName, String desc, String name) {
            super(shortName, longName, desc);
            this.name = name;
        }
    }

    protected static class NoArgOption
    extends Option {
        boolean selected;

        public NoArgOption(String shortName, String longName, String desc) {
            super(shortName, longName, desc);
        }
    }

    protected static class Option {
        final String shortName;
        final String longName;
        final String description;

        public Option(String shortName, String longName, String desc) {
            this.shortName = shortName;
            this.longName = longName;
            this.description = desc;
        }
    }
}

