/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOFatalException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.VerifierFactoryObserver;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.enhancer.EnhanceUtil;
import org.jpox.enhancer.Generator;
import org.jpox.enhancer.metadata.EnhancerClassMetaData;
import org.jpox.enhancer.metadata.EnhancerFieldMetaData;
import org.jpox.enhancer.metadata.EnhancerMetaDataManager;
import org.jpox.enhancer.method.CheckReadMethod;
import org.jpox.enhancer.method.CheckWriteMethod;
import org.jpox.enhancer.method.DefaultConstructor;
import org.jpox.enhancer.method.InitFieldFlags;
import org.jpox.enhancer.method.InitFieldNames;
import org.jpox.enhancer.method.InitFieldTypes;
import org.jpox.enhancer.method.InitPersistenceCapableSuperClass;
import org.jpox.enhancer.method.JdoCopyField;
import org.jpox.enhancer.method.JdoCopyFields;
import org.jpox.enhancer.method.JdoCopyKeyFieldsFromObjectId;
import org.jpox.enhancer.method.JdoCopyKeyFieldsFromObjectId2;
import org.jpox.enhancer.method.JdoCopyKeyFieldsToObjectId;
import org.jpox.enhancer.method.JdoCopyKeyFieldsToObjectId2;
import org.jpox.enhancer.method.JdoGetManagedFieldCount;
import org.jpox.enhancer.method.JdoGetObjectId;
import org.jpox.enhancer.method.JdoGetPersistenceManager;
import org.jpox.enhancer.method.JdoGetTransactionalObjectId;
import org.jpox.enhancer.method.JdoGetVersion;
import org.jpox.enhancer.method.JdoIsDeleted;
import org.jpox.enhancer.method.JdoIsDetached;
import org.jpox.enhancer.method.JdoIsDirty;
import org.jpox.enhancer.method.JdoIsNew;
import org.jpox.enhancer.method.JdoIsPersistent;
import org.jpox.enhancer.method.JdoIsTransactional;
import org.jpox.enhancer.method.JdoMakeDirty;
import org.jpox.enhancer.method.JdoNewInstance1;
import org.jpox.enhancer.method.JdoNewInstance2;
import org.jpox.enhancer.method.JdoNewObjectIdInstance1;
import org.jpox.enhancer.method.JdoNewObjectIdInstance2;
import org.jpox.enhancer.method.JdoPreSerialize;
import org.jpox.enhancer.method.JdoProvideField;
import org.jpox.enhancer.method.JdoProvideFields;
import org.jpox.enhancer.method.JdoReplaceDetachedState;
import org.jpox.enhancer.method.JdoReplaceField;
import org.jpox.enhancer.method.JdoReplaceFields;
import org.jpox.enhancer.method.JdoReplaceFlags;
import org.jpox.enhancer.method.JdoReplaceStateManager;
import org.jpox.enhancer.method.LoadClass;
import org.jpox.enhancer.method.MediateReadMethod;
import org.jpox.enhancer.method.MediateWriteMethod;
import org.jpox.enhancer.method.MethodBuilder;
import org.jpox.enhancer.method.NormalGetMethod;
import org.jpox.enhancer.method.NormalSetMethod;
import org.jpox.enhancer.method.ParentManagedFieldNum;
import org.jpox.enhancer.method.SuperClone;
import org.jpox.enhancer.method.WriteObject;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public abstract class GeneratorBase
implements Generator {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.jpox.enhancer.Localisation");
    public final JavaClass oldClass;
    public final ClassGen newClass;
    public final ConstantPoolGen constantPoolGen;
    public final FileMetaData jdoConfig;
    public final PackageMetaData packageConfig;
    public final EnhancerClassMetaData classConfig;
    public final String className;
    public final ObjectType classType;
    protected List addFieldList = new ArrayList();
    protected List methodBuilderList = new ArrayList();
    protected boolean update = false;
    protected long addSerialVersionUID;
    protected final ClassLoaderResolver clr;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Class;

    protected abstract GeneratorBase getGenerator();

    public GeneratorBase(EnhancerClassMetaData classConfig) {
        this.classConfig = classConfig;
        this.className = classConfig.getFullClassName();
        if (JPOXLogger.ENHANCER.isDebugEnabled()) {
            JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.SetupClass", (Object)this.className));
        }
        this.oldClass = classConfig.getEnhanceClass();
        this.newClass = classConfig.getClassGen();
        this.constantPoolGen = this.newClass.getConstantPool();
        this.packageConfig = classConfig.getPackageMetaData();
        this.jdoConfig = this.packageConfig.getFileMetaData();
        this.clr = new JDOClassLoaderResolver();
        this.classType = new ObjectType(this.className);
        ArrayList<Field> tmpList = new ArrayList<Field>();
        for (int i = 0; i < classConfig.getNoOfFields(); ++i) {
            EnhancerFieldMetaData f = (EnhancerFieldMetaData)classConfig.getField(i);
            if (f.isFinal() || f.isStatic()) continue;
            String fieldName = f.getName();
            Field field = EnhanceUtil.getFieldByName(fieldName, this.newClass);
            if (field == null) {
                throw new RuntimeException(LOCALISER.msg("Enhancer.ClassHasNoSuchField", (Object)this.newClass.getClassName(), (Object)fieldName));
            }
            tmpList.add(field);
        }
    }

    public void init() {
        this.init_addFieldsList();
        this.init_addMethodCallbackList();
    }

    private boolean requiresDetachable() {
        boolean hasPcsc;
        boolean isDetachable = this.classConfig.isDetachable();
        boolean bl = hasPcsc = this.classConfig.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc && isDetachable) {
            return true;
        }
        return hasPcsc && !this.classConfig.getSuperclassMetaData().isDetachable() && isDetachable;
    }

    protected void init_addMethodCallbackList() {
        boolean hasPcsc;
        boolean isDetachable = this.classConfig.isDetachable();
        boolean bl = hasPcsc = this.classConfig.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc) {
            this.methodBuilderList.add(JdoCopyKeyFieldsFromObjectId.getInstance(this));
            this.methodBuilderList.add(JdoCopyKeyFieldsFromObjectId2.getInstance(this));
            this.methodBuilderList.add(JdoCopyKeyFieldsToObjectId.getInstance(this));
            this.methodBuilderList.add(JdoCopyKeyFieldsToObjectId2.getInstance(this));
            this.methodBuilderList.add(JdoGetObjectId.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoGetVersion.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoPreSerialize.getInstance(this));
            this.methodBuilderList.add(JdoGetPersistenceManager.getInstance(this));
            this.methodBuilderList.add(JdoGetTransactionalObjectId.getInstance(this));
            this.methodBuilderList.add(JdoIsDeleted.getInstance(this));
            this.methodBuilderList.add(JdoIsDirty.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoIsNew.getInstance(this));
            this.methodBuilderList.add(JdoIsPersistent.getInstance(this));
            this.methodBuilderList.add(JdoIsTransactional.getInstance(this));
            this.methodBuilderList.add(JdoIsDetached.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoMakeDirty.getInstance(this));
            this.methodBuilderList.add(JdoNewObjectIdInstance1.getInstance(this));
            this.methodBuilderList.add(JdoNewObjectIdInstance2.getInstance(this));
            this.methodBuilderList.add(JdoProvideFields.getInstance(this));
            this.methodBuilderList.add(JdoReplaceFields.getInstance(this));
            this.methodBuilderList.add(JdoReplaceFlags.getInstance(this));
            this.methodBuilderList.add(JdoReplaceStateManager.getInstance(this));
        }
        if (this.requiresDetachable()) {
            this.methodBuilderList.add(JdoReplaceDetachedState.getInstance(this));
        }
        this.methodBuilderList.add(JdoNewInstance1.getInstance(this));
        this.methodBuilderList.add(JdoNewInstance2.getInstance(this));
        this.methodBuilderList.add(JdoReplaceField.getInstance(this));
        this.methodBuilderList.add(JdoProvideField.getInstance(this));
        this.methodBuilderList.add(JdoCopyField.getInstance(this));
        this.methodBuilderList.add(JdoCopyFields.getInstance(this));
        this.methodBuilderList.add(InitFieldNames.getInstance(this));
        this.methodBuilderList.add(InitFieldTypes.getInstance(this));
        this.methodBuilderList.add(InitFieldFlags.getInstance(this));
        this.methodBuilderList.add(ParentManagedFieldNum.getInstance(this));
        this.methodBuilderList.add(JdoGetManagedFieldCount.getInstance(this));
        this.methodBuilderList.add(InitPersistenceCapableSuperClass.getInstance(this));
        this.methodBuilderList.add(LoadClass.getInstance(this));
        this.methodBuilderList.add(SuperClone.getInstance(this));
        if (this.checkHasDefaultConstructor() != null) {
            this.methodBuilderList.add(DefaultConstructor.getInstance(this));
        }
        try {
            if (EnhanceUtil.isInstanceof(this.oldClass, class$java$io$Serializable == null ? (class$java$io$Serializable = GeneratorBase.class$("java.io.Serializable")) : class$java$io$Serializable) && EnhanceUtil.findMethod(this.newClass, "writeObject", "(Ljava/io/ObjectOutputStream;)V") == null) {
                this.methodBuilderList.add(WriteObject.getInstance(this));
                if (EnhanceUtil.getFieldByName("serialVersionUID", this.newClass) == null) {
                    this.addFieldList.add(new FieldGen(26, (Type)Type.LONG, "serialVersionUID", this.constantPoolGen));
                    Class<?> oClass = Class.forName(this.classConfig.getFullClassName(), false, this.getClass().getClassLoader());
                    this.addSerialVersionUID = ObjectStreamClass.lookup(oClass).getSerialVersionUID();
                }
            }
        }
        catch (ClassNotFoundException e) {
            JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.ErrorEnhancingClass", (Object)this.classConfig.getFullClassName(), (Object)e));
        }
    }

    protected void init_addFieldsList() {
        boolean hasPcsc;
        boolean bl = hasPcsc = this.classConfig.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc) {
            this.addFieldList.add(new FieldGen(132, (Type)Generator.OT_StateManager, "jdoStateManager", this.constantPoolGen));
            this.addFieldList.add(new FieldGen(132, Generator.OT_Flag, "jdoFlags", this.constantPoolGen));
        }
        if (this.requiresDetachable()) {
            this.addFieldList.add(new FieldGen(4, Generator.OT_ObjectArray, "jdoDetachedState", this.constantPoolGen));
        }
        this.addFieldList.add(new FieldGen(26, (Type)new ArrayType((Type)Type.BYTE, 1), "jdoFieldFlags", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)Generator.OT_CLASS, "jdoPersistenceCapableSuperclass", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)new ArrayType((class$java$lang$Class == null ? (class$java$lang$Class = GeneratorBase.class$("java.lang.Class")) : class$java$lang$Class).getName(), 1), "jdoFieldTypes", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)new ArrayType((Type)Type.STRING, 1), "jdoFieldNames", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)Type.INT, "jdoInheritedFieldCount", this.constantPoolGen));
    }

    public String check() {
        if (ClassUtils.isInnerClass((String)this.className) && (this.getAccessFlagsForInnerClass(this.oldClass, this.className) & 8) == 0) {
            return LOCALISER.msg("enhancer.error.if_pc_class_is_an_inner_class_it_must_be_static", (Object)this.newClass.getClassName());
        }
        if (this.checkEnhanced()) {
            return LOCALISER.msg("Enhancer.ClassIsAlreadyEnhanced", (Object)this.newClass.getClassName());
        }
        return null;
    }

    private int getAccessFlagsForInnerClass(JavaClass javaClass, String className) {
        for (int i = 0; i < javaClass.getAttributes().length; ++i) {
            if (!(javaClass.getAttributes()[i] instanceof InnerClasses)) continue;
            InnerClasses innerClasses = (InnerClasses)javaClass.getAttributes()[i];
            for (int j = 0; j < innerClasses.getInnerClasses().length; ++j) {
                String name = this.constantPoolGen.getConstantPool().getConstantString(innerClasses.getInnerClasses()[j].getInnerClassIndex(), (byte)7);
                if (!name.equals(className)) continue;
                return innerClasses.getInnerClasses()[i].getInnerAccessFlags();
            }
        }
        return -1;
    }

    protected String checkHasDefaultConstructor() {
        Method[] methods = this.newClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<init>") || !methods[i].getSignature().equals("()V")) continue;
            return null;
        }
        return LOCALISER.msg("enhancer.error.need_default_constructor", (Object)this.newClass.getClassName());
    }

    protected boolean checkEnhanced() {
        Method[] methods;
        String[] interfaceNames = this.newClass.getInterfaceNames();
        if (interfaceNames != null) {
            for (int i = 0; i < interfaceNames.length; ++i) {
                if (!interfaceNames[i].equals(Generator.CN_PersistenceCapable)) continue;
                return true;
            }
        }
        if ((methods = this.newClass.getMethods()) != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("jdoReplaceField")) continue;
                return true;
            }
        }
        return false;
    }

    public void enhance() {
        this.init();
        String message = this.check();
        if (message != null) {
            JPOXLogger.ENHANCER.error((Object)message);
            return;
        }
        if (this.classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            this.enhanceOriginalMethods();
            this.enhanceClassBefore();
            this.enhanceClass();
            this.enhanceClassAfter();
            this.enhanceFieldsBefore();
            this.enhanceFields();
            this.enhanceFieldsAfter();
            this.enhanceMethodBefore();
            this.enhanceMethod();
            this.enhanceMethodAfter();
            this.enhanceStaticInitializerBefore();
            this.enhanceStaticInitializer();
            this.enhanceStaticInitializerAfter();
        } else if (this.classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
            this.enhanceOriginalMethods();
        }
        this.update = true;
    }

    public void enhanceClass() {
        if (this.classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            this.class_addInterface(Generator.CN_PersistenceCapable);
            if (this.requiresDetachable()) {
                this.class_addInterface(Generator.CN_Detachable);
            }
            for (int i = 0; i < this.classConfig.getNoOfFields(); ++i) {
                EnhancerFieldMetaData f = (EnhancerFieldMetaData)this.classConfig.getField(i);
                if (!f.fieldBelongsToClass() || EnhanceUtil.isSynthetic((FieldOrMethod)f.getEnhanceField())) continue;
                this.enhanceSetter(f);
                this.enhanceGetter(f);
            }
        }
    }

    protected void class_addInterface(String interfaceName) {
        if (JPOXLogger.ENHANCER.isDebugEnabled()) {
            JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("enhancer.debug.add_interface", (Object)interfaceName));
        }
        this.newClass.addInterface(interfaceName);
        this.newClass.update();
    }

    public abstract void enhanceClassAfter();

    public abstract void enhanceClassBefore();

    public void enhanceFields() {
        for (int i = 0; i < this.addFieldList.size(); ++i) {
            FieldGen gen = (FieldGen)this.addFieldList.get(i);
            this.field_addField(gen);
        }
    }

    protected void field_addField(FieldGen fieldGen) {
        Field f = fieldGen.getField();
        this.newClass.addField(f);
        EnhanceUtil.addSynthetic((FieldOrMethod)f, this.constantPoolGen);
        if (JPOXLogger.ENHANCER.isDebugEnabled()) {
            JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.AddField", (Object)f.getType(), (Object)f.getName()));
        }
        this.newClass.update();
    }

    public abstract void enhanceFieldsAfter();

    public abstract void enhanceFieldsBefore();

    public void enhanceMethod() {
        for (int i = 0; i < this.methodBuilderList.size(); ++i) {
            Object o = this.methodBuilderList.get(i);
            if (o instanceof MethodBuilder) {
                MethodBuilder callback = (MethodBuilder)o;
                if (JPOXLogger.ENHANCER.isDebugEnabled()) {
                    JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("enhancer.debug.execute_method_callback", (Object)callback.getClass().getName()));
                }
                callback.init();
                callback.execute();
                callback.close();
                continue;
            }
            if (o == null) {
                JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("enhancer.error.callback_is_null"));
                continue;
            }
            JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("enhancer.error.instance_is_not_CreateMethodCallback_class", (Object)o.getClass().getName()));
        }
    }

    public abstract void enhanceMethodAfter();

    public abstract void enhanceMethodBefore();

    public void enhanceStaticInitializer() {
        InstructionList il = null;
        InstructionFactory factory = new InstructionFactory(this.newClass);
        Method clinit = null;
        InstructionList ilOriginal = null;
        MethodGen methodGen = null;
        MethodGen methodGenOriginal = null;
        Method[] methods = this.newClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<clinit>")) continue;
            clinit = methods[i];
            methodGenOriginal = new MethodGen(clinit, this.className, this.constantPoolGen);
            ilOriginal = methodGenOriginal.getInstructionList();
        }
        il = new InstructionList();
        methodGen = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, null, "<clinit>", this.className, il, this.constantPoolGen);
        if (this.addSerialVersionUID != 0L) {
            int svUidIndex = this.constantPoolGen.addLong(this.addSerialVersionUID);
            il.append((Instruction)new LDC2_W(svUidIndex));
            il.append((Instruction)factory.createPutStatic(this.className, "serialVersionUID", (Type)Type.LONG));
        }
        il.append((Instruction)factory.createInvoke(this.className, "__jdoFieldNamesInit", (Type)new ArrayType((Type)Type.STRING, 1), Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoFieldNames", (Type)new ArrayType((Type)Type.STRING, 1)));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoFieldTypesInit", (Type)new ArrayType((Type)Generator.OT_CLASS, 1), Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoFieldTypes", (Type)new ArrayType((Type)Generator.OT_CLASS, 1)));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoFieldFlagsInit", (Type)new ArrayType((Type)Type.BYTE, 1), Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoFieldFlags", (Type)new ArrayType((Type)Type.BYTE, 1)));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoGetInheritedFieldCount", (Type)Type.INT, Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoInheritedFieldCount", (Type)Type.INT));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoPersistenceCapableSuperclassInit", (Type)Generator.OT_CLASS, Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoPersistenceCapableSuperclass", (Type)Generator.OT_CLASS));
        il.append((Instruction)new LDC(this.constantPoolGen.addString(this.className)));
        il.append((Instruction)factory.createInvoke(this.className, "___jdo$loadClass", (Type)Generator.OT_CLASS, new Type[]{Type.STRING}, (short)184));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoFieldNames", (Type)new ArrayType((Type)Type.STRING, 1)));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoFieldTypes", (Type)new ArrayType((Type)Generator.OT_CLASS, 1)));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoFieldFlags", (Type)new ArrayType((Type)Type.BYTE, 1)));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoPersistenceCapableSuperclass", (Type)Generator.OT_CLASS));
        if (this.classConfig.getClassGen().isAbstract()) {
            il.append(InstructionConstants.ACONST_NULL);
        } else {
            il.append((Instruction)factory.createNew(new ObjectType(this.className)));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((Instruction)factory.createInvoke(this.className, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        }
        il.append((Instruction)factory.createInvoke(Generator.CN_JDOImplHelper, "registerClass", (Type)Type.VOID, new Type[]{Generator.OT_CLASS, new ArrayType((Type)Type.STRING, 1), new ArrayType((Type)Generator.OT_CLASS, 1), new ArrayType((Type)Type.BYTE, 1), Generator.OT_CLASS, Generator.OT_PersistenceCapable}, (short)184));
        this.staticInitializerAppend(factory, il);
        if (ilOriginal != null) {
            il.append(ilOriginal);
        }
        il.append((Instruction)InstructionConstants.RETURN);
        if (clinit != null) {
            this.newClass.removeMethod(clinit);
        }
        methodGen.setMaxLocals();
        methodGen.setMaxStack();
        Method method = methodGen.getMethod();
        Method[] allMethod = this.newClass.getMethods();
        this.newClass.replaceMethod(allMethod[0], method);
        this.newClass.addMethod(allMethod[0]);
        il.dispose();
    }

    protected abstract void staticInitializerAppend(InstructionFactory var1, InstructionList var2);

    public abstract void enhanceStaticInitializerAfter();

    public abstract void enhanceStaticInitializerBefore();

    protected void enhanceOriginalMethod(Method m) {
        boolean isDebugEnabled = JPOXLogger.ENHANCER.isDebugEnabled();
        if (EnhanceUtil.isSynthetic((FieldOrMethod)m)) {
            if (isDebugEnabled) {
                JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("enhancer.debug.skip_enhance_synthetic_method", (Object)m.getName()));
            }
            return;
        }
        MethodGen methodGen = new MethodGen(m, this.className, this.constantPoolGen);
        InstructionList il = methodGen.getInstructionList();
        if (il == null || il.size() == 0) {
            return;
        }
        InstructionFactory factory = new InstructionFactory(this.newClass);
        boolean isCloneMethod = "clone".equals(m.getName()) && (m.getArgumentTypes() == null || m.getArgumentTypes().length == 0);
        boolean change = false;
        for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof GETFIELD || i instanceof PUTFIELD) {
                FieldInstruction field = (FieldInstruction)i;
                Constant c = m.getConstantPool().getConstant(field.getIndex());
                ConstantFieldref fieldRef = (ConstantFieldref)c;
                ConstantClass cclass = (ConstantClass)m.getConstantPool().getConstant(fieldRef.getClassIndex());
                ConstantUtf8 utfClassName = (ConstantUtf8)m.getConstantPool().getConstant(cclass.getNameIndex());
                JavaClass fieldJavaClass = null;
                try {
                    fieldJavaClass = Repository.lookupClass((String)StringUtils.replaceAll((String)utfClassName.getBytes().toString(), (String)"/", (String)"."));
                }
                catch (Throwable ex) {
                    JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
                    throw new JDOFatalException(LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
                }
                Field f = EnhanceUtil.getFieldByName(field.getName(this.constantPoolGen), fieldJavaClass);
                if (f == null) {
                    String message = LOCALISER.msg("enhancer.error.field_is_null", (Object)this.className, (Object)m.getName(), (Object)field.getName(this.constantPoolGen));
                    JPOXLogger.ENHANCER.error((Object)message);
                    throw new NullPointerException(message);
                }
                ClassGen cg = EnhanceUtil.getClassByFieldByName(field.getName(this.constantPoolGen), fieldJavaClass);
                EnhancerFieldMetaData fieldConfig = null;
                EnhancerClassMetaData jdoConfigClass = this.classConfig;
                if (!this.isPersistenceCapable(StringUtils.replaceAll((String)cg.getClassName(), (String)"/", (String)"."))) continue;
                if (!cg.getClassName().equals(this.newClass.getClassName())) {
                    jdoConfigClass = (EnhancerClassMetaData)this.classConfig.getPackageMetaData().getFileMetaData().getMetaDataManager().getMetaDataForClass(cg.getClassName(), this.clr);
                }
                if ((fieldConfig = jdoConfigClass.findField(f)) == null) {
                    String message = LOCALISER.msg("enhancer.fatal.field_config_is_null", (Object)(this.className + "." + f.getName()));
                    JPOXLogger.ENHANCER.fatal((Object)message);
                    throw new RuntimeException(message);
                }
                if (!this.isFieldAccessInPersistenceCapableClass(ih, m.getConstantPool()) || fieldConfig != null && fieldConfig.getJdoFieldFlag() == 0 || f.isStatic() || f.isFinal() || EnhanceUtil.isSynthetic((FieldOrMethod)f)) continue;
                if (isDebugEnabled) {
                    JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("enhancer.debug.enhance_original_method", (Object)(this.className + "." + m.getName()), (Object)f.getName()));
                }
                if (i instanceof GETFIELD) {
                    ih.setInstruction((Instruction)factory.createInvoke(cg.getClassName(), "jdo" + EnhanceUtil.getGetterName(f), field.getType(this.constantPoolGen), new Type[]{new ObjectType(cg.getClassName())}, (short)184));
                } else {
                    ih.setInstruction((Instruction)factory.createInvoke(cg.getClassName(), "jdo" + EnhanceUtil.getSetterName(f), (Type)Type.VOID, new Type[]{new ObjectType(cg.getClassName()), field.getType(this.constantPoolGen)}, (short)184));
                }
                change = true;
                continue;
            }
            if (!isCloneMethod || !(i instanceof INVOKESPECIAL)) continue;
            INVOKESPECIAL is = (INVOKESPECIAL)i;
            if (this.classConfig.getPersistenceCapableSuperclass() != null || !"clone".equals(is.getMethodName(this.constantPoolGen)) || !"()Ljava/lang/Object;".equals(is.getSignature(this.constantPoolGen))) continue;
            ih.setInstruction((Instruction)factory.createInvoke(this.className, "jdoSuperClone", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            if (isDebugEnabled) {
                JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("enhancer.debug.enhance_original_method", (Object)(this.className + "." + m.getName()), (Object)"super.clone()"));
            }
            change = true;
        }
        if (change) {
            methodGen.setMaxLocals();
            methodGen.setMaxStack();
            this.newClass.replaceMethod(m, methodGen.getMethod());
        }
    }

    protected void enhanceOriginalMethods() {
        Method[] methods = this.newClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if ("jdoPreClear".equals(methods[i].getName()) || "jdoPostLoad".equals(methods[i].getName()) || "readObject".equals(methods[i].getName()) && (methods[i].getSignature().equals("(Ljava/io/ObjectOutputStream;)V") || methods[i].getSignature().equals("(Ljava/io/ObjectInputStream;)V"))) continue;
            this.enhanceOriginalMethod(methods[i]);
        }
    }

    private String getClassNameForFieldAccess(InstructionHandle ih, ConstantPool cp) {
        Constant c = cp.getConstant(((CPInstruction)ih.getInstruction()).getIndex());
        if (c instanceof ConstantFieldref) {
            ConstantFieldref fieldRef = (ConstantFieldref)c;
            ConstantClass cclass = (ConstantClass)cp.getConstant(fieldRef.getClassIndex());
            ConstantUtf8 className = (ConstantUtf8)cp.getConstant(cclass.getNameIndex());
            return StringUtils.replaceAll((String)className.getBytes().toString(), (String)"/", (String)".");
        }
        return null;
    }

    private boolean isFieldAccessInPersistenceCapableClass(InstructionHandle ih, ConstantPool cp) {
        String className = this.getClassNameForFieldAccess(ih, cp);
        if (className == null) {
            return false;
        }
        return this.isPersistenceCapable(className);
    }

    private boolean isPersistenceCapable(String className) {
        if (className.equals(this.className)) {
            return true;
        }
        if (ClassUtils.isPersistenceCapableClass((ClassLoader)this.getClass().getClassLoader(), (String)className)) {
            return true;
        }
        ClassMetaData cmd = this.jdoConfig.getMetaDataManager().getMetaDataForClass(className, this.clr);
        return cmd != null && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    protected void enhanceSetter(EnhancerFieldMetaData fieldConfig) {
        Field f = fieldConfig.getEnhanceField();
        String methodName = EnhanceUtil.getSetterName(fieldConfig.getEnhanceField());
        MethodBuilder callback = null;
        byte jdoFlag = fieldConfig.getJdoFieldFlag();
        if (f.isFinal() || f.isStatic()) {
            return;
        }
        if (FieldPersistenceModifier.NONE.equals((Object)fieldConfig.getPersistenceModifier())) {
            return;
        }
        callback = (jdoFlag & 2) == 2 ? new MediateWriteMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, (Type)Type.VOID, new Type[]{this.classType, f.getType()}, new String[]{"objPC", f.getName() + "_m"}, true, this, fieldConfig) : ((jdoFlag & 1) == 1 ? new CheckWriteMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, (Type)Type.VOID, new Type[]{this.classType, f.getType()}, new String[]{"objPC", f.getName() + "_c"}, true, this, fieldConfig) : new NormalSetMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, (Type)Type.VOID, new Type[]{this.classType, f.getType()}, new String[]{"objPC", f.getName() + "_n"}, true, this, fieldConfig));
        if (callback != null) {
            this.methodBuilderList.add(callback);
        }
    }

    protected void enhanceGetter(EnhancerFieldMetaData fieldConfig) {
        Field f = fieldConfig.getEnhanceField();
        String methodName = EnhanceUtil.getGetterName(f);
        MethodBuilder callback = null;
        byte jdoFlag = fieldConfig.getJdoFieldFlag();
        if (f.isFinal() || f.isStatic()) {
            return;
        }
        if (FieldPersistenceModifier.NONE.equals((Object)fieldConfig.getPersistenceModifier())) {
            return;
        }
        callback = (jdoFlag & 2) == 2 ? new MediateReadMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, f.getType(), new Type[]{this.classType}, new String[]{"objPC"}, true, this, fieldConfig) : ((jdoFlag & 1) == 1 ? new CheckReadMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, f.getType(), new Type[]{this.classType}, new String[]{"objPC"}, true, this, fieldConfig) : new NormalGetMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, f.getType(), new Type[]{this.classType}, new String[]{"objPC"}, true, this, fieldConfig));
        this.methodBuilderList.add(callback);
    }

    public static String[] getFullClassNames(FileMetaData config) {
        ArrayList<String> classNameList = new ArrayList<String>();
        for (int i = 0; i < config.getNoOfPackages(); ++i) {
            PackageMetaData packageConfig = config.getPackage(i);
            String packageName = packageConfig.getName();
            for (int j = 0; j < packageConfig.getNoOfClasses(); ++j) {
                EnhancerClassMetaData classConfig = (EnhancerClassMetaData)packageConfig.getClass(j);
                String fullClassName = null;
                fullClassName = packageName == null || packageName.length() == 0 ? classConfig.getName() : packageName + "." + classConfig.getName();
                classNameList.add(fullClassName);
            }
        }
        String[] results = new String[classNameList.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String)classNameList.get(i);
        }
        return results;
    }

    public static FileMetaData[] readJDOConfig(String[] fileList) throws Exception {
        ArrayList<FileMetaData> configList = new ArrayList<FileMetaData>();
        if (fileList == null) {
            return null;
        }
        EnhancerMetaDataManager mgr = new EnhancerMetaDataManager();
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver();
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.ReadJDOFilesStart", (Object)("" + fileList.length)));
        for (int i = 0; i < fileList.length; ++i) {
            try {
                FileMetaData conf = mgr.parseAndRegisterFile(fileList[i]);
                if (conf == null) {
                    String msg = LOCALISER.msg("Enhancer.CannotReadFileErrorUnknownCauseWithoutHelp", (Object)fileList[i]);
                    System.err.println(msg);
                    JPOXLogger.ENHANCER.error((Object)msg);
                    continue;
                }
                configList.add(conf);
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                JPOXLogger.ENHANCER.error((Object)ex.getMessage());
            }
        }
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.ReadJDOFilesEnd", (Object)("" + fileList.length), (Object)("" + configList.size())));
        Iterator configIter = configList.iterator();
        while (configIter.hasNext()) {
            FileMetaData filemd = (FileMetaData)configIter.next();
            mgr.populateRegisteredFile(filemd, (ClassLoaderResolver)clr);
        }
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.InitialiseJDOFilesStart", (Object)("" + configList.size())));
        boolean metadataIncorrect = false;
        FileMetaData[] metadata = new FileMetaData[configList.size()];
        for (int i = 0; i < metadata.length; ++i) {
            metadata[i] = (FileMetaData)configList.get(i);
            for (int j = 0; j < metadata[i].getNoOfPackages(); ++j) {
                PackageMetaData pmd = metadata[i].getPackage(j);
                JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.InitialisePackageMetaData", (Object)pmd.getName()));
                for (int k = 0; k < pmd.getNoOfClasses(); ++k) {
                    ClassMetaData cmd = pmd.getClass(k);
                    JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.InitialiseClassMetaData", (Object)cmd.getFullClassName()));
                    try {
                        if (cmd.isInitialised()) continue;
                        mgr.initialiseClassMetaData(cmd, (ClassLoaderResolver)clr);
                        continue;
                    }
                    catch (Exception ex) {
                        metadataIncorrect = true;
                        System.err.println(LOCALISER.msg("Enhancer.MetaDataError", (Object)metadata[i].getFilename(), (Object)cmd.getFullClassName(), (Object)ex.getMessage()));
                        JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.MetaDataError", (Object)metadata[i].getFilename(), (Object)cmd.getFullClassName(), (Object)ex));
                    }
                }
            }
        }
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.InitialiseJDOFilesEnd", (Object)("" + configList.size())));
        if (metadataIncorrect) {
            String msg = LOCALISER.msg("Enhancer.MetaDataIncorrectForEnhancing");
            System.err.println(msg);
            JPOXLogger.ENHANCER.error((Object)msg);
            throw new Exception(msg);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException {
        if (!this.update) {
            JPOXLogger.ENHANCER.warn((Object)LOCALISER.msg("Enhancer.ClassNotUpdated", (Object)this.className));
            return;
        }
        String path = Repository.lookupClassFile((String)this.className).getPath();
        JPOXLogger.ENHANCER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)path));
        File f = new File(path);
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(f);
            BufferedOutputStream bout = new BufferedOutputStream(fOut);
            this.dumpClass(bout);
            bout.flush();
        }
        finally {
            try {
                fOut.close();
                fOut = null;
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String dir) throws IOException {
        if (!this.update) {
            JPOXLogger.ENHANCER.warn((Object)LOCALISER.msg("Enhancer.ClassNotUpdated", (Object)this.className));
            return;
        }
        File baseDir = new File(dir);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        } else if (!baseDir.isDirectory()) {
            throw new RuntimeException("not directory " + dir);
        }
        String sep = System.getProperty("file.separator");
        String name = this.classConfig.getFullClassName();
        name = name.replace('.', sep.charAt(0));
        name = name + ".class";
        File f = new File(dir, name);
        f.getParentFile().mkdirs();
        FileOutputStream fOut = null;
        JPOXLogger.ENHANCER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)f.getCanonicalPath()));
        try {
            fOut = new FileOutputStream(f);
            BufferedOutputStream bout = new BufferedOutputStream(fOut);
            this.dumpClass(bout);
            bout.flush();
        }
        finally {
            try {
                fOut.close();
                fOut = null;
            }
            catch (Exception ignore) {}
        }
    }

    protected void dumpClass(OutputStream out) throws IOException {
        this.newClass.getJavaClass().dump(out);
        out.flush();
    }

    public byte[] getBytes() {
        return this.newClass.getJavaClass().getBytes();
    }

    public void verify() throws Exception {
        VerifierFactory.attach((VerifierFactoryObserver)new VerifierFactoryObserver(){

            public void update(String s) {
            }
        });
        Verifier verifier = VerifierFactory.getVerifier((String)this.className);
        VerificationResult result = verifier.doPass1();
        if (1 != result.getStatus()) {
            JPOXLogger.ENHANCER.fatal((Object)result.getMessage());
            return;
        }
        result = verifier.doPass2();
        if (1 != result.getStatus()) {
            JPOXLogger.ENHANCER.fatal((Object)result.getMessage());
            return;
        }
        Method[] methods = this.classConfig.getClassGen().getMethods();
        JPOXLogger.ENHANCER.info((Object)("methods num:" + methods.length));
        for (int i = 0; i < methods.length; ++i) {
            try {
                result = verifier.doPass3a(i);
                if (1 == result.getStatus()) continue;
                JPOXLogger.ENHANCER.fatal((Object)result.getMessage());
                continue;
            }
            catch (Exception e) {
                JPOXLogger.ENHANCER.error((Object)(i + " " + methods[i].getName()));
            }
        }
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

