/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.enhancer.ImplementationCreatorImpl;
import org.jpox.enhancer.StandardGenerator;
import org.jpox.enhancer.metadata.EnhancerClassMetaData;
import org.jpox.enhancer.metadata.EnhancerFieldMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.util.ClassUtils;

public class ImplementationGenerator
implements Constants {
    private final InstructionFactory factory;
    private final ConstantPoolGen constantPool;
    private final ClassGen classGen;
    private final InterfaceMetaData interfaceMetaData;
    private final String className;
    private final String fullClassName;
    private static final String fullSuperClassName = "java.lang.Object";
    private JavaClass javaClass;
    private byte[] bytes;

    public ImplementationGenerator(InterfaceMetaData interfaceMetaData) {
        this.className = interfaceMetaData.getName() + "Impl";
        this.fullClassName = interfaceMetaData.getPackageName() + '.' + this.className;
        this.interfaceMetaData = interfaceMetaData;
        this.classGen = new ClassGen(this.fullClassName, fullSuperClassName, this.className + ".java", 33, new String[]{interfaceMetaData.getFullInterfaceName()});
        this.constantPool = this.classGen.getConstantPool();
        this.factory = new InstructionFactory(this.classGen, this.constantPool);
    }

    public void create() {
        this.createFields();
        this.createDefaultConstructor();
        this.createMethods();
        this.javaClass = this.classGen.getJavaClass();
        this.bytes = this.javaClass.getBytes();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void enhance() {
        EnhancerClassMetaData ecmd = new EnhancerClassMetaData(this.interfaceMetaData.getPackageMetaData(), this.getClassName(), this.interfaceMetaData.getIdentityType().toString(), this.interfaceMetaData.getObjectidClass(), this.interfaceMetaData.isRequiresExtent() ? "true" : "false", this.interfaceMetaData.isDetachable() ? "true" : "false", this.interfaceMetaData.isEmbeddedOnly() ? "true" : "false", ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString(), null, this.interfaceMetaData.getCatalog(), this.interfaceMetaData.getSchema(), this.interfaceMetaData.getTable(), this.javaClass);
        for (int i = 0; i < this.interfaceMetaData.getPropertyMetaData().length; ++i) {
            EnhancerFieldMetaData efmd = new EnhancerFieldMetaData((MetaData)ecmd, this.interfaceMetaData.getPropertyMetaData()[i].getName());
            ecmd.addField(efmd);
        }
        ImplementationCreatorImpl.ImplementationCreatorClassLoader loader = new ImplementationCreatorImpl.ImplementationCreatorClassLoader();
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver((ClassLoader)loader);
        loader.defineClass(this.getFullClassName(), this.getBytes());
        ecmd.populate((ClassLoaderResolver)clr);
        ecmd.initialise();
        StandardGenerator gen = new StandardGenerator(ecmd);
        gen.enhance();
        this.bytes = gen.getBytes();
        try {
            gen.dumpClass(new FileOutputStream(new File("c:\\ParisImpl.class")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dump(OutputStream io) throws IOException {
        this.javaClass.dump(io);
    }

    private void createFields() {
        PropertyMetaData[] propertyMetaData = this.interfaceMetaData.getPropertyMetaData();
        for (int i = 0; i < propertyMetaData.length; ++i) {
            FieldGen field = new FieldGen(2, this.getObjectTypeByName(propertyMetaData[i].getTypeName()), propertyMetaData[i].getName(), this.constantPool);
            this.classGen.addField(field.getField());
        }
    }

    private void createMethods() {
        PropertyMetaData[] propertyMetaData = this.interfaceMetaData.getPropertyMetaData();
        for (int i = 0; i < propertyMetaData.length; ++i) {
            boolean isBoolean = propertyMetaData[i].getTypeName().equals("boolean");
            this.createGetter(propertyMetaData[i].getTypeName(), ClassUtils.getJavaBeanGetterName((String)propertyMetaData[i].getName(), (boolean)isBoolean), propertyMetaData[i].getName());
            this.createSetter(propertyMetaData[i].getTypeName(), ClassUtils.getJavaBeanSetterName((String)propertyMetaData[i].getName()), propertyMetaData[i].getName());
        }
    }

    private void createDefaultConstructor() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<init>", this.fullClassName, il, this.constantPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.factory.createInvoke(fullSuperClassName, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this.classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private void createGetter(String typeName, String getterName, String fieldName) {
        Type objectType = this.getObjectTypeByName(typeName);
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, objectType, Type.NO_ARGS, new String[0], getterName, this.fullClassName, il, this.constantPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.factory.createFieldAccess(this.fullClassName, fieldName, objectType, (short)180));
        il.append((Instruction)InstructionFactory.createReturn((Type)objectType));
        method.setMaxStack();
        method.setMaxLocals();
        this.classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private void createSetter(String typeName, String setterName, String fieldName) {
        Type objectType = this.getObjectTypeByName(typeName);
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, new Type[]{objectType}, new String[]{"arg0"}, setterName, this.fullClassName, il, this.constantPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)InstructionFactory.createLoad((Type)objectType, (int)1));
        il.append((Instruction)this.factory.createFieldAccess(this.fullClassName, fieldName, objectType, (short)181));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this.classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private Type getObjectTypeByName(String typeName) {
        if (typeName.equals("int")) {
            return Type.INT;
        }
        if (typeName.equals("boolean")) {
            return Type.BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return Type.BYTE;
        }
        if (typeName.equals("char")) {
            return Type.CHAR;
        }
        if (typeName.equals("double")) {
            return Type.DOUBLE;
        }
        if (typeName.equals("float")) {
            return Type.FLOAT;
        }
        if (typeName.equals("long")) {
            return Type.LONG;
        }
        if (typeName.equals("short")) {
            return Type.SHORT;
        }
        return new ObjectType(typeName);
    }
}

