/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.enhancer.CommandLine;
import org.jpox.enhancer.GeneratorBase;
import org.jpox.enhancer.StandardGenerator;
import org.jpox.enhancer.metadata.EnhancerClassMetaData;
import org.jpox.enhancer.metadata.EnhancerMetaDataHelper;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.types.UserTypes;
import org.jpox.util.JPOXLogger;

public class JPOXEnhancer
extends GeneratorBase {
    private static String jpoxVersion;
    private static String jpoxVendor;

    public JPOXEnhancer(EnhancerClassMetaData classConfig) {
        super(classConfig);
    }

    protected GeneratorBase getGenerator() {
        return this;
    }

    private static void jpoxSupportInit() {
        HashMap<String, String> supportOption = new HashMap<String, String>();
        supportOption.put("option.DatastoreIdentity", "true");
        supportOption.put("option.ApplicationIdentity", "true");
        supportOption.put("option.NonDurableIdentity", "true");
        supportOption.put("option.TransientTransactional", "true");
        supportOption.put("required.Serializable", "true");
        supportOption.put("FT_Locale", "true");
        supportOption.put("FT_BigDecimal", "true");
        supportOption.put("FT_BigInteger", "true");
        supportOption.put("FT_Date", "true");
        supportOption.put("FT_HashSet", "true");
        supportOption.put("FT_PersistenceCapable", "true");
        supportOption.put("FT_Collection", "true");
        supportOption.put("FT_Set", "true");
        supportOption.put("FT_Object", "true");
        supportOption.put("FT_ArrayList", "true");
        supportOption.put("FT_HashMap", "true");
        supportOption.put("FT_Hashtable", "true");
        supportOption.put("FT_LinkedList", "true");
        supportOption.put("FT_TreeMap", "true");
        supportOption.put("FT_TreeSet", "true");
        supportOption.put("FT_Vector", "true");
        supportOption.put("FT_Map", "true");
        supportOption.put("FT_List", "true");
        supportOption.put("FT_Arrays", "true");
        EnhancerMetaDataHelper.getInstance().setSupportOption("jpox", supportOption);
    }

    public static void main(String[] args) throws Exception {
        String[] jdofiles;
        JPOXEnhancer.jpoxSupportInit();
        CommandLine cmd = new CommandLine();
        cmd.addOption("d", "dest", "<directory>", "output directory");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.addOption("verify", "verify", null, "verify the enhancement");
        cmd.addOption("checkonly", "checkonly", null, "only check if the class is enhanced");
        cmd.addOption("check", "check", null, "after enhancement, check if the class was enhanced");
        cmd.addOption("types", "types", "types-file.xml", "filename of the user-defined types to use");
        cmd.parse(args);
        String dir = null;
        if (cmd.hasOption("d")) {
            dir = cmd.getOptionArg("d");
            File tmp = new File(dir);
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    System.out.println(dir + " is not directory. please set directory.");
                    System.exit(1);
                }
            } else {
                tmp.mkdirs();
            }
        }
        boolean verify = false;
        if (cmd.hasOption("verify")) {
            verify = true;
        }
        boolean verbose = false;
        if (cmd.hasOption("v")) {
            verbose = true;
        }
        boolean checkonly = false;
        if (cmd.hasOption("checkonly")) {
            checkonly = true;
        }
        String typefile = null;
        if (cmd.hasOption("types")) {
            typefile = cmd.getOptionArg("types");
            File tmp = new File(typefile);
            if (tmp.exists()) {
                if (tmp.isDirectory()) {
                    System.out.println(typefile + " is a directory! Should be an XML file.");
                    System.exit(1);
                }
            } else {
                System.out.println(typefile + " doesn't exist! Should be an XML file.");
                System.exit(1);
            }
        }
        String msg = null;
        msg = !verify && !checkonly ? LOCALISER.msg("Enhancer.Title.Enhance", (Object)JPOXEnhancer.getVersionNumber()) : (checkonly ? LOCALISER.msg("Enhancer.Title.CheckOnly", (Object)JPOXEnhancer.getVersionNumber()) : LOCALISER.msg("Enhancer.Title.Verify", (Object)JPOXEnhancer.getVersionNumber()));
        JPOXLogger.ENHANCER.info((Object)msg);
        System.out.println(msg);
        System.out.println();
        if (verbose) {
            msg = LOCALISER.msg("Enhancer.Classpath");
            JPOXLogger.ENHANCER.info((Object)msg);
            System.out.println(msg);
            StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
            while (tokeniser.hasMoreTokens()) {
                String entry = LOCALISER.msg("Enhancer.Classpath.Entry", (Object)tokeniser.nextToken());
                JPOXLogger.ENHANCER.info((Object)entry);
                System.out.println(entry);
            }
            System.out.println();
        }
        if (verbose) {
            msg = LOCALISER.msg("Enhancer.InputJDOFiles");
            JPOXLogger.ENHANCER.info((Object)msg);
            System.out.println(msg);
        }
        if ((jdofiles = cmd.getDefaultArgs()) != null) {
            if (verbose) {
                for (int i = 0; i < jdofiles.length; ++i) {
                    String entry = LOCALISER.msg("Enhancer.InputJDOFiles.Entry", (Object)jdofiles[i]);
                    JPOXLogger.ENHANCER.info((Object)entry);
                    System.out.println(entry);
                }
            }
        } else {
            System.err.println(LOCALISER.msg("Enhancer.NoInputJDOFilesError"));
        }
        if (verbose) {
            System.out.println();
        }
        if (typefile != null) {
            if (verbose) {
                msg = LOCALISER.msg("Enhancer.UserTypes", (Object)typefile);
                JPOXLogger.ENHANCER.info((Object)msg);
                System.out.println(msg);
                System.out.println();
            }
            try {
                URL typesURL = new URL("file:" + typefile);
                UserTypes.loadUserTypesFromFile((URL)typesURL, (ClassLoaderResolver)new JDOClassLoaderResolver());
            }
            catch (MalformedURLException mue) {
                JPOXLogger.ENHANCER.warn((Object)LOCALISER.msg("Enhancer.UserTypesError", (Object)typefile, (Object)mue));
            }
        }
        FileMetaData[] jdoConfigs = null;
        try {
            jdoConfigs = JPOXEnhancer.readJDOConfig(cmd.getDefaultArgs());
            if (jdoConfigs == null) {
                JPOXLogger.ENHANCER.error((Object)"readJDOConfig returned null!");
                return;
            }
        }
        catch (Exception e) {
            JPOXLogger.ENHANCER.error((Object)"readJDOConfig failed!", (Throwable)e);
            System.err.println("An error has occurred during enhancement. Please consult the JPOX Enhancer log for details. The following may help : " + e.getMessage());
            return;
        }
        for (int jdoLength = 0; jdoLength < jdoConfigs.length; ++jdoLength) {
            FileMetaData jdoConfig = jdoConfigs[jdoLength];
            for (int packageLength = 0; packageLength < jdoConfig.getNoOfPackages(); ++packageLength) {
                PackageMetaData packageConfig = jdoConfig.getPackage(packageLength);
                for (int classLength = 0; classLength < packageConfig.getNoOfClasses(); ++classLength) {
                    EnhancerClassMetaData classConfig = (EnhancerClassMetaData)packageConfig.getClass(classLength);
                    try {
                        if (verbose) {
                            System.out.println(LOCALISER.msg("Enhancer.ProcessingClass", (Object)classConfig.getFullClassName()));
                        }
                        StandardGenerator enhancer = new StandardGenerator(classConfig);
                        if (checkonly) {
                            if (classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                                if (enhancer.checkEnhanced()) {
                                    System.out.println("ENHANCED (PersistenceCapable) : " + classConfig.getFullClassName());
                                    continue;
                                }
                                System.out.println("NOT ENHANCED (PersistenceCapable) : " + classConfig.getFullClassName());
                                continue;
                            }
                            if (classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                                System.out.println("UNKNOWN (PersistenceAware) : " + classConfig.getFullClassName());
                                continue;
                            }
                            if (classConfig.getPersistenceModifier() != ClassPersistenceModifier.NON_PERSISTENT) continue;
                            System.out.println("NOT ENHANCED (NonPersistent) : " + classConfig.getFullClassName());
                            continue;
                        }
                        if (verify) {
                            enhancer.verify();
                            continue;
                        }
                        enhancer.enhance();
                        if (dir == null) {
                            enhancer.update();
                        } else {
                            enhancer.store(dir);
                        }
                        if (classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                            if (enhancer.checkEnhanced()) {
                                System.out.println("ENHANCED (PersistenceCapable) : " + classConfig.getFullClassName());
                                continue;
                            }
                            System.out.println("NOT ENHANCED (PersistenceCapable) : " + classConfig.getFullClassName());
                            continue;
                        }
                        if (classConfig.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                            System.out.println("UNKNOWN (PersistenceAware) : " + classConfig.getFullClassName());
                            continue;
                        }
                        if (classConfig.getPersistenceModifier() != ClassPersistenceModifier.NON_PERSISTENT) continue;
                        System.out.println("NOT ENHANCED (NonPersistent) : " + classConfig.getFullClassName());
                        continue;
                    }
                    catch (Exception ex) {
                        String ex_msg = LOCALISER.msg("Enhancer.ErrorEnhancingClass", (Object)classConfig.getFullClassName(), (Object)ex.getMessage());
                        JPOXLogger.ENHANCER.error((Object)ex_msg);
                        System.out.println(ex_msg);
                        JPOXLogger.ENHANCER.error((Object)ex);
                    }
                }
            }
        }
    }

    public void enhanceClassAfter() {
    }

    public void enhanceClassBefore() {
    }

    public void enhanceFieldsAfter() {
    }

    public void enhanceFieldsBefore() {
    }

    public void enhanceMethodAfter() {
    }

    public void enhanceMethodBefore() {
    }

    public void enhanceStaticInitializerAfter() {
    }

    protected void staticInitializerAppend(InstructionFactory factory, InstructionList il) {
    }

    public void enhanceStaticInitializerBefore() {
    }

    public static String getVersionNumber() {
        if (jpoxVersion != null) {
            return jpoxVersion;
        }
        String version = "Unknown";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.enhancer.Version");
            try {
                version = bundle.getString("jpox.enhancer.version");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVersion = version;
        return jpoxVersion;
    }

    public static String getVendorName() {
        if (jpoxVendor != null) {
            return jpoxVendor;
        }
        String vendor = "JPOX";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.enhancer.Version");
            try {
                vendor = bundle.getString("jpox.enhancer.vendor");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVendor = vendor;
        return jpoxVendor;
    }
}

