/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import java.io.File;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.jpox.enhancer.CommandLine;
import org.jpox.enhancer.GeneratorBase;
import org.jpox.enhancer.metadata.EnhancerClassMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.PackageMetaData;

public class StandardGenerator
extends GeneratorBase {
    public StandardGenerator(EnhancerClassMetaData classConfig) {
        super(classConfig);
    }

    protected GeneratorBase getGenerator() {
        return this;
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmd = new CommandLine();
        cmd.addOption("d", "dest", "<directory>", "output directory");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.parse(args);
        String dir = null;
        if (cmd.hasOption("d")) {
            dir = cmd.getOptionArg("d");
            File tmp = new File(dir);
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    System.out.println("The location \"" + dir + "\" is not a directory. Please set the directory correctly.");
                    System.exit(1);
                }
            } else {
                tmp.mkdirs();
            }
            System.out.println(dir);
        }
        boolean verbose = false;
        if (cmd.hasOption("v")) {
            verbose = true;
        }
        if (verbose) {
            String[] jdofiles = cmd.getDefaultArgs();
            if (jdofiles != null) {
                for (int i = 0; i < jdofiles.length; ++i) {
                    System.out.println(LOCALISER.msg("enhancer.info.using_jdo_file", (Object)jdofiles[i]));
                }
            } else {
                System.err.println(LOCALISER.msg("enhancer.error.no_jdo_files"));
            }
        }
        FileMetaData[] jdoConfigs = null;
        try {
            jdoConfigs = StandardGenerator.readJDOConfig(cmd.getDefaultArgs());
            if (jdoConfigs == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        for (int jdoLength = 0; jdoLength < jdoConfigs.length; ++jdoLength) {
            FileMetaData jdoConfig = jdoConfigs[jdoLength];
            for (int packageLength = 0; packageLength < jdoConfig.getNoOfPackages(); ++packageLength) {
                PackageMetaData pmd = jdoConfig.getPackage(packageLength);
                for (int classLength = 0; classLength < pmd.getNoOfClasses(); ++classLength) {
                    try {
                        EnhancerClassMetaData classConfig = (EnhancerClassMetaData)pmd.getClass(classLength);
                        if (verbose) {
                            System.out.println(LOCALISER.msg("enhancer.info.using_class", (Object)classConfig.getFullClassName()));
                        }
                        StandardGenerator enhancer = new StandardGenerator(classConfig);
                        enhancer.enhance();
                        if (dir == null) {
                            enhancer.update();
                            continue;
                        }
                        enhancer.store(dir);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void enhanceClassAfter() {
    }

    public void enhanceClassBefore() {
    }

    public void enhanceFieldsAfter() {
    }

    public void enhanceFieldsBefore() {
    }

    public void enhanceMethodAfter() {
    }

    public void enhanceMethodBefore() {
    }

    public void enhanceStaticInitializerAfter() {
    }

    protected void staticInitializerAppend(InstructionFactory factory, InstructionList il) {
    }

    public void enhanceStaticInitializerBefore() {
    }
}

