/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.metadata;

import javax.jdo.JDOFatalException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.jpox.enhancer.metadata.EnhancerFieldMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class EnhancerClassMetaData
extends ClassMetaData {
    protected static final Localiser LOCALISER_ENH = Localiser.getInstance((String)"org.jpox.enhancer.Localisation");
    protected final ClassGen classGen;
    protected final JavaClass enhanceClass;

    public EnhancerClassMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table) {
        super(parent, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table);
        try {
            this.enhanceClass = Repository.lookupClass((String)this.fullName);
        }
        catch (Throwable ex) {
            String msg = LOCALISER.msg("Enhancer.ClassNotFound", (Object)this.fullName);
            JPOXLogger.ENHANCER.error((Object)msg);
            throw new JDOFatalException(msg, ex);
        }
        if (this.enhanceClass == null) {
            String msg = LOCALISER.msg("Enhancer.ClassNotFound", (Object)this.fullName);
            JPOXLogger.ENHANCER.error((Object)msg);
            throw new JDOFatalException(msg);
        }
        this.classGen = new ClassGen(this.enhanceClass);
    }

    public EnhancerClassMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, JavaClass enhanceClass) {
        super(parent, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table);
        this.enhanceClass = enhanceClass;
        Repository.addClass((JavaClass)enhanceClass);
        this.classGen = new ClassGen(this.enhanceClass);
    }

    protected FieldMetaData newDefaultedField(String name) {
        return new EnhancerFieldMetaData((MetaData)this, name);
    }

    public EnhancerFieldMetaData[] getManagedFieldConfigs() {
        if (this.managedFields == null) {
            return null;
        }
        int numberOfValidConfigs = 0;
        for (int i = 0; i < this.managedFields.length; ++i) {
            if (!this.managedFields[i].fieldBelongsToClass()) continue;
            ++numberOfValidConfigs;
        }
        EnhancerFieldMetaData[] managed_field_configs = new EnhancerFieldMetaData[numberOfValidConfigs];
        int managedFieldNum = 0;
        for (int i = 0; i < this.managedFields.length; ++i) {
            if (!this.managedFields[i].fieldBelongsToClass()) continue;
            managed_field_configs[managedFieldNum++] = (EnhancerFieldMetaData)this.managedFields[i];
        }
        return managed_field_configs;
    }

    public int getNoOfManagedFields() {
        if (this.managedFields == null) {
            return 0;
        }
        int numberOfValidConfigs = 0;
        for (int i = 0; i < this.managedFields.length; ++i) {
            if (!this.managedFields[i].fieldBelongsToClass()) continue;
            ++numberOfValidConfigs;
        }
        return numberOfValidConfigs;
    }

    public ClassGen getClassGen() {
        return this.classGen;
    }

    public JavaClass getEnhanceClass() {
        return this.enhanceClass;
    }

    public EnhancerFieldMetaData findField(Field f) {
        if (f == null) {
            throw new NullPointerException("field is null");
        }
        String name = f.getName();
        for (int i = 0; i < this.fields.size(); ++i) {
            EnhancerFieldMetaData fieldConfig = (EnhancerFieldMetaData)this.getField(i);
            if (!fieldConfig.fieldBelongsToClass() || !fieldConfig.getEnhanceField().getName().equals(name)) continue;
            return fieldConfig;
        }
        if (this.pcSuperclassMetaData != null) {
            return ((EnhancerClassMetaData)this.pcSuperclassMetaData).findField(f);
        }
        return null;
    }
}

