/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.metadata;

import java.lang.reflect.Modifier;
import javax.jdo.JDOFatalException;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jpox.ClassLoaderResolver;
import org.jpox.enhancer.EnhanceUtil;
import org.jpox.enhancer.Generator;
import org.jpox.enhancer.metadata.EnhancerClassMetaData;
import org.jpox.enhancer.metadata.EnhancerMetaDataHelper;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class EnhancerFieldMetaData
extends FieldMetaData {
    protected static final Localiser LOCALISER_ENH = Localiser.getInstance((String)"org.jpox.enhancer.Localisation");
    protected final Field enhanceField;
    protected byte jdoFieldFlag;
    static /* synthetic */ Class class$java$io$Serializable;

    public EnhancerFieldMetaData(MetaData parent, String name) {
        this(parent, name, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public EnhancerFieldMetaData(MetaData parent, String name, String pk, String modifier, String defaultFetchGroup, String nullValue, String embedded, String serialized, String dependent, String mappedBy, String column, String table, String defaultAction, String indexed, String unique, String fetchDepth, String loadFetchGroup, String valueStrategy, String foreignKey, String sequence, String fieldType) {
        super(parent, name, pk, modifier, defaultFetchGroup, nullValue, embedded, serialized, dependent, mappedBy, column, table, defaultAction, indexed, unique, fetchDepth, loadFetchGroup, valueStrategy, foreignKey, sequence, fieldType);
        if (parent instanceof EnhancerClassMetaData && this.fieldBelongsToClass()) {
            this.enhanceField = EnhanceUtil.getFieldByName(name, ((EnhancerClassMetaData)parent).getClassGen());
            if (this.enhanceField == null) {
                throw new InvalidMetaDataException(LOCALISER_ENH, "conf.error.field_not_found", (Object)((parent instanceof ClassMetaData ? ((ClassMetaData)parent).getFullClassName() + "." : "") + name));
            }
        } else {
            this.enhanceField = null;
        }
    }

    public boolean isFieldTypePersistenceCapable() {
        if (this.enhanceField == null) {
            return false;
        }
        ObjectType objectType = this.enhanceField.getType() instanceof ObjectType ? (ObjectType)this.enhanceField.getType() : null;
        return this.isTypePersistenceCapable(objectType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFieldArrayTypePersistenceCapable() {
        if (this.enhanceField == null) {
            return false;
        }
        ObjectType objectType = null;
        if (this.enhanceField.getType() instanceof ArrayType) {
            Type elementType = ((ArrayType)this.enhanceField.getType()).getElementType();
            if (!(elementType instanceof ObjectType)) return false;
            objectType = (ObjectType)elementType;
            return this.isTypePersistenceCapable(objectType);
        } else {
            if (!(this.enhanceField.getType() instanceof ObjectType)) return this.isTypePersistenceCapable(objectType);
            objectType = (ObjectType)this.enhanceField.getType();
        }
        return this.isTypePersistenceCapable(objectType);
    }

    private boolean isTypePersistenceCapable(ObjectType type) {
        boolean capable = false;
        if (type == null) {
            return false;
        }
        if (type != null) {
            String fieldClassName = type.getClassName();
            String[] classFullNames = EnhancerMetaDataHelper.getInstance().getRegisteredPersistenceCapables();
            for (int i = 0; i < classFullNames.length; ++i) {
                String pcName = classFullNames[i];
                if (!pcName.equals(fieldClassName)) continue;
                capable = true;
            }
            try {
                try {
                    if (type.isCastableTo((Type)Generator.OT_PersistenceCapable)) {
                        capable = true;
                    }
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
                if (!capable) {
                    if (type.subclassOf(Generator.OT_PersistenceCapable)) {
                        capable = true;
                    } else if (Generator.OT_PersistenceCapable.subclassOf(type)) {
                        capable = true;
                    } else {
                        String[] pcClassNames = EnhancerMetaDataHelper.getInstance().getRegisteredPersistenceCapables();
                        if (pcClassNames != null) {
                            for (int i = 0; i < pcClassNames.length; ++i) {
                                if (!pcClassNames[i].equals(fieldClassName)) continue;
                                capable = true;
                            }
                        }
                    }
                }
            }
            catch (Throwable ex) {
                JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
                throw new JDOFatalException(LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
            }
        }
        return capable;
    }

    public synchronized void populate(ClassLoaderResolver loader, Class fieldType, int modifiers) {
        super.populate(loader, fieldType, modifiers);
        if (this.enhanceField == null) {
            this.jdoFieldFlag = 0;
            return;
        }
        int serializable = 0;
        if (EnhancerMetaDataHelper.getInstance().isSupported("required.Serializable") && ((class$java$io$Serializable == null ? (class$java$io$Serializable = EnhancerFieldMetaData.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.getType()) || this.getType().isPrimitive())) {
            serializable = 16;
        }
        this.jdoFieldFlag = EnhanceUtil.isSynthetic((FieldOrMethod)this.enhanceField) ? (byte)0 : (FieldPersistenceModifier.NONE.equals((Object)this.persistenceModifier) ? (byte)0 : (FieldPersistenceModifier.TRANSACTIONAL.equals((Object)this.persistenceModifier) && Modifier.isTransient(modifiers) ? (byte)(4 | serializable) : (this.primaryKey != false ? (byte)(8 | serializable) : (this.defaultFetchGroup != false ? (byte)(5 | serializable) : (this.defaultFetchGroup == false ? (byte)(0xA | serializable) : (byte)0)))));
    }

    public Field getEnhanceField() {
        return this.enhanceField;
    }

    public byte getJdoFieldFlag() {
        return this.jdoFieldFlag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

