/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.metadata;

import java.net.URL;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFConfiguration;
import org.jpox.enhancer.metadata.EnhancerMetaDataParser;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.JPOXLogger;

public class EnhancerMetaDataManager
extends MetaDataManager {
    public EnhancerMetaDataManager() {
        EnhancerPMFConfiguration pmfConfiguration = new EnhancerPMFConfiguration();
        String jdo_file_suffix = pmfConfiguration.getJdoMetaDataFileExtension();
        String orm_file_suffix = pmfConfiguration.getOrmMetaDataFileExtension();
        String jdoquery_file_suffix = pmfConfiguration.getJdoqueryMetaDataFileExtension();
        String orm_mapping_name = pmfConfiguration.getMapping();
        if (jdo_file_suffix != null || orm_file_suffix != null || orm_mapping_name != null || jdoquery_file_suffix != null) {
            this.initialiseMetaDataFileSuffixes(jdo_file_suffix, orm_file_suffix, orm_mapping_name, jdoquery_file_suffix);
        }
        this.enhancing = true;
    }

    protected FileMetaData parseFile(URL file_url, boolean validate) {
        return EnhancerMetaDataParser.parseMetaData(file_url, validate, this);
    }

    public FileMetaData parseAndRegisterFile(String filename) {
        FileMetaData filemd = EnhancerMetaDataParser.parseMetaDataFile(filename, true, this);
        URL fileURL = ((Object)((Object)this)).getClass().getResource(filename);
        if (filemd != null) {
            this.registerFile(fileURL, filemd);
        }
        return filemd;
    }

    public void populateRegisteredFile(FileMetaData filemd, ClassLoaderResolver clr) {
        this.populateClassesInFile(filemd, clr);
    }

    public void initialiseClassMetaData(ClassMetaData cmd, ClassLoaderResolver clr) {
        try {
            Class c = clr.classForName(cmd.getFullClassName(), false);
            this.initialiseMetaDataForClass(cmd, c, clr);
        }
        catch (ClassNotResolvedException cnre) {
            JPOXLogger.ENHANCER.error((Object)("Error finding class " + cmd.getFullClassName()));
        }
    }

    protected void initialiseMetaDataForClass(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        if (!cmd.isPopulated() && !cmd.isInitialised()) {
            cmd.populate(clr);
        }
        if (!cmd.isInitialised()) {
            cmd.initialise();
        }
    }

    private class EnhancerPMFConfiguration
    extends PMFConfiguration {
        private EnhancerPMFConfiguration() {
        }
    }
}

