/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.jdo.JDOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jpox.enhancer.metadata.EnhancerClassMetaData;
import org.jpox.enhancer.metadata.EnhancerFieldMetaData;
import org.jpox.enhancer.metadata.EnhancerMetaDataHelper;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.InvalidMetaDataException;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataParser;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EnhancerMetaDataParser
extends MetaDataParser {
    protected static Localiser LOCALISER_ENH = Localiser.getInstance((String)"org.jpox.enhancer.Localisation");

    protected EnhancerMetaDataParser(MetaDataManager mdm, String filename) {
        super(mdm, filename);
    }

    public static FileMetaData parseMetaData(URL url, boolean validate, MetaDataManager mdm) {
        if (url == null) {
            String msg = LOCALISER.msg("MetaData.Parser.NullFile");
            JPOXLogger.METADATA.error((Object)msg);
            throw new JDOException(msg);
        }
        JPOXLogger.METADATA.info((Object)LOCALISER.msg("MetaData.Parser.ParseFile", (Object)url.getFile()));
        try {
            InputStream in = null;
            try {
                in = url.openStream();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (in == null) {
                try {
                    in = new FileInputStream(new File(url.getFile()));
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (in == null) {
                JPOXLogger.METADATA.error((Object)LOCALISER.msg("MetaData.Parser.CannotReadFile.Error", (Object)url.getFile()));
                throw new JDOException(LOCALISER.msg("MetaData.Parser.CannotReadFile.Error", (Object)url.getFile()));
            }
            FileMetaData filemd = EnhancerMetaDataParser.parseMetaDataStream(in, validate, mdm, url.getFile());
            return filemd;
        }
        catch (JDOException e) {
            throw e;
        }
        catch (Exception e) {
            String message = LOCALISER.msg("MetaData.Parser.CannotReadFile.Error", (Object)url.getFile());
            JPOXLogger.METADATA.error((Object)message, (Throwable)e);
            Exception cause = e;
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                cause = se.getException();
            }
            if (JavaUtils.isJRE1_4OrAbove()) {
                Throwable throwable = cause = e.getCause() == null ? cause : e.getCause();
            }
            if (e instanceof SAXException) {
                JPOXLogger.METADATA.error((Object)LOCALISER.msg("MetaData.Parser.ErrorCause", (Object)url.getFile(), (Object)cause));
            }
            if (cause instanceof InvalidMetaDataException) {
                throw (InvalidMetaDataException)cause;
            }
            throw new JDOException(message, (Throwable)cause);
        }
    }

    public static FileMetaData parseMetaDataFile(String fileName, boolean validate, MetaDataManager mdm) {
        JPOXLogger.ENHANCER.debug((Object)LOCALISER_ENH.msg("Enhancer.ReadJDOFile", (Object)fileName));
        try {
            InputStream in = null;
            try {
                in = new URL(fileName).openStream();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (in == null) {
                try {
                    in = new FileInputStream(new File(fileName));
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (in == null) {
                JPOXLogger.ENHANCER.error((Object)LOCALISER_ENH.msg("Enhancer.CannotOpenFileError", (Object)fileName));
                return null;
            }
            FileMetaData filemd = EnhancerMetaDataParser.parseMetaDataStream(in, true, mdm, fileName);
            if (filemd != null) {
                filemd.setFilename(fileName);
            }
            return filemd;
        }
        catch (JDOException e) {
            throw e;
        }
        catch (Exception e) {
            Exception cause = e;
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                cause = se.getException();
            }
            if (JavaUtils.isJRE1_4OrAbove()) {
                cause = e.getCause() == null ? cause : e.getCause();
            }
            String msg = cause != null ? LOCALISER_ENH.msg("Enhancer.CannotReadFileError", (Object)fileName, (Object)cause.getMessage()) : LOCALISER_ENH.msg("Enhancer.CannotReadFileErrorUnknownCause", (Object)fileName, (Object)e.getMessage());
            if (cause instanceof InvalidMetaDataException) {
                throw (InvalidMetaDataException)cause;
            }
            throw new JDOException(msg, (Throwable)cause);
        }
    }

    public static FileMetaData parseMetaDataStream(InputStream in, boolean validate, MetaDataManager mdm, String filename) {
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            EnhancerMetaDataParser handler = new EnhancerMetaDataParser(mdm, filename);
            parser.parse(in, (DefaultHandler)((Object)handler));
            FileMetaData fileMetaData = handler.getMetaData();
            return fileMetaData;
        }
        catch (JDOException e) {
            throw e;
        }
        catch (Exception e) {
            Exception cause = e;
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                cause = se.getException();
            }
            if (JavaUtils.isJRE1_4OrAbove()) {
                Throwable throwable = cause = e.getCause() == null ? cause : e.getCause();
            }
            if (cause != null) {
                JPOXLogger.ENHANCER.error((Object)"CAUSE of Exception:", (Throwable)cause);
            } else {
                JPOXLogger.ENHANCER.error((Object)"Exception has no cause!");
            }
            String message = LOCALISER_ENH.msg("Enhancer.CannotReadInput", (Object)e.getMessage());
            if (cause instanceof InvalidMetaDataException) {
                throw (InvalidMetaDataException)cause;
            }
            throw new JDOException(message, (Throwable)cause);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignore) {}
        }
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs) {
        EnhancerClassMetaData cmd = new EnhancerClassMetaData(pmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "identity-type"), this.getAttr(attrs, "objectid-class"), this.getAttr(attrs, "requires-extent"), this.getAttr(attrs, "detachable"), this.getAttr(attrs, "embedded-only"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "persistence-capable-superclass"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "table"));
        if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            EnhancerMetaDataHelper.getInstance().registerNewPersistenceCapable(cmd.getFullClassName());
        }
        return cmd;
    }

    protected FieldMetaData newFieldObject(MetaData md, Attributes attrs) {
        EnhancerFieldMetaData fmd = new EnhancerFieldMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "primary-key"), this.getAttr(attrs, "persistence-modifier"), this.getAttr(attrs, "default-fetch-group"), this.getAttr(attrs, "null-value"), this.getAttr(attrs, "embedded"), this.getAttr(attrs, "serialized"), this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mappedBy"), this.getAttr(attrs, "column"), this.getAttr(attrs, "table"), this.getAttr(attrs, "defaultAction"), this.getAttr(attrs, "indexed"), this.getAttr(attrs, "unique"), this.getAttr(attrs, "fetch-depth"), this.getAttr(attrs, "load-fetch-group"), this.getAttr(attrs, "value-strategy"), this.getAttr(attrs, "foreign-key"), this.getAttr(attrs, "strategy"), this.getAttr(attrs, "implementation-type"));
        return fmd;
    }
}

