/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.method;

import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.jpox.enhancer.Generator;
import org.jpox.enhancer.GeneratorBase;
import org.jpox.enhancer.metadata.EnhancerFieldMetaData;
import org.jpox.enhancer.metadata.EnhancerMetaDataManager;
import org.jpox.enhancer.method.MethodBuilder;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.AIDUtils;

public class JdoCopyKeyFieldsToObjectId
extends MethodBuilder {
    public JdoCopyKeyFieldsToObjectId(String methodName, int type, Type resultType, Type[] argType, String[] argName, boolean synthetic, GeneratorBase gen) {
        super(methodName, type, resultType, argType, argName, synthetic, gen);
    }

    public static JdoCopyKeyFieldsToObjectId getInstance(GeneratorBase gen) {
        return new JdoCopyKeyFieldsToObjectId("jdoCopyKeyFieldsToObjectId", 17, (Type)Type.VOID, new Type[]{Type.OBJECT}, new String[]{"oid"}, false, gen);
    }

    public void execute() {
        InstructionHandle[] lv_o = new InstructionHandle[2];
        String objectIdClass = this.classConfig.getObjectidClass();
        EnhancerFieldMetaData[] fields = this.classConfig.getManagedFieldConfigs();
        int objectIdInstance = 2;
        if (AIDUtils.isSingleFieldIdentityClass((String)objectIdClass)) {
            this.createThrowException(Generator.CN_JDOFatalInternalException, "It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
            this.il.append((Instruction)InstructionConstants.RETURN);
        } else if (objectIdClass != null && objectIdClass.length() > 0) {
            ObjectType objectIdClassType = new ObjectType(objectIdClass);
            this.il.append((Instruction)InstructionConstants.ALOAD_1);
            IFNE oidClassIsNotNull = new IFNE(null);
            this.il.append((Instruction)this.factory.createInstanceOf((ReferenceType)objectIdClassType));
            this.il.append((BranchInstruction)oidClassIsNotNull);
            this.createThrowException(Generator.CN_ClassCastException, "key class is not " + objectIdClass + " or null");
            oidClassIsNotNull.setTarget(this.il.append((Instruction)InstructionConstants.ALOAD_1));
            this.il.append(this.factory.createCast((Type)Type.OBJECT, (Type)objectIdClassType));
            lv_o[0] = this.il.append((Instruction)new ASTORE(objectIdInstance));
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    ClassMetaData cmd;
                    EnhancerFieldMetaData f = fields[i];
                    if (!f.isPrimaryKey()) continue;
                    this.il.append((Instruction)InstructionFactory.createLoad((Type)objectIdClassType, (int)objectIdInstance));
                    this.il.append((Instruction)InstructionConstants.ALOAD_0);
                    this.il.append((Instruction)this.factory.createGetField(this.gen.className, f.getName(), f.getEnhanceField().getType()));
                    MetaDataManager mgr = this.classConfig.getMetaDataManager();
                    if (mgr == null) {
                        mgr = new EnhancerMetaDataManager();
                    }
                    if ((cmd = mgr.getMetaDataForClass(f.getType(), this.gen.getClassLoaderResolver())) != null) {
                        this.il.append((Instruction)this.factory.createInvoke(Generator.CN_JDOHelper, "getObjectId", (Type)Type.OBJECT, new Type[]{Type.OBJECT}, (short)184));
                        ObjectType OT_objectidclass = new ObjectType(cmd.getObjectidClass());
                        this.il.append(this.factory.createCast((Type)Type.OBJECT, (Type)OT_objectidclass));
                        this.il.append((Instruction)this.factory.createPutField(objectIdClass, f.getName(), (Type)OT_objectidclass));
                        continue;
                    }
                    this.il.append((Instruction)this.factory.createPutField(objectIdClass, f.getName(), f.getEnhanceField().getType()));
                }
            }
            lv_o[1] = this.il.append((Instruction)InstructionConstants.RETURN);
            this.methodGen.addLocalVariable("o", (Type)objectIdClassType, lv_o[0], lv_o[1]);
        } else {
            this.il.append((Instruction)InstructionConstants.RETURN);
        }
    }
}

