/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.method;

import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.jpox.enhancer.EnhanceUtil;
import org.jpox.enhancer.Generator;
import org.jpox.enhancer.GeneratorBase;
import org.jpox.enhancer.metadata.EnhancerFieldMetaData;
import org.jpox.enhancer.metadata.EnhancerMetaDataManager;
import org.jpox.enhancer.method.MethodBuilder;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.AIDUtils;

public class JdoCopyKeyFieldsToObjectId2
extends MethodBuilder {
    public JdoCopyKeyFieldsToObjectId2(String methodName, int type, Type resultType, Type[] argType, String[] argName, boolean synthetic, GeneratorBase gen) {
        super(methodName, type, resultType, argType, argName, synthetic, gen);
    }

    public static JdoCopyKeyFieldsToObjectId2 getInstance(GeneratorBase gen) {
        return new JdoCopyKeyFieldsToObjectId2("jdoCopyKeyFieldsToObjectId", 17, (Type)Type.VOID, new Type[]{Generator.OT_ObjectIdFieldSupplier, Type.OBJECT}, new String[]{"fs", "oid"}, false, gen);
    }

    public void execute() {
        InstructionHandle[] lv_o = new InstructionHandle[2];
        String oidClassName = this.classConfig.getObjectidClass();
        EnhancerFieldMetaData[] fields = this.classConfig.getManagedFieldConfigs();
        if (AIDUtils.isSingleFieldIdentityClass((String)oidClassName)) {
            this.createThrowException(Generator.CN_JDOFatalInternalException, "It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
            this.il.append((Instruction)InstructionConstants.RETURN);
        } else if (oidClassName != null && oidClassName.length() > 0) {
            EnhancerFieldMetaData[] targetFields = this.classConfig.getManagedFieldConfigs();
            ObjectType oidType = new ObjectType(oidClassName);
            this.il.append((Instruction)InstructionConstants.ALOAD_1);
            IFNONNULL checkFmNotNull = new IFNONNULL(null);
            this.il.append((BranchInstruction)checkFmNotNull);
            this.createThrowException(Generator.CN_IllegalArgumentException, "ObjectIdFieldSupplier is null");
            checkFmNotNull.setTarget(this.il.append((Instruction)InstructionConstants.ALOAD_2));
            this.il.append((Instruction)this.factory.createInstanceOf((ReferenceType)oidType));
            this.il.append(InstructionConstants.ICONST_1);
            IF_ICMPEQ isInstanceof = new IF_ICMPEQ(null);
            this.il.append((BranchInstruction)isInstanceof);
            this.createThrowException(Generator.CN_ClassCastException, "oid is not instanceof " + oidClassName);
            isInstanceof.setTarget(this.il.append((Instruction)InstructionConstants.ALOAD_2));
            this.il.append(this.factory.createCast((Type)Type.OBJECT, (Type)oidType));
            lv_o[0] = this.il.append((Instruction)new ASTORE(3));
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    ClassMetaData cmd;
                    MetaDataManager mgr;
                    EnhancerFieldMetaData f = fields[i];
                    if (!f.isPrimaryKey()) continue;
                    this.il.append((Instruction)InstructionFactory.createLoad((Type)oidType, (int)3));
                    Field field = targetFields[i].getEnhanceField();
                    this.il.append((Instruction)InstructionConstants.ALOAD_1);
                    this.il.append(EnhanceUtil.getBIPUSH(i));
                    String paramName = EnhanceUtil.getJDOMethodName(field.getType());
                    this.il.append((Instruction)this.factory.createInvoke(Generator.CN_ObjectIdFieldSupplier, "fetch" + paramName + "Field", EnhanceUtil.getJDOMethodType(field.getType()), new Type[]{Type.INT}, (short)185));
                    if (EnhanceUtil.getJDOMethodType(field.getType()) == Type.OBJECT) {
                        String type = null;
                        type = field.getType() instanceof ArrayType ? field.getType().getSignature() : field.getType().toString();
                        this.il.append((Instruction)new CHECKCAST(this.constantPoolGen.addClass(type)));
                    }
                    if ((mgr = this.classConfig.getMetaDataManager()) == null) {
                        mgr = new EnhancerMetaDataManager();
                    }
                    if ((cmd = mgr.getMetaDataForClass(f.getType(), this.gen.getClassLoaderResolver())) != null) {
                        this.il.append((Instruction)this.factory.createInvoke(Generator.CN_JDOHelper, "getObjectId", (Type)Type.OBJECT, new Type[]{Type.OBJECT}, (short)184));
                        ObjectType OT_objectidclass = new ObjectType(cmd.getObjectidClass());
                        this.il.append(this.factory.createCast((Type)Type.OBJECT, (Type)OT_objectidclass));
                        this.il.append((Instruction)this.factory.createPutField(oidClassName, f.getName(), (Type)OT_objectidclass));
                        continue;
                    }
                    this.il.append((Instruction)this.factory.createPutField(oidClassName, f.getName(), f.getEnhanceField().getType()));
                }
            }
            lv_o[1] = this.il.append((Instruction)InstructionConstants.RETURN);
            this.methodGen.addLocalVariable("o", (Type)oidType, lv_o[0], lv_o[1]);
        } else {
            this.il.append((Instruction)InstructionConstants.RETURN);
        }
    }
}

