/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.method;

import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.jpox.enhancer.EnhanceUtil;
import org.jpox.enhancer.GeneratorBase;
import org.jpox.enhancer.method.MethodBuilder;
import org.jpox.util.JPOXLogger;

public abstract class ReplaceMethodCallback
extends MethodBuilder {
    protected Method originalMethod;

    public ReplaceMethodCallback(Method originalMethod, GeneratorBase gen) {
        super(originalMethod.getName(), originalMethod.getModifiers(), originalMethod.getReturnType(), originalMethod.getArgumentTypes(), null, false, gen);
        this.originalMethod = originalMethod;
    }

    public void close() {
        if (this.originalMethod == null) {
            super.close();
            return;
        }
        if (this.methodGen != null) {
            this.methodGen.setMaxStack();
            this.methodGen.setMaxLocals();
            Method m = this.methodGen.getMethod();
            this.classGen.replaceMethod(this.originalMethod, m);
            if (this.synthetic) {
                EnhanceUtil.addSynthetic((FieldOrMethod)m, this.classGen.getConstantPool());
            }
            if (JPOXLogger.ENHANCER.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("replace method: ");
                sb.append(this.methodName).append("(");
                for (int i = 0; i < this.argType.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(this.argType[i]).append(" ");
                }
                sb.append(")");
                JPOXLogger.ENHANCER.debug((Object)sb.toString());
            }
            this.methodGen.update();
            this.classGen.update();
            this.il.dispose();
        }
    }
}

