/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.tools;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;

public class EnhancerTask
extends Java {
    private File dir;
    private String jdoFileSuffixes = "jdo";

    public EnhancerTask() {
        this.setClassname("org.jpox.enhancer.JPOXEnhancer");
        this.setFork(true);
    }

    public void execute() throws BuildException {
        StringTokenizer token = new StringTokenizer(this.jdoFileSuffixes, ",");
        while (token.hasMoreTokens()) {
            DirectoryScanner dsJDO = this.getDirectoryScanner(this.getDir());
            dsJDO.setIncludes(new String[]{"**\\*." + token.nextToken()});
            dsJDO.scan();
            for (int i = 0; i < dsJDO.getIncludedFiles().length; ++i) {
                this.createArg().setFile(new File(this.getDir(), dsJDO.getIncludedFiles()[i]));
            }
        }
        this.setFork(true);
        super.execute();
    }

    public void setVerify(boolean verify) {
        if (verify) {
            this.createArg().setValue("-verify");
            this.log("Enhancer verify: " + verify, 3);
        }
    }

    public void setCheckonly(boolean checkonly) {
        if (checkonly) {
            this.createArg().setValue("-checkonly");
            this.log("Enhancer checkonly: " + checkonly, 3);
        }
    }

    private DirectoryScanner getDirectoryScanner(File dir) {
        FileSet fileset = new FileSet();
        fileset.setDir(dir);
        return fileset.getDirectoryScanner(this.getProject());
    }

    public void setDestination(File destdir) {
        if (destdir != null && destdir.length() > 0L) {
            this.createArg().setValue("-d");
            this.createArg().setFile(destdir);
            this.log("Enhancer destdir: " + destdir, 3);
        }
    }

    public void setTypes(String userTypesFile) {
        if (userTypesFile != null && userTypesFile.length() > 0) {
            this.createArg().setLine("-types " + userTypesFile);
            this.log("Enhancer types: " + userTypesFile, 3);
        }
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir == null ? this.getProject().getBaseDir() : this.dir;
    }

    public void setJDOFileSuffixes(String jdoFileSuffixes) {
        this.jdoFileSuffixes = jdoFileSuffixes;
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.createArg().setValue("-v");
            this.log("Enhancer verbose: " + verbose, 3);
        }
    }
}

