/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.jpox.cache.CachedPC;
import org.jpox.cache.Level2Cache;

public class OSCacheLevel2Cache
implements Level2Cache {
    private final GeneralCacheAdministrator cache = new GeneralCacheAdministrator();
    private final String cacheName;

    public OSCacheLevel2Cache(Properties props) {
        this.cacheName = props.getProperty("CacheName");
    }

    public void clear() {
        this.cache.flushAll();
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        try {
            return (CachedPC)this.cache.getFromCache(this.toString(oid));
        }
        catch (NeedsRefreshException e) {
            this.cache.cancelUpdate(this.toString(oid));
            return null;
        }
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by OSCache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by OSCache plugin");
    }

    public int getSize() {
        throw new UnsupportedOperationException("getSize() method not yet supported by OSCache plugin");
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (pc.getPersistenceCapable().jdoGetPersistenceManager() != null) {
            return null;
        }
        this.cache.putInCache(this.toString(oid), (Object)pc);
        return pc;
    }

    public void evict(Object oid) {
        this.cache.flushEntry(this.toString(oid));
    }

    public void evictAll() {
        this.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by OSCache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by OSCache plugin");
    }

    public void pinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by OSCache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by OSCache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by OSCache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by OSCache plugin");
    }

    public void unpinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by OSCache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by OSCache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by OSCache plugin");
    }

    private String toString(Object key) {
        if (this.cacheName != null) {
            return String.valueOf(key) + '.' + this.cacheName;
        }
        return String.valueOf(key);
    }
}

