/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import net.sf.swarmcache.CacheFactory;
import net.sf.swarmcache.ObjectCache;
import org.jpox.cache.CachedPC;
import org.jpox.cache.Level2Cache;

public class SwarmCacheLevel2Cache
implements Level2Cache {
    private final ObjectCache cache;
    private final String cacheName;

    public SwarmCacheLevel2Cache(Properties props) {
        CacheFactory factory = new CacheFactory(null);
        this.cacheName = props.getProperty("CacheName");
        this.cache = factory.createCache(this.cacheName);
    }

    public void clear() {
        this.cache.clearAll();
    }

    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    public CachedPC get(Object oid) {
        if (oid instanceof Serializable) {
            return (CachedPC)this.cache.get((Serializable)oid);
        }
        throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by SwarmCache plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by SwarmCache plugin");
    }

    public int getSize() {
        throw new UnsupportedOperationException("getSize() method not yet supported by SwarmCache plugin");
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (pc.getPersistenceCapable().jdoGetPersistenceManager() != null) {
            return null;
        }
        if (!(oid instanceof Serializable)) {
            throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
        }
        this.cache.put((Serializable)oid, (Object)pc);
        return pc;
    }

    public void evict(Object oid) {
        if (!(oid instanceof Serializable)) {
            throw new UnsupportedOperationException("SwarmCache doesnt support use of keys that aren't Serializable");
        }
        this.cache.clear((Serializable)oid);
    }

    public void evictAll() {
        this.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by SwarmCache plugin");
    }

    public void pinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by SwarmCache plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by SwarmCache plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by SwarmCache plugin");
    }

    public void unpinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by SwarmCache plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by SwarmCache plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by SwarmCache plugin");
    }
}

