/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.cache.tangosol;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.jpox.ObjectManagerHelper;
import org.jpox.cache.CachedPC;
import org.jpox.cache.Level2Cache;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class TangosolLevel2Cache
implements Level2Cache {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.jpox.cache.Localisation", (ClassLoader)TangosolLevel2Cache.class.getClassLoader());
    private static final Localiser LOCALISER_TANGOSOL = Localiser.getInstance((String)"org.jpox.cache.Localisation_tangosol", (ClassLoader)TangosolLevel2Cache.class.getClassLoader());
    private NamedCache cache;

    public TangosolLevel2Cache(Properties props) {
        try {
            Class.forName("com.tangosol.net.CacheFactory");
        }
        catch (ClassNotFoundException cnfe) {
            throw new JPOXUserException(LOCALISER_TANGOSOL.msg("Cache.Tangosol.Unavailable")).setFatal();
        }
        String name = props.getProperty("CacheName");
        if (name == null) {
            throw new JPOXUserException(LOCALISER_TANGOSOL.msg("Cache.Tangosol.CacheNameNotSpecified")).setFatal();
        }
        this.cache = CacheFactory.getCache((String)name);
    }

    public NamedCache getTangosolCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean containsOid(Object oid) {
        return this.cache.containsKey(oid);
    }

    public boolean lock(Object oid) {
        return this.cache.lock(oid);
    }

    public boolean lock(Object oid, int wait) {
        return this.cache.lock(oid, wait);
    }

    public boolean unlock(Object oid) {
        return this.cache.unlock(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPC get(Object oid) {
        this.cache.lock(oid, -1);
        try {
            CachedPC cachedPC = (CachedPC)this.cache.get(oid);
            return cachedPC;
        }
        finally {
            this.cache.unlock(oid);
        }
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not yet supported by Tangosol plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not yet supported by Tangosol plugin");
    }

    public int getSize() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            JPOXLogger.CACHE.warn((Object)LOCALISER.msg("Cache.CantStoreNullObject"));
            return null;
        }
        if (ObjectManagerHelper.getObjectManager((Object)pc.getPersistableObject()) != null) {
            JPOXLogger.CACHE.error((Object)LOCALISER.msg("Cache.ObjectConnectedError", oid));
            return null;
        }
        return (CachedPC)this.cache.put(oid, (Object)pc);
    }

    public void evict(Object oid) {
        this.cache.remove(oid);
    }

    public void evictAll() {
        this.cache.clear();
    }

    public void evictAll(Class pcClass, boolean subclasses) {
        throw new UnsupportedOperationException("evict(Class, boolean) method not yet supported by Tangosol plugin");
    }

    public void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public void pin(Object oid) {
        throw new UnsupportedOperationException("pinAll(Object) method not yet supported by Tangosol plugin");
    }

    public void pinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("pinAll(Class, boolean) method not yet supported by Tangosol plugin");
    }

    public void pinAll(Collection oids) {
        throw new UnsupportedOperationException("pinAll(Collection) method not yet supported by Tangosol plugin");
    }

    public void pinAll(Object[] oids) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not yet supported by Tangosol plugin");
    }

    public void unpin(Object oid) {
        throw new UnsupportedOperationException("unpin(Object) method not yet supported by Tangosol plugin");
    }

    public void unpinAll(Class cls, boolean subs) {
        throw new UnsupportedOperationException("unpinAll(Class, boolean) method not yet supported by Tangosol plugin");
    }

    public void unpinAll(Collection oids) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not yet supported by Tangosol plugin");
    }

    public void unpinAll(Object[] oids) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not yet supported by Tangosol plugin");
    }
}

