/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.ItemDescription;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FullItemDescription
extends ItemDescription {
    public static final int PRIVATE = 0;
    public static final int DEFAULT = 1;
    public static final int PROTECTED = 2;
    public static final int PUBLIC = 3;
    public boolean isSynthetic = false;
    public Vector modifiers = new Vector();
    public String type;
    public String declaringClass;
    public String args;
    public String throwables = "";
    private String last;
    private boolean isThrowables;

    public FullItemDescription(Field field) {
        this.memberType = "fld  ";
        this.modifiers = FullItemDescription.printModifiers(field.getModifiers());
        this.type = field.getType().getName();
        this.declaringClass = field.getDeclaringClass().getName();
        this.name = field.getName();
    }

    public FullItemDescription(Method method) {
        this.memberType = "meth ";
        this.modifiers = FullItemDescription.printModifiers(method.getModifiers());
        this.type = method.getReturnType().getName();
        this.declaringClass = method.getDeclaringClass().getName();
        this.name = method.getName();
        this.args = "(";
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 0) {
            this.args = this.args + classArray[0].getName();
        }
        int n = 1;
        while (n < classArray.length) {
            this.args = this.args + "," + classArray[n].getName();
            ++n;
        }
        this.args = this.args + ")";
        Class<?>[] classArray2 = method.getExceptionTypes();
        String[] stringArray = new String[classArray2.length];
        int n2 = 0;
        while (n2 < classArray2.length) {
            stringArray[n2] = classArray2[n2].getName();
            ++n2;
        }
        FullItemDescription.sort(stringArray);
        if (stringArray.length > 0) {
            this.throwables = "throws " + stringArray[0];
        }
        int n3 = 1;
        while (n3 < stringArray.length) {
            this.throwables = this.throwables + "," + stringArray[n3];
            ++n3;
        }
    }

    public FullItemDescription(Constructor constructor) {
        this.memberType = "cons ";
        this.modifiers = FullItemDescription.printModifiers(constructor.getModifiers());
        this.parseQualifiedName(constructor.getName());
        this.declaringClass = constructor.getDeclaringClass().getName();
        this.args = "(";
        Class<?>[] classArray = constructor.getParameterTypes();
        if (classArray.length > 0) {
            this.args = this.args + classArray[0].getName();
        }
        int n = 1;
        while (n < classArray.length) {
            this.args = this.args + "," + classArray[n].getName();
            ++n;
        }
        this.args = this.args + ")";
        Class<?>[] classArray2 = constructor.getExceptionTypes();
        String[] stringArray = new String[classArray2.length];
        int n2 = 0;
        while (n2 < classArray2.length) {
            stringArray[n2] = classArray2[n2].getName();
            ++n2;
        }
        FullItemDescription.sort(stringArray);
        if (stringArray.length > 0) {
            this.throwables = "throws " + stringArray[0];
        }
        int n3 = 1;
        while (n3 < stringArray.length) {
            this.throwables = this.throwables + "," + stringArray[n3];
            ++n3;
        }
    }

    public FullItemDescription(String string) {
        this.setData(string);
    }

    public FullItemDescription() {
    }

    protected static String[] sort(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 < stringArray.length) {
                if (stringArray[n3].compareTo(stringArray[n2]) < 0) {
                    n2 = n3;
                }
                ++n3;
            }
            String string = stringArray[n];
            stringArray[n] = stringArray[n2];
            stringArray[n2] = string;
            ++n;
        }
        return stringArray;
    }

    public static Vector printModifiers(int n) {
        Vector<String> vector = new Vector<String>();
        if ((n & 1) != 0) {
            vector.addElement("public");
        }
        if ((n & 2) != 0) {
            vector.addElement("private");
        }
        if ((n & 4) != 0) {
            vector.addElement("protected");
        }
        if ((n & 8) != 0) {
            vector.addElement("static");
        }
        if ((n & 0x80) != 0) {
            vector.addElement("transient");
        }
        if ((n & 0x20) != 0) {
            vector.addElement("synchronized");
        }
        if ((n & 0x400) != 0 || (n & 0x200) != 0) {
            vector.addElement("abstract");
        }
        if ((n & 0x100) != 0) {
            vector.addElement("native");
        }
        if ((n & 0x10) != 0) {
            vector.addElement("final");
        }
        if ((n & 0x200) != 0) {
            vector.addElement("interface");
        }
        if ((n & 0x40) != 0) {
            vector.addElement("volatile");
        }
        return vector;
    }

    public ItemDescription getItem() {
        if (this.memberType.equals("intf ") || this.memberType.equals("supr ")) {
            return new ItemDescription(this.memberType);
        }
        return new ItemDescription(this.memberType + this.name + (this.args != null ? this.args : ""));
    }

    public String toString() {
        String string = this.memberType;
        Enumeration enumeration = this.modifiers.elements();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + " ";
        }
        string = string + (this.type != null ? this.type + " " : "");
        if (this.declaringClass != null && !this.declaringClass.equals("")) {
            return (string + this.declaringClass + (this.isClass() ? "$" : ".") + this.name + (this.args != null ? this.args : "") + (this.throwables != null ? " " + this.throwables : "")).trim();
        }
        return (string + this.name + (this.args != null ? this.args : "") + (this.throwables != null ? " " + this.throwables : "")).trim();
    }

    public int getAcces() {
        if (this.modifiers.contains("private")) {
            return 0;
        }
        if (this.modifiers.contains("protected")) {
            return 2;
        }
        if (this.modifiers.contains("public")) {
            return 3;
        }
        return 1;
    }

    public Vector getModifiers() {
        return this.modifiers;
    }

    public String getType() {
        return this.type;
    }

    public String getDeclaringClass() {
        return this.declaringClass == null ? "" : this.declaringClass;
    }

    public String getSignature() {
        return (this.name == null ? "" : this.name) + (this.args == null ? "" : this.args);
    }

    public String getName() {
        if (this.isClass() && !this.getDeclaringClass().equals("")) {
            return this.declaringClass + "$" + this.name;
        }
        return this.name == null ? "" : this.name;
    }

    public String getThrowables() {
        return this.throwables == null ? "" : this.throwables;
    }

    public boolean equals(Object object) {
        if (object instanceof FullItemDescription) {
            String string = this.toString();
            String string2 = ((FullItemDescription)object).toString();
            return string.equals(string2);
        }
        return false;
    }

    public boolean isProtected() {
        return this.modifiers.contains("protected");
    }

    public boolean isPublic() {
        return this.modifiers.contains("public");
    }

    public boolean isPrivate() {
        return this.modifiers.contains("private");
    }

    public boolean isAbstract() {
        return this.modifiers.contains("abstract");
    }

    public boolean isStatic() {
        return this.modifiers.contains("static");
    }

    public boolean isSynthetic() {
        if (this.modifiers.contains("<synthetic>")) {
            return true;
        }
        if (this.isMethod() && this.isProtected() && this.name.startsWith("access$")) {
            boolean bl = this.name.length() > 7;
            int n = 7;
            while (n < this.name.length()) {
                if (this.name.charAt(n) < '0' || this.name.charAt(n) > '9') {
                    bl = false;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    protected void setData(String string) {
        this.memberType = string.substring(0, "CLSS ".length());
        this.memberType = this.memberType.equals("innr ") ? "CLSS " : this.memberType;
        String string2 = string.substring("CLSS ".length());
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " <>()", true);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3.equals("<")) {
                this.addToken("<" + this.getElement(stringTokenizer, ">") + ">");
                continue;
            }
            if (string3.equals("(")) {
                this.addToken("(" + this.getElement(stringTokenizer, ")") + ")");
                continue;
            }
            if (string3.equals(" ")) continue;
            this.addToken(string3);
        }
        this.addToken(null);
        if (!this.modifiers.isEmpty() && (this.isMethod() || this.isField())) {
            this.type = (String)this.modifiers.lastElement();
            this.modifiers.setSize(this.modifiers.size() - 1);
        }
    }

    public static Vector printClassModifiers(int n) {
        Vector vector = FullItemDescription.printModifiers(n);
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2).equals("synchronized")) {
                vector.setElementAt("<flag_super>", n2);
                break;
            }
            ++n2;
        }
        return vector;
    }

    private String getElement(Enumeration enumeration, String string) {
        String string2;
        String string3 = "";
        while (enumeration.hasMoreElements() && !(string2 = (String)enumeration.nextElement()).equals(string)) {
            string3 = string3 + string2;
        }
        return string3;
    }

    private void addToken(String string) {
        if (string == null) {
            if (this.args == null) {
                this.parseQualifiedName(this.last);
            }
        } else if (this.isThrowables) {
            this.throwables = this.throwables + " " + string;
        } else if (string.startsWith("(")) {
            this.parseQualifiedName(this.last);
            this.args = string;
            this.last = null;
        } else if (string.equals("throws")) {
            this.throwables = string;
            this.isThrowables = true;
        } else {
            if (this.last != null) {
                this.modifiers.addElement(this.last);
            }
            this.last = string;
        }
    }

    protected void parseQualifiedName(String string) {
        if (string != null) {
            int n = string.lastIndexOf(46);
            int n2 = string.lastIndexOf(36);
            if (this.isConstructor() || this.isClass() && n2 > n) {
                if (n2 > n) {
                    n = n2;
                }
            } else if (!this.isMethod() && !this.isField()) {
                n = -1;
            }
            this.declaringClass = n > 0 ? string.substring(0, n) : "";
            this.name = string.substring(++n);
        }
    }
}

