/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.tdk.signaturetest.ArchiveFinder;
import com.sun.tdk.signaturetest.ClassDescrLoader;
import com.sun.tdk.signaturetest.ClassDescription;
import com.sun.tdk.signaturetest.DescriptionFormat;
import com.sun.tdk.signaturetest.ErrorFormatter;
import com.sun.tdk.signaturetest.FullItemDescription;
import com.sun.tdk.signaturetest.ItemDescription;
import com.sun.tdk.signaturetest.ReflClassDescrLoader;
import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.SignatureClassLoader;
import com.sun.tdk.signaturetest.SortedErrorFormatter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SignatureTest
extends SigTest
implements Test {
    protected PrintWriter log;
    protected boolean logFile = false;
    protected Hashtable trackedClassNames = new Hashtable();
    protected DescriptionFormat converter;
    protected ArchiveFinder classIterator;
    private boolean isProtectedTracked = true;
    protected URL signatureFile;
    protected boolean isVerbose = false;
    protected boolean isValueTracked = false;

    public static void main(String[] stringArray) {
        SignatureTest signatureTest = new SignatureTest();
        Status status = signatureTest.run(stringArray, null, null);
        status.exit();
    }

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        this.log = printWriter;
        if (stringArray.length == 1 && (stringArray[0].equals("-help") || stringArray[0].equals("-?"))) {
            this.usage();
            return Status.parse("Not run.");
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n++]);
        }
        Status status = this.parseParameters(vector);
        if (status.isPassed()) {
            status = this.check(this.signatureFile);
            if (this.logFile) {
                this.log.println("STATUS: " + status);
            }
        } else {
            this.usage();
        }
        if (this.logFile) {
            this.log.close();
        }
        return status;
    }

    public Status parseParameters(Vector vector) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<Object> vector2 = new Vector<Object>();
        String string4 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).equals("-TestURL")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -TestURL");
                }
                if (string != null) {
                    return Status.failed("The -TestURL option is specified twice.");
                }
                string = (String)enumeration.nextElement();
                continue;
            }
            if (((String)object).equals("-FileName")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -FileName");
                }
                if (string2 != null) {
                    return Status.failed("The -FileName option is specified twice.");
                }
                string2 = (String)enumeration.nextElement();
                continue;
            }
            if (((String)object).equals("-FormatPlain")) {
                string4 = "plain";
                continue;
            }
            if (((String)object).equals("-Verbose")) {
                this.isVerbose = true;
                continue;
            }
            if (((String)object).equals("-CheckValue")) {
                this.isValueTracked = true;
                continue;
            }
            if (((String)object).equals("-out")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -out");
                }
                if (string3 != null) {
                    return Status.failed("The -out option is specified twice.");
                }
                string3 = (String)enumeration.nextElement();
                continue;
            }
            if (((String)object).equals("-help") || ((String)object).equals("-?")) {
                this.usage();
                continue;
            }
            vector2.addElement(object);
        }
        object = super.parseParameters(vector2);
        if (((Status)object).isFailed()) {
            return object;
        }
        if (this.isValueTracked && !this.isStatic) {
            return Status.failed("The values could be checked in the static mode only.");
        }
        this.isProtectedTracked = this.isStatic || this.isProtectedTracked;
        boolean bl = this.isReflectUsed = this.isProtectedTracked && !this.isStatic && this.isReflectUsed;
        if (this.log == null) {
            if (string3 == null) {
                this.log = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
            } else {
                try {
                    this.log = new PrintWriter(new BufferedWriter(new FileWriter(string3)));
                    this.logFile = true;
                }
                catch (IOException iOException) {
                    return Status.failed("Invalid -out file name");
                }
            }
        } else if (string3 != null) {
            System.err.println("-out option ignored");
        }
        this.errorManager = this.createErrorFormatter(string4);
        if (string == null) {
            string = "file:";
        } else {
            int n = string.indexOf(58);
            int n2 = string.indexOf(47);
            if (n == -1 || n2 == -1 || n > n2) {
                string = "file:" + string;
            }
        }
        return this.constructFields(string, string2);
    }

    protected void usage() {
        System.err.println("Available options are:\n-TestURL  <url>   Specify URL of signature file\n-FileName <file>  Specify signature file name\n-Package <name>   Specify package to be tested along with subpackages\n-PackageWithoutSubpackages <name> Specify package to be tested excluding subpackages\n-Exclude <name>   Specify package or class, which is not required to be tested\n-Classpath <path> Specify search path for tested classes\n-out <file>       Specify report file name\n-static           Run SignatureTest in static mode\n-AllPublic        Test public/protected nested classes, which are members of default scope classes\n-CheckValue       Check values of primitive constants (static mode only)\n-ClassCacheSize <numb>  Specify size of class cache (default value is 100)\n-FormatPlain      Don't sort error messages\n-Verbose          Enable error diagnostics for inherited class members\n-Version <str>    Set API version for report (default is JRE version)\n-help             Print this text");
    }

    protected Status constructFields(String string, String string2) {
        if (string == null) {
            return Status.failed("URL not specified");
        }
        if (string2 == null) {
            return Status.failed("Signature file name not specified");
        }
        if (this.isStatic && this.classpath == null) {
            return Status.failed("Class path not specified in the static mode.");
        }
        try {
            this.signatureFile = new URL(new URL(string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.log.println(string + "  throw " + malformedURLException);
            return Status.failed("Invalid URL");
        }
        catch (IOException iOException) {
            this.log.println(iOException);
            return Status.failed("Can't read specification file.");
        }
        try {
            if (this.classpath == null) {
                this.classpath = this.getDefaultClassPath();
            }
            this.classIterator = new ArchiveFinder(this.classpath);
        }
        catch (SecurityException securityException) {
            this.log.println("The security constraint does not allow tracking class path for tracking of the added new classes.");
        }
        return Status.passed("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Status check(URL uRL) {
        SignatureClassLoader signatureClassLoader;
        block9: {
            this.trackedClassNames = new Hashtable();
            signatureClassLoader = null;
            try {
                Status status;
                block8: {
                    try {
                        ClassDescription classDescription;
                        signatureClassLoader = new SignatureClassLoader(this.signatureFile);
                        this.converter = this.createDescriptionFormat((this.isThrowsTracked() || this.isStatic) && signatureClassLoader.isThrowsTracked);
                        this.loader = this.createClassDescrLoader();
                        while ((classDescription = signatureClassLoader.nextClass()) != null) {
                            Status status2;
                            if (!classDescription.isPublic() && !classDescription.isProtected() || !(status2 = this.verifyClass(classDescription)).isFailed()) continue;
                            status = status2;
                            Object var7_10 = null;
                            if (signatureClassLoader == null) return status;
                            break block8;
                        }
                        break block9;
                    }
                    catch (IOException iOException) {
                        this.log.println("problem with definitions file");
                        this.log.println(iOException);
                        Status status3 = Status.failed("problem with definitions file");
                        Object var7_12 = null;
                        if (signatureClassLoader == null) return status3;
                        signatureClassLoader.close();
                        return status3;
                    }
                    catch (SecurityException securityException) {
                        this.log.println("The security constraints does not allow to read from signature file.");
                        this.log.println(securityException);
                        Status status4 = Status.failed("The security constraints does not allow to read from signature file.");
                        Object var7_13 = null;
                        if (signatureClassLoader == null) return status4;
                        signatureClassLoader.close();
                        return status4;
                    }
                }
                signatureClassLoader.close();
                return status;
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                if (signatureClassLoader != null) {
                    signatureClassLoader.close();
                }
                throw throwable;
            }
        }
        Object var7_11 = null;
        if (signatureClassLoader != null) {
            signatureClassLoader.close();
        }
        this.checkAddedClasses();
        return this.printErrors(signatureClassLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkAddedClasses() {
        try {
            if (this.classIterator == null) {
                return;
            }
            while (true) {
                String string;
                if ((string = this.classIterator.nextClassName()) == null) {
                    return;
                }
                if (this.trackedClassNames.get(string) != null || !this.isPackageMember(string)) continue;
                try {
                    ClassDescription classDescription = this.loader.loadClass(string);
                    if (!this.isAccessible(classDescription)) continue;
                    this.errorManager.addError("Added", classDescription.getName(), null, "");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
        }
        catch (SecurityException securityException) {
            this.log.println("The security constraints does not allow to inspect class path.");
            this.log.println(securityException);
        }
    }

    protected Status verifyClass(ClassDescription classDescription) {
        if (!this.isPackageMember(classDescription.getName())) {
            return Status.passed("");
        }
        String string = classDescription.getName();
        try {
            ClassDescription classDescription2 = this.loader.loadClass(string);
            if (classDescription2.isPublic() || classDescription2.isProtected()) {
                this.loader.createMembers(classDescription2);
                this.verifyClass(classDescription, classDescription2);
            } else {
                this.reportMissingClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.reportMissingClass(string);
        }
        catch (LinkageError linkageError) {
            this.errorManager.addError("LinkageError", string, " thrown " + linkageError, " " + string + " not linked");
            this.trackedClassNames.put(string, "non-linked");
        }
        catch (SecurityException securityException) {
            this.log.println("The security constraints does not allow to track declared members. " + securityException);
            return Status.failed("The security constraints does not allow to track declared members.");
        }
        return Status.passed("");
    }

    protected void verifyClass(ClassDescription classDescription, ClassDescription classDescription2) {
        Object object;
        this.trackedClassNames.put(classDescription2.getName(), "tracked");
        if (this.errorManager instanceof SortedErrorFormatter) {
            ((SortedErrorFormatter)this.errorManager).Tested(classDescription2);
        }
        this.checkClassDescription(classDescription, classDescription2);
        Enumeration enumeration = classDescription.items();
        while (enumeration.hasMoreElements()) {
            object = (ItemDescription)enumeration.nextElement();
            if (((ItemDescription)object).isClass()) {
                this.trackNestedClass(classDescription2, (ItemDescription)object, classDescription.get((ItemDescription)object));
                continue;
            }
            this.trackMember(classDescription.getName(), classDescription.get((ItemDescription)object), classDescription2.get((ItemDescription)object));
        }
        object = classDescription2.items();
        while (object.hasMoreElements()) {
            ItemDescription itemDescription = (ItemDescription)object.nextElement();
            if (classDescription.get(itemDescription) != null) continue;
            this.trackMember(classDescription.getName(), null, classDescription2.get(itemDescription));
        }
    }

    protected void checkClassDescription(FullItemDescription fullItemDescription, FullItemDescription fullItemDescription2) {
        String string;
        String string2 = this.converter.convertShortClassDescription(fullItemDescription);
        if (!string2.equals(string = this.converter.convertShortClassDescription(fullItemDescription2))) {
            this.errorManager.addError("Missing", fullItemDescription.getName(), string2, "");
            this.errorManager.addError("Added", fullItemDescription2.getName(), string, "");
        }
    }

    protected void trackMember(String string, Vector vector, Vector vector2) {
        int n;
        vector = vector == null ? new Vector() : vector;
        vector2 = vector2 == null ? new Vector() : vector2;
        Vector vector3 = this.convertDescription(vector);
        Vector vector4 = this.convertDescription(vector2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!((FullItemDescription)enumeration.nextElement()).isSynthetic()) continue;
            return;
        }
        int n2 = 0;
        while (n2 < vector3.size()) {
            n = vector4.indexOf(vector3.elementAt(n2));
            if (n >= 0) {
                vector3.removeElementAt(n2);
                vector4.removeElementAt(n);
                continue;
            }
            ++n2;
        }
        n = 0;
        while (n < vector3.size()) {
            SigEntry sigEntry = (SigEntry)vector3.elementAt(n);
            if (this.isProtectedTracked || sigEntry.entry.isSuperClass() || sigEntry.entry.isSuperInterface() || sigEntry.entry.isPublic() && (!sigEntry.entry.isMethod() || !sigEntry.entry.isAbstract() || vector2 == null || vector2.isEmpty())) {
                this.errorManager.addError("Missing", string, sigEntry.value, "");
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector4.size()) {
            SigEntry sigEntry = (SigEntry)vector4.elementAt(n3);
            if (this.isProtectedTracked) {
                this.errorManager.addError("Added", string, sigEntry.value, "");
            } else if (sigEntry.entry.isField()) {
                if (sigEntry.entry.getDeclaringClass().equals(string) && vector.isEmpty()) {
                    this.errorManager.addError("Added", string, sigEntry.value, "");
                }
            } else if (sigEntry.entry.isMethod()) {
                if (vector.isEmpty() || !sigEntry.entry.isAbstract() && !sigEntry.entry.isStatic()) {
                    this.errorManager.addError("Added", string, sigEntry.value, "");
                }
            } else if (!sigEntry.entry.isClass()) {
                this.errorManager.addError("Added", string, sigEntry.value, "");
            }
            ++n3;
        }
    }

    protected Vector convertDescription(Vector vector) {
        Vector<SigEntry> vector2 = new Vector<SigEntry>();
        if (vector == null) {
            return vector2;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(new SigEntry((FullItemDescription)enumeration.nextElement()));
        }
        return vector2;
    }

    protected void trackNestedClass(ClassDescription classDescription, ItemDescription itemDescription, Vector vector) {
        if (this.isReflectUsed) {
            this.trackMember(classDescription.getName(), vector, classDescription.get(itemDescription));
        } else if (!vector.isEmpty()) {
            String string = ((FullItemDescription)vector.firstElement()).getSignature();
            this.trackMember(classDescription.getName(), vector, this.loader.getNestedClass(classDescription, string));
        }
    }

    protected void reportMissingClass(String string) {
        this.errorManager.addError("Missing", string, null, "");
    }

    protected Status printErrors(SignatureClassLoader signatureClassLoader) {
        this.log.println("SignatureTest report\n");
        this.log.println("Tested version: " + this.apiVersion + "\n");
        this.errorManager.printErrors();
        int n = this.errorManager.getNumErrors();
        if (n == 0) {
            return Status.passed("");
        }
        return Status.failed(n + " errors");
    }

    protected ErrorFormatter createErrorFormatter(String string) {
        if (string != null && string.equals("plain")) {
            return new ErrorFormatter(this.log);
        }
        return new SortedErrorFormatter(this.log, this.isVerbose);
    }

    protected DescriptionFormat createDescriptionFormat(boolean bl) {
        return new DescriptionFormat(false, bl, this.details){

            protected boolean isModifierTracked(String string, FullItemDescription fullItemDescription) {
                if (string.startsWith("<value")) {
                    return SignatureTest.this.isValueTracked;
                }
                return super.isModifierTracked(string, fullItemDescription);
            }
        };
    }

    protected ClassDescrLoader createClassDescrLoader() {
        if (!this.isStatic) {
            return new ReflClassDescrLoader(this.isReflectUsed, this.isProtectedTracked);
        }
        try {
            Class<?> clazz = Class.forName("com.sun.tdk.signaturetest.staticsig.ArchiveClassDescrLoader");
            Constructor<?> constructor = clazz.getConstructor(this.classIterator.getClass(), Integer.TYPE);
            return (ClassDescrLoader)constructor.newInstance(this.classIterator, new Integer(this.cacheSize));
        }
        catch (Throwable throwable) {
            throw new LinkageError("Can't create static ClassDescrLoader");
        }
    }

    public class SigEntry {
        public FullItemDescription entry;
        public String value;
        public int status;

        public SigEntry(FullItemDescription fullItemDescription) {
            this.entry = fullItemDescription;
            this.value = SignatureTest.this.converter.convertShortDescription(fullItemDescription);
        }

        public boolean equals(Object object) {
            if (object instanceof SigEntry) {
                return this.value.equals(((SigEntry)object).value);
            }
            return false;
        }
    }
}

