/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.setup;

import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.tdk.signaturetest.ArchiveFinder;
import com.sun.tdk.signaturetest.ClassDescrLoader;
import com.sun.tdk.signaturetest.ClassDescription;
import com.sun.tdk.signaturetest.DescriptionFormat;
import com.sun.tdk.signaturetest.FullItemDescription;
import com.sun.tdk.signaturetest.ItemDescription;
import com.sun.tdk.signaturetest.NestedClassTable;
import com.sun.tdk.signaturetest.ReflClassDescrLoader;
import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.SortedVector;
import com.sun.tdk.signaturetest.setup.ClassNameSorter;
import com.sun.tdk.signaturetest.staticsig.ArchiveClassDescrLoader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Setup
extends SigTest
implements Test {
    PrintWriter log;
    protected int errors;
    protected DescriptionFormat converter;
    protected ArchiveFinder classIterator;
    protected URL signatureFile;
    protected String signatureFileName;
    protected int allClassesNumber = 0;
    protected int scannedClassesNumber = 0;
    protected int includedClassesNumber = 0;
    protected int excludedClassesNumber = 0;
    protected boolean isIgnorableReported;
    private boolean isValueTracked;
    private boolean isFlagSuperTracked;
    private boolean isQualifiedNames;
    private boolean isPrimitiveConstants;
    private boolean isAllModifiers;

    public static void main(String[] stringArray) {
        Setup setup = new Setup();
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
        Status status = setup.run(stringArray, printWriter, null);
        status.exit();
    }

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        this.log = printWriter;
        if (stringArray.length == 1 && (stringArray[0].equals("-help") || stringArray[0].equals("-?"))) {
            this.usage();
            return Status.parse("Not run.");
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n++]);
        }
        Status status = this.parseParameters(vector);
        if (status.isPassed()) {
            status = this.check(this.signatureFile);
        } else {
            this.usage();
        }
        return status;
    }

    public Status parseParameters(Vector vector) {
        Object var2_2 = null;
        String string = null;
        String string2 = null;
        Vector<String> vector2 = new Vector<String>();
        this.signatureFileName = "Signature file";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.equals("-TestURL")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -TestURL");
                }
                string = (String)enumeration.nextElement();
                continue;
            }
            if (string3.equals("-FileName")) {
                if (!enumeration.hasMoreElements()) {
                    return Status.failed("Missing value for option -FileName");
                }
                string2 = (String)enumeration.nextElement();
                continue;
            }
            if (string3.equals("-Verbose")) {
                this.isIgnorableReported = true;
                continue;
            }
            if (string3.equals("-apichanges")) {
                this.isQualifiedNames = true;
                this.isPrimitiveConstants = true;
                this.isAllModifiers = true;
                this.signatureFileName = "API Master signature file";
                continue;
            }
            if (string3.equals("-pJava")) {
                this.isQualifiedNames = true;
                this.signatureFileName = "PJava Signature file";
                continue;
            }
            if (string3.equals("-FlagSuper")) {
                this.isFlagSuperTracked = true;
                continue;
            }
            if (string3.equals("-CheckValue")) {
                this.isValueTracked = true;
                this.isPrimitiveConstants = true;
                continue;
            }
            if (string3.equals("-AllPublic")) {
                this.trackMode = 2;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.usage();
                continue;
            }
            vector2.addElement(string3);
        }
        Status status = super.parseParameters(vector2);
        if (status.isFailed()) {
            return status;
        }
        if (string == null) {
            string = "file:";
        } else {
            int n = string.indexOf(58);
            int n2 = string.indexOf(47);
            if (n == -1 || n2 == -1 || n > n2) {
                string = "file:" + string;
            }
        }
        if (string2 == null) {
            return Status.failed("Signature file name not specified");
        }
        if (this.isStatic && this.classpath == null) {
            return Status.failed("Class path not specified in the static mode.");
        }
        try {
            this.signatureFile = new URL(new URL(string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            return Status.failed("Invalid URL");
        }
        catch (IOException iOException) {
            return Status.failed("Can't read specification file.");
        }
        try {
            if (this.classpath == null) {
                this.classpath = ArchiveFinder.getClasspath();
            }
            this.classIterator = new ArchiveFinder(this.classpath);
        }
        catch (SecurityException securityException) {
            this.log.println("The security constraints does not allow tracking class path.");
            this.log.println(securityException);
            return Status.failed("The security constraints does not allow tracking class path.");
        }
        return Status.passed("");
    }

    protected void usage() {
        System.err.println("Available options are:\n-FileName <file>  Specify signature file to be created\n-Package <name>   Specify package to be tested along with subpackages\n-PackageWithoutSubpackages <name> Specify package to be tested excluding subpackages\n-Exclude <name>   Specify package or class, which is not required to be tested\n-Classpath <path> Specify search path for tested classes\n-static           Run Setup in static mode\n-AllPublic        Test public/protected nested classes, which are members of default scope classes\n-CheckValue       Write values of primitive constants in signature file (static mode only)\n-Verbose          Print names of ignored classes\n-Version          Set API version for signature file (default is JRE version)\n-help             Print this text");
    }

    public Status check(URL uRL) {
        Object object;
        Vector vector = new Vector();
        this.converter = this.createDescriptionFormat(true);
        this.loader = this.createClassDescrLoader();
        ClassNameSorter classNameSorter = new ClassNameSorter(this.createNestedClassTable(), this.loader);
        Vector vector2 = classNameSorter.getSortedClasses(vector);
        try {
            object = new PrintWriter(new FileOutputStream(uRL.getFile()));
            ((PrintWriter)object).println("#" + this.signatureFileName);
            ((PrintWriter)object).println("#Version " + this.apiVersion);
            if (!this.isThrowsTracked() && !this.isStatic) {
                ((PrintWriter)object).println("#Throws clause not tracked.");
            }
            int n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.elementAt(n);
                try {
                    ClassDescription classDescription = this.loader.loadClass(string);
                    if (this.isAccessible(classDescription)) {
                        this.scanClass((PrintWriter)object, this.loader.loadClass(string));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setupProblem("Class not found: " + string);
                }
                catch (LinkageError linkageError) {
                    this.setupProblem("Class not linked: " + string);
                }
                ++n;
            }
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.println("problem creating signature file.");
            this.log.println(iOException);
            return Status.failed("problem creating signature file.");
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.setupProblem((String)object.nextElement());
        }
        try {
            this.log.println("Class path: \"" + (this.classpath == null ? ArchiveFinder.getClasspath() : this.classpath) + "\"");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.log.println("Found in total: " + this.allClassesNumber + " classes.");
        this.log.println("Selected by -Package: " + (this.includedClassesNumber + this.excludedClassesNumber) + " classes.");
        if (!this.excludedPackages.isEmpty()) {
            this.log.println("Filtered out by -Exclude: " + this.excludedClassesNumber + " classes.");
        }
        this.log.println("Written to sigfile: " + this.scannedClassesNumber + " classes.");
        if (this.errors == 0) {
            return this.scannedClassesNumber == 0 ? Status.error("Empty sigfile created") : Status.passed("");
        }
        return Status.failed(this.errors + " errors");
    }

    private Vector createNestedClassTable() {
        String string;
        Vector<String> vector = new Vector<String>();
        while ((string = this.classIterator.nextClassName()) != null) {
            ++this.allClassesNumber;
            String string2 = string;
            if (string.indexOf(36) >= 0) {
                NestedClassTable.addNestedClass(string);
                if (this.trackMode != 2 || !this.isPackageMember(string)) continue;
                vector.addElement(string);
                continue;
            }
            if (this.isPackageMember(string)) {
                ++this.includedClassesNumber;
                try {
                    ClassDescription classDescription = this.loader.loadClass(string);
                    if (this.isAccessible(classDescription)) {
                        vector.addElement(string);
                        continue;
                    }
                    this.ignore(string + " is not public or protected.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setupProblem("Class not found: " + string);
                }
                catch (LinkageError linkageError) {
                    this.setupProblem("Class not linked: " + string);
                }
                continue;
            }
            if (!this.excludedPackages.isEmpty() && this.excludedPackages.checkName(string)) {
                ++this.excludedClassesNumber;
            }
            this.ignore(string + " is not from required packages.");
        }
        this.classIterator.setListToBegin();
        return vector;
    }

    private void scanClass(PrintWriter printWriter, ClassDescription classDescription) throws ClassNotFoundException {
        ++this.scannedClassesNumber;
        this.loader.createMembers(classDescription);
        SortedVector sortedVector = new SortedVector(){

            protected int compare(Object object, Object object2) {
                if (object instanceof String && object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return 0;
            }
        };
        Enumeration enumeration = classDescription.items();
        while (enumeration.hasMoreElements()) {
            Vector vector = classDescription.get((ItemDescription)enumeration.nextElement());
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                FullItemDescription fullItemDescription = (FullItemDescription)enumeration2.nextElement();
                sortedVector.insert(this.converter.convertDescription(fullItemDescription));
            }
        }
        printWriter.println(this.converter.convertClassDescription(classDescription));
        int n = sortedVector.size();
        int n2 = 0;
        while (n2 < n) {
            printWriter.println(sortedVector.elementAt(n2));
            ++n2;
        }
    }

    protected void setupProblem(String string) {
        this.log.println(string);
        ++this.errors;
    }

    protected void ignore(String string) {
        if (this.isIgnorableReported) {
            this.log.println(string);
        }
    }

    protected ClassDescrLoader createClassDescrLoader() {
        if (this.isStatic) {
            return new ArchiveClassDescrLoader(this.classIterator, this.cacheSize);
        }
        return new ReflClassDescrLoader(this.isReflectUsed, true);
    }

    protected DescriptionFormat createDescriptionFormat(boolean bl) {
        if (!(this.isAllModifiers || this.isFlagSuperTracked || this.isPrimitiveConstants)) {
            return new DescriptionFormat(this.isQualifiedNames, true, this.details);
        }
        return new DescriptionFormat(this.isQualifiedNames, true, this.details){

            protected boolean isModifierTracked(String string, FullItemDescription fullItemDescription) {
                if (super.isModifierTracked(string, fullItemDescription)) {
                    return true;
                }
                if (string.startsWith("<value")) {
                    return Setup.this.isValueTracked;
                }
                if (string.equals("<flag_super>")) {
                    return Setup.this.isFlagSuperTracked;
                }
                if (string.equals("<constant>")) {
                    return Setup.this.isValueTracked || Setup.this.isPrimitiveConstants;
                }
                return Setup.this.isAllModifiers;
            }
        };
    }
}

