/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.staticsig;

import com.sun.tdk.signaturetest.ClassDescription;
import com.sun.tdk.signaturetest.FullItemDescription;
import com.sun.tdk.signaturetest.ItemDescription;
import com.sun.tdk.signaturetest.staticsig.CPX;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

class BinaryClassDescription
extends ClassDescription {
    private DataInputStream in;
    private FullItemDescription superClass;
    private FullItemDescription[] constructors = new FullItemDescription[0];
    private FullItemDescription[] fields = new FullItemDescription[0];
    private FullItemDescription[] interfaces = new FullItemDescription[0];
    private FullItemDescription[] methods = new FullItemDescription[0];
    private CPE[] constantPool;

    public BinaryClassDescription(InputStream inputStream) throws IOException {
        this.in = new DataInputStream(inputStream);
        this.read();
        this.constantPool = null;
    }

    public String getName() {
        return (this.declaringClass == null || this.declaringClass.equals("") ? "" : this.declaringClass + "$") + this.name;
    }

    public FullItemDescription[] getDeclaredConstructors() {
        return this.constructors;
    }

    public FullItemDescription[] getDeclaredFields() {
        return this.fields;
    }

    public FullItemDescription[] getDeclaredMethods() {
        return this.methods;
    }

    public FullItemDescription getSuperclass() {
        return this.superClass;
    }

    public FullItemDescription[] getInterfaces() {
        return this.interfaces;
    }

    public Vector getModifiers() {
        return this.modifiers;
    }

    public CPE getCPEntry(int n) {
        try {
            return this.constantPool[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ClassFormatError("Incorrect constant pool entry: " + n);
        }
    }

    private void readCP() throws IOException {
        int n = this.in.readUnsignedShort();
        this.constantPool = new CPE[n];
        int n2 = 1;
        while (n2 < n) {
            byte by = this.in.readByte();
            switch (by) {
                case 1: {
                    this.constantPool[n2] = new CPE(by, this.in.readUTF());
                    break;
                }
                case 3: {
                    this.constantPool[n2] = new CPE(by, new Integer(this.in.readInt()));
                    break;
                }
                case 4: {
                    this.constantPool[n2] = new CPE(by, new Float(this.in.readFloat()));
                    break;
                }
                case 5: {
                    this.constantPool[n2++] = new CPE(by, new Long(this.in.readLong()));
                    break;
                }
                case 6: {
                    this.constantPool[n2++] = new CPE(by, new Double(this.in.readDouble()));
                    break;
                }
                case 7: 
                case 8: {
                    this.constantPool[n2] = new CPE(by, new Integer(this.in.readUnsignedShort()));
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.constantPool[n2] = new CPE(by, new CPX(this.in.readUnsignedShort(), this.in.readUnsignedShort()));
                    break;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + by);
                }
            }
            ++n2;
        }
    }

    private void read() throws IOException {
        int n = this.in.readInt();
        if (n != -889275714) {
            throw new ClassFormatError("wrong magic: " + n + ", expected " + -889275714);
        }
        short s = this.in.readShort();
        short s2 = this.in.readShort();
        this.readCP();
        int n2 = this.in.readUnsignedShort();
        int n3 = this.in.readUnsignedShort();
        int n4 = this.in.readUnsignedShort();
        this.memberType = "CLSS ";
        this.modifiers = FullItemDescription.printClassModifiers(n2);
        this.parseQualifiedName(BinaryClassDescription.convertClassName(this.getCPEntry(n3).toString()));
        if (n4 == 0 || (n2 & 0x200) != 0) {
            this.superClass = null;
        } else {
            String string = this.getCPEntry(n4).toString();
            this.superClass = new FullItemDescription("supr " + BinaryClassDescription.convertClassName(string));
        }
        int n5 = this.in.readUnsignedShort();
        this.interfaces = new FullItemDescription[n5];
        int n6 = 0;
        while (n6 < n5) {
            String string = BinaryClassDescription.convertClassName(this.getCPEntry(this.in.readShort()).toString());
            this.interfaces[n6] = new FullItemDescription("intf " + string);
            ++n6;
        }
        this.readMembers();
        this.readClassAttributes();
        this.in.close();
    }

    private void readMembers() throws IOException {
        int n = this.in.readUnsignedShort();
        this.fields = new FullItemDescription[n];
        int n2 = 0;
        while (n2 < n) {
            this.fields[n2] = this.readField();
            ++n2;
        }
        int n3 = this.in.readUnsignedShort();
        Vector<FullItemDescription> vector = new Vector<FullItemDescription>();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            try {
                FullItemDescription fullItemDescription = this.readMethod();
                vector.addElement(fullItemDescription);
                if (fullItemDescription.isConstructor()) {
                    ++n4;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            ++n5;
        }
        this.methods = new FullItemDescription[vector.size() - n4];
        this.constructors = new FullItemDescription[n4];
        int n6 = 0;
        int n7 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FullItemDescription fullItemDescription = (FullItemDescription)enumeration.nextElement();
            if (fullItemDescription.isConstructor()) {
                this.constructors[n6++] = fullItemDescription;
                continue;
            }
            this.methods[n7++] = fullItemDescription;
        }
    }

    private void readClassAttributes() throws IOException {
        int n = this.in.readUnsignedShort();
        String string = this.getName().replace('.', '/');
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.in.readUnsignedShort();
            if (this.getCPEntry((int)n3).type == 1 && this.getCPEntry(n3).toString().equals("InnerClasses")) {
                this.in.readInt();
                int n4 = this.in.readUnsignedShort();
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = this.in.readUnsignedShort();
                    int n7 = this.in.readUnsignedShort();
                    int n8 = this.in.readUnsignedShort();
                    int n9 = this.in.readUnsignedShort();
                    if (string.equals(this.getCPEntry(n6).toString())) {
                        int n10 = n9;
                        this.modifiers = FullItemDescription.printClassModifiers(n10);
                    }
                    ++n5;
                }
            } else {
                if (this.getCPEntry((int)n3).type == 1 && this.getCPEntry(n3).toString().equals("Deprecated")) {
                    this.modifiers.addElement("<deprecated>");
                }
                this.in.skip(this.in.readInt());
            }
            ++n2;
        }
    }

    private static String convertName(String string) {
        if (string.startsWith("L")) {
            return BinaryClassDescription.convertClassName(string.substring(1));
        }
        return BinaryClassDescription.convertClassName(string);
    }

    private static String convertClassName(String string) {
        if (string.startsWith("[")) {
            return string.replace('/', '.');
        }
        if (string.equals("B")) {
            return "byte";
        }
        if (string.equals("S")) {
            return "short";
        }
        if (string.equals("C")) {
            return "char";
        }
        if (string.equals("I")) {
            return "int";
        }
        if (string.equals("J")) {
            return "long";
        }
        if (string.equals("F")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("Z")) {
            return "boolean";
        }
        if (string.equals("V")) {
            return "void";
        }
        String string2 = string.replace('/', '.');
        return string2.endsWith(";") ? string2.substring(0, string2.length() - 1) : string2;
    }

    private FullItemDescription readField() throws IOException {
        Object object;
        boolean bl = false;
        short s = this.in.readShort();
        short s2 = this.in.readShort();
        short s3 = this.in.readShort();
        String string = null;
        boolean bl2 = false;
        int n = this.in.readShort();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            object = this.getCPEntry(this.in.readShort());
            if (((CPE)object).type == 1 && ((CPE)object).toString().equals("ConstantValue")) {
                if (this.in.readInt() != 2) {
                    throw new ClassFormatError("invalid attr length");
                }
                n3 = this.in.readShort();
                string = this.getCPEntry(n3).toString();
            } else {
                if (((CPE)object).type == 1 && ((CPE)object).toString().equals("Synthetic")) {
                    bl2 = true;
                }
                if (((CPE)object).type == 1 && ((CPE)object).toString().equals("Deprecated")) {
                    bl = true;
                }
                n3 = this.in.readInt();
                this.in.skip(n3);
            }
            ++n2;
        }
        object = new FullItemDescription();
        ((ItemDescription)object).memberType = "fld  ";
        ((FullItemDescription)object).modifiers = FullItemDescription.printModifiers(s);
        if (!((s & 1) == 0 && (s & 4) == 0 || (s & 8) == 0 && (s & 0x200) == 0 || (s & 0x10) == 0 || string == null)) {
            ((FullItemDescription)object).modifiers.addElement("<constant>");
            if (string != null) {
                ((FullItemDescription)object).modifiers.addElement("<value=" + this.parseValue(string) + ">");
            }
        }
        ((FullItemDescription)object).type = BinaryClassDescription.convertName(this.getCPEntry(s3).toString());
        ((FullItemDescription)object).declaringClass = this.getName();
        ((ItemDescription)object).name = this.getCPEntry(s2).toString();
        ((FullItemDescription)object).isSynthetic = bl2;
        if (bl) {
            ((FullItemDescription)object).modifiers.addElement("<deprecated>");
        }
        return object;
    }

    private String parseValue(String string) {
        String string2 = "\"";
        int n = 0;
        while (n < string.length()) {
            String string3;
            char c = string.charAt(n);
            string2 = c >= '*' && c <= '~' && c != '>' && c != '<' || c == ' ' ? string2 + c : ((string3 = Integer.toHexString(c)).length() == 1 ? string2 + "\\u000" + string3 : (string3.length() == 2 ? string2 + "\\u00" + string3 : (string3.length() == 3 ? string2 + "\\u0" + string3 : string2 + "\\u" + string3)));
            ++n;
        }
        return string2 + "\"";
    }

    private String readExceptions() throws IOException {
        int n = this.in.readInt();
        int n2 = this.in.readShort();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            short s = this.in.readShort();
            stringArray[n3] = BinaryClassDescription.convertClassName(this.getCPEntry(s).toString());
            ++n3;
        }
        FullItemDescription.sort(stringArray);
        if (stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0];
        int n4 = 1;
        while (n4 < stringArray.length) {
            string = string + "," + stringArray[n4];
            ++n4;
        }
        return "throws " + string;
    }

    private FullItemDescription readMethod() throws IOException, NoSuchMethodException {
        boolean bl = false;
        int n = this.in.readUnsignedShort();
        int n2 = this.in.readUnsignedShort();
        int n3 = this.in.readUnsignedShort();
        FullItemDescription fullItemDescription = new FullItemDescription();
        int n4 = this.in.readUnsignedShort();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.in.readUnsignedShort();
            CPE cPE = this.getCPEntry(n6);
            if (cPE.type == 1 && cPE.toString().equals("Exceptions")) {
                fullItemDescription.throwables = this.readExceptions();
            } else {
                if (cPE.type == 1) {
                    if (cPE.toString().equals("Synthetic")) {
                        fullItemDescription.isSynthetic = true;
                    } else if (cPE.toString().equals("Deprecated")) {
                        bl = true;
                    }
                }
                this.in.skip(this.in.readInt());
            }
            ++n5;
        }
        fullItemDescription.modifiers = FullItemDescription.printModifiers(n);
        fullItemDescription.declaringClass = this.getName();
        fullItemDescription.name = this.getCPEntry(n2).toString();
        if (fullItemDescription.name.equals("<clinit>")) {
            throw new NoSuchMethodException("<clinit> isn't declared method");
        }
        if (fullItemDescription.name.equals("<init>")) {
            fullItemDescription.memberType = "cons ";
            fullItemDescription.name = this.name.substring(this.name.lastIndexOf(".") + 1);
        } else {
            fullItemDescription.memberType = "meth ";
        }
        String string = this.getCPEntry(n3).toString();
        int n7 = string.lastIndexOf(41);
        int n8 = string.indexOf(40);
        if (n8 < 0 || n7 < 0 || n7 < n8 || n7 == string.length() - 1) {
            throw new ClassFormatError("Incorrect method signature of the Method " + this.name);
        }
        if (fullItemDescription.isMethod()) {
            fullItemDescription.type = BinaryClassDescription.convertName(string.substring(n7 + 1));
        }
        fullItemDescription.args = "(" + this.parseParameters(string.substring(n8 + 1, n7)) + ")";
        if (bl) {
            fullItemDescription.modifiers.addElement("<deprecated>");
        }
        return fullItemDescription;
    }

    private String parseParameters(String string) {
        String string2 = "";
        String string3 = "BSCIJFDVZ";
        boolean bl = false;
        String string4 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            string2 = string2 + c;
            if (string3.indexOf(c) >= 0 && !bl) {
                string4 = string4 + BinaryClassDescription.convertName(string2) + ',';
                string2 = "";
            } else if (c == 'L') {
                bl = true;
            } else if (c == ';') {
                bl = false;
                string4 = string4 + BinaryClassDescription.convertName(string2) + ',';
                string2 = "";
            }
            ++n;
        }
        if (string4.endsWith(",")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        return string4;
    }

    private class CPE {
        public byte type;
        public Object value;

        public CPE(byte by, Object object) {
            this.type = by;
            this.value = object;
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return this.value.toString();
                }
                case 7: 
                case 8: {
                    try {
                        int n = (Integer)this.value;
                        return BinaryClassDescription.this.getCPEntry(n).toString();
                    }
                    catch (ClassCastException classCastException) {
                        throw new ClassFormatError("Incorrect constant pool entry");
                    }
                }
                case 9: 
                case 10: 
                case 11: {
                    return BinaryClassDescription.this.getCPEntry(((CPX)this.value).cpx1) + "." + BinaryClassDescription.this.getCPEntry(((CPX)this.value).cpx2);
                }
                case 12: {
                    return BinaryClassDescription.this.getCPEntry(((CPX)this.value).cpx1) + ":" + BinaryClassDescription.this.getCPEntry(((CPX)this.value).cpx2);
                }
            }
            throw new RuntimeException("UnknownTag");
        }
    }
}

