/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.rules.ConfigurationException;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.admin.RuleAdministrator;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.util.TestCaseUtil;

public class ClassLoaderTest
extends TestCase {
    public ClassLoaderTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testRuleServiceProviderManager() {
        Vector vect = TestCaseUtil.getRuleServiceProviderJarURLs();
        ClassLoaderTest.assertNotNull((String)"[ClassLoaderTest] No jar file name for the rule service provider.", (Object)vect);
        ClassLoaderTest.assertTrue((String)"[ClassLoaderTest] No jar file name for the rule service provider.", (vect.size() > 0 ? 1 : 0) != 0);
        int size = vect.size();
        URL[] urls = new URL[size];
        for (int i = 0; i < size; ++i) {
            try {
                URL url;
                urls[i] = url = new URL((String)vect.elementAt(i));
                continue;
            }
            catch (MalformedURLException ex) {
                ClassLoaderTest.fail((String)ex.getMessage());
            }
        }
        try {
            String uri = (String)vect.elementAt(0);
            RuleServiceProvider provider = TestCaseUtil.getRuleServiceProvider(uri, urls);
            RuleServiceProvider object = RuleServiceProviderManager.getRuleServiceProvider((String)uri);
            ClassLoaderTest.assertEquals((String)"[RuleServiceProviderManagerTest] ", provider.getClass(), object.getClass());
            this.useProvider(provider);
            RuleServiceProviderManager.deregisterRuleServiceProvider((String)uri);
            try {
                object = RuleServiceProviderManager.getRuleServiceProvider((String)uri);
                ClassLoaderTest.assertNull((String)"[RuleServiceProviderManagerTest] Deregistered provider still in list of registrations.", (Object)object);
            }
            catch (ConfigurationException ce) {}
        }
        catch (Exception e) {
            ClassLoaderTest.fail((String)e.getMessage());
        }
    }

    private void useProvider(RuleServiceProvider provider) {
        try {
            RuleAdministrator admin = provider.getRuleAdministrator();
            ClassLoaderTest.assertNotNull((String)"[RuleServiceProviderTest] Could not retrieve a rule administrator.", (Object)admin);
            RuleRuntime runtime = provider.getRuleRuntime();
            ClassLoaderTest.assertNotNull((String)"[RuleServiceProviderTest] Could not retrieve a rule runtime.", (Object)runtime);
        }
        catch (Exception e) {
            ClassLoaderTest.fail((String)e.getMessage());
        }
    }
}

