/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck;

import javax.rules.Handle;
import javax.rules.StatefulRuleSession;
import junit.framework.TestCase;
import org.jcp.jsr94.tck.util.TestCaseUtil;
import org.jcp.jsr94.tck.util.TestFactory;

public class HandleTest
extends TestCase {
    private StatefulRuleSession ruleSession;

    public HandleTest(String name) {
        super(name);
    }

    public void setUp() {
        try {
            this.ruleSession = TestCaseUtil.getStatefulRuleSession("handleTest", "tck_res_2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            HandleTest.fail((String)e.getMessage());
        }
    }

    public void tearDown() {
        this.ruleSession = null;
    }

    public void testHandle() throws Exception {
        Object object = TestFactory.newInstance().createHandleTestObject("handle");
        Handle handle = this.ruleSession.addObject(object);
        HandleTest.assertTrue((String)"[HandleTest] instanceof Handle", (boolean)(handle instanceof Handle));
        HandleTest.assertTrue((String)"[HandleTest] containsObject", (boolean)this.ruleSession.containsObject(handle));
        Object newobject = this.ruleSession.getObject(handle);
        HandleTest.assertTrue((String)"[HandleTest] calling equals", (boolean)object.equals(newobject));
        newobject = TestFactory.newInstance().createHandleTestObject("new handle");
        this.ruleSession.updateObject(handle, newobject);
        HandleTest.assertTrue((String)"[HandleTest] containsObject after update", (boolean)this.ruleSession.containsObject(handle));
        HandleTest.assertTrue((String)"[HandleTest] calling equals after update", (boolean)newobject.equals(this.ruleSession.getObject(handle)));
        this.ruleSession.removeObject(handle);
        HandleTest.assertTrue((String)"[HandleTest] containsObject after remove", (!this.ruleSession.containsObject(handle) ? 1 : 0) != 0);
    }
}

