/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.NodePrinter;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeStore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final TreeBuilder builder;
    private final Bindings bindings;
    private final String expr;
    private final Class<?> type;
    private final boolean deferred;
    private transient ExpressionNode node;
    private String structure;

    public TreeValueExpression(TreeStore treeStore, FunctionMapper functionMapper, VariableMapper variableMapper, TypeConverter typeConverter, String string, Class<?> clazz) {
        Tree tree = treeStore.get(string);
        this.builder = treeStore.getBuilder();
        this.bindings = tree.bind(functionMapper, variableMapper, typeConverter);
        this.expr = string;
        this.type = clazz;
        this.node = tree.getRoot();
        this.deferred = tree.isDeferred();
        if (clazz == null) {
            throw new NullPointerException(LocalMessages.get("error.value.notype", new Object[0]));
        }
    }

    private String getStructuralId() {
        if (this.structure == null) {
            this.structure = this.node.getStructuralId(this.bindings);
        }
        return this.structure;
    }

    public Class<?> getExpectedType() {
        return this.type;
    }

    public String getExpressionString() {
        return this.expr;
    }

    public Class<?> getType(ELContext eLContext) throws ELException {
        return this.node.getType(this.bindings, eLContext);
    }

    public Object getValue(ELContext eLContext) throws ELException {
        return this.node.getValue(this.bindings, eLContext, this.type);
    }

    public boolean isReadOnly(ELContext eLContext) throws ELException {
        return this.node.isReadOnly(this.bindings, eLContext);
    }

    public void setValue(ELContext eLContext, Object object) throws ELException {
        this.node.setValue(this.bindings, eLContext, object);
    }

    public boolean isLiteralText() {
        return this.node.isLiteralText();
    }

    public boolean isLeftValue() {
        return this.node.isLeftValue();
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == ((Object)((Object)this)).getClass()) {
            TreeValueExpression treeValueExpression = (TreeValueExpression)((Object)object);
            if (!this.builder.equals(treeValueExpression.builder)) {
                return false;
            }
            if (this.type != treeValueExpression.type) {
                return false;
            }
            return this.getStructuralId().equals(treeValueExpression.getStructuralId()) && this.bindings.equals(treeValueExpression.bindings);
        }
        return false;
    }

    public int hashCode() {
        return this.getStructuralId().hashCode();
    }

    public String toString() {
        return "TreeValueExpression(" + this.expr + ")";
    }

    public void dump(PrintWriter printWriter) {
        NodePrinter.dump(printWriter, this.node);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.node = this.builder.build(this.expr).getRoot();
        }
        catch (ELException eLException) {
            throw new IOException(eLException.getMessage());
        }
    }
}

