/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;

public class BooleanOperations {
    private static final Set<Class<? extends Number>> SIMPLE_INTEGER_TYPES = new HashSet<Class<? extends Number>>();
    private static final Set<Class<? extends Number>> SIMPLE_FLOAT_TYPES = new HashSet<Class<? extends Number>>();

    private static final boolean lt0(TypeConverter typeConverter, Object object, Object object2) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (BigDecimal.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz2)) {
            return typeConverter.convert(object, BigDecimal.class).compareTo(typeConverter.convert(object2, BigDecimal.class)) < 0;
        }
        if (SIMPLE_FLOAT_TYPES.contains(clazz) || SIMPLE_FLOAT_TYPES.contains(clazz2)) {
            return typeConverter.convert(object, Double.class) < typeConverter.convert(object2, Double.class);
        }
        if (BigInteger.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz2)) {
            return typeConverter.convert(object, BigInteger.class).compareTo(typeConverter.convert(object2, BigInteger.class)) < 0;
        }
        if (SIMPLE_INTEGER_TYPES.contains(clazz) || SIMPLE_INTEGER_TYPES.contains(clazz2)) {
            return typeConverter.convert(object, Long.class) < typeConverter.convert(object2, Long.class);
        }
        if (clazz == String.class || clazz2 == String.class) {
            return typeConverter.convert(object, String.class).compareTo(typeConverter.convert(object2, String.class)) < 0;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2) < 0;
        }
        if (object2 instanceof Comparable) {
            return ((Comparable)object2).compareTo(object) > 0;
        }
        throw new ELException(LocalMessages.get("error.compare.types", object.getClass(), object2.getClass()));
    }

    private static final boolean gt0(TypeConverter typeConverter, Object object, Object object2) {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (BigDecimal.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz2)) {
            return typeConverter.convert(object, BigDecimal.class).compareTo(typeConverter.convert(object2, BigDecimal.class)) > 0;
        }
        if (SIMPLE_FLOAT_TYPES.contains(clazz) || SIMPLE_FLOAT_TYPES.contains(clazz2)) {
            return typeConverter.convert(object, Double.class) > typeConverter.convert(object2, Double.class);
        }
        if (BigInteger.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz2)) {
            return typeConverter.convert(object, BigInteger.class).compareTo(typeConverter.convert(object2, BigInteger.class)) > 0;
        }
        if (SIMPLE_INTEGER_TYPES.contains(clazz) || SIMPLE_INTEGER_TYPES.contains(clazz2)) {
            return typeConverter.convert(object, Long.class) > typeConverter.convert(object2, Long.class);
        }
        if (clazz == String.class || clazz2 == String.class) {
            return typeConverter.convert(object, String.class).compareTo(typeConverter.convert(object2, String.class)) > 0;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2) > 0;
        }
        if (object2 instanceof Comparable) {
            return ((Comparable)object2).compareTo(object) < 0;
        }
        throw new ELException(LocalMessages.get("error.compare.types", object.getClass(), object2.getClass()));
    }

    public static final boolean lt(TypeConverter typeConverter, Object object, Object object2) {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return BooleanOperations.lt0(typeConverter, object, object2);
    }

    public static final boolean gt(TypeConverter typeConverter, Object object, Object object2) {
        if (object == object2) {
            return false;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return BooleanOperations.gt0(typeConverter, object, object2);
    }

    public static final boolean ge(TypeConverter typeConverter, Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return !BooleanOperations.lt0(typeConverter, object, object2);
    }

    public static final boolean le(TypeConverter typeConverter, Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return !BooleanOperations.gt0(typeConverter, object, object2);
    }

    public static final boolean eq(TypeConverter typeConverter, Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (BigDecimal.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz2)) {
            return typeConverter.convert(object, BigDecimal.class).equals(typeConverter.convert(object2, BigDecimal.class));
        }
        if (SIMPLE_FLOAT_TYPES.contains(clazz) || SIMPLE_FLOAT_TYPES.contains(clazz2)) {
            return typeConverter.convert(object, Double.class).equals(typeConverter.convert(object2, Double.class));
        }
        if (BigInteger.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz2)) {
            return typeConverter.convert(object, BigInteger.class).equals(typeConverter.convert(object2, BigInteger.class));
        }
        if (SIMPLE_INTEGER_TYPES.contains(clazz) || SIMPLE_INTEGER_TYPES.contains(clazz2)) {
            return typeConverter.convert(object, Long.class).equals(typeConverter.convert(object2, Long.class));
        }
        if (clazz == Boolean.class || clazz2 == Boolean.class) {
            return typeConverter.convert(object, Boolean.class).equals(typeConverter.convert(object2, Boolean.class));
        }
        if (object instanceof Enum) {
            return object == typeConverter.convert(object2, object.getClass());
        }
        if (object2 instanceof Enum) {
            return typeConverter.convert(object, object2.getClass()) == object2;
        }
        if (clazz == String.class || clazz2 == String.class) {
            return typeConverter.convert(object, String.class).equals(typeConverter.convert(object2, String.class));
        }
        return object.equals(object2);
    }

    public static final boolean ne(TypeConverter typeConverter, Object object, Object object2) {
        return !BooleanOperations.eq(typeConverter, object, object2);
    }

    public static final boolean and(TypeConverter typeConverter, Object object, Object object2) {
        return typeConverter.convert(object, Boolean.class) != false && typeConverter.convert(object2, Boolean.class) != false;
    }

    public static final boolean or(TypeConverter typeConverter, Object object, Object object2) {
        return typeConverter.convert(object, Boolean.class) != false || typeConverter.convert(object2, Boolean.class) != false;
    }

    public static final boolean not(TypeConverter typeConverter, Object object) {
        return typeConverter.convert(object, Boolean.class) == false;
    }

    public static final boolean empty(TypeConverter typeConverter, Object object) {
        if (object == null || "".equals(object)) {
            return true;
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        return false;
    }

    static {
        SIMPLE_INTEGER_TYPES.add(Byte.class);
        SIMPLE_INTEGER_TYPES.add(Short.class);
        SIMPLE_INTEGER_TYPES.add(Integer.class);
        SIMPLE_INTEGER_TYPES.add(Long.class);
        SIMPLE_FLOAT_TYPES.add(Float.class);
        SIMPLE_FLOAT_TYPES.add(Double.class);
    }
}

