/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;

public class NumberOperations {
    private static final Long LONG_ZERO = 0L;

    private static final boolean isDotEe(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean isDotEe(Object object) {
        return object instanceof String && NumberOperations.isDotEe((String)object);
    }

    private static final boolean isFloatOrDouble(Object object) {
        return object instanceof Float || object instanceof Double;
    }

    private static final boolean isFloatOrDoubleOrDotEe(Object object) {
        return NumberOperations.isFloatOrDouble(object) || NumberOperations.isDotEe(object);
    }

    private static final boolean isBigDecimalOrBigInteger(Object object) {
        return object instanceof BigDecimal || object instanceof BigInteger;
    }

    private static final boolean isBigDecimalOrFloatOrDoubleOrDotEe(Object object) {
        return object instanceof BigDecimal || NumberOperations.isFloatOrDoubleOrDotEe(object);
    }

    public static final Number add(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return typeConverter.convert(object, BigDecimal.class).add(typeConverter.convert(object2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return typeConverter.convert(object, BigDecimal.class).add(typeConverter.convert(object2, BigDecimal.class));
            }
            return typeConverter.convert(object, Double.class) + typeConverter.convert(object2, Double.class);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return typeConverter.convert(object, BigInteger.class).add(typeConverter.convert(object2, BigInteger.class));
        }
        return typeConverter.convert(object, Long.class) + typeConverter.convert(object2, Long.class);
    }

    public static final Number sub(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return typeConverter.convert(object, BigDecimal.class).subtract(typeConverter.convert(object2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return typeConverter.convert(object, BigDecimal.class).subtract(typeConverter.convert(object2, BigDecimal.class));
            }
            return typeConverter.convert(object, Double.class) - typeConverter.convert(object2, Double.class);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return typeConverter.convert(object, BigInteger.class).subtract(typeConverter.convert(object2, BigInteger.class));
        }
        return typeConverter.convert(object, Long.class) - typeConverter.convert(object2, Long.class);
    }

    public static final Number mul(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return typeConverter.convert(object, BigDecimal.class).multiply(typeConverter.convert(object2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return typeConverter.convert(object, BigDecimal.class).multiply(typeConverter.convert(object2, BigDecimal.class));
            }
            return typeConverter.convert(object, Double.class) * typeConverter.convert(object2, Double.class);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return typeConverter.convert(object, BigInteger.class).multiply(typeConverter.convert(object2, BigInteger.class));
        }
        return typeConverter.convert(object, Long.class) * typeConverter.convert(object2, Long.class);
    }

    public static final Number div(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrBigInteger(object) || NumberOperations.isBigDecimalOrBigInteger(object2)) {
            return typeConverter.convert(object, BigDecimal.class).divide(typeConverter.convert(object2, BigDecimal.class), 4);
        }
        return typeConverter.convert(object, Double.class) / typeConverter.convert(object2, Double.class);
    }

    public static final Number mod(TypeConverter typeConverter, Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(object) || NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(object2)) {
            return typeConverter.convert(object, Double.class) % typeConverter.convert(object2, Double.class);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return typeConverter.convert(object, BigInteger.class).remainder(typeConverter.convert(object2, BigInteger.class));
        }
        return typeConverter.convert(object, Long.class) % typeConverter.convert(object2, Long.class);
    }

    public static final Number neg(TypeConverter typeConverter, Object object) {
        if (object == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).negate();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).negate();
        }
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(-((Float)object).floatValue());
        }
        if (object instanceof String) {
            if (NumberOperations.isDotEe((String)object)) {
                return -typeConverter.convert(object, Double.class).doubleValue();
            }
            return -typeConverter.convert(object, Long.class).longValue();
        }
        if (object instanceof Long) {
            return -((Long)object).longValue();
        }
        if (object instanceof Integer) {
            return -((Integer)object).intValue();
        }
        if (object instanceof Short) {
            return -((Short)object).shortValue();
        }
        if (object instanceof Byte) {
            return -((Byte)object).byteValue();
        }
        throw new ELException(LocalMessages.get("error.negate", object.getClass()));
    }
}

