/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterImpl
implements TypeConverter {
    private static final long serialVersionUID = 1L;
    protected static final Long LONG_ZERO = 0L;
    protected static final Map<Class<?>, Class<?>> WRAPPER_TYPES;

    protected Boolean coerceToBoolean(Object object) {
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", object.getClass(), Boolean.class));
    }

    protected Character coerceToCharacter(Object object) {
        if (object == null || "".equals(object)) {
            return Character.valueOf('\u0000');
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Number) {
            return new Character((char)((Number)object).shortValue());
        }
        if (object instanceof String) {
            return new Character(((String)object).charAt(0));
        }
        throw new ELException(LocalMessages.get("error.coerce.type", object.getClass(), Character.class));
    }

    protected Number coerceStringToNumber(String string, Class<? extends Number> clazz) {
        try {
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string);
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(string);
            }
            if (clazz == Byte.class) {
                return Byte.valueOf(string);
            }
            if (clazz == Short.class) {
                return Short.valueOf(string);
            }
            if (clazz == Integer.class) {
                return Integer.valueOf(string);
            }
            if (clazz == Long.class) {
                return Long.valueOf(string);
            }
            if (clazz == Float.class) {
                return Float.valueOf(string);
            }
            if (clazz == Double.class) {
                return Double.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ELException(LocalMessages.get("error.coerce.value", string, clazz));
        }
        throw new ELException(LocalMessages.get("error.coerce.type", String.class, clazz));
    }

    protected Number coerceNumberToNumber(Number number, Class<? extends Number> clazz) {
        if (clazz.isInstance(number)) {
            return number;
        }
        if (clazz == BigInteger.class) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (clazz == BigDecimal.class) {
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (clazz == Byte.class) {
            return number.byteValue();
        }
        if (clazz == Short.class) {
            return number.shortValue();
        }
        if (clazz == Integer.class) {
            return number.intValue();
        }
        if (clazz == Long.class) {
            return number.longValue();
        }
        if (clazz == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz == Double.class) {
            return number.doubleValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", number.getClass(), clazz));
    }

    protected <T extends Number> T coerceToNumber(Object object, Class<T> clazz) {
        if (object == null || "".equals(object)) {
            return (T)this.coerceNumberToNumber(LONG_ZERO, clazz);
        }
        if (object instanceof Character) {
            return (T)this.coerceNumberToNumber((short)((Character)object).charValue(), clazz);
        }
        if (object instanceof Number) {
            return (T)this.coerceNumberToNumber((Number)object, clazz);
        }
        if (object instanceof String) {
            return (T)this.coerceStringToNumber((String)object, clazz);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", object.getClass(), clazz));
    }

    protected String coerceToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        return object.toString();
    }

    protected <T extends Enum<T>> T coerceToEnum(Object object, Class<T> clazz) {
        if (object == null || "".equals(object)) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)((Enum)object);
        }
        if (object instanceof String) {
            try {
                return Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ELException(LocalMessages.get("error.coerce.value", object, clazz));
            }
        }
        throw new ELException(LocalMessages.get("error.coerce.type", object.getClass(), clazz));
    }

    protected Object coerceStringToType(String string, Class<?> clazz) {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor == null) {
            if ("".equals(string)) {
                return null;
            }
            throw new ELException(LocalMessages.get("error.coerce.type", String.class, clazz));
        }
        if ("".equals(string)) {
            try {
                propertyEditor.setAsText(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        try {
            propertyEditor.setAsText(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ELException(LocalMessages.get("error.coerce.value", string, clazz));
        }
        return propertyEditor.getValue();
    }

    protected Object coerceToType(Object object, Class<?> clazz) {
        if (clazz == String.class) {
            return this.coerceToString(object);
        }
        if (clazz.isPrimitive()) {
            clazz = WRAPPER_TYPES.get(clazz);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return this.coerceToNumber(object, clazz);
        }
        if (clazz == Character.class) {
            return this.coerceToCharacter(object);
        }
        if (clazz == Boolean.class) {
            return this.coerceToBoolean(object);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.coerceToEnum(object, clazz);
        }
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        if (object instanceof String) {
            return this.coerceStringToType((String)object, clazz);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", object.getClass(), clazz));
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public <T> T convert(Object object, Class<T> clazz) throws ELException {
        return (T)this.coerceToType(object, clazz);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> hashMap = new HashMap<Class<Comparable<Boolean>>, Class>();
        hashMap = new HashMap();
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Double.TYPE, Double.class);
        WRAPPER_TYPES = Collections.unmodifiableMap(hashMap);
    }
}

