/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.IdentifierNode;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree {
    private final ExpressionNode root;
    private final Collection<FunctionNode> functions;
    private final Collection<IdentifierNode> identifiers;
    private final boolean deferred;

    public Tree(ExpressionNode expressionNode, Collection<FunctionNode> collection, Collection<IdentifierNode> collection2, boolean bl) {
        this.root = expressionNode;
        this.functions = collection;
        this.identifiers = collection2;
        this.deferred = bl;
    }

    public Iterable<FunctionNode> getFunctionNodes() {
        return this.functions;
    }

    public Iterable<IdentifierNode> getIdentifierNodes() {
        return this.identifiers;
    }

    public ExpressionNode getRoot() {
        return this.root;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public String toString() {
        return this.getRoot().getStructuralId(null);
    }

    public Bindings bind(FunctionMapper functionMapper, VariableMapper variableMapper) {
        return this.bind(functionMapper, variableMapper, null);
    }

    public Bindings bind(FunctionMapper functionMapper, VariableMapper variableMapper, TypeConverter typeConverter) {
        Object object;
        Method[] methodArray = null;
        if (!this.functions.isEmpty()) {
            if (functionMapper == null) {
                throw new ELException(LocalMessages.get("error.function.nomapper", new Object[0]));
            }
            methodArray = new Method[this.functions.size()];
            for (FunctionNode object2 : this.functions) {
                String string = object2.getName();
                object = null;
                int n = string.indexOf(58);
                object = n < 0 ? functionMapper.resolveFunction("", string) : functionMapper.resolveFunction(string.substring(0, n), string.substring(n + 1));
                if (object == null) {
                    throw new ELException(LocalMessages.get("error.function.notfound", string));
                }
                if (object2.isVarArgs() && ((Method)object).isVarArgs() ? ((Method)object).getParameterTypes().length > object2.getParamCount() + 1 : ((Method)object).getParameterTypes().length != object2.getParamCount()) {
                    throw new ELException(LocalMessages.get("error.function.params", string));
                }
                methodArray[object2.getIndex()] = object;
            }
        }
        ValueExpression[] valueExpressionArray = null;
        if (this.identifiers.size() > 0) {
            valueExpressionArray = new ValueExpression[this.identifiers.size()];
            for (IdentifierNode identifierNode : this.identifiers) {
                object = null;
                if (variableMapper != null) {
                    object = variableMapper.resolveVariable(identifierNode.getName());
                }
                valueExpressionArray[identifierNode.getIndex()] = object;
            }
        }
        return new Bindings(methodArray, valueExpressionArray, typeConverter);
    }
}

