/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Scanner;
import de.odysseus.el.tree.impl.ast.AstBinary;
import de.odysseus.el.tree.impl.ast.AstBoolean;
import de.odysseus.el.tree.impl.ast.AstBracket;
import de.odysseus.el.tree.impl.ast.AstChoice;
import de.odysseus.el.tree.impl.ast.AstComposite;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstEval;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstMethod;
import de.odysseus.el.tree.impl.ast.AstNested;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstNull;
import de.odysseus.el.tree.impl.ast.AstNumber;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.tree.impl.ast.AstText;
import de.odysseus.el.tree.impl.ast.AstUnary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final String EXPR_FIRST = (Object)((Object)Scanner.Symbol.IDENTIFIER) + "|" + (Object)((Object)Scanner.Symbol.STRING) + "|" + (Object)((Object)Scanner.Symbol.FLOAT) + "|" + (Object)((Object)Scanner.Symbol.INTEGER) + "|" + (Object)((Object)Scanner.Symbol.TRUE) + "|" + (Object)((Object)Scanner.Symbol.FALSE) + "|" + (Object)((Object)Scanner.Symbol.NULL) + "|" + (Object)((Object)Scanner.Symbol.MINUS) + "|" + (Object)((Object)Scanner.Symbol.NOT) + "|" + (Object)((Object)Scanner.Symbol.EMPTY) + "|" + (Object)((Object)Scanner.Symbol.LPAREN);
    protected final Builder context;
    protected final Scanner scanner;
    private List<IdentifierNode> identifiers = Collections.emptyList();
    private List<FunctionNode> functions = Collections.emptyList();
    private List<LookaheadToken> lookahead = Collections.emptyList();
    private Scanner.Token token;
    private int position;
    protected Map<Scanner.ExtensionToken, ExtensionHandler> extensions = Collections.emptyMap();

    public Parser(Builder builder, String string) {
        this.context = builder;
        this.scanner = this.createScanner(string);
    }

    protected Scanner createScanner(String string) {
        return new Scanner(string);
    }

    public void putExtensionHandler(Scanner.ExtensionToken extensionToken, ExtensionHandler extensionHandler) {
        if (this.extensions.isEmpty()) {
            this.extensions = new HashMap<Scanner.ExtensionToken, ExtensionHandler>(16);
        }
        this.extensions.put(extensionToken, extensionHandler);
    }

    protected ExtensionHandler getExtensionHandler(Scanner.Token token) {
        return this.extensions.get(token);
    }

    protected Number parseInteger(String string) throws ParseException {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Scanner.Symbol.INTEGER);
            return null;
        }
    }

    protected Number parseFloat(String string) throws ParseException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Scanner.Symbol.FLOAT);
            return null;
        }
    }

    protected AstBinary createAstBinary(AstNode astNode, AstNode astNode2, AstBinary.Operator operator) {
        return new AstBinary(astNode, astNode2, operator);
    }

    protected AstBracket createAstBracket(AstNode astNode, AstNode astNode2, boolean bl, boolean bl2) {
        return new AstBracket(astNode, astNode2, bl, bl2);
    }

    protected AstChoice createAstChoice(AstNode astNode, AstNode astNode2, AstNode astNode3) {
        return new AstChoice(astNode, astNode2, astNode3);
    }

    protected AstComposite createAstComposite(List<AstNode> list) {
        return new AstComposite(list);
    }

    protected AstDot createAstDot(AstNode astNode, String string, boolean bl) {
        return new AstDot(astNode, string, bl);
    }

    protected AstFunction createAstFunction(String string, int n, List<AstNode> list) {
        return new AstFunction(string, n, list, this.context.isEnabled(Builder.Feature.VARARGS));
    }

    protected AstIdentifier createAstIdentifier(String string, int n) {
        return new AstIdentifier(string, n);
    }

    protected AstMethod createAstMethod(AstNode astNode, String string, List<AstNode> list) {
        return new AstMethod(astNode, string, list, this.context.isEnabled(Builder.Feature.VARARGS));
    }

    protected AstUnary createAstUnary(AstNode astNode, AstUnary.Operator operator) {
        return new AstUnary(astNode, operator);
    }

    protected final List<FunctionNode> getFunctions() {
        return this.functions;
    }

    protected final List<IdentifierNode> getIdentifiers() {
        return this.identifiers;
    }

    protected final Scanner.Token getToken() {
        return this.token;
    }

    protected void fail(String string) throws ParseException {
        throw new ParseException(this.position, "'" + this.token.getImage() + "'", string);
    }

    protected void fail(Scanner.Symbol symbol) throws ParseException {
        this.fail(symbol.toString());
    }

    protected final Scanner.Token lookahead(int n) throws Scanner.ScanException, ParseException {
        if (this.lookahead.isEmpty()) {
            this.lookahead = new LinkedList<LookaheadToken>();
        }
        while (n >= this.lookahead.size()) {
            this.lookahead.add(new LookaheadToken(this.scanner.next(), this.scanner.getPosition()));
        }
        return this.lookahead.get((int)n).token;
    }

    protected final Scanner.Token consumeToken() throws Scanner.ScanException, ParseException {
        Scanner.Token token = this.token;
        if (this.lookahead.isEmpty()) {
            this.token = this.scanner.next();
            this.position = this.scanner.getPosition();
        } else {
            LookaheadToken lookaheadToken = this.lookahead.remove(0);
            this.token = lookaheadToken.token;
            this.position = lookaheadToken.position;
        }
        return token;
    }

    protected final Scanner.Token consumeToken(Scanner.Symbol symbol) throws Scanner.ScanException, ParseException {
        if (this.token.getSymbol() != symbol) {
            this.fail(symbol);
        }
        return this.consumeToken();
    }

    public Tree tree() throws Scanner.ScanException, ParseException {
        this.consumeToken();
        AstNode astNode = this.text();
        if (this.token.getSymbol() == Scanner.Symbol.EOF) {
            if (astNode == null) {
                astNode = new AstText("");
            }
            return new Tree(astNode, this.functions, this.identifiers, false);
        }
        AstEval astEval = this.eval();
        if (this.token.getSymbol() == Scanner.Symbol.EOF && astNode == null) {
            return new Tree(astEval, this.functions, this.identifiers, astEval.isDeferred());
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        if (astNode != null) {
            arrayList.add(astNode);
        }
        arrayList.add(astEval);
        astNode = this.text();
        if (astNode != null) {
            arrayList.add(astNode);
        }
        while (this.token.getSymbol() != Scanner.Symbol.EOF) {
            if (astEval.isDeferred()) {
                arrayList.add(this.eval(true, true));
            } else {
                arrayList.add(this.eval(true, false));
            }
            if ((astNode = this.text()) == null) continue;
            arrayList.add(astNode);
        }
        return new Tree(this.createAstComposite(arrayList), this.functions, this.identifiers, astEval.isDeferred());
    }

    protected AstNode text() throws Scanner.ScanException, ParseException {
        AstText astText = null;
        if (this.token.getSymbol() == Scanner.Symbol.TEXT) {
            astText = new AstText(this.token.getImage());
            this.consumeToken();
        }
        return astText;
    }

    protected AstEval eval() throws Scanner.ScanException, ParseException {
        AstEval astEval = this.eval(false, false);
        if (astEval == null && (astEval = this.eval(false, true)) == null) {
            this.fail((Object)((Object)Scanner.Symbol.START_EVAL_DEFERRED) + "|" + (Object)((Object)Scanner.Symbol.START_EVAL_DYNAMIC));
        }
        return astEval;
    }

    protected AstEval eval(boolean bl, boolean bl2) throws Scanner.ScanException, ParseException {
        Scanner.Symbol symbol;
        AstEval astEval = null;
        Scanner.Symbol symbol2 = symbol = bl2 ? Scanner.Symbol.START_EVAL_DEFERRED : Scanner.Symbol.START_EVAL_DYNAMIC;
        if (this.token.getSymbol() == symbol) {
            this.consumeToken();
            astEval = new AstEval(this.expr(true), bl2);
            this.consumeToken(Scanner.Symbol.END_EVAL);
        } else if (bl) {
            this.fail(symbol);
        }
        return astEval;
    }

    protected AstNode expr(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.or(bl);
        if (astNode == null) {
            return null;
        }
        if (this.token.getSymbol() == Scanner.Symbol.QUESTION) {
            this.consumeToken();
            AstNode astNode2 = this.expr(true);
            this.consumeToken(Scanner.Symbol.COLON);
            AstNode astNode3 = this.expr(true);
            astNode = this.createAstChoice(astNode, astNode2, astNode3);
        }
        return astNode;
    }

    protected AstNode or(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.and(bl);
        if (astNode == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case OR: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.and(true), AstBinary.OR);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.OR) break block4;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(astNode, this.and(true));
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode and(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.eq(bl);
        if (astNode == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case AND: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.eq(true), AstBinary.AND);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.AND) break block4;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(astNode, this.eq(true));
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode eq(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.cmp(bl);
        if (astNode == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol()) {
                case EQ: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.cmp(true), AstBinary.EQ);
                    continue block5;
                }
                case NE: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.cmp(true), AstBinary.NE);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.EQ) break block5;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(astNode, this.cmp(true));
                    continue block5;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode cmp(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.add(bl);
        if (astNode == null) {
            return null;
        }
        block7: while (true) {
            switch (this.token.getSymbol()) {
                case LT: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.LT);
                    continue block7;
                }
                case LE: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.LE);
                    continue block7;
                }
                case GE: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.GE);
                    continue block7;
                }
                case GT: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.add(true), AstBinary.GT);
                    continue block7;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.CMP) break block7;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(astNode, this.add(true));
                    continue block7;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode add(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.mul(bl);
        if (astNode == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol()) {
                case PLUS: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.mul(true), AstBinary.ADD);
                    continue block5;
                }
                case MINUS: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.mul(true), AstBinary.SUB);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.ADD) break block5;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(astNode, this.mul(true));
                    continue block5;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode mul(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = this.unary(bl);
        if (astNode == null) {
            return null;
        }
        block6: while (true) {
            switch (this.token.getSymbol()) {
                case MUL: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.unary(true), AstBinary.MUL);
                    continue block6;
                }
                case DIV: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.unary(true), AstBinary.DIV);
                    continue block6;
                }
                case MOD: {
                    this.consumeToken();
                    astNode = this.createAstBinary(astNode, this.unary(true), AstBinary.MOD);
                    continue block6;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.MUL) break block6;
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(astNode, this.unary(true));
                    continue block6;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode unary(boolean bl) throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.token.getSymbol()) {
            case NOT: {
                this.consumeToken();
                astNode = this.createAstUnary(this.unary(true), AstUnary.NOT);
                break;
            }
            case MINUS: {
                this.consumeToken();
                astNode = this.createAstUnary(this.unary(true), AstUnary.NEG);
                break;
            }
            case EMPTY: {
                this.consumeToken();
                astNode = this.createAstUnary(this.unary(true), AstUnary.EMPTY);
                break;
            }
            case EXTENSION: {
                if (this.getExtensionHandler(this.token).getExtensionPoint() == ExtensionPoint.UNARY) {
                    astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(this.unary(true));
                    break;
                }
            }
            default: {
                astNode = this.value();
            }
        }
        if (astNode == null && bl) {
            this.fail(EXPR_FIRST);
        }
        return astNode;
    }

    protected AstNode value() throws Scanner.ScanException, ParseException {
        boolean bl = true;
        AstNode astNode = this.nonliteral();
        if (astNode == null) {
            astNode = this.literal();
            if (astNode == null) {
                return null;
            }
            bl = false;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case DOT: {
                    this.consumeToken();
                    String string = this.consumeToken(Scanner.Symbol.IDENTIFIER).getImage();
                    if (this.token.getSymbol() == Scanner.Symbol.LPAREN && this.context.isEnabled(Builder.Feature.METHOD_INVOCATIONS)) {
                        this.consumeToken();
                        astNode = this.createAstMethod(astNode, string, this.list());
                        this.consumeToken(Scanner.Symbol.RPAREN);
                        continue block4;
                    }
                    astNode = this.createAstDot(astNode, string, bl);
                    continue block4;
                }
                case LBRACK: {
                    this.consumeToken();
                    AstNode astNode2 = this.expr(true);
                    boolean bl2 = !this.context.isEnabled(Builder.Feature.NULL_PROPERTIES);
                    astNode = this.createAstBracket(astNode, astNode2, bl, bl2);
                    this.consumeToken(Scanner.Symbol.RBRACK);
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    protected AstNode nonliteral() throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.token.getSymbol()) {
            case IDENTIFIER: {
                String string = this.consumeToken().getImage();
                if (this.token.getSymbol() == Scanner.Symbol.COLON && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER && this.lookahead(1).getSymbol() == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    string = string + ":" + this.token.getImage();
                    this.consumeToken();
                }
                if (this.token.getSymbol() == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    List<AstNode> list = this.list();
                    this.consumeToken(Scanner.Symbol.RPAREN);
                    astNode = this.function(string, list);
                    break;
                }
                astNode = this.identifier(string);
                break;
            }
            case LPAREN: {
                this.consumeToken();
                astNode = this.expr(true);
                this.consumeToken(Scanner.Symbol.RPAREN);
                astNode = new AstNested(astNode);
            }
        }
        return astNode;
    }

    protected List<AstNode> list() throws Scanner.ScanException, ParseException {
        List<AstNode> list = Collections.emptyList();
        AstNode astNode = this.expr(false);
        if (astNode != null) {
            list = new ArrayList<AstNode>();
            list.add(astNode);
            while (this.token.getSymbol() == Scanner.Symbol.COMMA) {
                this.consumeToken();
                list.add(this.expr(true));
            }
        }
        return list;
    }

    protected AstNode literal() throws Scanner.ScanException, ParseException {
        AstNode astNode = null;
        switch (this.token.getSymbol()) {
            case TRUE: {
                astNode = new AstBoolean(true);
                this.consumeToken();
                break;
            }
            case FALSE: {
                astNode = new AstBoolean(false);
                this.consumeToken();
                break;
            }
            case STRING: {
                astNode = new AstString(this.token.getImage());
                this.consumeToken();
                break;
            }
            case INTEGER: {
                astNode = new AstNumber(this.parseInteger(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case FLOAT: {
                astNode = new AstNumber(this.parseFloat(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case NULL: {
                astNode = new AstNull();
                this.consumeToken();
                break;
            }
            case EXTENSION: {
                if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.LITERAL) break;
                astNode = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[0]);
            }
        }
        return astNode;
    }

    protected final AstFunction function(String string, List<AstNode> list) {
        if (this.functions.isEmpty()) {
            this.functions = new ArrayList<FunctionNode>(4);
        }
        AstFunction astFunction = this.createAstFunction(string, this.functions.size(), list);
        this.functions.add(astFunction);
        return astFunction;
    }

    protected final AstIdentifier identifier(String string) {
        if (this.identifiers.isEmpty()) {
            this.identifiers = new ArrayList<IdentifierNode>(4);
        }
        AstIdentifier astIdentifier = this.createAstIdentifier(string, this.identifiers.size());
        this.identifiers.add(astIdentifier);
        return astIdentifier;
    }

    public static abstract class ExtensionHandler {
        private final ExtensionPoint point;

        public ExtensionHandler(ExtensionPoint extensionPoint) {
            this.point = extensionPoint;
        }

        public ExtensionPoint getExtensionPoint() {
            return this.point;
        }

        public abstract AstNode createAstNode(AstNode ... var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtensionPoint {
        OR,
        AND,
        EQ,
        CMP,
        ADD,
        MUL,
        UNARY,
        LITERAL;

    }

    private static final class LookaheadToken {
        final Scanner.Token token;
        final int position;

        LookaheadToken(Scanner.Token token, int n) {
            this.token = token;
            this.position = n;
        }
    }

    public static class ParseException
    extends Exception {
        final int position;
        final String encountered;
        final String expected;

        public ParseException(int n, String string, String string2) {
            super(LocalMessages.get("error.parse", n, string, string2));
            this.position = n;
            this.encountered = string;
            this.expected = string2;
        }
    }
}

